#include "snow.h"

extern _projectile projectile[MAX_PROJECTILES];
extern _elf player;

void new_projectile(int x, int y, int type);
void new_projectile(int x, int y, int type, int dir);

_wpn::_wpn()
{
  anim = 0;
  type = -1;
  delay = 0;
  ammo = 0;
}

void _wpn::fire(int x, int y)
{
  if (ammo > 0)
  {
    switch(type)
    {
      case FIRE_PUFF:
        new_projectile(x, y, type);
        play_sound(S_SMALLBURN);
        delay = 25;
        break;
      case FLAMETHROWER:
        new_projectile(x, y, type);
        new_projectile(x, y, type);
        if (sound_delay <= 0)
        {
          play_sound(S_FLAMETHROWER);
          sound_delay = 25;
        }
        ammo -= 0.2;
        delay = 0;
        break;
      case HEAT_RAY:
        new_projectile(x, y, type);
        new_projectile(x, y, type);
        if (sound_delay <= 0)
        {
          play_sound(S_HEATRAY);
          sound_delay = 25;
        }
        ammo -= 0.1;
        delay = 0;
        break;
      case NAPALM_GRENADE:
        new_projectile(x, y, type);
        play_sound(S_GRENADE);
        ammo--;
        delay = 50;
        break;
      case PLASMA:
        new_projectile(x, y, type);
        play_sound(S_PLASMA);
        ammo--;
        delay = 25;
        break;
    }
  }
  else
  {
    ammo = 0;
  }
}

void new_projectile(int x, int y, int type, int dir)
{
  int i = 0;
  while (i < MAX_PROJECTILES)
  {
    if (projectile[i].exists == 0)
    {
      projectile[i].init(x, y, type, dir);
      i = MAX_PROJECTILES;
    }
    i++;
  }
}

void new_projectile(int x, int y, int type)
{
  new_projectile(x, y, type, player.dir);
}
