#include "snow.h"

extern _elf player;
extern _snowman snowman[MAX_SNOWMEN];

extern BITMAP *smallshadow;
extern BITMAP *snowballshadow;

extern DATAFILE *weapons;
extern DATAFILE *firepuff;
extern DATAFILE *grenade;
extern DATAFILE *plasma;
extern DATAFILE *snowmandat;
extern DATAFILE *snowmanmelt;
extern DATAFILE *present;
extern DATAFILE *flames;

extern void new_projectile(int x, int y, int type);
extern int push_back_direction(int x, int y);

int check_collide_with_snowman(int type, int x, int y);
int player_present_contact(int x, int y);
int snowball_hit_player(int x, int y);

int hissdelay;

_projectile::_projectile()
{
  exists = 0;
  type = -1;
}

void _projectile::init(int sx, int sy, int stype, int sdir)
{
  float speed = 0;
  float pspeed = 0;  //speed perpendicular to the direction of movement
  int z = 0;
  x = float(sx);
  y = float(sy);
  h = 0;
  dir = sdir;
  type = stype;
  exists = 1;
  anim = 0;
  if (type < 5)
  {  //if it is a player weapon, move its starting height to where the gun is
    h = 29;
    switch(dir)
    {
      case UP:
        x += 20;
        h += 20;
        y--;
        break;
      case DOWN:
        x += 20;
        h += 8;
        y++;
        break;
      case LEFT:
        h += 10;
        break;
      case RIGHT:
        x += 39;
        h += 10;
        break;
    }
  }
  if (type == SNOWBALL)
  {  //move the snowball weapon to the snowman's hand
    switch(dir)
    {
      case UP:
      case DOWN:
        x += 50;
        h += 60;
        break;
      case LEFT:
      case RIGHT:
        x += 30;
        h += 60;
        break;
    }
  }  
  switch(type)
  {
    case FIRE_PUFF:
      speed = 3.5;
      life = 25;
      hv = 0;
      break;
    case FLAMETHROWER:
      z = rand()%2;
      if (z == 0) z = -1;
      speed = 7 + (4 / float(rand()%20 + 1));
      pspeed = 0.8 * float(z) / float(rand()%10 + 1);
      life = 20 + rand()%8;
      hv = 0;
      break;
    case HEAT_RAY:
      z = rand()%2;
      if (z == 0) z = -1;
      speed = 7 + (4 / float(rand()%20 + 1));
      pspeed = 1.2 * float(z) / float(rand()%10 + 1);
      life = 10;
      hv = 0;
      break;
    case NAPALM_GRENADE:
      speed = 2;
      life = 120;
      hv = 1.5;
      break;
    case MELT_ANIM:  //not a projectile, but needs to be drawn in y-order
      speed = 0;
      life = 40;
      hv = 0;
      break;
    case PRESENT:  //same here
      speed = 0;
      life = 500;
      h = 480;
      hv = 0;
      break;
    case GRENADE_FLAME:
      z = rand()%2;
      if (z == 0) z = -1;
      speed = (rand()%8) * float(z);
      z = rand()%2;
      if (z == 0) z = -1;
      pspeed = (rand()%8) * float(z);
      life = 275;
      hv = 0;
      break;
    case DYING_FLAME:
      hv = 0;
      life = 20;
      speed = 0;
      break;
    case PLASMA:
      hv = 0;
      speed = 9;
      life = int(640 / speed) + 15;
      break;
    case SNOWBALL:
      if (dir == LEFT)
      {
        speed = 3 + float(abs(player.x - int(x))) / 40;
        pspeed = float(player.y - int(y)) / 40;
      }
      else if (dir == RIGHT)
      {
        speed = 3 + float(abs(player.x - int(x))) / 40;
        pspeed = float(int(y) - player.y) / 40;
      }
      else if (dir == UP)
      {
        speed = 3 + float(abs(int(y) - player.y)) / 40;
        pspeed = float(player.x - int(x)) / 40;      
      }
      else
      {
        speed = 3 + float(abs(int(y) - player.y)) / 40;
        pspeed = float(int(x) - player.x) / 40;      
      }
      while (speed > 6.5)  //the snowball shouldn't go so fast as to be unavoidable
      {  //plus, snowmen have skinny little twig arms, so how well could they throw?
        speed /= 1.2;
        pspeed /= 1.2;
      }
      hv = 1.5;
      life = 90;
      break;
  }
  switch(dir)
  {
    case UP:
      xv = pspeed;
      yv = -speed;
      break;
    case DOWN:
      xv = -pspeed;
      yv = speed;
      break;
    case LEFT:
      xv = -speed;
      yv = pspeed;
      break;
    case RIGHT:
      xv = speed;
      yv = -pspeed;
      break;
  }
  if (type < 5)
  {  //if it's a player weapon, add to it the speed of the player
    if (player.walking == 1)
    {
      switch(dir)
      {
        case UP:
          yv -= 2;
          break;
        case DOWN:
          yv += 2;
          break;
        case LEFT:
          xv -= 2;
          break;
        case RIGHT:
          xv += 2;
          break;
      }
    }
  }
}

void _projectile::draw()
{
  int z, c;
  switch(type)
  {
    case FIRE_PUFF:
      anim++;
      if (anim >= 4 * 3)
      {
        anim = 0;
      }
      draw_sprite(back_buffer, (BITMAP *)firepuff[anim / 3].dat, int(x) - 4, int(y) - 4 - int(h));
      break;
    case FLAMETHROWER:
      set_trans_blender(180, 180, 180, 180);
      draw_trans_sprite(back_buffer, (BITMAP *)weapons[1].dat, int(x) - 4, int(y) - 4 - int(h));
      set_trans_blender(128, 128, 128, 128);
      break;
    case HEAT_RAY:
      z = rand()%2;
      if (z == 0)
      {
        c = RED;
      }
      else
      {
        c = ORANGE;
      }
      if ((dir == UP) || (dir == DOWN))
      {
        rectfill(back_buffer, int(x), int(y) - int(h) - 2, int(x) + 4, int(y) + 2, c);
      }
      else
      {
        if (dir == LEFT)
        {
          rectfill(back_buffer, int(x) - 35, int(y) - int(h) - 2, int(x), int(y) - int(h) + 2, c);
        }
        else
        {
          rectfill(back_buffer, int(x), int(y) - int(h) - 2, int(x) + 35, int(y) - int(h) + 2, c);
        }
      }
      break;
    case NAPALM_GRENADE:
      if (h > 0)
      {
        draw_trans_sprite(back_buffer, smallshadow, int(x) - 10, int(y) - 10);
        draw_sprite(back_buffer, (BITMAP *)grenade[0].dat, int(x) - 10, int(y) - 10 - int(h));
      }
      else
      {
        switch(dir)
        {
          case UP:
          case DOWN:
            anim += int(yv * 8);
            if (anim >= 4 * 7)
            {
              anim = 0;
            }
            if (anim < 0)
            {
              anim = 4 * 7;
            }
            draw_sprite(back_buffer, (BITMAP *)grenade[dir * 4 + (anim / 7)].dat, int(x) - 10, int(y) - 10);
            break;
          case LEFT:
          case RIGHT:
            anim += int(xv * 10);
            rotate_sprite(back_buffer, (BITMAP *)grenade[0].dat, int(x) - 10, int(y) - 10, itofix(anim));
            break;
        }
      }
      break;
    case MELT_ANIM:
      anim++;
      if (anim >= 5 * 8)
      {
        anim = 0;
        life = 0;
      }
      else
      {
        draw_sprite(back_buffer, (BITMAP *)snowmanmelt[anim / 8].dat, int(x), int(y) - 70);
      }
      break;
    case PRESENT:
      draw_trans_sprite(back_buffer, shadow, int(x), int(y));
      if (h > 0)
      {
        draw_sprite(back_buffer, (BITMAP *)present[0].dat, int(x), int(y) - int(h) - 70);
      }
      else
      {
        if (life > 150)
        {
          draw_sprite(back_buffer, (BITMAP *)present[1].dat, int(x), int(y));
        }
        else
        {
          draw_trans_sprite(back_buffer, (BITMAP *)present[1].dat, int(x), int(y));
        }
      }
      break;
    case GRENADE_FLAME:
      anim++;
      if (anim >= 4 * 5)
      {
        anim = 0;
      }
      draw_sprite(back_buffer, (BITMAP *)flames[anim / 5].dat, int(x), int(y) - 18);
      break;
    case DYING_FLAME:
      anim++;
      if (anim >= 4 * 5)
      {
        anim = 0;
        exists = 0;
      }
      else
      {
        draw_sprite(back_buffer, (BITMAP *)flames[4 + anim / 5].dat, int(x), int(y) - 18);
      }
      break;
    case PLASMA:
      anim++;
      if (anim >= 3 * 3)
      {
        anim = 0;
      }
      draw_sprite(back_buffer, (BITMAP *)plasma[anim / 3].dat, int(x) - 15, int(y) - 15 - int(h));
      break;
    case SNOWBALL:
      draw_trans_sprite(back_buffer, snowballshadow, int(x), int(y));
      draw_sprite(back_buffer, (BITMAP *)snowmandat[17].dat, int(x), int(y) - int(h));
      break;
  }
}

void _projectile::do_everything()
{
  int z, a;
  life--;
  x += xv;
  y += yv;
  if (life <= 0)
  {
    exists = 0;
  }
  switch(type)
  {
    case FIRE_PUFF:
    case FLAMETHROWER:
    case HEAT_RAY:
      if (check_collide_with_snowman(type, int(x), int(y)) != -1)
      {
        exists = 0;
        if (hissdelay <= 0)
        {
          play_sound(S_HISS);
          hissdelay = 3;
        }
      }
      if (exists == 0)
      {
        new_particle(int(x) + 1, int(y) - int(h) + 1, T_SPARK);
        new_particle(int(x) + 1, int(y) - int(h) + 1, T_SPARK);
        new_particle(int(x) + 1, int(y) - int(h) + 1, T_SPARK);
        new_particle(int(x) + 1, int(y) - int(h) + 1, T_SPARK);
        new_particle(int(x) + 1, int(y) - int(h) + 1, T_SPARK);
        new_particle(int(x) + 1, int(y) - int(h) + 1, T_SPARK);        
        if (type != HEAT_RAY)
        {
          new_particle(int(x), int(y) - int(h), T_SMOKE);
        }
      }
      break;
    case NAPALM_GRENADE:
      if (life % 5 == 0)
      {
        new_particle(int(x), int(y) - int(h), T_SMOKE);
      }
      h += hv;
      if (h <= 0)
      {
        h = 0;
        hv = 0;
        xv /= 1.1;
        yv /= 1.1;
      }
      else
      {
        hv -= .1;
      }
      if (life <= 0)
      {
        z = 0;
        play_sound(S_PLASMA);
        play_sound(S_FIRE);
        while (z < 30)
        {
          new_projectile(int(x), int(y), GRENADE_FLAME);
          z++;
        }
      }
      break;
    case PRESENT:
      h += hv;
      hv -= .02;
      if (h < 0)
      {
        h = 0;
      }
      if ((h == 0) && (gamestatus == BONUS_ROUND))
      {
        exists = 0;
      }
      if ((player_present_contact(int(x), int(y)) == 1) && (h < 40))
      {
        a = 0;
        z = 1 + rand()%4;
        switch(z)
        {
          case 1:
            a = 30;
            break;
          case 2:
            a = 20;
            break;
          case 3:
            a = 3;
            break;
          case 4:
            a = 5;
            break;
        }
        player.weapon[z].ammo += float(a);
        if (player.weapon[z].ammo > 99)
        {
          player.weapon[z].ammo = 99;
        }
        life = 0;
        exists = 0;
      }
      break;
    case GRENADE_FLAME:
      xv /= 1.2;
      yv /= 1.2;
      if (check_collide_with_snowman(type, int(x) + 1, int(y) + 1) != -1)
      {
        life -= 3;
      }
      if (life <= 0)
      {
        exists = 0;
        new_projectile(int(x), int(y), DYING_FLAME);
      }
      break;
    case DYING_FLAME:
      anim++;
      if (anim % 5 == 0)
      {
        new_particle(int(x) + 3, int(y) - 4, T_SMOKE);
      }
      break;
    case PLASMA:
      check_collide_with_snowman(type, int(x) - 10, int(y) - 10);
      if (anim % 3 == 0)
      {
        new_projectile(int(x) - 10, int(y), DYING_FLAME);
      }
      break;
    case SNOWBALL:
      h += hv;
      if (h <= 0)
      {
        exists = 0;
      }
      else
      {
        hv -= .1;
      }
      if (player.hurting == 0)
      {
        if (snowball_hit_player(int(x), int(y)) == 1)
        {
          exists = 0;
          player.health--;
          player.hurting = 1;
          z = push_back_direction(int(x), int(y));
          switch(z)
          {
            case UP:
              player.hurtyv = -5;
              break;
            case DOWN:
              player.hurtyv = 5;
              break;
            case LEFT:
              player.hurtxv = -5;
              break;
            case RIGHT:
              player.hurtxv = 5;
              break;
          }
        }
      }
      break;
  }
  draw();
}

int check_collide_with_snowman(int type, int x, int y)
{
  int i, l, w;
  int h_lim = 50;
  int retval = -1;
  switch(type)
  {
    case FIRE_PUFF:
    case FLAMETHROWER:
      l = 8;
      w = 8;
      break;
    case HEAT_RAY:
      l = 4;
      w = 4;
      break;
    case GRENADE_FLAME:
      l = 18;
      w = 18;
      h_lim = 10;
      break;
    case PLASMA:
      l = 20;
      w = 20;
      break;
  }
  i = 0;
  while (i < MAX_SNOWMEN)
  {
    if (snowman[i].exists == 1)
    {
      if ((snowman[i].x + 12 < x + l) && (snowman[i].x + 49 > x))
      {
        if ((snowman[i].y - 15 < y + w) && (snowman[i].y + 15 > y))
        {
          if (snowman[i].h < h_lim)
          {  //for GRENADE_FLAME, where a snowman's height makes a difference
            snowman[i].take_damage(type);
            retval = i;
          }
        }
      }
    }
    i++;
  }
  return retval;
}

int player_present_contact(int x, int y)
{
  if ((x < player.x + 41) && (x + 30 > player.x + 3))
  {
    if ((y < player.y + 15) && (y + 30 > player.y - 15))
    {
      return 1;
    }
  }
  return 0;
}

int snowball_hit_player(int x, int y)
{
  if ((x < player.x + 38) && (x + 11 > player.x + 9))
  {
    if ((y < player.y + 6) && (y + 11 > player.y - 13))
    {
      return 1;
    }
  }
  return 0;
}
