#include "snow.h"

extern MIDI *minimidi;

extern _elf player;
extern _projectile projectile[MAX_PROJECTILES];

extern void new_projectile(int x, int y, int type);
extern void clear_projectiles();
extern void draw_weapon_icons();

void do_bonusround()
{
  static int first = 1;
  static int intro = 1;
  static int t = 100;
  int i = 0;
  if (first == 1)
  {
    if (domusic == 1)
    {
      play_looped_midi(minimidi, 1, -1);
    }
    t = 100;
    intro = 1;
    first = 0;
  }
  blit((BITMAP *)bg[0].dat, back_buffer, 0, 0, 0, 0, 640, 480);
  if (intro == 1)
  {
    text_mode(-1);
    textout_centre(back_buffer, comic, "Bonus Round", 320, 250, RED);
    textout_centre(back_buffer, font, "Grab the presents!", 320, 300, RED);
    text_mode(0);
    t--;
    if (t <= 0)
    {
      t = 1500;
      intro = 0;
    }
    player.draw();
  }
  else
  {
    player.do_everything_minigame();
    t--;
    if (t % 50 == 0)
    {
      new_projectile(20 + rand()%600, player.y - 25 + rand()%5, PRESENT);
    }
    i = 0;
    while (i < MAX_PROJECTILES)
    {
      if (projectile[i].exists == 1)
      {
        projectile[i].do_everything();
      }
      i++;
    }
    text_mode(-1);
    textprintf_centre(back_buffer, font, 320, 5, BLACK, "Time: %-1d", t / 50);
    text_mode(0);
    draw_weapon_icons();
    if (t <= 0)
    {
      first = 1;
      gamestatus = LEVEL_TRANSITION;
      player.dir = DOWN;
      player.x = 320;
      player.y = 240;
      player.walking = 0;
      clear_projectiles();
      clear_particles();
    }
  }
}
