#include "snow.h"

volatile int counter;
int gamestatus;
int dovsync;
int doparticles;
int round;
int roundtime;
int score;
int domusic;
int dosfx;
int bestround;
int bestscore;
int meltings;
int bonus_now;
int sound_delay;

_particle p[MAX_PARTICLES];
DATAFILE *data;
DATAFILE *bg;
DATAFILE *midis;
DATAFILE *orb;
DATAFILE *playerdat;
DATAFILE *playertop;
DATAFILE *playerbottom;
DATAFILE *snowmandat;
DATAFILE *snowmanmelt;
DATAFILE *snowthrow;
DATAFILE *weaponpics;
DATAFILE *weapons;
DATAFILE *firepuff;
DATAFILE *grenade;
DATAFILE *plasma;
DATAFILE *present;
DATAFILE *flames;
DATAFILE *sounds;

BITMAP *back_buffer;
BITMAP *shadow;
BITMAP *smallshadow;
BITMAP *snowballshadow;
BITMAP *smokebit;
BITMAP *saved_buffer;
MIDI *titlemidi;
MIDI *gamemidi;
MIDI *minimidi;
MIDI *gameovermidi;
FONT *comic;

extern _elf player;

void timer_handler()
{
  counter++;
}
END_OF_FUNCTION(timer_handler);

void do_menu();
void do_logic();
void do_transition();
void do_bonusround();
void do_christmas_cookie();

void new_particle(int x, int y, int type);
void do_particles();
void clear_particles();
void play_sound(int s);

int main()
{
  srand(time(NULL));
  int defaultgfx = 0;
  int modestried = 0;
  int goodmode = 0;
  int draw_ok;
  int i;
  srand(time(NULL));
  set_color_depth(24);
  LOCK_VARIABLE(counter);
  LOCK_FUNCTION(timer_handler);
  allegro_init();
  install_keyboard();
  install_timer();
  install_int_ex(timer_handler, BPS_TO_TIMER(50));
  gamestatus = MENU;
  draw_ok = 1;
  ifstream opt("snow.ini");
  if (opt.bad())
  {
    defaultgfx = 0;
    dovsync = 0;
    doparticles = 1;
    domusic = 1;
    dosfx = 1;
    bestscore = 0;
    bestround = 0;
  }
  else
  {
    opt >> defaultgfx;
    opt >> dovsync;
    opt >> doparticles;
    opt >> domusic;
    opt >> dosfx;
    opt >> bestround;
    opt >> bestscore;
  }
  while ((modestried < 4) && (goodmode == 0))
  {
    if (defaultgfx == 0)
    {
      if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) != 0)
      {
        defaultgfx = 1;
      }
      else
      {
        goodmode = 1;
      }
      modestried++;
    }
    if (defaultgfx == 1)
    {
      set_color_depth(32);
      if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) != 0)
      {
        defaultgfx = 2;
      }
      else
      {
        goodmode = 1;
      }
      modestried++;
    }
    if (defaultgfx == 2)
    {
      set_color_depth(16);
      if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) != 0)
      {
        defaultgfx = 3;
      }
      else
      {
        goodmode = 1;
      }
      modestried++;
    }
    if (defaultgfx == 3)
    {
      set_color_depth(15);
      if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) != 0)
      {
        defaultgfx = 0;
      }
      else
      {
        goodmode = 1;
      }
      modestried++;
    }
  }
  if (goodmode == 0)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
    return 1;
  }
  if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0)
  {
    install_sound(DIGI_NONE, MIDI_NONE, NULL);
  }
  data = load_datafile("snow.dat");
  if (!data)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to load snow.dat\n%s\n", allegro_error);
    return 1;
  }
  bg = (DATAFILE *)data[0].dat;
  comic = (FONT *)bg[2].dat;
  midis = (DATAFILE *)data[1].dat;
  gamemidi = (MIDI *)midis[0].dat;
  titlemidi = (MIDI *)midis[1].dat;
  minimidi = (MIDI *)midis[2].dat;
  gameovermidi = (MIDI *)midis[3].dat;
  orb = (DATAFILE *)data[2].dat;
  playerdat = (DATAFILE *)data[3].dat;
  playertop = (DATAFILE *)playerdat[1].dat;
  playerbottom = (DATAFILE *)playerdat[0].dat;
  snowmandat = (DATAFILE *)data[4].dat;
  snowmanmelt = (DATAFILE *)snowmandat[18].dat;
  snowthrow = (DATAFILE *)snowmandat[19].dat;
  weaponpics = (DATAFILE *)data[5].dat;
  weapons = (DATAFILE *)data[6].dat;
  firepuff = (DATAFILE *)weapons[0].dat;
  grenade = (DATAFILE *)weapons[2].dat;
  plasma = (DATAFILE *)weapons[3].dat;
  present = (DATAFILE *)data[7].dat;
  flames = (DATAFILE *)data[8].dat;
  sounds = (DATAFILE *)data[9].dat;
  i = 0;
  while (i < MAX_PARTICLES)
  {
    p[i].exists = 0;
    i++;
  }
  set_trans_blender(128, 128, 128, 128);
  back_buffer = create_bitmap(640, 480);
  saved_buffer = create_bitmap(640, 480);
  shadow = create_bitmap(40, 30);
  smallshadow = create_bitmap(16, 16);
  snowballshadow = create_bitmap(11, 11);
  smokebit = create_bitmap(8, 8);
  clear(back_buffer);
  clear_to_color(shadow, TRANS);
  clear_to_color(smallshadow, TRANS);
  clear_to_color(snowballshadow, TRANS);
  ellipsefill(shadow, 20, 15, 19, 15, BLACK);
  circlefill(smallshadow, 7, 7, 8, BLACK);
  circlefill(snowballshadow, 5, 5, 5, BLACK);
  clear_to_color(smokebit, TRANS);
  circlefill(smokebit, 4, 4, 4, BLACK);
  round = 1;
  bonus_now = 0;
  roundtime = 0;
  score = 0;
  player.init();
  while (gamestatus != QUIT)
  {
    while (counter > 0)
    {
      if (((key[KEY_LCONTROL]) || (key[KEY_RCONTROL])) && (key[KEY_B]))
      {  //Ctrl-B is the end-the-game-right-now button
        gamestatus = QUIT;
      }
      switch(gamestatus)
      {
        case MENU:
          do_menu();
          break;
        case LOGIC:
          do_logic();
          break;
        case LEVEL_TRANSITION:
          do_transition();
          break;
        case BONUS_ROUND:
          do_bonusround();
          break;
        case COOKIE:
          do_christmas_cookie();
          break;
      }
      if (key[KEY_F12])
      {
        save_bitmap("scrngrab.bmp", back_buffer, NULL);
      }
      draw_ok = 1;
      counter--;
    }
    if (draw_ok == 1)
    {
      if (dovsync != 0)
      {
        vsync();
      }
      blit(back_buffer, screen, 0, 0, 0, 0, 640, 480);
      draw_ok = 0;
    }
    yield_timeslice();
  }
  destroy_bitmap(back_buffer);
  destroy_bitmap(shadow);
  destroy_bitmap(smokebit);
  destroy_bitmap(smallshadow);
  destroy_bitmap(snowballshadow);
  destroy_bitmap(saved_buffer);
  ofstream settings("snow.ini");
  if (!(settings.bad()))
  {
    settings << defaultgfx << "\n" << dovsync << "\n" << doparticles << "\n" << domusic << "\n" << dosfx << "\n";
    settings << bestround << "\n" << bestscore;
    settings.close();
  }
  return 0;
}
END_OF_MAIN();

void do_menu()
{
  static int selected = 0;
  static int orbanim = 0;
  static int keydelay = 0;
  static int first = 1;
  static int cheatstate = 0;
  if (first == 1)
  {
    if (domusic == 1)
    {
      play_looped_midi(titlemidi, 11, 68);
    }
    cheatstate = 0;
    first = 0;
  }
  clear(back_buffer);
  blit((BITMAP *)bg[1].dat, back_buffer, 0, 0, 0, 0, 640, 480);
  text_mode(-1);
  textout_centre(back_buffer, comic, "Flaming Snow", 320, 100, RED);
  textout_centre(back_buffer, font, "Start Game", 320, 200, BLACK);
  if (doparticles != 1)
  {
    textout_centre(back_buffer, font, "Particles: OFF", 320, 220, BLACK);
  }
  else
  {
    textout_centre(back_buffer, font, "Particles: ON", 320, 220, BLACK);
  }
  if (dovsync == 0)
  {
    textout_centre(back_buffer, font, "Vsync: OFF", 320, 240, BLACK);
  }
  else
  {
    textout_centre(back_buffer, font, "Vsync: ON", 320, 240, BLACK);
  }
  if (domusic == 1)
  {
    textout_centre(back_buffer, font, "Music: ON", 320, 260, BLACK);
  }
  else
  {
    textout_centre(back_buffer, font, "Music: OFF", 320, 260, BLACK);
  }
  if (dosfx == 1)
  {
    textout_centre(back_buffer, font, "SFX: ON", 320, 280, BLACK);
  }
  else
  {
    textout_centre(back_buffer, font, "SFX: OFF", 320, 280, BLACK);
  }
  textout_centre(back_buffer, font, "Quit", 320, 300, BLACK);
  textprintf_centre(back_buffer, font, 140, 460, WHITE, "Highest Round: %-1d", bestround);
  textprintf_centre(back_buffer, font, 500, 460, WHITE, "Highest Score: %-1d", bestscore);
  text_mode(0);
  if (keydelay > 0)
  {
    keydelay--;
  }
  else
  {
    if (key[KEY_UP])
    {
      if (selected > 0)
      {
        selected--;
        keydelay = 10;
      }
    }
    if (key[KEY_DOWN])
    {
      if (selected < 5)
      {
        selected++;
        keydelay = 10;
      }
    }
    if (key[KEY_ESC])
    {
      if (selected != 5)
      {
        selected = 5;
      }
      else
      {
        gamestatus = QUIT;
      }
      keydelay = 12;
    }
    if (key[KEY_ENTER])
    {
      switch(selected)
      {
        case 0:
          gamestatus = LOGIC;
          first = 1;
          break;
        case 1:
          if (doparticles == 1)
          {
            doparticles = 0;
          }
          else
          {
            doparticles = 1;
          }
          break;
        case 2:
          if (dovsync == 1)
          {
            dovsync = 0;
          }
          else
          {
            dovsync = 1;
          }
          break;
        case 3:
          if (domusic == 1)
          {
            domusic = 0;
            stop_midi();
          }
          else
          {
            domusic = 1;
            play_looped_midi(titlemidi, 11, 68);
          }
          break;
        case 4:
          if (dosfx == 1)
          {
            dosfx = 0;
          }
          else
          {
            dosfx = 1;
          }
          break;
        case 5:
          gamestatus = QUIT;
          break;
      }
      keydelay = 20;
    }
  }
  switch(cheatstate)
  {
    case 0:
      if (key[KEY_S])
      {
        cheatstate++;
      }
      break;
    case 1:
      if (key[KEY_N])
      {
        cheatstate++;
      }
      break;
    case 2:
      if (key[KEY_O])
      {
        cheatstate++;
      }
      break;
    case 3:
      if (key[KEY_W])
      {
        first = 1;
        gamestatus = COOKIE;
        cheatstate++;
      }
      break;
  }
  orbanim++;  //animate the little red selection orb
  if (orbanim >= 5 * 5)
  {  //five frames animation, with 5 loops (.1 seconds) per frame
    orbanim = 0;
  }
  draw_sprite(back_buffer, (BITMAP *)orb[orbanim / 5].dat, 232, 189 + (selected * 20));
  if (doparticles == 1)
  {
    new_particle(rand()%630, 0, T_SNOW);
    do_particles();
  }
}

void new_particle(int x, int y, int type)
{
  int i = 0;
  if (doparticles == 1)
  {
    while (i < MAX_PARTICLES)
    {
      if (p[i].exists == 0)
      {
        p[i].init(x, y, type);
        i = MAX_PARTICLES;
      }
      i++;
    }
  }
}

void do_particles()
{
  int i = 0;
  while (i < MAX_PARTICLES)
  {
    if (p[i].exists == 1)
    {
      p[i].draw();
    }
    i++;
  }
}

void clear_particles()
{
  int i = 0;
  while (i < MAX_PARTICLES)
  {
    p[i].exists = 0;
    i++;
  }
}

void do_transition()
{
  static int first = 1;
  static int x, r, g, s;
  if (first == 1)
  {
    r = 0;
    g = 255;
    x = 640;
    s = 0;
    blit(back_buffer, saved_buffer, 0, 0, 0, 0, 640, 480);
    first = 0;
    stop_midi();
  }
  else
  {
    switch(s)
    {
      case 0:
        blit(saved_buffer, back_buffer, 0, 0, 0, 0, 640, 480);
        rectfill(back_buffer, x, 0, 640, 480, GREEN);
        x -= 10;
        if (x <= 0)
        {
          x = 640;
          s = 1;
        }
        break;
      case 1:
        clear_to_color(back_buffer, makecol(r, g, 0));
        r += 3;
        g -= 3;
        if ((r >= 255) || (g <= 0))
        {
          s = 2;
          x = 640;
        }
        text_mode(-1);
        textout_centre(back_buffer, comic, "Round Complete", 320, 220, WHITE);
        text_mode(0);
        break;
      case 2:
        blit((BITMAP *)bg[0].dat, back_buffer, 0, 0, 0, 0, 640, 480);
        player.draw();
        rectfill(back_buffer, 0, 0, x, 480, RED);
        x -= 10;
        if (x <= 0)
        {
          first = 1;
          if ((round % 4 == 0) && (bonus_now == 0))
          {
            gamestatus = BONUS_ROUND;
            bonus_now = 1;
          }
          else
          {
            gamestatus = LOGIC;
            bonus_now = 0;
          }
        }
        break;
    }
  }
}

void play_sound(int s)
{
  if (dosfx == 1)
  {
    play_sample((SAMPLE*)sounds[s].dat, 200, 128, 1000, 0);
  }
}

void do_christmas_cookie()
{
  static int first = 1;
  static int x, y, xv, yv, t;
  static int p1y, score1, score2;
  static float p2y;
  if (first == 1)
  {
    x = 320;
    y = 240;
    xv = rand()%2;
    if (xv == 0) xv = -1;
    yv = rand()%2;
    if (yv == 0) yv = -1;
    xv *= 4;
    yv *= 4;
    p1y = 220;
    p2y = 220;
    score1 = 0;
    score2 = 0;
    t = 100;
    first = 0;
  }
  blit((BITMAP *)bg[1].dat, back_buffer, 0, 0, 0, 0, 640, 480);
  if (t > 0)
  {
    text_mode(-1);
    textout_centre(back_buffer, comic, "Pong!", 320, 235, RED);
    text_mode(0);
    t--;
  }
  else
  {
    x += xv;
    y += yv;
    if (y <= 0)
    {
      yv = abs(yv);
      play_sound(S_BEEP);
    }
    if (y + 11 >= 480)
    {
      yv = -abs(yv);
      play_sound(S_BEEP);
    }
    if (x + 11 < 0)
    {
      score2++;
      x = 320;
      y = 240;
      xv = rand()%2;
      if (xv == 0) xv = -1;
      yv = rand()%2;
      if (yv == 0) yv = -1;
      xv *= 4;
      yv *= 4;
    }
    if (x > 640)
    {
      score1++;
      x = 320;
      y = 240;
      xv = rand()%2;
      if (xv == 0) xv = -1;
      yv = rand()%2;
      if (yv == 0) yv = -1;
      xv *= 4;
      yv *= 4;
    }
    draw_sprite(back_buffer, (BITMAP *)snowmandat[17].dat, x, y);
    rectfill(back_buffer, 20, p1y, 30, p1y + 50, BLUE);
    rect(back_buffer, 20, p1y, 30, p1y + 50, WHITE);
    rectfill(back_buffer, 610, int(p2y), 620, int(p2y) + 50, BLUE);
    rect(back_buffer, 610, int(p2y), 620, int(p2y) + 50, WHITE);
    text_mode(-1);
    textprintf(back_buffer, font, 2, 2, BLACK, "%-1d", score1);
    textprintf_right(back_buffer, font, 638, 2, BLACK, "%-1d", score2);
    text_mode(0);
    if (key[KEY_UP])
    {
      if (p1y > 0)
      {
        p1y -= 4;
      }
    }
    if (key[KEY_DOWN])
    {
      if (p1y < 430)
      {
        p1y += 4;
      }
    }
    if ((p2y > y) && (p2y > 0))
    {
      p2y -= 3.7;
    }
    if ((p2y < y) && (p2y < 430))
    {
      p2y += 3.7;
    }
    if (key[KEY_ESC])
    {
      first = 1;
      gamestatus = MENU;
    }
    if ((x < 30) && (x + 11 > 20))
    {
      if ((y + 11 > p1y) && (y < p1y + 50))
      {
        xv = abs(xv);
        play_sound(S_BOOP);
      }
    }
    if ((x < 620) && (x + 11 > 610))
    {
      if ((y + 11 > int(p2y)) && (y < int(p2y) + 50))
      {
        xv = -abs(xv);
        play_sound(S_BOOP);
      }
    }    
  }
}
