#include "snow.h"

typedef struct _ysort
{
  int y;
  int num;
}_ysort;

_elf player;
_snowman snowman[MAX_SNOWMEN];
_projectile projectile[MAX_PROJECTILES];

extern int doparticles;
extern int bestround, bestscore;
extern int hissdelay;

extern MIDI *gamemidi;
extern MIDI *gameovermidi;
extern DATAFILE *playerdat;
extern DATAFILE *weaponpics;
extern DATAFILE *sounds;

extern void new_projectile(int x, int y, int type);

void draw_healthbar();
void draw_weapon_icons();
void make_new_snowman();
void drop_present();
void put_offscreen(int &x, int &y);
void clear_projectiles();
int do_deathscreen();
int existing_snowmen();

void do_logic()
{
  static int first = 1;
  static int snowdelay = 3;
  static int t = 0;
  static int escdelay = 0;
  static int escstatus = 0;
  int i = 0;
  int j;
  int min;
  int playerdrawn = 0;
  _ysort temp;
  vector<_ysort> draworder;
  draworder.reserve(MAX_SNOWMEN + (MAX_PROJECTILES / 2) + 1);
  if (first == 1)
  {
    escdelay = 0;
    escstatus = 0;
    clear_particles();
    if (domusic == 1)
    {
      play_looped_midi(gamemidi, 20, 116);
    }
    roundtime = 90 * 50;  //A minute and a half
    first = 0;
    i = 0;
    while (i < MAX_SNOWMEN)
    {
      snowman[i].exists = 0;
      i++;
    }
    t = 740;
    meltings = 0;
    sound_delay = 0;
    hissdelay = 0;
  }
  blit((BITMAP *)bg[0].dat, back_buffer, 0, 0, 0, 0, 640, 480);
  if (sound_delay > 0)
  {
    sound_delay--;
  }
  if (hissdelay > 0)
  {
    hissdelay--;
  }
  if (t > 0)
  {  //if it's doing the level intro
    player.draw();
    draw_healthbar();
    draw_weapon_icons();
    text_mode(-1);
    textprintf_centre(back_buffer, font, 320, 5, BLACK, "Meltings: %-1d", meltings);
    textprintf_centre(back_buffer, font, 320, 15, BLACK, "Time: %-1d", roundtime / 50);
    textprintf(back_buffer, comic, t - 100, 200, RED, "Round %-1d", round);
    if (score >= bestscore)
    {
      textprintf(back_buffer, font, 110, 5, GREEN, "Score: %-1d", score);
    }
    else
    {
      textprintf(back_buffer, font, 110, 5, BLACK, "Score: %-1d", score);
    }
    text_mode(0);
    t -= 7;
  }
  else if ((escstatus == 0) && (player.health > 0))
  {  //if it's not in the "do you want to quit" screen
    if (escdelay > 0)
    {
      escdelay--;
    }
    if (key[KEY_ESC])
    {
      if (escdelay <= 0)
      {
        escstatus = 1;
        escdelay = 20;
      }
    }
    i = 0;
    while (i < MAX_SNOWMEN)
    {
      if (snowman[i].exists == 1)
      {
        temp.y = snowman[i].y;
        temp.num = i;
        draworder.push_back(temp);
      }
      i++;
    }
    i = 0;
    while (i < MAX_PROJECTILES)
    {
      if (projectile[i].exists == 1)
      {
        temp.y = int(projectile[i].y);
        temp.num = 100 + i;
        draworder.push_back(temp);
      }
      i++;
    }
    temp.y = player.y;
    temp.num = -1;
    draworder.push_back(temp);
    i = 0;
    while (i < draworder.size() - 1)
    {  //arrange draworder in order of smallest y to largest
      min = i;
      j = i;
      while (j < draworder.size())
      {
        if (draworder[j].y < draworder[min].y)
        {
          min = j;
        }
        j++;
      }
      if (min != i)
      {
        temp = draworder[i];
        draworder[i] = draworder[min];
        draworder[min] = temp;
      }
      i++;
    }   
    i = 0;
    while (i < draworder.size())
    {  //draw according to how draworder is arranged
      if (draworder[i].num == -1)
      {
        player.do_everything();
      }
      else if (draworder[i].num < 100)
      {
        snowman[draworder[i].num].do_everything();
      }
      else
      {
        projectile[draworder[i].num - 100].do_everything();      
      }
      i++;
    }
    make_new_snowman();
    drop_present();
    draw_healthbar();
    draw_weapon_icons();
    text_mode(-1);
    textprintf_centre(back_buffer, font, 320, 5, BLACK, "Meltings: %-1d", meltings);
    textprintf_centre(back_buffer, font, 320, 15, BLACK, "Time: %-1d", roundtime / 50);
    if (score >= bestscore)
    {
      textprintf(back_buffer, font, 110, 5, GREEN, "Score: %-1d", score);
    }
    else
    {
      textprintf(back_buffer, font, 110, 5, BLACK, "Score: %-1d", score);
    }
    text_mode(0);
    roundtime--;
    if (roundtime <= 0)
    {
      player.dir = DOWN;
      player.x = 320;
      player.y = 240;
      player.health += 2;
      player.hurting = 0;
      player.walking = 0;
      if (player.health >= 10)
      {
        player.health = 10;
      }
      round++;
      clear_projectiles();
      clear_particles();
      i = 0;
      while (i < TOTAL_SOUNDS)
      {
        stop_sample((SAMPLE *)sounds[i].dat);
        i++;
      }
      if ((round % 4 == 0) && (bonus_now == 0))
      {  //if it is going into the weapon-collection minigame
        player.y = 450;
      }
      gamestatus = LEVEL_TRANSITION;
      first = 1;
    }
    if (doparticles == 1)
    {
      snowdelay--;
      if (snowdelay <= 0)
      {
        new_particle(rand()%630, 0, T_SNOW);
        snowdelay = 3;
      }
      do_particles();
    }
  }
  else if (escstatus == 1)
  {  //if it is in the "do you want to quit" screen
    rectfill(back_buffer, 100, 150, 540, 330, WHITE);
    rect(back_buffer, 100, 150, 540, 330, BLACK);
    text_mode(-1);
    textout_centre(back_buffer, comic, "Paused", 320, 160, BLACK);
    textout_centre(back_buffer, font, "Do you want to quit?", 320, 200, BLACK);
    textout_centre(back_buffer, comic, "Yes: ESC", 200, 240, RED);
    textout_centre(back_buffer, comic, "No: Enter", 440, 240, GREEN);
    text_mode(0);
    if (escdelay > 0)
    {
      escdelay--;
    }
    else
    {
      if (key[KEY_ESC])
      {
        first = 1;
        clear_particles();
        clear_projectiles();
        gamestatus = MENU;
        round = 1;
        player.init();
        roundtime = 0;
        score = 0;
        escdelay = 20;
      }
      else if (key[KEY_ENTER])
      {
        escstatus = 0;
        escdelay = 10;
      }
    }
  }
  else
  {  //if the player has run out of health
    if (do_deathscreen() == 1)
    {  //if do_deathscreen() returns 1, then it's going back to the menu
      first = 1;
    }
  }
}

void draw_healthbar()
{
  int i = 0;
  rectfill(back_buffer, 4, 4, 106, 16, BLACK);
  while (i < player.health)
  {  //draw a festive health bar
    if (i % 2 == 0)
    {
      rectfill(back_buffer, 5 + (10 * i), 5, 15 + (10 * i), 15, RED);
    }
    else
    {
      rectfill(back_buffer, 5 + (10 * i), 5, 15 + (10 * i), 15, GREEN);
    }
    i++;
  }
}

void draw_weapon_icons()
{
  int i = 0;
  text_mode(-1);
  while (i < 5)
  {  //draw each icon and show its ammo underneath
    draw_sprite(back_buffer, (BITMAP *)weaponpics[i].dat, 530 + (21 * i), 5);
    if (i > 0)
    {
      textprintf_centre(back_buffer, font, 540 + (21 * i), 25, BLACK, "%-1d", int(player.weapon[i].ammo));
    }
    else
    {
      textout_centre(back_buffer, font, "-", 540, 25, BLACK);
    }
    i++;
  }  //and put a blue rectangle around the selected weapon
  rect(back_buffer, 529 + (21 * player.selected), 4, 550 + (21 * player.selected), 33, BLUE);
  text_mode(0);
}

void make_new_snowman()
{
  static int t = 0;
  int delay;
  int i, x, y, z;
  int round_max;
  delay = 100;  //2 seconds
  delay -= (round - 1) * 5;
  if (delay < 25)  //if less than half a second
  {
    delay = 25;
  }
  switch(round)
  {
    case 1:
      round_max = 3;
      break;
    case 2:
      round_max = 5;
      break;
    case 3:
      round_max = 7;
      break;
    case 4:
      round_max = 10;
      break;
    case 5:
      round_max = 14;
      break;
    case 6:
      round_max = 17;
      break;
    default:
      round_max = MAX_SNOWMEN;
      break;
  }
  if (round_max > MAX_SNOWMEN)
  {
    round_max = MAX_SNOWMEN;
  }
  t++;
  if (existing_snowmen() >= round_max)
  {
    t = 0;
  }
  if (t >= delay)
  {
    i = 0;
    while (i < MAX_SNOWMEN)
    {
      if (snowman[i].exists == 0)
      {
        x = -20 + rand()%680;
        y = -20 + rand()%520;
        put_offscreen(x, y);
        snowman[i].init(x, y);
        i = MAX_SNOWMEN;
      }
      i++;
    }
    t = 0;
  }
}

void put_offscreen(int &x, int &y)
{
  int d1, d2, z;
  z = rand()%2;
  if (z == 0) z = -1;
  if ((x > -10) && (x < 650))
  {
    if ((y > -10) && (y < 490))
    {
      d1 = abs(320 - x);
      d2 = abs(240 - y);
      if (d1 < d2)
      {
        if (z == -1)
        {
          y = -15;
        }
        else
        {
          y = 495;
        }
      }
      else
      {
        if (z == -1)
        {
          x = -15;
        }
        else
        {
          x = 655;
        }
      }
    }
  }
}

int existing_snowmen()
{
  int i = 0;
  int count = 0;
  while (i < MAX_SNOWMEN)
  {
    if (snowman[i].exists == 1)
    {
      count++;
    }
    i++;
  }
  return count;
}

int do_deathscreen()
{
  int movelength = 4;
  int moved = 0;
  int returnstatus = 0;
  int drawnormal = 1;
  static int first = 1;
  static int deathanim = 0;
  static int finishedturning = 0;
  static int midiplayed = 0;
  if (first == 1)
  {
    midiplayed = 0;
    deathanim = 0;
    first = 0;
    finishedturning = 0;
    player.walking = 0;
    player.hurting = 0;
    stop_midi();
  }
  clear(back_buffer);
  if (player.x > 320 + movelength)
  {
    player.x -= movelength;
    moved = 1;
  }
  else if (player.x < 320 - movelength)
  {
    player.x += movelength;
    moved = 1;
  }
  if (player.y > 250 + movelength)
  {
    player.y -= movelength;
    moved = 1;
  }
  else if (player.y < 250 - movelength)
  {
    player.y += movelength;
    moved = 1;
  }
  if (moved == 0)
  {
    if (midiplayed == 0)
    {
      if (domusic == 1)
      {
        play_midi(gameovermidi, 0);
      }
      midiplayed = 1;
    }
    if (finishedturning == 0)
    {
      deathanim++;
      switch((deathanim / 7) % 4)
      {
        case 0:
          player.dir = LEFT;
          break;
        case 1:
          player.dir = UP;
          break;
        case 2:
          player.dir = RIGHT;
          break;
        case 3:
          player.dir = DOWN;
          break;
      }
      if ((deathanim > 80) && (player.dir == DOWN))
      {
        finishedturning = 1;
      }
    }
    else
    {
      draw_sprite(back_buffer, (BITMAP *)playerdat[2].dat, player.x, player.y - 40);
      drawnormal = 0;
      textprintf_centre(back_buffer, font, 320, 90, WHITE, "Round: %-1d    Score: %-1d", round, score);
      textout(back_buffer, comic, "Game Over", 200, 320, RED);
      textout(back_buffer, font, "Press Enter", 230, 360, RED);
      if (key[KEY_ENTER])
      {
        if (round > bestround)
        {
          bestround = round;
        }
        if (score > bestscore)
        {
          bestscore = score;
        }
        clear_particles();
        clear_projectiles();
        first = 1;
        gamestatus = MENU;
        returnstatus = 1;
        round = 1;
        player.init();
        roundtime = 0;
        score = 0;
      }
    }
  }
  if (drawnormal == 1)
  {
    player.draw();
  }
  return returnstatus;
}

void drop_present()
{
  int r;
  int x = 20 + rand()%600;
  int y = 20 + rand()%440;
  if (round > 6)
  {
    r = rand()%250;
  }
  else if (round > 4)
  {
    r = rand()%500;
  }
  else
  {
    r = rand()%1000;
  }
  if (r == 0)
  {
    new_projectile(x, y, PRESENT);
  }
}

void clear_projectiles()
{
  int i = 0;
  while (i < MAX_PROJECTILES)
  {
    projectile[i].exists = 0;
    i++;
  }
}
