#ifndef _snow_h
#define _snow_h

#include <time.h>
#include <math.h>
#include <fstream.h>
#include <vector>
#include <allegro.h>
#include <winalleg.h>
#include "snowparticle.h"
#include "snowweapon.h"
#include "snowplayer.h"
#include "snowman.h"
#include "snowprojectile.h"

#define QUIT             -1
#define MENU             0
#define LOGIC            1
#define LEVEL_TRANSITION 2
#define BONUS_ROUND      3
#define COOKIE           4

#define UP    0
#define DOWN  1
#define LEFT  2
#define RIGHT 3

#define MAX_PARTICLES   500
#define MAX_SNOWMEN     20
#define MAX_PROJECTILES 250

#define FIRE_PUFF      0
#define FLAMETHROWER   1
#define HEAT_RAY       2
#define NAPALM_GRENADE 3
#define PLASMA         4
#define MELT_ANIM      5
#define PRESENT        6
#define GRENADE_FLAME  7
#define DYING_FLAME    8
#define SNOWBALL       9

#define T_SNOW         0
#define T_SMOKE        1
#define T_SPARK        2

#define S_FIRE         0
#define S_FLAMETHROWER 1
#define S_HISS         2
#define S_THROW        3
#define S_WALK1        4
#define S_WALK2        5
#define S_SNOWHOP      6
#define S_PLASMA       7
#define S_SMALLBURN    8
#define S_HEATRAY      9
#define S_GRENADE      10
#define S_MELT         11
#define S_BEEP         12
#define S_BOOP         13
#define TOTAL_SOUNDS   14

#define BLACK makecol(0, 0, 0)
#define RED makecol(255, 0, 0)
#define GREEN makecol(0, 255, 0)
#define DGREEN makecol(0, 150, 0)
#define BLUE makecol(0, 0, 255)
#define YELLOW makecol(255, 255, 0)
#define DYELLOW makecol(150, 150, 0)
#define ORANGE makecol(255, 128, 0)
#define WHITE makecol(255, 255, 255)
#define TRANS makecol(255, 0, 255)

extern DATAFILE *data;
extern DATAFILE *bg;
extern BITMAP *back_buffer;
extern BITMAP *shadow;
extern BITMAP *smokebit;
extern FONT *comic;

extern int gamestatus;
extern int round;
extern int roundtime;
extern int score;
extern int meltings;
extern int bonus_now;
extern int domusic;
extern int sound_delay;

extern void new_particle(int x, int y, int type);
extern void do_particles();
extern void clear_particles();
extern void play_sound(int s);

#endif
