#include "snow.h"

extern DATAFILE *playertop;
extern DATAFILE *playerbottom;

void _elf::init()
{
  int i = 0;
  health = 10;
  x = 320;
  y = 240;
  dir = DOWN;
  anim = 0;
  selected = 0;
  hurting = 0;
  hurtxv = 0;
  hurtyv = 0;
  hurt_timer = 0;
  walking = 0;
  sound = 0;
  while (i < 5)
  {
    weapon[i].anim = 0;
    weapon[i].type = i;
    weapon[i].delay = 0;
    weapon[i].ammo = 0;
    i++;
  }
  weapon[0].ammo = 99;
}

void _elf::draw()
{
  int i = 0;
  draw_trans_sprite(back_buffer, shadow, x + 2, y - 22);
  draw_sprite(back_buffer, (BITMAP *)playerbottom[dir * 3 + anim / 10].dat, x, y - 29);
  if (dir == LEFT)
  {
    draw_sprite(back_buffer, (BITMAP *)playertop[dir].dat, x - 9, y - 58 - 29);
  }
  else
  {
    draw_sprite(back_buffer, (BITMAP *)playertop[dir].dat, x - 1, y - 58 - 29);
  }
  if ((hurting == 1) && (hurt_timer % 2 == 0))
  {
    draw_trans_sprite(back_buffer, (BITMAP *)playerbottom[12 + dir * 3 + anim / 10].dat, x, y - 29);
    if (dir == LEFT)
    {
      draw_trans_sprite(back_buffer, (BITMAP *)playertop[4 + dir].dat, x - 9, y - 58 - 29);
    }
    else
    {
      draw_trans_sprite(back_buffer, (BITMAP *)playertop[4 + dir].dat, x - 1, y - 58 - 29);
    }
  }
  if (walking == 1)
  {
    anim++;
    if (anim >= 3 * 10)
    {
      anim = 0;
    }
  }
}

void _elf::do_everything()
{
  int i = 0;
  walking = 0;
  if (key[KEY_LEFT])
  {
    dir = LEFT;
    if (x - 10 > 0)
    {
      x -= 2;
    }
    walking = 1;
  }
  if (key[KEY_RIGHT])
  {
    dir = RIGHT;
    if (x + 47 < 640)
    {
      x += 2;
    }
    walking = 1;
  }
  if (key[KEY_UP])
  {
    dir = UP;
    if (y - 50 > 0)
    {
      y -= 2;
    }
    walking = 1;
  }
  if (key[KEY_DOWN])
  {
    dir = DOWN;
    if (y + 1 < 480)
    {
      y += 2;
    }
    walking = 1;
  }
  if (anim / 10 == 2)
  {
    if (sound >= 0)
    {
      sound--;
    }
    else
    {
      if (walking == 1)
      {
        play_sound(S_WALK1 + rand()%2);
        sound = 10;
      }
    }
  }
  if (weapon[selected].delay == 0)
  {
    if (key[KEY_1])
    {
      if (selected != 0)
      {
        selected = 0;
        weapon[0].delay = 20;
      }
    }
    if (key[KEY_2])
    {
      if (selected != 1)
      {
        if (weapon[1].ammo > 0)
        {
          selected = 1;
          weapon[1].delay = 20;
        }
      }
    }
    if (key[KEY_3])
    {
      if (selected != 2)
      {
        if (weapon[2].ammo > 0)
        {
          selected = 2;
          weapon[2].delay = 20;
        }
      }
    }
    if (key[KEY_4])
    {
      if (selected != 3)
      {
        if (weapon[3].ammo > 0)
        {
          selected = 3;
          weapon[3].delay = 20;
        }
      }
    }
    if (key[KEY_5])
    {
      if (selected != 4)
      {
        if (weapon[4].ammo > 0)
        {
          selected = 4;
          weapon[4].delay = 20;
        }
      }
    }
  }
  if (weapon[selected].delay <= 0)
  {
    if (key[KEY_SPACE])
    {
      weapon[selected].fire(x, y);
    }
  }
  i = 0;
  while(i < 5)
  {
    if (weapon[i].delay > 0)
    {
      weapon[i].delay--;
    }
    i++;
  }
  if (hurtxv != 0)
  {
    x += hurtxv;
    if (hurtxv < 0)
    {
      hurtxv++;
    }
    else
    {
      hurtxv--;
    }
  }
  if (hurtyv != 0)
  {
    y += hurtyv;
    if (hurtyv < 0)
    {
      hurtyv++;
    }
    else
    {
      hurtyv--;
    }
  }
  draw();
  if (hurting == 1)
  {
    hurt_timer++;
    if (hurt_timer >= 20)
    {
      hurt_timer = 0;
      hurting = 0;
    }
  }
}

void _elf::do_everything_minigame()
{
  walking = 0;
  if (key[KEY_LEFT])
  {
    dir = LEFT;
    if (x - 10 > 0)
    {
      x -= 2;
    }
    walking = 1;
  }
  if (key[KEY_RIGHT])
  {
    dir = RIGHT;
    if (x + 47 < 640)
    {
      x += 2;
    }
    walking = 1;
  }
  draw();
}
