#include "snow.h"

void _particle::init(int px, int py, int ptype)
{
  int z;
  float q = 1;
  exists = 1;
  x = float(px);
  y = float(py);
  type = ptype;
  switch(type)
  {
    case T_SNOW:
      q /= (rand()%5 + 4);
      z = rand()%2;
      if (z == 0) z = -1;
      xv = (0.05 + q) * float(z);
      yv = 1;
      life = int(480 / yv);
      break;
    case T_SMOKE:
      q /= (rand()%5 + 4);
      z = rand()%2;
      if (z == 0) z = -1;
      xv = (0.07 + q) * float(z);
      yv = -1.3;
      life = 9;
      break;
    case T_SPARK:
      q /= (1 + rand()%4);
      z = rand()%2;
      if (z == 0) z = -1;
      xv = (1 + q) * float(z);
      q = 1 / (1 + rand()%4);
      z = rand()%2;
      if (z == 0) z = -1;
      yv = (1 + q) * float(z);
      life = 5;
      break;
  }
}

void _particle::draw()
{
  switch(type)
  {
    case T_SNOW:
      putpixel(back_buffer, int(x), int(y), WHITE);
      putpixel(back_buffer, int(x) - 1, int(y), WHITE);
      putpixel(back_buffer, int(x), int(y) - 1, WHITE);
      putpixel(back_buffer, int(x) + 1, int(y), WHITE);
      putpixel(back_buffer, int(x), int(y) + 1, WHITE);
      break;
    case T_SMOKE:
      draw_trans_sprite(back_buffer, smokebit, int(x), int(y));
      break;
    case T_SPARK:
      putpixel(back_buffer, int(x), int(y), RED);
      putpixel(back_buffer, int(x) + 1, int(y), ORANGE);
      putpixel(back_buffer, int(x), int(y) + 1, ORANGE);
      putpixel(back_buffer, int(x) - 1, int(y), ORANGE);
      putpixel(back_buffer, int(x), int(y) - 1, ORANGE);
      break;
  }
  x += xv;
  y += yv;
  life--;
  if (life <= 0)
  {
    exists = 0;
  }
}
