#include "snow.h"

extern DATAFILE *snowmandat;
extern DATAFILE *snowthrow;

extern _elf player;

extern void new_projectile(int x, int y, int type);
extern void new_projectile(int x, int y, int type, int dir);

int push_back_direction(int x, int y);

_snowman::_snowman()
{
  exists = 0;
  x = 0;
  y = 0;
}

void _snowman::init(int px, int py)
{
  x = px;
  y = py;
  h = 0;
  hv = 0;
  anim = 0;
  hurting = 0;
  health = 10;
  movedelay = 0;
  moving = 0;
  throwing = 0;
  next_action = -1;
  exists = 1;
  dir = RIGHT;  //they should start offscreen, so starting dir doesn't matter
}

void _snowman::draw()
{
  int q = 0;
  if ((moving == 1) || (throwing == 1))
  {
    anim++;
    if (anim >= 4 * 8)
    {
      anim = 0;
    }
  }
  draw_trans_sprite(back_buffer, shadow, x + 12, y - 25);
  if (throwing != 1)
  {
    draw_sprite(back_buffer, (BITMAP *)snowmandat[(4 * dir) + (anim / 8)].dat, x, y - 70 - int(h));
  }
  else
  {
    draw_sprite(back_buffer, (BITMAP *)snowthrow[(4 * dir) + (anim / 8)].dat, x, y - 70 - int(h));
  }
  if (hurting == 1)
  {
    if (dir == LEFT)
    {
      q = -1;
    }
    draw_trans_sprite(back_buffer, (BITMAP *)snowmandat[16].dat, x + q, y - 70 - int(h));
  }
}

void _snowman::do_everything()
{
  int z, d;
  if ((moving == 0) && (throwing == 0))
  {
    if (key[KEY_S])
    {
      next_action = 1;
    }
    if (next_action == 0)
    {  //0 means move
      movedelay--;
      if (movedelay <= 0)
      {
        moving = 1;
        next_action = -1;
        hv = 1 + rand()%2;
        h += hv;
      }
    }
    else if (next_action == 1)
    {  //1 means throw snowball
      throwing = 1;
      anim = 1;
      next_action = -1;
    }
    else
    {
      d = 12;
      if (round < 4)
      {
        d = 112 - (round * 20);
      }
      z = rand()%d;
      if (round == 1)
      {  //no snowballs thrown in round 1
        z = 1;
      }
      if (z == 0)
      {
        next_action = 1;
      }
      else
      {
        next_action = 0;
      }
    }
    if (player.x < x)
    {
      z = x - player.x;
      dir = LEFT;
    }
    else
    {
      z = player.x - x;
      dir = RIGHT;
    }
    if (player.y < y)
    {
      if (y - player.y > z)
      {  //if the player is further away in y than x, go in the y direction
        dir = UP;
      }
    }
    else
    {
      if (player.y - y > z)
      {
        dir = DOWN;
      }
    }
  }
  else if (throwing == 1)
  {
    if (anim == 0)
    {
      throwing = 0;
      new_projectile(x, y, SNOWBALL, dir);
      play_sound(S_THROW);
    }
  }
  else
  {
    switch(dir)
    {
      case UP:
        y -= 2;
        break;
      case DOWN:
        y += 2;
        break;
      case LEFT:
        x -= 2;
        break;
      case RIGHT:
        x += 2;
        break;
    }
    if (h > 0)
    {
      h += hv;
      hv -= 0.1;
    }
    if (h <= 0)
    {
      play_sound(S_SNOWHOP);
      moving = 0;
      movedelay = 50;
      h = 0;
    }
  }
  if (player.hurting == 0)
  {
    if (collision_with_player() == 1)
    {
      player.health -= 2;
      player.hurting = 1;
      d = push_back_direction(x, y);
      switch(d)
      {
        case UP:
          player.hurtyv = -10;
          break;
        case DOWN:
          player.hurtyv = 10;
          break;
        case LEFT:
          player.hurtxv = -10;
          break;
        case RIGHT:
          player.hurtxv = 10;
          break;
      }
    }
  }
  draw();
  if (hurting == 1)
  {
    hurting = 0;
  }
}

void _snowman::take_damage(int type)
{
  float dmg = 0;
  hurting = 1;
  switch(type)
  {
    case FIRE_PUFF:
      dmg = 1.5;
      break;
    case FLAMETHROWER:
      dmg = 0.75;
      break;
    case HEAT_RAY:
      dmg = 0.7;
      break;
    case GRENADE_FLAME:
      dmg = 0.1;
      break;
    case PLASMA:
      dmg = 10;
      break;
  }
  health -= dmg;
  if (health <= 0)
  {
    play_sound(S_MELT);
    exists = 0;
    meltings++;
    score += meltings * round;
    new_projectile(x, y, MELT_ANIM);
  }
}


int _snowman::collision_with_player()
{
  if ((x + 12 < player.x + 41) && (x + 49 > player.x + 3))
  {
    if ((y - 15 < player.y + 15) && (y + 15 > player.y - 15))
    {
      return 1;
    }
  }
  return 0;
}

int push_back_direction(int x, int y)
{
  int d = -1;
  int z;
  if (player.x > x)
  {  //get the direction the player should be pushed back in
    z = player.x - x;
    if (player.y > y)
    {
      if (player.y - y > z)
      {
        d = DOWN;
      }
      else
      {
        d = RIGHT;
      }
    }
    else
    {
      if (y - player.y > z)
      {
        d = UP;
      }
      else
      {
        d = RIGHT;
      }
    }
  }
  else
  {
    z = x - player.x;
    if (player.y > y)
    {
      if (player.y - y > z)
      {
        d = DOWN;
      }
      else
      {
        d = LEFT;
      }
    }
    else
    {
      if (y - player.y > z)
      {
        d = UP;
      }
      else
      {
        d = LEFT;
      }
    }
  }
  return d;
}
