#include "CPeca.h"
#include <malloc.h>
#include <string.h>

CPeca::CPeca( int x, int y, int **gm, int valor, int sqrs )
{

	this->comps = new CSquare*[ sqrs ];

	for ( int i=0; i<sqrs; i++ )
	{
		comps[ i ] = new CSquare( valor );

		comps[ i ]->setXpos(x);

		comps[ i ]->setYpos(y);
	}

	this->xini = x;

	this->yini = y;

	this->game_matrix = gm;

	this->state = 0;

	this->colidiu = false;

	this->sqrs = sqrs;

}

bool CPeca::Zera_Peca(  )
{

	this->colidiu = false;

	this->state = 0;

	bool success = true;

	if(sqrs > 3)
	{
		comps[ 2 ]->setXpos( xini );

		comps[ 2 ]->setYpos( yini );
	}
	else
	{
		comps[ 0 ]->setXpos( xini );

		comps[ 0 ]->setYpos( yini );
	}

	restart( 0 );

	for(  int i = 0; i < sqrs; i++  )
	{

		if( game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] == 0 )
			game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] = comps[ 0 ]->getValor(  );

		else
		{

			success = false;
			break;

		}

	}

	return success;

}

void CPeca::movX(  int Xadd  )
{
	int i;

	int count = 0;


	for(  i = 0; i < sqrs; i++ )
		this->game_matrix[  comps[ i ]->getYpos(  )  ][  comps[ i ]->getXpos(  )  ] = 0;
	

	for ( i = 0; i < sqrs; i++ )
	{
		if(  comps[ i ]->getXpos(  ) + Xadd < 10  )
		{

			if (  this->game_matrix[  comps[ i ]->getYpos(  )  ][  comps[ i ]->getXpos(  )+Xadd  ] == 0 )
				count++;

		}
		else
			break;
	}
	

	if( count==sqrs )
	{

		for ( i = 0; i < sqrs; i++ )
		{

			this->game_matrix[  comps[ i ]->getYpos(  )  ][  comps[ i ]->getXpos(  )+Xadd  ] = comps[ i ]->getValor(  );

			comps[ i ]->setXpos(  comps[ i ]->getXpos(  ) + Xadd  );

		}

	}
	else
	{
		for ( i = 0; i < sqrs; i++ )
		{
			this->game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] = comps[ i ]->getValor(  );
		}
	}
}

bool CPeca::movY(  )
{

	int i;

	for( int j = 0; j < sqrs; j++ )
	{

		this->game_matrix[comps[j]->getYpos()][comps[j]->getXpos()] = 0;

	}

	for(  i = 0 ; i < sqrs; i++ )
	{

		if(  comps[ i ]->getYpos(  ) >= 19 || this->game_matrix[  comps[ i ]->getYpos(  ) + 1  ][  comps[ i ]->getXpos(  )  ] != 0 )
		{

			for(  i = 0; i < sqrs; i++ )
				this->game_matrix[  comps[ i ]->getYpos(  )  ][  comps[ i ]->getXpos(  )  ] = comps[ 0 ]->getValor(  );

			colidiu = true;

			return colidiu;

		}

	}

	for(  i = 0 ; i < sqrs ; i++ )
	{ 

		this->game_matrix[  comps[ i ]->getYpos(  ) + 1  ][  comps[ i ]->getXpos(  )  ] = comps[ i ]->getValor(  );
		
		comps[ i ]->setYpos(  comps[ i ]->getYpos(  ) + 1  );

	}

	colidiu = false;

	return colidiu;

}

void CPeca::desenha()
{

	int i;

	for( i = 0; i < sqrs; i++)
		this->game_matrix[ comps[i]->getYpos() ][ comps[i]->getXpos() ] = comps[i]->getValor();

}

void CPeca::Rotate_0(  )
{

	int i;
	for(  i = 0; i < sqrs; i++ )
	{
		this->game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] = 0;
	}
	
	this->restart( 1 );
	
	for(  i = 0; i < sqrs; i++  )
	{
		if( comps[ i ]->getYpos(  ) < 20 && comps[ i ]->getXpos(  ) >= 0 && comps[ i ]->getXpos(  ) < 10 && comps[ i ]->getYpos(  ) >= 0 )
		{
			if( game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] != 0 )
			{
				this->restart( 0 );
				this->desenha(  );
				return;
			}
		}
		else
		{
			this->restart( 0 );
			this->desenha(  );
			return;
		}
	}
	
	this->desenha(  );
	
	this->state = 1;

}

void CPeca::Rotate_1_2(  )
{

	int i;
	for(  i = 0; i < sqrs; i++ )
	{
		this->game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] = 0;
	}

	this->restart(0);
	
	for(  i = 0; i < sqrs; i++  )
	{
		if( comps[ i ]->getYpos(  ) < 20 && comps[ i ]->getXpos(  ) >= 0 && comps[ i ]->getXpos(  ) < 10 && comps[ i ]->getYpos(  ) >= 0 )
		{
			if( game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] != 0 )
			{
				this->restart(1);
				this->desenha(  );
				return;
			}
		}
		else
		{
			this->restart(1);
			this->desenha(  );
			return;
		}
	}
	
	this->desenha(  );
	
	this->state = 0;

}

void CPeca::Rotate_1_4(  )
{

	int i;
	for(  i = 0; i < sqrs; i++ )
	{
		this->game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] = 0;
	}

	this->restart( 2 );
	
	for(  i = 0; i < sqrs; i++  )
	{
		if( comps[ i ]->getYpos(  ) < 20 && comps[ i ]->getXpos(  ) >= 0 && comps[ i ]->getXpos(  ) < 10 && comps[ i ]->getYpos(  ) >= 0 )
		{
			if( game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] != 0 )
			{
				this->restart(1);
				this->desenha(  );
				return;
			}
		}
		else
		{
			this->restart(1);
			this->desenha(  );
			return;
		}
	}
	
	this->desenha(  );
	
	this->state = 2;

}

void CPeca::Rotate_2(  )
{
	int i;
	for(  i = 0; i < sqrs; i++ )
	{
		this->game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] = 0;
	}

	this->restart(3);
	
	for(  i = 0; i < sqrs; i++  )
	{
		if( comps[ i ]->getYpos(  ) < 20 && comps[ i ]->getXpos(  ) >= 0 && comps[ i ]->getXpos(  ) < 10 && comps[ i ]->getYpos(  ) >= 0)
		{
			if( game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] != 0 )
			{
				this->restart( 2 );
				this->desenha(  );
				return;
			}
		}
		else
		{
			this->restart( 2 );
			this->desenha(  );
			return;
		}
	}
	
	this->desenha(  );
	
	this->state = 3;
}

void CPeca::Rotate_3(  )
{

	int i;
	for(  i = 0; i < sqrs; i++ )
	{
		this->game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] = 0;
	}

	this->restart(0);
	
	for(  i = 0; i < sqrs; i++  )
	{
		if( comps[ i ]->getYpos(  ) < 20 && comps[ i ]->getXpos(  ) >= 0 && comps[ i ]->getXpos(  ) < 10 && comps[ i ]->getYpos(  ) >= 0)
		{
			if( game_matrix[ comps[ i ]->getYpos(  ) ][ comps[ i ]->getXpos(  ) ] != 0 )
			{
				this->restart(3);
				this->desenha(  );
				return;
			}
		}
		else
		{
			this->restart(3);
			this->desenha(  );
			return;
		}
	}
	
	this->desenha(  );
	
	this->state = 0;

}

CPeca::~CPeca()
{
	for( int i = 0; i < sqrs; i++ )
	{
		delete this->comps[i];
	}
}
