#include <allegro.h>
#include <time.h>
#include "tetris.h"
#include "tiles.h"
#include "stuff.h"

//Implement a menu
//Implement the 'next block' thingy
//Implement Score keepint stuff

int t_color_depth = 0;
int t_keys[6] = {KEY_UP, KEY_DOWN, KEY_LEFT, KEY_RIGHT, KEY_SPACE, KEY_ESC}; 
int block_x = 0;
int block_y = 0;
int block_fine = 0;
int block_tile = 0;
unsigned long int block_rate = 1;
int block_rate_temp = 0;
int difficulty = 10;
int *mouse_mickeys_x;
int *mouse_mickeys_y;
volatile unsigned long int block_rate2 = 0;
volatile unsigned long int timer_var = 0;
volatile unsigned long int timer_change = 0;
BITMAP *tiles[TILE_COUNT];
MIDI *background_music;
SAMPLE *sound_bam;
int tile_mask_layout[20][12]={
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             //1
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             //2
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             //3
    {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1},             //4
    { 4,  1,  1,  1,  1,  1,  1,  1,  1,  5, -1, -1},             //5
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //6
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //7
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //8
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //9
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //10
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //11
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //12
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //13
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //14
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //15
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //16
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //17
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //18
    { 3, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -1},             //19
    { 6,  2,  2,  2,  2,  2,  2,  2,  2,  7, -1, -1}};            //20
int tile_block_layout[16][8] = {
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0},
    { 0, 0, 0, 0, 0, 0, 0, 0}};
int tile_block_delete[16][8];
int tile_block_tops[8] = {0, 0, 0, 0, 0, 0, 0, 0};
BITMAP *double_buffer;
BITMAP *mask_layer;
BITMAP *background;
BITMAP *background2;
BITMAP *menu_bitmap;
BITMAP *help_menu_bitmap;


void timer_func()
{
    timer_var++;
}

void rate_func()
{
    block_rate2++;
}

void draw_mask_layout()
{
    int x, y;
    x = 0;
    y = 0;
    while(x < 12)
    {
        while(y < 20)
        {
                if(tile_mask_layout[y][x]!=-1)
                {
                                masked_blit(tiles[tile_mask_layout[y][x]], mask_layer, 0, 0, x*32, y*32, 32, 32);
                }
                y++;
        }
        y = 0;
        x++;
    }
}

int setup()
{
    DATAFILE *da_temp = 0;
    int int_temp = 0;
    int x = 0;
    int y = 0;
    allegro_init(); 
    t_color_depth=desktop_color_depth();
    if (!t_color_depth)
    {
        t_color_depth = 16;
    }
    set_color_depth(t_color_depth);
    if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, 384, 640, 0, 0))
    {
        allegro_message("Setting the graphics mode has failed! Color Depth:%i", t_color_depth);
        return 1;
    }
    clear(screen);
    install_keyboard();
    install_mouse();
    install_timer();
    show_mouse(screen);
    scare_mouse();
    install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, "not used");
    LOCK_VARIABLE(timer_var)
    LOCK_FUNCTION(timer_func)
    install_int_ex(timer_func, BPS_TO_TIMER(100));
    LOCK_VARIABLE(block_rate)
    LOCK_FUNCTION(rate_func)
    install_int_ex(rate_func, SECS_TO_TIMER(5));
    double_buffer = create_bitmap(384, 640);
    mask_layer = create_bitmap(384, 640);
    clear_to_color(mask_layer, makecol(255, 0, 255));
    clear(double_buffer);
    packfile_password("razor sharp");
    da_temp = load_datafile("tiles.dat");
    if(!da_temp)
    {
        allegro_message("Failed to load the tiles data file!");
        return 2;
    }
    while(int_temp < TILE_COUNT)
    {
        tiles[int_temp] = (BITMAP *)da_temp[int_temp].dat;
        int_temp++;
    }
    delete da_temp;
    da_temp = load_datafile("stuff.dat");
    if(!da_temp)
    {
        allegro_message("Failed to load the stuff data file!");
        return 2;
    }
    background = (BITMAP *)da_temp[0].dat;
    masked_blit((BITMAP *)da_temp[1].dat, background, 0, 0, 0, 0, 300, 48);
    background_music = (MIDI *)da_temp[2].dat;
    sound_bam = (SAMPLE *)da_temp[3].dat;
    background2 = (BITMAP *)da_temp[4].dat;
    menu_bitmap = (BITMAP *)da_temp[5].dat;
    help_menu_bitmap = (BITMAP *)da_temp[6].dat;
    if(play_midi(background_music, 1))
    {
        allegro_message("Unable to start background <midi> music!");
        return 3;
    }
    set_volume(255, 255);
    while(x < 10)
    {
        while(y < 15)
        {
                tile_block_layout[y][x] = 0;
                y++;
        }
        y = 0;
        x++;
    }       
    srand(time(0));
    draw_mask_layout();
    return 0;
}

void find_tops()
{
    int x = 0;
    int y = 0;
    while(x < 8)
    {
        tile_block_tops[x] = 15;
        while(y < 16)
        {
                if(tile_block_layout[y][x] == 0)
                {

                }
                else
                {
                                tile_block_tops[x] = y;
                                break;
                }
                y++;
        }
        y = 0;
        x++;
    }
}

void check_line(int x, int y)
{
    int distance = 0;
    int temp = 0;
    while(y + distance < 16)
    {
        if(tile_block_layout[y][x] == tile_block_layout[y + distance][x])
        {
                distance++;
        }
        else
        {
                break;
        }
    }
    if(distance >= 3)
    {
        distance--;
        while(temp <= distance)
        {
                //allegro_message("X:%i, Y:%i, D:%i, T:%i", x, y, distance, temp);
                tile_block_delete[y + temp][x] = 1;
                temp++;
        }
    }

    distance = 0;
    temp = 0;
    while(x + distance < 8)
    {
        if(tile_block_layout[y][x] == tile_block_layout[y][x + distance])
        {
                distance++;
        }
        else
        {
                break;
        }
    }
    if(distance >= 3)
    {
        distance--;
        while(temp <= distance)
        {
                //allegro_message("X:%i, Y:%i, D:%i, T:%i", x, y, distance, temp);
                tile_block_delete[y][x+temp] = 1;
                temp++;
        }
    }
    
}


void delete_lines()
{
    int x = 0;
    int y = 0;
    while(x < 16)
    {
        while(y < 8)
        {
                tile_block_delete[x][y] = 0;
                y++;
        }
        y = 0;
        x++;
    }
    x = 0;
    y = 0;
    while(x < 16)
    {
        while(y < 8)
        {
                if(tile_block_layout[x][y]!=0)
                {
                                check_line(y, x);
                }
                y++;
        }             
        y = 0;
        x++;
    }
    x = 0;
    y = 0;
    int something_deleted = 0;
    while(x < 16)
    {
        while(y < 8)
        {
                if(tile_block_delete[x][y] == 1)
                {
                                tile_block_layout[x][y] = 0;
                                something_deleted = 1;
                }
                y++;
        }
        y = 0;
        x++;
    }
    if(something_deleted)
        play_sample(sound_bam, 128, 128, 1000, 0);
}

int drop_block()
{
    block_rate_temp = 0;
    block_x = rand()%8+1;
    block_y = 4;
    block_fine = 0;
    block_tile = rand()%6+8;
    if(block_rate2/difficulty < block_rate)
    {
        block_rate = 1;
    }
    else
    {
        block_rate = block_rate2/difficulty;
    }
    if(tile_block_layout[1][block_x-1]!=0)
    {
            return 1;
    }
return 0;
}

void draw_block()
{
    blit(tiles[block_tile], double_buffer, 0, 0, block_x * 32, (block_y * 32) - block_fine, 32, 32);
}

void draw_old_blocks()
{
    int x = 0;
    int y = 0;
    while(x < 8)
    {
        while(y != 16)
        {
                if(tile_block_layout[y][x] != 0)
                {
                                blit(tiles[tile_block_layout[y][x]], double_buffer, 0, 0, (x + 1) * 32, (y + 4) * 32, 32, 32);
                }
                y++;
        }
        y = 0;
        x++;
    }
}
                

void screen_update()
{
    clear(double_buffer);
    blit(background, double_buffer, 0, 0, 0, 0, 384, 640);
    draw_old_blocks();
    draw_block();
    masked_blit(mask_layer, double_buffer, 0, 0, 0, 0, 384, 640);
    blit(double_buffer, screen, 0, 0, 0, 0, 384, 640);
}

int update_block()
{
    block_fine = block_fine - (block_rate * timer_change);
    while(block_fine < 32)
    {
        block_fine = block_fine + 32;
        block_y++;
    }
    if(block_y < 21)
    {
        if(tile_block_layout[block_y-5][block_x-1] != 0)
        {
                tile_block_layout[tile_block_tops[block_x-1]-1][block_x-1] = block_tile;
                if(drop_block())
                return 1;
        }
                
    }
    else
    {
        if(tile_block_layout[15][block_x-1] == 0)
                tile_block_layout[15][block_x-1] = block_tile;
        else
                tile_block_layout[tile_block_tops[block_x-1]][block_x-1] = block_tile;
        if(drop_block())
        return 1;
    }
return 0;
}

void start_game()
{
    int x = 0;
    int y = 0;
    while(x < 16)
    {
        while(y < 8)
        {
                tile_block_layout[x][y] = 0;
                y++;
        }
        y = 0;
        x++;
    }
    x = 0;
    y = 0;
    while(x < 16)
    {
        while(y < 8)
        {
                tile_block_delete[x][y] = 0;
                y++;
        }
        y = 0;
        x++;
    }
    
    drop_block();
}

int check_lose()
{
    int x = 0;
    while(x < 8)
    {
        if(tile_block_layout[0][x]!=0)
        {
                return 1;
        }
        x++;
    }
return 0;
}

void apply_gravity()
{
    int x = 0;
    int y = 15;
    int c;
    while(x < 8)
    {
        while(y > -1)
        {
                c = y;
                if((tile_block_layout[y][x] == 0)&&(y > tile_block_tops[x]))
                {
                                while(c > 0)
                                {
                                           tile_block_layout[c][x] = tile_block_layout[c-1][x];
                                           tile_block_layout[c-1][x] = 0;
                                           c--;
                                }
                                find_tops();
                }
                else
                {
                                y--;
                }
        }
        y = 15;
        x++;
    }     
}

void game_menu_help()
{
    scare_mouse();
    blit(background2, double_buffer, 0, 0, 0, 0, 384, 640);
    masked_blit(help_menu_bitmap, double_buffer, 0, 0, 0, 0, 384, 640);
    blit(double_buffer, screen, 0, 0, 0, 0, 384, 640);
    while(!((mouse_x > 200)&&(mouse_x < 350)&&(mouse_y > 590)&&(mouse_y < 630)&&(mouse_b & 1)))
    {
    unscare_mouse();
    }
    scare_mouse();
}

void game_menu_options()
{

}

int game_menu()
{
    int exit = 0;
    int return_val = 0;
    blit(background2, double_buffer, 0, 0, 0, 0, 384, 640);
    masked_blit(menu_bitmap, double_buffer, 0, 0, 0, 0, 384, 640);
    blit(double_buffer, screen, 0, 0, 0, 0, 384, 640);
    unscare_mouse();
    while(!exit)
    {
        if(mouse_b & 1)
        {
                if((mouse_x > 117)&&(mouse_x < 280)&&(mouse_y > 245)&&(mouse_y < 288))  //play
                {
                                exit = 1;
                                return_val = 1;
                }
                if((mouse_x > 117)&&(mouse_x < 383)&&(mouse_y > 299)&&(mouse_y < 341))  // options
                {
                                exit = 1;
                                return_val = 2;
                }
                if((mouse_x > 117)&&(mouse_x < 271)&&(mouse_y > 354)&&(mouse_y < 396))  //help
                {
                                exit = 1;
                                return_val = 3;
                }
                if((mouse_x > 117)&&(mouse_x < 272)&&(mouse_y > 406)&&(mouse_y < 449))  //quit
                {
                                exit = 1;
                                return_val = 4;
                }
        }
    }
    scare_mouse();
    return return_val;
    
}

int main() 
{ 
    int exit = 0;
    int last_timer = 0;
    int menu_val = 0;
    if(setup())
    {
        return 0;
    }
    while(menu_val != 4)
    {
        menu_val = game_menu();
        if(menu_val==2)
        {
                game_menu_options();
        }
        if(menu_val==3)
        {
                game_menu_help();
        }
        if(menu_val==1)
        {
            start_game();
            screen_update();
            timer_var = 0;
            mouse_mickeys_x = new int;
            mouse_mickeys_y = new int;
            get_mouse_mickeys(mouse_mickeys_x, mouse_mickeys_y);
            while(!exit)
            {
                if(last_timer - timer_var)                        //check if things need to be updated
                {
                        timer_change = timer_var - last_timer;
                        last_timer = timer_var;
                        delete_lines();
                        exit = check_lose();
                        find_tops();
                        if(update_block())
                        {exit = 1;}
                        apply_gravity();
                        screen_update();
                }
                if(key[t_keys[0]])                                //up
                {
                        if(block_rate_temp != 0)
                        {
                                        block_rate_temp--;
                                        block_rate = block_rate/3;
                        }
                        if(block_rate == 0)
                        {
                                        block_rate = 1;
                        }
                }
                if(key[t_keys[1]])                                //down
                {
                        if(block_rate_temp != (1||3))
                        {
                                        block_rate_temp = block_rate_temp + 1;
                                        block_rate = block_rate * 3;
                        }
                }
                if((key[t_keys[2]])||(*mouse_mickeys_x < 0))                                //left
                {
                        if(((block_x > 1)&&(tile_block_layout[block_y-6][block_x-2]==0))&&(tile_block_layout[block_y-5][block_x-2]==0))
                        {
                                        block_x--;
                        }
                }
                if((key[t_keys[3]])||(*mouse_mickeys_x > 0))                                //right
                {
                        if(((block_x < 8)&&(tile_block_layout[block_y-6][block_x]==0))&&(tile_block_layout[block_y-5][block_x]==0))
                        {
                                        block_x++;
                        }
                }
                if(key[t_keys[4]])                                //space
                {
                    //    block_y = tile_block_tops[block_x - 1] + 4;
                }
                if(key[t_keys[5]])                                //esc
                {
                        exit = 1;
                }      
                get_mouse_mickeys(mouse_mickeys_x, mouse_mickeys_y); 
                *mouse_mickeys_x = *mouse_mickeys_x / 5;
            }
            exit = 0;
            int block_x = 0;
            block_y = 0;
            block_fine = 0;
            block_tile = 0;
            block_rate = 1;
            block_rate_temp = 0;
            difficulty = 10;
            block_rate2 = 0;
            timer_var = 0;
            timer_change = 0;
        }
    }
    allegro_exit();
    delete mouse_mickeys_x;
    delete mouse_mickeys_y;
    return 0;     
}     

END_OF_MAIN();
