// evolve1.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "evolve1.h"


#define MAX_LOADSTRING 100
#define MAX_POPULATION 50


#define XPOS 0
#define YPOS 0

#define MAX_WID 100
#define MAX_HEI 75

#define LAY 5
#define NODES 25

#define FiSzX 8
#define FiSzY 8


int layer_used_nodes[LAY] = {25, 25, 20, 15, 5};

struct netelem
{
    int actfn;
    float thresh;
    float state;
    float weights[NODES];
};

class Genetic
{
	public:
		int init();
		int load();
		int save();
		int iterate();
		int show();
};


struct subject
{
    int age;
    float x;
    float y;
    int sprite_color;
    float arg;
    float vel;
    float reso;
    float hunt;
    struct netelem net[LAY][NODES];
    float R[10];
    float Z[10];
} sub[MAX_POPULATION];

int population = MAX_POPULATION;


int width = MAX_WID;
int height = MAX_HEI;


#define INITIAL_RESERVE 5.0


float a[MAX_WID][MAX_HEI];
float b[MAX_WID][MAX_HEI];

int xfrom[MAX_WID][MAX_HEI];
int yfrom[MAX_WID][MAX_HEI];


int it_count = 0, run_flag;
int pa;
int time_counter;
int show;

BITMAP *bbuff;

int itpersec = 0;
int period = 0;
void randomize_fertility();
void force_resamble();

int info_x = 10;
int info_y = 10;

void one_per_sec()
{
    int i;
    time_counter++;

    for(i=0; i<population; i++)
        sub[i].age++;

    itpersec = it_count;
    it_count = 0;

    period++;
    if ( period > 20 )
    {
        randomize_fertility();
        force_resamble();
        period = 0;

        info_x = 10 + rand()%(width*FiSzX - 150);
        info_y = 10 + rand()%(height*FiSzY - 50);
        if (!show)
            clear(screen);
    }
}
END_OF_FUNCTION(one_per_sec);


void initialize();
void randomize_colors();
void randomize_field();

int showinfo = 0;

void on_mouse_touch(int flags)
{
    run_flag = 0;
}
END_OF_FUNCTION(on_mouse_touch);

void refresh()
{
    int i, j, c;

    if ( keypressed() )
    {
        c = readkey() >> 8;

        if ( c == KEY_F3 )
        {
            show = !show;
            if (show)
                text_mode(-1);
            else
                text_mode(0);
        }
        else if ( c == KEY_PLUS_PAD )
        {
            if ( population < MAX_POPULATION )
                population++;
        }
        else if ( ( c == KEY_MINUS ) || ( c == KEY_MINUS_PAD ) )
        {
            if ( population > 2 )
                population--;
        }
        else if ( c == KEY_F12 )
        {
            initialize();
        }
        else if ( c == KEY_F2 )
        {
            randomize_colors();
        }
        else if ( c == KEY_F4 )
        {
            randomize_field();
        }
        else if ( c == KEY_F1 )
        {
            showinfo = !showinfo;
        }
        else
        {
            run_flag = 0;
        }

    }


    if(show)
    {
        clear (bbuff);

        for(j=0; j<height; j++)
        for(i=0; i<width; i++)
            {
                if ( 0 < (c = a[i][j] * 255.0) )
                {
                    rectfill(bbuff, xfrom[i][j], yfrom[i][j], xfrom[i][j]+FiSzX-2, yfrom[i][j]+FiSzY-2, makecol(c,c,c));
                }
            }

        for(i=0; i<population; i++)
        {


            line(bbuff, FiSzX*sub[i].x, FiSzY*sub[i].y, FiSzX*sub[i].x-10*cos(sub[i].arg), FiSzY*sub[i].y-10*sin(sub[i].arg), sub[i].sprite_color);
            putpixel(bbuff, FiSzX*sub[i].x, FiSzY*sub[i].y, 0xFF0000);
        }

        if ( showinfo )
        {
            textprintf(bbuff, font, 300, 10, 0x7F7F7F, "  time     resources  ");

            for(i=0; i<population; i++)
            {
                if ( i == pa )
                    textprintf(bbuff, font, 300, 20+10*i, sub[i].sprite_color, "%5d *     %5.1f ", sub[i].age, sub[i].reso);
                else
                {
                    textprintf(bbuff, font, 300, 20+10*i, sub[i].sprite_color, "%5d       %5.1f ", sub[i].age, sub[i].reso);
                }
            }


            textprintf(bbuff, font, 10,  50, 0x808080, "(num.)+  inc. population");
            textprintf(bbuff, font, 10,  60, 0x808080, "      -  dec. population");
            textprintf(bbuff, font, 10,  70, 0x808080, "     F1  info");
            textprintf(bbuff, font, 10,  80, 0x808080, "     F2  colorize");
            textprintf(bbuff, font, 10,  90, 0x808080, "     F3  show/hide");
            textprintf(bbuff, font, 10, 100, 0x808080, "     F4  maximize field");
            textprintf(bbuff, font, 10, 110, 0x808080, "    F12  brainwash");
            textprintf(bbuff, font, 10, 120, 0x808080, "    any  exit");
            textprintf(bbuff, font, 10, 150, 0x808080, "star (*) marks the best");

            textprintf(bbuff, font, 10, 10, 0x808080, "time:%6d", time_counter);
            textprintf(bbuff, font, 10, 20, 0x808080, " ips:%6d", itpersec);
        }
        else
        {
            textprintf(bbuff, font, info_x, info_y, 0x808080, "time:%6d", time_counter);
            textprintf(bbuff, font, info_x, info_y+10, 0x808080, " ips:%6d", itpersec);
        }


        blit(bbuff, screen, 0, 0, XPOS, YPOS, width*FiSzX, height*FiSzY);
    }
    else
    {
        textprintf(screen, font, XPOS+info_x, YPOS+info_y, 0x808080, "time:%6d", time_counter);
        textprintf(screen, font, XPOS+info_x, YPOS+info_y+10, 0x808080, " ips:%6d", itpersec);
    }
}
END_OF_FUNCTION(refresh);





void randomize_colors()
{
    int i;

    for(i=0; i<MAX_POPULATION; i++)
    {
        sub[i].sprite_color = makecol(rand()%256, rand()%256, rand()%256);
    }
}

void randomize_field()
{
    width = MAX_WID;
    height = MAX_HEI;

    int i, j;

    for(i=0; i<width; i++)
    for(j=0; j<height; j++)
    {
        a[i][j] = 0.0;
        if ( (i>0) && (i<width-1) && (j>0) && (j<height-1) )
        {
            b[i][j] = (rand()%10000)/10000.0;
            if(b[i][j] > 0.02)
                b[i][j] = 0.0;
        }
        else
        {
            b[i][j] = 0.0;
            a[i][j] = -2.0;
        }

        xfrom[i][j] = i*FiSzX;
        yfrom[i][j] = j*FiSzY;
    }
}

void randomize_fertility()
{
    int i, j;

    for(i=1; i<width-1; i++)
    for(j=1; j<height-1; j++)
    {
        b[i][j] = (rand()%10000)/10000.0;
        if(b[i][j] > 0.03)
            b[i][j] = 0.0;
        else
        {
            b[i][j] *= (((double)population)/MAX_POPULATION);
            a[i][j] = -(rand()%10000)/10000.0;
        }

    }
}


void initialize()
{
    int i, j, k, l;

    it_count = 0;
    time_counter = 0;
    show = 1;

    rectfill(screen, XPOS-1, YPOS-1, XPOS+width*FiSzX, YPOS+height*FiSzY, 0x202020);

    srand(1);

    randomize_field();

    for(i=0; i<population; i++)
    {
        sub[i].age = 0;
        sub[i].x = 0.5 + (rand()%width)/1.0;
        sub[i].y = 0.5 + (rand()%height)/1.0;
        sub[i].arg = ((rand()%1000) * 2 * M_PI)/1000.0;
        sub[i].vel = 0.1;
        sub[i].reso = INITIAL_RESERVE;
        sub[i].hunt = 0.0;

        for(l=1; l<LAY; l++)
            for(k=0; k<layer_used_nodes[l]; k++)
            {
                sub[i].net[l][k].actfn = 1;
                sub[i].net[l][k].thresh = (rand()%200 - 100) / 50.0;
                sub[i].net[l][k].state = 0.0;
                for(j=0; j<layer_used_nodes[l-1]; j++)
                    sub[i].net[l][k].weights[j] = (rand()%2000 - 1000) / 500.0;
            }
    }

    randomize_colors();

}

void resamble(int i);


void force_resamble()
{
    int i, j=0;
    for (i=1; i<population; i++)
    {
        if ( sub[i].hunt < sub[j].hunt )
            j = i;
    }
    resamble(j);
}


void resamble(int i)
{
    int j, k, l, s;

    pa=i?0:1;

    for ( s=0; s<i; s++ )
    if ( sub[s].hunt > sub[pa].hunt )
        pa = s;

    for ( s=i+1; s<population; s++ )
    if ( sub[s].hunt > sub[pa].hunt )
        pa = s;


    for ( l=1; l<LAY; l++ )
    for ( k=0; k<layer_used_nodes[l]; k++ )
    {
        sub[i].net[l][k].actfn = sub[pa].net[l][k].actfn;
        sub[i].net[l][k].thresh = sub[pa].net[l][k].thresh + (rand()%2000 - 1000) / 10000.0;
        sub[i].net[l][k].state = 0.0;
        for(j=0; j<layer_used_nodes[l-1]; j++)
            sub[i].net[l][k].weights[j] = sub[pa].net[l][k].weights[j] + (rand()%2000 - 1000) / 10000.0;
    }

    sub[pa].reso += 1.0;

    sub[i].vel = 0.1;
    sub[i].age = 0;
    sub[i].reso = sub[pa].reso;
    sub[i].x = sub[pa].x;
    sub[i].y = sub[pa].y;
    sub[i].arg = sub[pa].arg;

    int rcomp = getr(sub[pa].sprite_color) + (rand()%41 - 20);
    int gcomp = getg(sub[pa].sprite_color) + (rand()%41 - 20);
    int bcomp = getb(sub[pa].sprite_color) + (rand()%41 - 20);

    sub[i].sprite_color = makecol(MID(0, rcomp, 255), MID(0, gcomp, 255), MID(0, bcomp, 255));

    for(s=0; s<population; s++)
    {
        sub[s].reso /= 2.0;
        sub[s].reso += 2.0 * sub[s].hunt;
        sub[s].hunt /= 2.0;
        sub[s].reso += 1.0;
    }

}



void forward(int i)
{
    int j, k, l;
    float st;

    for(l=1; l<LAY; l++)
        for(k=0; k<layer_used_nodes[l]; k++)
        {
            st = sub[i].net[l][k].thresh;
            for(j=0; j<layer_used_nodes[l-1]; j++)
                st += sub[i].net[l][k].weights[j] * sub[i].net[l-1][j].state;
            sub[i].net[l][k].state = st;
        }

}


void iterate()
{
    float st, dx, dy, dist;
    int i, j, k, s;


    for ( s=0; s<population; s++)
        for(k=0; k<10; k++)
        {
            sub[s].R[k] = 0.0;
            sub[s].Z[k] = 1000.0;
        }

    for ( i=0; i<width; i++)
    for ( j=0; j<height; j++)
    {
        if ( a[i][j] <= 1.0 )
        {
            a[i][j] += b[i][j]/50.0;
        }

        if ( a[i][j] >= 0.1 )
        for ( s=0; s<population; s++ )
        {
            dx = ((float)i+0.5) - sub[s].x;
            dy = ((float)j+0.5) - sub[s].y;
            st = 5 + 10.0 * (atan2(dy, dx) - sub[s].arg);
            k = (int)st;
            if ( k>=0 && k<10 )
            {
                dist = sqrt(dx*dx + dy*dy);
                sub[s].R[k] += a[i][j] / ( 1.0 + sqrt(dist));
                if ( dist <= sub[s].Z[k] )
                {
                    sub[s].Z[k] = dist;
                }
            }
        }
    }


    for ( s=0; s<population; s++ )
    {
        for ( i=0; i<10; i++ )
        {
            sub[s].net[0][i].state = sub[s].R[i];
            sub[s].net[0][10+i].state = 1.0 / (1.0+sub[s].Z[i]);
        }
        sub[s].net[0][20].state = sub[s].vel;
        sub[s].net[0][21].state = sub[s].arg;
        //sub[s].net[0][22].state = sub[s].reso;
        //sub[s].net[0][23].state = sub[s].hunt;
        //sub[s].net[0][24].state = sub[s].age;

        forward(s);
        sub[s].vel  = fabs(sub[s].net[LAY-1][1].state / 5000.0);
        sub[s].arg += sub[s].net[LAY-1][0].state / 10000.0;

        if(sub[s].arg > M_PI)
            sub[s].arg -= 2*M_PI;
        else if(sub[s].arg < -M_PI)
            sub[s].arg += 2*M_PI;

        if(sub[s].reso>0.0)
        {
            sub[s].reso -= sub[s].vel/256.0 + 0.00001 + fabs(sub[s].net[LAY-1][0].state / 65536.0); // CENA !!!

            st = sub[s].x + sub[s].vel*cos(sub[s].arg);
            if ( 0.0<st && st<((float)width-0.125) )
                sub[s].x = st;

            st = sub[s].y + sub[s].vel*sin(sub[s].arg);
            if ( 0.0<st && st<((float)height-0.125) )
                sub[s].y = st;

            i = (int)sub[s].x;
            j = (int)sub[s].y;

            if(a[i][j]>0.0)
            {
                sub[s].reso += a[i][j];
                sub[s].hunt += a[i][j];
                a[i][j] = -1.0;
            }
            else if (a[i][j]<-1.0)
            {
                sub[s].reso -= 0.001;
                sub[s].hunt -= 0.001;
            }
        }
        else
            resamble(s);
    }
    it_count++;
}



void save(const char * datafile)
{
    FILE *fout = fopen(datafile, "w");
    int i, j, k, l;

    fprintf(fout, "%d\n", it_count);
    fprintf(fout, "%d\n", time_counter);
    fprintf(fout, "%d\n", show);


    fprintf(fout, "%d\n", width);
    fprintf(fout, "%d\n", height);

    for(i=0; i<width; i++)
    for(j=0; j<height; j++)
    {
        fprintf(fout, "%f\n", a[i][j]);
        fprintf(fout, "%f\n", b[i][j]);
    }

    fprintf(fout, "%d\n", population);

    for(i=0; i<population; i++)
    {
        fprintf(fout, "%d\n", sub[i].age);
        fprintf(fout, "%f\n", sub[i].x);
        fprintf(fout, "%f\n", sub[i].y);
        fprintf(fout, "%f\n", sub[i].arg);
        fprintf(fout, "%f\n", sub[i].vel);
        fprintf(fout, "%f\n", sub[i].reso);
        fprintf(fout, "%f\n", sub[i].hunt);
        fprintf(fout, "%d\n", sub[i].sprite_color);

        for(l=1; l<LAY; l++)
        for(k=0; k<layer_used_nodes[l]; k++)
        {
                fprintf(fout, "%d\n", sub[i].net[l][k].actfn);
                fprintf(fout, "%f\n", sub[i].net[l][k].thresh);
                fprintf(fout, "%f\n", sub[i].net[l][k].state);
                for(j=0; j<layer_used_nodes[l-1]; j++)
                    fprintf(fout, "%f\n", sub[i].net[l][k].weights[j]);
        }
    }

    fclose(fout);
}

void load(const char * datafile)
{
    FILE *fout = fopen(datafile, "r");
    if ( !fout )
        return;
    int i, j, k, l;

    fscanf(fout, "%d\n", &it_count);
    fscanf(fout, "%d\n", &time_counter);
    fscanf(fout, "%d\n", &show);

    fscanf(fout, "%d\n", &width);
    fscanf(fout, "%d\n", &height);

    for(i=0; i<width; i++)
    for(j=0; j<height; j++)
    {
        fscanf(fout, "%f\n", &(a[i][j]));
        fscanf(fout, "%f\n", &(b[i][j]));
    }


    fscanf(fout, "%d\n", &(population));

    for(i=0; i<population; i++)
    {
        fscanf(fout, "%d\n", &(sub[i].age));
        fscanf(fout, "%f\n", &(sub[i].x));
        fscanf(fout, "%f\n", &(sub[i].y));
        fscanf(fout, "%f\n", &(sub[i].arg));
        fscanf(fout, "%f\n", &(sub[i].vel));
        fscanf(fout, "%f\n", &(sub[i].reso));
        fscanf(fout, "%f\n", &(sub[i].hunt));
        fscanf(fout, "%d\n", &(sub[i].sprite_color));

        for(l=1; l<LAY; l++)
        for(k=0; k<layer_used_nodes[l]; k++)
        {
                fscanf(fout, "%d\n", &(sub[i].net[l][k].actfn));
                fscanf(fout, "%f\n", &(sub[i].net[l][k].thresh));
                fscanf(fout, "%f\n", &(sub[i].net[l][k].state));
                for(j=0; j<layer_used_nodes[l-1]; j++)
                    fscanf(fout, "%f\n", &(sub[i].net[l][k].weights[j]));
        }
    }

    fclose(fout);
}


int main(int argc, char *argv[])
{
    allegro_init();
    install_timer();
    install_keyboard();
    install_mouse();

    char *extension;

    if ( argc > 0 )
    {
        extension = strrchr(argv[0], '.');
        if ( !stricmp(extension, ".scr") )
        {
            if ( argc > 1 )
            {
                if ( !_strnicmp(argv[1], "/c", 2) ) //configure
                {
                    // Settings...
                    return 0;                    
                }
                else if ( !_strnicmp(argv[1], "/s", 2) ) //save
                {
                    // Preview...                    
                }
                else if ( !_strnicmp(argv[1], "/p", 2) ) //preview
                {
                    // Preview in Display Properties dialog
                    return 0;
                }
            }
        }
    }





    set_color_depth(32);
    set_gfx_mode(GFX_DIRECTX_ACCEL, 800, 600, 0, 0);
    text_mode(-1);

    run_flag = -1;
    LOCK_FUNCTION(on_mouse_touch)
    mouse_callback = on_mouse_touch;
    

    /*
    int arg;

    for ( arg=0; arg<argc; arg++)
    {
        textprintf(screen, font, 0, SCREEN_H-(arg+1)*10, 0xFFFFFF, "%d  >%s", arg, argv[arg]);
    }
    */

    bbuff = create_bitmap(MAX_WID*FiSzX, MAX_HEI*FiSzY);


    LOCK_VARIABLE(it_count);
    LOCK_VARIABLE(run_flag);
    LOCK_VARIABLE(sub);
    LOCK_VARIABLE(time_counter);
    LOCK_VARIABLE(a);
    LOCK_VARIABLE(b);
    LOCK_VARIABLE(xfrom);
    LOCK_VARIABLE(yfrom);
    LOCK_VARIABLE(layer_used_nodes);
    LOCK_VARIABLE(pa);
    LOCK_VARIABLE(show);

    LOCK_FUNCTION(one_per_sec);
    LOCK_FUNCTION(refresh);

    install_int_ex(&one_per_sec, SECS_TO_TIMER(1));
    install_int_ex(&refresh, BPS_TO_TIMER(18));


    if (!run_flag)
        return 0;
    initialize();

    char datafile[400];
    sprintf(datafile, "%s", argv[0]);
    extension = strrchr(datafile, '.');
    sprintf(extension, ".sav");

    if (!run_flag) return 0;

    load(datafile);

    if (show)
        text_mode(-1);
    else
    {
        clear(screen);
        text_mode(0);
    }

    //main loop
    do
    {
        iterate();
    }
    while ( run_flag );

    save(datafile);


    remove_int(&one_per_sec);
    remove_int(&refresh);

    destroy_bitmap(bbuff);

    return 0;

}
END_OF_MAIN()
