#include "empire.h"

int move_priority(_unit* u);

int _player::create_unit(int type, int x, int y, int player)
{
  int i = 0;
  while (i < 50)
  {
    if (unit[i].exists == 0)
    {
      unit[i].create(type, x, y, player, i);
      return i;  //return the number of the newly created unit
    }
    i++;
  }
  return -1;
}

void _player::clear_units()
{
  int i = 0;
  int x, y;
  while (i < 50)
  {
    if (unit[i].exists == 1)
    {
      unit[i].kill();
    }
    unit[i].exists = 0;
    unit[i].ready = 0;
    i++;
  }
}

void _player::ready_units()
{
  int i = 0;
  while (i < 50)
  {
    unit[i].ready = 1;
    i++;
  }
}

int _player::units_in_play()
{
  int i = 0;
  int n = 0;
  while (i < 50)
  {
    if (unit[i].exists == 1)
    {
      n++;
    }
    i++;
  }
  return n;
}

bool _player::defeated(int pnum)
{
  int i, j, z;
  if (units_in_play() > 0)
  {
    return false;
  }
  j = 0;
  while (j < map.h)
  {
    i = 0;
    while (i < map.l)
    {
      if (map.tile[i][j].is_unit_producing())
      {  //if the building can make units
        if (map.tile[i][j].owned_by(pnum))
        {  //and is owned by the player
          z = map.tile[i][j].unit_here();
          if (z == -1)
          {  //and doesn't have a unit on it (the unit must be an enemy at this point)
            return false;
          }
          else if (player[z / 100].unit[z % 100].ready == 1)
          {  //if the unit could move off the tile (like if a move is cancelled)
            return false;
          }
        }
      }
      i++;
    }
    j++;
  }
  return true;  //the player has no units and can't make any units, so he's defeated
}

void _player::sort_units()
{
  mergesort_units(0, 49);
}

void _player::mergesort_units(int min, int max)
{
  vector<_unit> temp;
  int left, right, size, i, pivot, a, b;
  size = max - min + 1;
  pivot = (min + max) / 2;
  temp.clear();
  if (min == max)
  {
    return;
  }
  mergesort_units(min, pivot);
  mergesort_units(pivot + 1, max);
  i = 0;
  while (i < size)
  {
    temp.push_back(unit[min + i]);
    i++;
  }
  left = 0;
  right = pivot - min + 1;
  i = 0;
  while (i < size)
  {
    if (right <= max - min)
    {
      if (left <= pivot - min)
      {
        a = move_priority(&temp[left]);
		b = move_priority(&temp[right]);
        if (a > b)
        {
          unit[i + min] = temp[right];
          unit[i + min].number = i + min;
          if (unit[i].exists == 1)
          {
            map.tile[unit[i].tilex][unit[i].tiley].set_unit(unit[i].color, unit[i].number);
          }
          right++;
        }
        else
        {
          unit[i + min] = temp[left];
          unit[i + min].number = i + min;
          if (unit[i].exists == 1)
          {
            map.tile[unit[i].tilex][unit[i].tiley].set_unit(unit[i].color, unit[i].number);
          }
          left++;
        }
      }
      else
      {
        unit[i + min] = temp[right];
        unit[i + min].number = i + min;
        if (unit[i].exists == 1)
        {
          map.tile[unit[i].tilex][unit[i].tiley].set_unit(unit[i].color, unit[i].number);
        }
        right++;
      }
    }
    else
    {
      unit[i + min] = temp[left];
      unit[i + min].number = i + min;
      if (unit[i].exists == 1)
      {
        map.tile[unit[i].tilex][unit[i].tiley].set_unit(unit[i].color, unit[i].number);
      }
      left++;
    }
    i++;
  }
}

void _character::create(string n, string d, int s, int w, int p, string pn, BITMAP *pic)
{
  name = n;
  description = d;
  strength = s;
  weakness = w;
  power = p;
  powername = pn;
  picture = create_bitmap(80, 80);
  clear_to_color(picture, BLACK);
  stretch_sprite(picture, pic, 0, 0, 80, 80);
}

void _character::destroy()
{
  name = "";
  description = "";
  strength = 5;
  weakness = 5;
  power = 0;
  powername = "";
  destroy_bitmap(picture);
}

int move_priority(_unit* u)
{
  if (u->attacktype == RANGED)
  {
    return 0;
  }
  else if (u->attacktype == DIRECT)
  {
    if ((u->type == INFANTRY) || (u->type == MECH))
    {
      return 2;
    }
    else
    {
      return 1;
    }
  }
  else
  {
    if (u->type == APC)
    {
      return 3;
    }
    else  //t-copter or lander
    {
      return 4;
    }
  }
  return 99;
}
