#ifndef _map_h
#define _map_h

class _tile
{
  int anim;  //in case I want to make the tiles animated later on
  int unit;
  int set;
  int number;
  short step;  //this should never go above 999
  short temp;  //neither should this
  public:
    bool is_building();
    bool is_building(int type);
    bool is_unit_producing();
    bool is_HQ();
    bool owned_by(int plyr);
    bool same_type(int t);
    bool same_type(int tset, int tnum);
    void reset();
    void change_type(int new_set, int new_number);
    void change_owner(int plyr);
    void change_to_city();
    void draw(int x, int y, _unit *other_unit_here);
    void set_unit(int plyr, int number);
    void set_temp(short t);
    void set_step(short s);
    short get_temp();
    short get_step();
    int unit_here();
    int owner();
    int get_set();
    int get_number();
    int building_type();
};

class _map
{
  string name;
  int pathmap_limit;
  void create_pathmap(int plyr, int mtype, int startx, int starty, bool limited);
  void pathmap_recursive(int plyr, int mtype, int ox, int oy, int moves, bool limited);
  public:
    _tile tile[50][50];
    int l, h, scroll_x, scroll_y;
    int offset_x, offset_y;
    void reset();
    string get_name();
    void set_name(string new_name);
    void draw_tiles();
    void draw_tiles(int gridx, int gridy, int numx, int numy);
    void draw_tiles(int gridx, int gridy, int numx, int numy, _unit *other_unit_here);
    void create_pathmap(int plyr, int mtype, int startx, int starty);
    void create_limited_pathmap(int plyr, int mtype, int startx, int starty, int limit);
    void backup_pathmap();
    void restore_pathmap();
};

#endif
