#ifndef _empire
#define _empire

#define __GTHREAD_HIDE_WIN32API

using namespace std;

#include <time.h>
#include <string>
#include <vector>
#include <fstream>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include <winalleg.h>
#include <fblend.h>
#include "button.h"
#include "units.h"
#include "player.h"
#include "map.h"
#include "minimap.h"
#include "particle.h"
#include "gameoptions.h"

#define CITY    0
#define BASE    1
#define AIRPORT 2
#define PORT    3
#define HQ      9

#define QUIT     -1
#define MENU      0
#define LOGIC     1
#define MAPEDIT   2
#define GAMEOVER  3
#define GAMEINTRO 4

#define LMOUSE 0
#define LTILE 1

#define HUMAN 0
#define AI    1

#define BACK     0
#define SPRITE   1
#define MOUSE    2

#define RANGED 0
#define DIRECT 1

#define LAND   0
#define AIR    1
#define SEA    2
#define CUSTOM 3

#define BLACK makecol(0, 0, 0)
#define GREY makecol(128, 128, 128)
#define LGREY makecol(192, 192, 192)
#define DGREY makecol(64, 64, 64)
#define VDGREY makecol(32, 32, 32)
#define RED makecol(255, 0, 0)
#define GREEN makecol(0, 255, 0)
#define DGREEN makecol(0, 150, 0)
#define BLUE makecol(0, 0, 255)
#define YELLOW makecol(255, 255, 0)
#define DYELLOW makecol(150, 150, 0)
#define WHITE makecol(255, 255, 255)
#define ORANGE makecol(255, 128, 0)
#define BROWN makecol(150, 100, 50)
#define DBROWN makecol(100, 70, 40)
#define TRANS makecol(255, 0, 255)

#define RIGHT 1
#define DOWN  2
#define UP    3
#define LEFT  4

#define ANTI_AIR  0
#define APC       1
#define ARTILLERY 2
#define B_COPTER  3
#define B_SHIP    4
#define BOMBER    5
#define CRUISER   6
#define FIGHTER   7
#define INFANTRY  8
#define LANDER    9
#define MD_TANK   10
#define MECH      11
#define MISSILES  12
#define RECON     13
#define ROCKETS   14
#define SUB       15
#define T_COPTER  16
#define TANK      17

#define M_INFANTRY 0
#define M_TIRES    1
#define M_TREAD    2
#define M_AIR      3
#define M_MECH     4
#define M_SEA      5
#define M_LANDER   6

#define AAFIRE     0
#define AUTOGUN    1
#define BOMBS      2
#define CHOPPER    3
#define CLICK      4
#define ENGINE     5
#define BLAST      6
#define JET        7
#define MARCH      8
#define MDTANKFIRE 9
#define MISSILE    10
#define SEABOAT    11
#define TANKMOVE   12
#define TANKFIRE   13
#define TILEDOWN   14
#define TORPEDO    15
#define UNITDOWN   16
#define EXPLOSION  17
#define VICTORY    18

typedef struct _aibuild
{
  int weight;
  int limit;
} _aibuild;

typedef struct _loc
{
  int x;
  int y;
} _loc;

typedef struct _connectedlocs
{
  vector<_loc> loc;
} _connectedlocs;

void draw_mouse();
void play_sound(int soundtype);
int mouse_moved();
int mouse_clicked();
int mouse_rclicked();

extern DATAFILE *graphics;
extern DATAFILE *units;
extern DATAFILE *mouse;
extern DATAFILE *explosions;
extern DATAFILE *p[4];
extern DATAFILE *glb;
extern BITMAP *back_buffer;
extern BITMAP *mouse_bitmap;
extern _player player[4];
extern _character character[8];

extern volatile int counter;

extern _map map;
extern _minimap minimap;
extern _gameoptions gameoptions;

extern char msg[30];
extern int pturn;
extern int loaded_game;
extern int aiprofile;
extern int translucency;
extern int particles;
extern int maporder;
extern int very_first_turn;
extern _aibuild build[4][18];

#endif
