// [-----] [      ] [---] [--v--] [---] [-----]
// |       |\    /| |   |    |    |   | |
// |       | \  / | |   |    |    |   | |
// >----   |  \/  | [---]    |    [\--] >----
// |       |      | |        |    | \   |
// |       |      | |        |    |  \  |
// [-----] []    [] []    [--^--] [] [] [-----]
// 
// [-----] []      []      [-----] [-----] [---] [-----]
// |     | |       |       |       |       |   | |     |
// |     | |       |       |       |       |   | |     |
// >-----< |       |       >----   | <---] [\--] |     |
// |     | |       |       |       |     | | \   |     |
// |     | |       |       |       |     | |  \  |     |
// []   [] [-----] [-----] [-----] [-----] [] [] [-----]
// 
//     /| |\   |    /  /| |\    |  /-- /---
//    / | | \  |   /  / | | \   | /    |
//   /--| |  | |  /  /--| |  \  | |    |--
//  /   | | /  | /  /   | |   \ | \    |
// /    | |/   |/  /    | |    \|  \-- \---
//
//    BY KENT DEVILLAFRANCA


#include "empire.h"

volatile int counter;
volatile int seconds;
char msg[30];
int loaded_game;
int gamestatus;
int scroll_x;
int scroll_y;
int dovsync;
int mspeed;
int volume;
int fullscreen;
int translucency;
int particles;
int maporder;
int aiprofile;
int defaultgfx;

extern _player player[4];

_character character[8];

BITMAP *back_buffer;
BITMAP *mouse_bitmap;
BITMAP *unittemp;
BITMAP *small_white;
BITMAP *small_yellow;
BITMAP *small_grey;
BITMAP *file_minimap;
BITMAP *battle_bitmap;
BITMAP *statbuf;
BITMAP *unitstatbuf;
DATAFILE *graphics;
DATAFILE *units;
DATAFILE *sounds;
DATAFILE *explosions;
DATAFILE *p[4];
DATAFILE *tiles;
DATAFILE *mouse;
DATAFILE *title;
DATAFILE *land;
DATAFILE *river;
DATAFILE *sea;
DATAFILE *shoal;
DATAFILE *buildings;
DATAFILE *mapunits;
DATAFILE *darkunits;
DATAFILE *powered_overlay;
DATAFILE *glb;

_map map;
_minimap minimap;

extern void draw_tiles(int scrollx, int scrolly, int editing);
extern void draw_tile(int set, int pic, int x, int y);
void draw_dirty();

int intro();
int logic();
int menu();
int mapedit();
int show_winner();
void save_debug_info();
void save_pathmap_info();
void save_unitmap_info();

string unit_name(int type);
int unit_type(string name);

void fps_handler()
{
  seconds++;
}
END_OF_FUNCTION(fps_handler);

void timer_handler()
{
  counter++;
}
END_OF_FUNCTION(timer_handler);

int main()
{
  defaultgfx = 0;
  int modestried = 0;
  int goodmode = 0;
  int i = 0;
  int screenmode;
  char na[30];
  bool showfps = false;
  bool showgfxmode = false;
  srand(time(NULL));
  set_color_depth(16);
  LOCK_VARIABLE(counter);
  LOCK_FUNCTION(timer_handler);
  LOCK_VARIABLE(frames);
  LOCK_FUNCTION(fps_handler);
  allegro_init();
  install_keyboard();
  install_timer();
  install_mouse();
  install_int_ex(timer_handler, BPS_TO_TIMER(50));
  install_int_ex(fps_handler, BPS_TO_TIMER(1));
  ifstream opt("empire.ini");
  if (opt.bad())
  {
    dovsync = 0;
    mspeed = 2;
    volume = 192;
    defaultgfx = 0;
    fullscreen = 1;
    translucency = 1;
    particles = 1;
    maporder = 0;
  }
  else
  {
    opt >> dovsync;
    opt >> mspeed;
    opt >> volume;
    opt >> defaultgfx;
    opt >> fullscreen;
    opt >> translucency;
    opt >> particles;
    opt >> maporder;
  }
  if (fullscreen == 1)
  {
    screenmode = GFX_AUTODETECT_FULLSCREEN;
  }
  else
  {
    screenmode = GFX_AUTODETECT_WINDOWED;
  }
  ifstream landai("ai/land.txt");
  if (landai.bad())
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to open ai/land.txt\n%s\n", allegro_error);
    return 1; 
  }
  else
  {
    i = 0;
    while (i < 18)
    {
      landai >> na >> na >> build[LAND][i].weight >> na >> build[LAND][i].limit;
      i++;
    }
  }
  ifstream seaai("ai/sea.txt");
  if (seaai.bad())
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to open ai/sea.txt\n%s\n", allegro_error);
    return 1; 
  }
  else
  {
    i = 0;
    while (i < 18)
    {
      seaai >> na >> na >> build[SEA][i].weight >> na >> build[SEA][i].limit;
      i++;
    }
  }
  ifstream airai("ai/air.txt");
  if (airai.bad())
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to open ai/air.txt\n%s\n", allegro_error);
    return 1; 
  }
  else
  {
    i = 0;
    while (i < 18)
    {
      airai >> na >> na >> build[AIR][i].weight >> na >> build[AIR][i].limit;
      i++;
    }
  }  
  while ((modestried < 3) && (goodmode == 0))
  {
    if (defaultgfx == 0)
    {
      if (set_gfx_mode(screenmode, 640, 480, 0, 0) != 0)
      {
        defaultgfx = 1;
      }
      else
      {
        goodmode = 1;
      }
      modestried++;
    }
    if (defaultgfx == 1)
    {
      set_color_depth(15);
      if (set_gfx_mode(screenmode, 640, 480, 0, 0) != 0)
      {
        defaultgfx = 2;
      }
      else
      {
        goodmode = 1;
      }
      modestried++;
    }
    if (defaultgfx == 2)
    {
      set_color_depth(32);
      if (set_gfx_mode(screenmode, 640, 480, 0, 0) != 0)
      {
        defaultgfx = 3;
      }
      else
      {
        goodmode = 1;
      }
      modestried++;
    }
  }
  if (goodmode == 0)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
    return 1;
  }
  textout(screen, font, "LOADING...", 5, 5, WHITE);
  if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0)
  {
    allegro_message("Error initialising sound\n%s\n", allegro_error);
    install_sound(DIGI_NONE, MIDI_NONE, NULL);
  }
  graphics = load_datafile("empire.dat");
  if (!graphics)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to load empire.dat\n%s\n", allegro_error);
    return 1;
  }
  tiles = (DATAFILE *)graphics[0].dat;
  land = (DATAFILE *)tiles[0].dat;
  river = (DATAFILE *)tiles[1].dat;
  sea = (DATAFILE *)tiles[2].dat;
  shoal = (DATAFILE *)tiles[3].dat;
  buildings = (DATAFILE *)tiles[4].dat;
  mapunits = (DATAFILE *)tiles[5].dat;
  darkunits = (DATAFILE *)tiles[6].dat;
  mouse = (DATAFILE *)graphics[1].dat;
  title = (DATAFILE *)graphics[2].dat;
  explosions = (DATAFILE *)graphics[4].dat;
  units = load_datafile("units.dat");
  if (!units)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to load units.dat\n%s\n", allegro_error);
    return 1;
  }
  p[0] = (DATAFILE *)units[0].dat;
  p[1] = (DATAFILE *)units[1].dat;
  p[2] = (DATAFILE *)units[2].dat;
  p[3] = (DATAFILE *)units[3].dat;
  powered_overlay = (DATAFILE *)units[5].dat;
  sounds = load_datafile("empfx.dat");
  if (!sounds)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to load empfx.dat\n%s\n", allegro_error);
    return 1;
  }  
  ifstream playerdat("players.dat");
  if (playerdat.bad())
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to load players.dat\n%s\n", allegro_error);
    return 1;
  }
  string a[8], b[8], c[8], d[8], e[8], f[8];
  i = 0;
  while (i < 8)
  {
    getline(playerdat, a[i]);
    getline(playerdat, b[i]);
    getline(playerdat, c[i]);
    getline(playerdat, d[i]);
    getline(playerdat, e[i]);
    getline(playerdat, f[i]);
    i++;
  }
  playerdat.close();
  char blah[3];
  string thepath;
  BITMAP *temp[8];
  glb = (DATAFILE *)graphics[2].dat;
  font = (FONT *)glb[19].dat;
  PALETTE q;
  i = 0;
  while (i < 8)
  {
    thepath = "player";
    sprintf(blah, "%-1d", i + 1);
    thepath += blah;
    thepath += ".bmp";
    temp[i] = load_bitmap(thepath.c_str(), q);
    if (!temp[i])
    {
      temp[i] = create_bitmap(80, 80);
      clear_to_color(temp[i], LGREY);
    }
    character[i].create(a[i], b[i], int(strtol(c[i].c_str(), NULL, 10)), int(strtol(d[i].c_str(), NULL, 10)), int(strtol(e[i].c_str(), NULL, 10)), f[i], temp[i]);
    i++;
  }
  i = 0;
  while (i < 8)
  {
    destroy_bitmap(temp[i]);
    i++;
  }
  BITMAP *tempbmp = create_bitmap(640, 480);
  set_volume(volume, volume);
  small_white = create_bitmap(40, 40);
  clear_to_color(small_white, WHITE);
  small_yellow = create_bitmap(40, 40);
  clear_to_color(small_yellow, YELLOW);
  small_grey = create_bitmap(40, 40);
  clear_to_color(small_grey, GREY);
  file_minimap = create_bitmap(200, 200);
  clear_to_color(file_minimap, BLACK);
  battle_bitmap = create_bitmap(640, 200);
  clear_to_color(battle_bitmap, BLACK);
  set_mouse_speed(mspeed, mspeed);
  back_buffer = create_bitmap(640, 480);
  statbuf = create_bitmap(130, 95);
  unitstatbuf = create_bitmap(100, 80);
  mouse_bitmap = (BITMAP *)mouse[0].dat;
  clear_to_color(back_buffer, BLACK);
  unittemp = create_bitmap(40, 40);
  
  if (translucency == 1)
  {
    gamestatus = GAMEINTRO;
  }
  else
  {
    gamestatus = MENU;
  }
  
  counter = 0;
  scroll_x = 0;
  scroll_y = 0;
  map.reset();
  minimap.create();
  seconds = 0;
  
  int frames = 0;
  int fps = 0;
  bool draw = true;
  
  while (gamestatus != QUIT)
  {
    while (counter > 0)
    {
      clear(back_buffer);
      if ((key[KEY_LCONTROL]) && (key[KEY_B]))
      {
        gamestatus = QUIT;
      }
      switch(gamestatus)
      {
        case GAMEINTRO:
          gamestatus = intro();
          break;
        case MENU:
          gamestatus = menu();
          break;
        case LOGIC:
          gamestatus = logic();
          break;
        case GAMEOVER:
          gamestatus = show_winner();
          break;
        case MAPEDIT:
          gamestatus = mapedit();
          break;
      }
      draw = true;
      counter--;
    }
    if (draw == true)
    {
      frames++;
      if (dovsync == 1)
      {
        vsync();
      }
      if (showfps)
      {
        textprintf(back_buffer, font, 2, 2, WHITE, "%-1d", fps);
        if (seconds > 0)
        {
          fps = frames;
          seconds = 0;
          frames = 0;
        }
      }
      if (showgfxmode)
      {
        switch(defaultgfx)
        {
          case 0:
            textout(back_buffer, font, "16", 2, 15, WHITE);
            break;
          case 1:
            textout(back_buffer, font, "15", 2, 15, WHITE);
            break;
          case 2:
            textout(back_buffer, font, "32", 2, 15, WHITE);
            break;
        }
      }
      blit(back_buffer, screen, 0, 0, 0, 0, 640, 480);
      draw = false;
    }
    if (key[KEY_F12])
    {
      blit(back_buffer, tempbmp, 0, 0, 0, 0, 640, 480);
      save_bitmap("scrngrab.bmp", tempbmp, NULL);
    }
    if (key[KEY_D])
    {
      save_debug_info();
      save_pathmap_info();
      save_unitmap_info();
    }
    yield_timeslice();
  }
  i = 0;
  while (i < 8)
  {
    character[i].destroy();
    i++;
  }
  ofstream settings("empire.ini");
  if (!(settings.bad()))
  {
    settings << dovsync << "\n" << mspeed << "\n" << volume << "\n" << defaultgfx << "\n" << fullscreen << "\n";
    settings << translucency << "\n" << particles << "\n" << maporder;
    settings.close();
  }
  minimap.destroy();
  destroy_bitmap(back_buffer);
  destroy_bitmap(tempbmp);
  destroy_bitmap(unittemp);
  destroy_bitmap(statbuf);
  destroy_bitmap(unitstatbuf);
  destroy_bitmap(small_white);
  destroy_bitmap(small_yellow);
  destroy_bitmap(small_grey);
  destroy_bitmap(file_minimap);
  destroy_bitmap(battle_bitmap);
  unload_datafile(graphics);
  unload_datafile(units);
  unload_datafile(sounds);
  allegro_exit();
  return 0;
}
END_OF_MAIN()





int intro()
{
  _button start[5];
  static BITMAP* introbmp;
  static bool first = true;
  static int t = 0;
  if (first)
  {
    introbmp = create_bitmap(640, 480);
    clear_to_color(introbmp, BLACK);
    start[0].init(270, 150, 100, 20, "Skirmish");
    start[1].init(270, 180, 100, 20, "Load Game");
    start[2].init(270, 240, 100, 20, "Quit");
    start[3].init(270, 300, 100, 20, "Map Editor");
    start[4].init(270, 350, 100, 20, "Options");
    blit((BITMAP *)glb[0].dat, introbmp, 0, 0, 95, 20, 450, 450);
    masked_blit((BITMAP *)glb[1].dat, introbmp, 0, 0, 58, 0, 524, 128);  
    start[0].draw(introbmp);
    start[1].draw(introbmp);
    start[2].draw(introbmp);
    start[3].draw(introbmp);
    start[4].draw(introbmp);
    t = 0;
    first = false;
  }
  if (t < 50)
  {
    clear_to_color(back_buffer, makecol(t * 5, t * 5, t * 5));
  }
  else if (t < 100)
  {
    blit(introbmp, back_buffer, 0, 0, 0, 0, 640, 480);
    fblend_rect_trans(back_buffer, 0, 0, 640, 480, WHITE, 245 - ((t - 50) * 5));
  }
  else
  {
    blit(introbmp, back_buffer, 0, 0, 0, 0, 640, 480);
    destroy_bitmap(introbmp);
    return MENU;
  }
  t++;
  return GAMEINTRO;
}




int mouse_moved()
{
  static int mx = 0;
  static int my = 0;
  if ((mx != mouse_x) || (my != mouse_y))
  {
    mx = mouse_x;
    my = mouse_y;
    return 1;
  }
  return 0;
}





int mouse_clicked()
{
  static int mousedown = 0;
  if (mouse_b & 1)
  {
    mousedown = 1;
  }
  else
  {
    if (mousedown == 1)
    {
      mousedown = 0;
      return 1;
    }
  }
  return 0;
}





int mouse_rclicked()
{
  static int mousedown = 0;
  if (mouse_b & 2)
  {
    mousedown = 1;
  }
  else
  {
    if (mousedown == 1)
    {
      mousedown = 0;
      return 1;
    }
  }
  return 0;
}





void draw_mouse()
{
  draw_sprite(back_buffer, mouse_bitmap, mouse_x, mouse_y);
}





int show_winner()
{
  static int time = 0;
  static int color[4];
  static int winner[4];
  static char winning_team;
  static int num_winners; 
  int i;
  if (time == 0)
  {
    i = 0;
    while (i < 4)
    {
      if (player[i].playing == 1)
      {  
        switch(player[i].team)
        {
          case 1:
            winning_team = 'A';
            break;
          case 2:
            winning_team = 'B';
            break;
          case 3:
            winning_team = 'C';
            break;
          case 4:
            winning_team = 'D';
            break;
        }
        i = 4;
      }
      i++;
    }
    i = 0;
    num_winners = 0;
    while (i < 4)
    {
      if (player[i].playing == 1)
      {
        num_winners++;
        switch(i)
        {
          case 0:
            color[num_winners - 1] = RED;
            break;
          case 1:
            color[num_winners - 1] = BLUE;
            break;
          case 2:
            color[num_winners - 1] = DGREEN;
            break;
          case 3:
            color[num_winners - 1] = DYELLOW;
            break;
        }
        winner[num_winners - 1] = i + 1;
      }
      i++;
    }
    map.draw_tiles();    
    time++;
  }
  else if (time < 60)
  {
    map.draw_tiles();
    if (num_winners < 2)
    {
      rectfill(back_buffer, 0, 0, 640, time * 6, color[0]);
      rectfill(back_buffer, 0, 480, 640, 480 - (time * 6), color[0]);
    }
    else
    {
      rectfill(back_buffer, 0, 0, 640, time * 6, DGREY);
      rectfill(back_buffer, 0, 480, 640, 480 - (time * 6), DGREY);
    }
    time++;
    if (time >= 60)
    {
      play_sound(VICTORY);
    }
  }
  else
  {
    text_mode(-1);
    if (num_winners < 2)
    {
      clear_to_color(back_buffer, color[0]);
      textprintf_centre(back_buffer, (FONT *)glb[2].dat, 319, 200, BLACK, "Player %-1d Wins!", winner[0]);
    }
    else
    {
      clear_to_color(back_buffer, DGREY);
      textprintf_centre(back_buffer, (FONT *)glb[2].dat, 319, 150, WHITE, "Team %-1c Wins!", winning_team);
      i = 0;
      while (i < num_winners)
      {
        textprintf_centre(back_buffer, (FONT *)glb[2].dat, 319, 200 + (30 * i), color[i], "Player %-1d", winner[i]);
        i++;
      }
    }
    textout_centre(back_buffer, font, "Press Enter", 320, 400, BLACK);
    text_mode(0);
  }
  if (key[KEY_ENTER])
  {
    position_mouse(320, 240);
    time = 0;
    return MENU;
  }
  return GAMEOVER;
}

void play_sound(int soundtype)
{
  play_sample((SAMPLE *)sounds[soundtype].dat, volume, 128, 1000, FALSE);
}

extern string unit_name(int type);
void save_debug_info()
{
  int i = 0;
  int j, k;
  _unit* u;
  ofstream dump("empiredump.txt");
  while (i < 4)
  {
    if (player[i].playing == 1)
    {
      dump << "PLAYER " << i << "\n";
      j = 0;
      while (j < 50)
      {
        u = &player[i].unit[j];
        dump << "  UNIT " << j << "\n";
        dump << "    exists:         " << u->exists << "\n";
        dump << "    type:           " << unit_name(u->type) << "\n";
        dump << "    tilex:          " << u->tilex << "\n";
        dump << "    tiley:          " << u->tiley << "\n";
        dump << "    ready:          " << u->ready << "\n";
        dump << "    color:          " << u->color << "\n";
        dump << "    number:         " << u->number << "\n";
        dump << "    gas:            " << u->gas << "\n";
        dump << "    ammo:           " << u->ammo << "\n";
        dump << "    health:         " << u->health << "\n";
        dump << "    capturing:      " << u->capturing << "\n";
        dump << "    submerged:      " << u->submerged << "\n";
        if ((u->type == T_COPTER) || (u->type == LANDER) || (u->type == APC))
        {
          k = 0;
          while (k < 2)
          {
            dump << "      UNIT LOAD " << k << "\n";
            dump << "        loaded:  " << u->load[k].loaded << "\n";
            dump << "        type:    " << unit_name(u->load[k].type) << "\n";
            dump << "        gas:     " << u->load[k].gas << "\n";
            dump << "        ammo:    " << u->load[k].ammo << "\n";
            dump << "        health:  " << u->load[k].health << "\n";
            if (u->load[k].type == APC)
            {
              dump << "          UNIT LOAD " << k << " SUBLOAD\n";
              dump << "            loaded:  " << u->load[k].subload.loaded << "\n";
              dump << "            type:    " << unit_name(u->load[k].subload.type) << "\n";
              dump << "            gas:     " << u->load[k].subload.gas << "\n";
              dump << "            ammo:    " << u->load[k].subload.ammo << "\n";
              dump << "            health:  " << u->load[k].subload.health << "\n";
            }
            k++;
          }
        }
        dump << "\n";
        j++;
      }
      dump << "\n";
    }
    i++;
  }
}

void save_pathmap_info()
{
  int i, j, k;
  ofstream path("pathmap.txt");
  j = 0;
  while (j < map.h)
  {
    i = 0;
    while (i < map.l)
    {
      k = map.tile[i][j].get_step();
      if (k < 10) path << " ";
      path << k << " ";
      if (k < 99) path << " ";
      i++;
    }
    path << "\n";
    j++;
  }
}

void save_unitmap_info()
{
  int i, j, k;
  ofstream unit("unitmap.txt");
  j = 0;
  while (j < map.h)
  {
    i = 0;
    while (i < map.l)
    {
      k = map.tile[i][j].unit_here();
      if ((k < 100) && (k != -1)) unit << " ";
      if (k < 10) unit << " ";
      unit << k << " ";
      i++;
    }
    unit << "\n";
    j++;
  }
}

string unit_name(int type)
{
  switch(type)
  {
    case ANTI_AIR:
      return "Anti-Air";
      break;
    case APC:
      return "APC";
      break;
    case ARTILLERY:
      return "Artillery";
      break;
    case B_COPTER:
      return "B-Copter";
      break;
    case B_SHIP:
      return "B-Ship";
      break;
    case BOMBER:
      return "Bomber";
      break;
    case CRUISER:
      return "Cruiser";
      break;
    case FIGHTER:
      return "Fighter";
      break;
    case INFANTRY:
      return "Infantry";
      break;
    case LANDER:
      return "Lander";
      break;
    case MD_TANK:
      return "Md-Tank";
      break;
    case MECH:
      return "Mech";
      break;
    case MISSILES:
      return "Missiles";
      break;
    case RECON:
      return "Recon";
      break;
    case ROCKETS:
      return "Rockets";
      break;
    case SUB:
      return "Sub";
      break;
    case T_COPTER:
      return "T-Copter";
      break;
    case TANK:
      return "Tank";
      break;
  }
  return "-";
}

int unit_type(string name)
{
  if (name == "Anti-Air")
  {
    return ANTI_AIR;
  }
  else if (name == "APC")
  {
    return APC;
  }
  else if (name == "Artillery")
  {
    return ARTILLERY;
  }
  else if (name == "B-Copter")
  {
    return B_COPTER;
  }
  else if (name == "B-Ship")
  {
    return B_SHIP;
  }
  else if (name == "Bomber")
  {
    return BOMBER;
  }
  else if (name == "Cruiser")
  {
    return CRUISER;
  }
  else if (name == "Fighter")
  {
    return FIGHTER;
  }
  else if (name == "Infantry")
  {
    return INFANTRY;
  }
  else if (name == "Lander")
  {
    return LANDER;
  }
  else if (name == "Md-Tank")
  {
    return MD_TANK;
  }
  else if (name == "Mech")
  {
    return MECH;
  }
  else if (name == "Missiles")
  {
    return MISSILES;
  }
  else if (name == "Recon")
  {
    return RECON;
  }
  else if (name == "Rockets")
  {
    return ROCKETS;
  }
  else if (name == "Sub")
  {
    return SUB;
  }
  else if (name == "T-Copter")
  {
    return T_COPTER;
  }
  else if (name == "Tank")
  {
    return TANK;
  }
  return -1;
}
