#include "empire.h"

bool _button::mouseover()
{
  int mx;
  int my;
  mx = mouse_x;
  my = mouse_y;
  if ((mx >= x) && (mx <= x + w))
  {
    if ((my >= y) && (my <= y + h))
    {
      return true;
    }
  }
  return false;
}

bool _button::mousedown()
{
  if (mouseover() == true)
  {
    if (mouse_b & 1)
    {
      click = true;
      return true;
    }
  }
  else
  {
    click = false;
    return false;
  }
}

bool _button::clicked()
{
  if ((mousedown() == false) && (click == true))
  {
    if (mouseover() == true)
    {
      click = false;
      return true;
    }
  }
  return false;
}

void _button::draw(BITMAP *back_buffer)
{
  if (picture == NULL)
  {
    int m = text_mode(-1);
    int l = text_length(font, text.c_str());
    rect(back_buffer, x, y, x + w, y + h, DGREY);
    rectfill(back_buffer, x + 2, y + 2, x + w - 2, y + h - 2, GREY);
    if (mousedown() == 0)
    {
      textout_centre(back_buffer, font, text.c_str(), x + (w / 2), y + (h / 2) - 5, BLACK);
      rect(back_buffer, x + 1, y + 1, x + w - 1, y + h - 1, LGREY);
      hline(back_buffer, x + 1, y + h - 1, x + w - 1, DGREY);
      vline(back_buffer, x + w - 1, y + 1, y + h - 1, DGREY);
    }
    else
    {
      textout_centre(back_buffer, font, text.c_str(), x + (w / 2) + 1, y + (h / 2) - 4, BLACK);
      rect(back_buffer, x + 1, y + 1, x + w - 1, y + h - 1, DGREY);
      hline(back_buffer, x + 1, y + h - 1, x + w - 1, LGREY);
      vline(back_buffer, x + w - 1, y + 1, y + h - 1, LGREY);
    }
    text_mode(m);
  }
  else
  {
    draw_sprite(back_buffer, picture, x, y);
  }
}

void _button::check(BITMAP *back_buffer)
{
  draw(back_buffer);
  if (mousedown() == true)
  {
    if (sound == false)
    {
      play_sound(CLICK);
      sound = true;
    }
  }
  else
  {
    sound = false;
  }
}

void _button::init(int ix, int iy, int iw, int ih)
{
  init(ix, iy, iw, ih, "", NULL);
}

void _button::init(int ix, int iy, int iw, int ih, string itext)
{
  init(ix, iy, iw, ih, itext, NULL);
}

void _button::init(int ix, int iy, int iw, int ih, string itext, BITMAP *ipicture)
{
  x = ix;
  y = iy;
  w = iw;
  h = ih;
  text = itext;
  picture = ipicture;
  click = false;
  sound = false;
}
