#ifndef _unit_h
#define _unit_h

typedef struct unitprops
{
  int move;
  int movetype;
  int vision;
  int gas;
  int ammo;
  int attacktype;
  int price;
  int basetype;
} unitprops;

typedef struct _subload
{
  int loaded;
  int type;
  int gas;
  int ammo;
  float health;
} _subload;

typedef struct _loadedunit
{
  int loaded;
  int type;
  int gas;
  int ammo;
  float health;
  _subload subload;
} _loadedunit;

class _unit
{
  float frame;
  int direction;
  int x;
  int y;
  vector<int> mlist;
  int moving;
  int destx;
  int desty;
  int maxload;
  void do_move();
  void draw_status_symbols(BITMAP *bmp);
  unitprops get_properties(int type);
  public:
    _unit();
    int otherunit;    
    int type;
    int color;
    int number;
    int ready;
    int price;
    float health;
    int exists;
    int basetype;
    int tilex;
    int tiley;
    int move;
    int movetype;
    int vision;
    int gas;
    int ammo;
    int submerged;
    int attacktype;
    int capturing;
    void create(int utype, int tx, int ty, int tcolor, int tnum);
    void draw();
    void draw(bool increment_frame);
    void set_moves(vector<int> list);
    void supply();
    void kill();
    void set_tiles(int tx, int ty);
    void do_movement();
    bool can_load_unit(_unit *u);
    bool can_unload_unit(int n);
    bool is_moving();
    int load_unit(_unit *u);
    _loadedunit load[2];
};

#endif
