#include "ranges.h"

extern int moves_needed(int mtype, int tx, int ty);
extern int any_unit_here(int tx, int ty);
extern int attackable_unit_here(_unit *attacker, int tx, int ty, bool ignore_teams);

int tile_distance(int ax, int ay, int bx, int by)
{
  int dx, dy;
  dx = abs(bx - ax);
  dy = abs(by - ay);
  return dx + dy;
}

int get_rangemin(int type)
{
  switch(type)
  {
    case ARTILLERY:
    case B_SHIP:    
      return 2;
      break;
    case MISSILES:
    case ROCKETS:
      return 3;
      break;
  }
}

int get_rangemax(int type)
{
  switch(type)
  {
    case ARTILLERY:
      return 3;
      break;
    case B_SHIP:
      return 6;
      break;
    case MISSILES:
    case ROCKETS:
      return 5;
      break;
  }
}

int enemy_in_range(_unit *u)
{
  int i, j, z;
  int min = get_rangemin(u->type);
  int max = get_rangemax(u->type);
  j = u->tiley - max;
  if (j < 0) j = 0;
  while ((j <= u->tiley + max) && (j < map.h))
  {
    i = u->tilex - max;
    if (i < 0) i = 0;
    while ((i <= u->tilex + max) && (i < map.l))
    {
      z = attackable_unit_here(u, i, j, true);
      if (z != -1)
      {
        return z;
      }
      i++;
    }
    j++;
  }
  return -1;
}      

void draw_attackrange(_unit *u)
{
  BITMAP *redbmp = create_bitmap(40, 40);
  clear_to_color(redbmp, RED);
  int rangemin = get_rangemin(u->type);
  int rangemax = get_rangemax(u->type);
  int d;
  int x = u->tilex - rangemax;
  int y = u->tiley - rangemax;
  int max_x = u->tilex + rangemax + 1;
  int max_y = u->tiley + rangemax + 1;
  if (max_x > map.scroll_x + 16) max_x = map.scroll_x + 16;
  if (max_y > map.scroll_y + 12) max_y = map.scroll_y + 12;
  if (x < 0) x = 0;
  while (x < max_x)
  {
    y = u->tiley - rangemax;
    if (y < 0) y = 0;
    while (y < max_y)
    {
      d = tile_distance(x, y, u->tilex, u->tiley);
      if ((d >= rangemin) && (d <= rangemax))
      {
        if (translucency == 1)
        {
          fblend_trans(redbmp, back_buffer, (x - map.scroll_x) * 40, (y - map.scroll_y) * 40, 170);
        }
        else
        {
          rect(back_buffer, (x - map.scroll_x) * 40, (y - map.scroll_y) * 40, (x - map.scroll_x + 1) * 40, (y - map.scroll_y + 1) * 40, RED);
        }
      }
      y++;
    }
    x++;
  }
  destroy_bitmap(redbmp);
}
