#include "empire.h"

void _particle::create(int _x, int _y, int _type)
{
  int a, b;
  x = float(_x);
  y = float(_y);
  type = _type;
  a = rand()%2;
  if (a == 0) a = -1;
  b = rand()%2;
  if (b == 0) b = -1;
  switch(type)
  {
    case P_FLAME:      
      xv = (float(rand()%30) / 10) * float(a);
      yv = (float(rand()%30) / 10) * float(b);
      xa = 0;
      ya = 0;
      life = 8;
      a = rand()%3;
      if (a == 0) color = RED;
      if (a == 1) color = ORANGE;
      if (a == 2) color = YELLOW;
      break;
    case P_DUST:
      xv = (float(rand()%5) / 10) * float(a);
      yv = (float(rand()%5) / 10) * float(b) - 0.5;
      xa = 0;
      ya = 0;
      life = 10;
      break;
    case P_SMOKE:
      xv = (float(rand()%5) / 10) * float(a);
      yv = (float(rand()%2) / 10) * float(a);
      xa = 0;
      ya = -0.02;
      life = 25;
      break;
    case P_AIRTRAIL:
      xv = (float(rand()%6) / 10) * float(a);
      yv = (float(rand()%6) / 10) * float(b);
      xa = 0;
      ya = 0;
      life = 10;
      break;
    case P_SEATRAIL:
      xv = (float(rand()%5) / 10) * float(a);
      yv = (float(rand()%5) / 10) * float(b);
      xa = 0;
      ya = 0;
      life = 30;
      break;
  }
  exists = true;
}

void _particle::move()
{
  xv += xa;
  x += xv;
  yv += ya;
  y += yv;
  life--;
  if (life <= 0)
  {
    exists = false;
  }
}

void _particle::draw()
{
  int screenx = int(x) - (map.scroll_x * 40) + map.offset_x;
  int screeny = int(y) - (map.scroll_y * 40) + map.offset_y;
  int r;
  if ((screenx > -10) && (screenx < 650) && (screeny > -10) && (screeny < 490))
  {
    switch(type)
    {
      case P_FLAME:
        r = (10 - life) / 5;
        circlefill(back_buffer, screenx, screeny, r, color);
        break;
      case P_DUST:
        r = (10 - life) / 5;
        if (translucency == 1)
        {
          fblend_rect_trans(back_buffer, screenx, screeny, r * 2, r * 2, LGREY, 170);
        }
        else
        {
          circlefill(back_buffer, screenx, screeny, r - 1, LGREY);
        }
        break;
      case P_SMOKE:
        r = (25 - life) / 8;
        if (translucency == 1)
        {
          fblend_rect_trans(back_buffer, screenx, screeny, r * 2, r * 2, GREY, 160);
        }
        else
        {
          circlefill(back_buffer, screenx, screeny, r, GREY);
        }
        break;
      case P_AIRTRAIL:
        if (translucency == 1)
        {
          fblend_rect_trans(back_buffer, screenx, screeny, 1, 1, WHITE, 150);
        }
        else
        {
          putpixel(back_buffer, screenx, screeny, WHITE);
        }
        break;
      case P_SEATRAIL:
        if (translucency == 1)
        {
          fblend_rect_trans(back_buffer, screenx, screeny, 1, 1, makecol(170, 170, 255), 170);
        }
        else
        {
          putpixel(back_buffer, screenx, screeny, makecol(170, 170, 255));
        }
        break;
    }
  }
}
