#include "empire.h"

extern int mapcolor(int set, int num);

void _minimap::create()
{
  _tile *t;
  int x;
  int y;
  int s;
  int n;
  if (bmp != NULL)
  {  //if recreating the minimap, destroy the old bitmap
    destroy_bitmap(bmp);
  }
  bmp = create_bitmap((map.l * 4) + 2, (map.h * 4) + 2);
  clear_to_color(bmp, BLACK);
  y = 0;
  while (y < map.h)
  {
    x = 0;
    while (x < map.l)
    {
      t = &map.tile[x][y];
      s = t->get_set();
      n = t->get_number();
      rectfill(bmp, x * 4, y * 4, (x * 4) + 4, (y * 4) + 4, mapcolor(s, n));
      if (s == 4)
      {
        if (n > 3)  //if a normal building
        {
          rect(bmp, x * 4, y * 4, (x * 4) + 3, (y * 4) + 3, BLACK);
        }
        else  //if an HQ
        {
          rect(bmp, x * 4, y * 4, (x * 4) + 3, (y * 4) + 3, WHITE);
        }
      }
      x++;
    }
    y++;
  }  
}

void _minimap::draw(bool mapeditor)
{
  if (translucency == 1)
  {
    fblend_trans(bmp, back_buffer, 1, 1, 200);
  }
  else
  {
    draw_sprite(back_buffer, bmp, 1, 1);
  }
  if (mapeditor)  //show where the viewable area isif in the map editor
  {
    rect(back_buffer, (map.scroll_x * 4) + 1, (map.scroll_y * 4) + 1, (map.scroll_x + 16) * 4, (map.scroll_y + 10) * 4, BLACK);
  }
  else
  {
    rect(back_buffer, (map.scroll_x * 4) + 1, (map.scroll_y * 4) + 1, (map.scroll_x + 16) * 4, (map.scroll_y + 12) * 4, WHITE);
  }
  rect(back_buffer, 0, 0, (map.l * 4) + 1, (map.h * 4) + 1, BLACK);
}

void _minimap::destroy()
{
  destroy_bitmap(bmp);
}
