#include "empire.h"

#define MFIRST  6
#define MLOAD   7
#define MNEW    8
#define MEDIT   9
#define MEXIT  10
#define MCHECK 11
#define MSAVE  12

typedef struct setunit  //the units predeployed on the map, if any
{
  int x;
  int y;
  int player;
  int type;
  int exist;
} setunit;
setunit mapunit[200];

extern char msg[30];
extern volatile int counter;

extern DATAFILE *graphics;
extern BITMAP *back_buffer;
extern BITMAP *file_minimap;

extern int any_unit_here(int tx, int ty);

void draw_selection(int set, int x);
void delete_map(char *file);
void draw_minimap(int x, int y, string file);
void text_box(int x, int y, int w, int h, char *ret, int leng, int spaces);
void draw_units(int scrollx, int scrolly);
void draw_unit(int num, int x, int y);
void new_unit(int x, int y, int type, int player);
void new_unit(int x, int y, int type, int player, int sound);
void clear_all_units();
void remove_unit(int n);
void remove_previous_HQ(int player, int ignorex, int ignorey, int scrollx, int scrolly);
void map_message(string message);
void arrange_mapnames();
void draw_trans_tile(int set, int num, int x, int y);
int mfirst();
int mload();
int mnew();
int medit();
int mcheck();
int save_map();
int mapcolor(int set, int num);
int check_for_unit(int x, int y);
int HQ_exists(int playernum);
int base_exists(int playernum);
int munit_exists(int playernum);
int find_free_unit();
int units_for_player(int plyr);
int do_aiselect();
int datafile_size(DATAFILE *data);
DATAFILE *set_datafile(int set);
//text_box function courtesy of Derezo at allegro.cc, just slightly modified

float length;
float height;

extern DATAFILE *tiles;
extern DATAFILE *land;
extern DATAFILE *river;
extern DATAFILE *sea;
extern DATAFILE *shoal;
extern DATAFILE *buildings;
extern DATAFILE *p[4];
extern DATAFILE *mapunits;

_button option[31];

int mapedit()
{
  static int firstentry = 1;
  static int status = MFIRST;
  int i, j;
  if (firstentry == 1)
  {
    map.h = 12;
    map.l = 16;
    map.reset();
    firstentry = 0;
  }
  switch(status)
  {
    case MFIRST:
      status = mfirst();
      break;
    case MLOAD:
      status = mload();
      break;
    case MNEW:
      status = mnew();
      break;
    case MEDIT:
      status = medit();
      break;
    case MCHECK:
      status = mcheck();
      break;
    case MSAVE:
      status = save_map();
      break;
    case MEXIT:
      status = MFIRST;
      return MENU;
      break;
  }
  return MAPEDIT;
}





int mfirst()
{
  static int drawfirst = 1;
  if (drawfirst == 1)
  {
    option[0].init(10, 455, 100, 20, "New Map");
    option[1].init(120, 455, 100, 20, "Load Map");
    option[2].init(520, 455, 110, 20, "Back to Menu");
    option[3].init(230, 455, 120, 20, "Continue Map");
    drawfirst = 0;
  }  
  blit((BITMAP *)glb[14].dat, back_buffer, 0, 0, 0, 0, 640, 480);
  option[0].check(back_buffer);
  option[1].check(back_buffer);
  option[2].check(back_buffer);
  option[3].check(back_buffer);
  draw_mouse();
  if (option[0].clicked())
  {
    drawfirst = 1;
    return MNEW;
  }
  if (option[1].clicked())
  {
    drawfirst = 1;
    return MLOAD;
  }
  if ((option[2].clicked()) || (key[KEY_ESC]))
  {
    drawfirst = 1;
    return MEXIT;
  }
  if (option[3].clicked())
  {
    drawfirst = 1;
    return MEDIT;
  }
  return MFIRST;
}





int mload()
{
  static int drawfirst = 1;
  static int mapok = 1;
  static int highlighted = -1;
  static int delay = 0;
  static int lscroll = 0;
  static int mapnum;
  int i;
  int j;
  int ok;
  int mx;
  int my;
  int sel;
  int pnum;
  int a, b, c, d;
  char p[30] = "";
  static string n[50];
  if (drawfirst == 1)
  {
    ifstream map("maps/maplist.txt");
    if (map.bad())
    {
      textout(back_buffer, font, "Unable to load 'maplist.txt'", 5, 5, RED);
      mapok = 0;
    }
    i = 0;
    while (i < 50)
    {
      n[i] = "";
      i++;
    }
    option[0].init(10, 455, 100, 20, "Back");
    if (mapok == 1)
    {
      i = 0;
      while (!map.eof())
      {
        getline(map, n[i]);
        sprintf(p, n[i].c_str());
        a = strlen(p) - 1;           //
        b = 0;                       //
        while (b < 4)                //
        {                            // this code removes the ".map"
          p[a] = '\0';               // from the end of the name
          a--;                       //
          b++;                       //
        }                            //
        n[i] = p;
        i++;
      }
      if (i > 22)  //if the list will go beyond the load box
      {
        option[1].init(195, 355, 85, 20, "Up");
        option[2].init(285, 355, 85, 20, "Down");
      }
      mapnum = i;
      i = lscroll;
      while (i < lscroll + 22)
      {
        textout(back_buffer, font, n[i].c_str(), 200, 20 + (15 * (i - lscroll)), WHITE);
        i++;
      }
    }
    drawfirst = 0;
  }
  blit((BITMAP *)glb[14].dat, back_buffer, 0, 0, 0, 0, 640, 480);
  rectfill(back_buffer, 195, 455, 370, 478, BLACK);
  rect(back_buffer, 195, 455, 370, 478, LGREY);
  textout_centre(back_buffer, font, "Left mouse: Select", 280, 456, WHITE);
  textout_centre(back_buffer, font, "Right mouse: Delete", 280, 466, RED);
  rect(back_buffer, 195, 15, 370, 350, LGREY);
  rectfill(back_buffer, 196, 16, 369, 349, BLACK);
  i = lscroll;
  while (i < lscroll + 22)
  {
    textout(back_buffer, font, n[i].c_str(), 200, 20 + (15 * (i - lscroll)), WHITE);
    i++;
  }
  option[0].check(back_buffer);
  if (mapnum > 22)
  {
    option[1].check(back_buffer);
    option[2].check(back_buffer);
    if (option[1].clicked())
    {
      if (lscroll > 0)
      {
        lscroll--;
        drawfirst = 1;
      }
    }
    if (option[2].clicked())
    {
      if (lscroll + 22 < mapnum)
      {
        lscroll++;
        drawfirst = 1;
      }
    }
  }
  if (option[0].clicked())
  {
    drawfirst = 1;
    highlighted = -1;
    lscroll = 0;
    return MFIRST;
  }
  mx = mouse_x;
  my = mouse_y;
  if ((mx > 200) && (mx < 370))
  {
    if ((my > 15) && (my < 350))
    {
      sel = (my - 20) / 15 + lscroll;
      if (n[sel].c_str() != "")
      {
        rectfill(back_buffer, 395, 80, 605, 305, BLACK);
        rect(back_buffer, 395, 80, 605, 305, LGREY);
        sprintf(p, "maps/");
        strcat(p, n[sel].c_str());
        strcat(p, ".map");
        text_mode(-1);
        textout(back_buffer, font, n[sel].c_str(), 400, 85, WHITE);
        text_mode(0);
        draw_minimap(400, 100, p);
      }
      if (mouse_b & 1)
      {
        sprintf(p, "maps/");
        strcat(p, n[sel].c_str());
        strcat(p, ".map");
        ok = 1;
        ifstream m(p);
        if (m.bad())
        {
          ok = 0;
        }
        if (ok == 1)
        {
          sprintf(p, n[sel].c_str());  //
          strcat(p, ".map");
          i = strlen(p) - 1;           //
          j = 0;                       //
          while (j < 4)                //
          {                            // this code removes the ".map"
            p[i] = '\0';               // from the end of the name
            i--;                       //
            j++;                       //
          }                            //
          map.set_name(p);
          m >> map.l >> map.h >> pnum;
          i = 0;
          while (i < map.h)  //loading the map tiles
          {
            j = 0;
            while (j < map.l)
            {
              m >> a;
              map.tile[j][i].change_type(a / 100, a % 100);
              j++;
            }
            i++;
          }
          i = 0;
          while (i < 200)  //loading any placed units
          {
            m >> a;
            if (a != -1)  //if there is a saved unit for this i
            {
              m >> b >> c >> d;
              new_unit(a, b, c, d, 0);  //no unit placement sound
            }
            else  //if a reads -1, there are no more saved units
            {
              i = 200;
            }
            i++;
          }
          m >> aiprofile;
          lscroll = 0;
          drawfirst = 1;
          highlighted = -1;
          minimap.create();
          return MEDIT;
        }
      }
      if (mouse_b & 2)
      {
        if (delay == 0)
        {
          sprintf(p, n[sel].c_str());
          strcat(p, ".map");
          delete_map(p);
          delay = 50;
          lscroll = 0;
          drawfirst = 1;
        }
      }
    }
  }
  if (delay > 0)
  {
    delay--;
  }
  draw_mouse();
  return MLOAD;
}





int mnew()
{
  static int drawfirst = 1;
  int i;
  int j;
  if (drawfirst == 1)
  {
    length = 16;
    height = 12;
    option[0].init(270, 160, 40, 15, "+");
    option[1].init(270, 190, 40, 15, "-");
    option[2].init(330, 160, 40, 15, "+");
    option[3].init(330, 190, 40, 15, "-");
    option[4].init(270, 215, 100, 20, "Create New");
    option[5].init(270, 250, 100, 20, "Cancel");
    drawfirst = 0;
  }
  blit((BITMAP *)glb[14].dat, back_buffer, 0, 0, 0, 0, 640, 480);
  rectfill(back_buffer, 260, 130, 380, 280, GREY);
  rect(back_buffer, 260, 130, 380, 280, WHITE);
  text_mode(-1);
  textout_centre(back_buffer, font, "Size:", 320, 140, BLACK);
  sprintf(msg, "%-1d", int(length));
  textout_centre(back_buffer, font, msg, 290, 180, BLACK);
  sprintf(msg, "%-1d", int(height));
  textout_centre(back_buffer, font, msg, 350, 180, BLACK);  
  text_mode(0);
  i = 0;
  while (i < 6)
  {
    option[i].check(back_buffer);
    i++;
  }
  if (option[0].mousedown() == 1)
  {
    if (length < 50)
    {
      length += .25;
    }
  }
  if (option[1].mousedown() == 1)
  {
    if (length > 16)
    {
      length -=.25;
    }
    else
    {
      length = 16;
    }
  }
  if (option[2].mousedown() == 1)
  {
    if (height < 50)
    {
      height += .25;
    }
  }
  if (option[3].mousedown() == 1)
  {
    if (height > 12)
    {
      height -=.25;
    }
    else
    {
      height = 12;
    }
  }
  if (option[4].clicked())
  {
    map.reset();
    map.l = int(length);
    map.h = int(height);
    drawfirst = 1;
    clear_all_units();
    minimap.create();
    return MEDIT;
  }
  if (option[5].clicked())
  {
    drawfirst = 1;
    return MFIRST;
  }
  draw_mouse();
  return MNEW;
}





int medit()
{
  string backupname;
  char tempname[20] = "";
  static int drawfirst = 1;
  static float scrx = 0;
  static float scry = 0;
  static float tscroll = 0;
  static int selected = -1;
  static int set = 0;
  static int gone_to_mapcheck = 0;
  static int ai_select = 0;
  int tscroll_i = int(tscroll);
  int scrolled;
  int i;
  int j;
  int z;
  int temp;
  int mx = mouse_x;
  int my = mouse_y;
  int mickeyx;
  int mickeyy;
  setunit t;
  if (drawfirst == 1)
  {
    option[0].init(1, 405, 24, 40, "<");
    option[1].init(614, 405, 24, 40, ">");
    option[20].init(1, 450, 40, 15, "Land");
    option[21].init(46, 450, 50, 15, "River");
    option[22].init(101, 450, 40, 15, "Sea");
    option[29].init(146, 450, 50, 15, "Shoal");
    option[26].init(201, 450, 80, 15, "Buildings");
    option[27].init(286, 450, 50, 15, "Units");
    option[23].init(560, 455, 80, 15, "Save Map");
    option[24].init(475, 455, 40, 15, "Name");
    option[30].init(520, 455, 35, 15, "AI");
    option[25].init(430, 455, 40, 15, "Back");
    option[28].init(345, 455, 80, 15, "Check Map");
    text_mode(-1);
    textout(back_buffer, font, "Left mouse: Lay Tile [+Ctrl: Remove Unit]  Right mouse: Mini-map", 106, 472, BLACK);
    text_mode(0);
    if (gone_to_mapcheck == 0)
    {
      i = 0;
      draw_selection(0, i);
      draw_units(0, 0);
      scrx = 0;
      scry = 0;
      set = 0;
      tscroll = 0;
      selected = -1;
    }
    else
    {
      map.scroll_x = int(scrx);
      map.scroll_y = int(scry);
      draw_selection(set, tscroll_i);
      draw_units(map.scroll_x, map.scroll_y);
      gone_to_mapcheck = 0;
    }
    map.scroll_x = 0;
    map.scroll_y = 0;
    position_mouse(320, 240);
    drawfirst = 0;
    ai_select = 0;
  }
  rectfill(back_buffer, 0, 401, 640, 480, LGREY);
  map.draw_tiles(0, 0, 16, 10);
  draw_units(map.scroll_x, map.scroll_y);
  if (ai_select == 1)
  {
    ai_select = do_aiselect();
    if (ai_select == 0)  //do_aiselect() just ended
    {
      map.scroll_x = int(scrx);
      map.scroll_y = int(scry);
    }
  }
  else
  {
    option[20].check(back_buffer);
    option[21].check(back_buffer);
    option[22].check(back_buffer);
    option[23].check(back_buffer);
    option[24].check(back_buffer);
    option[25].check(back_buffer);
    option[26].check(back_buffer);
    option[27].check(back_buffer);
    option[28].check(back_buffer);
    option[29].check(back_buffer);
    option[30].check(back_buffer);
    if (option[28].clicked())
    {
      gone_to_mapcheck = 1;
      drawfirst = 1;
      return MCHECK;
    }
    if (option[25].clicked())
    {
      drawfirst = 1;
      clear_all_units();
      return MFIRST;
    }
    if (option[23].clicked())
    {
      return MSAVE;
    }
    if (option[24].clicked())
    {  //"name" was clicked, go to map name input
      sprintf(tempname, map.get_name().c_str());
      backupname = map.get_name();
      text_box(240, 200, 160, 20, tempname, 15, 1);
      if (strcmp(tempname, "_CANCEL_") == 0)
      {  //if ESC was pressed in text_box
        map.set_name(backupname);
      }
      else
      {
        map.set_name(tempname);
      }
    }
    if (option[30].clicked())
    {  //"AI" was clicked, select AI profile
      ai_select = 1;
    }
    if (option[20].clicked())
    {  //switch to the land tiles
      set = 0;
      tscroll = 0;
      tscroll_i = 0;
      selected = -1;
      draw_selection(set, tscroll_i);
    }
    if (option[21].clicked())
    {  //switch to the river tiles
      set = 1;
      tscroll = 0;
      tscroll_i = 0;
      selected = -1;
      draw_selection(set, tscroll_i);
    }
    if (option[22].clicked())
    {  //switch to the sea tiles
      set = 2;
      tscroll = 0;
      tscroll_i = 0;
      selected = -1;
      draw_selection(set, tscroll_i);
    }
    if (option[29].clicked())
    {  //switch to the shoal tiles
      set = 3;
      tscroll = 0;
      tscroll_i = 0;
      selected = -1;
      draw_selection(set, tscroll_i);
    }
    if (option[26].clicked())
    {  //switch to the building tiles
      set = 4;
      tscroll = 0;
      tscroll_i = 0;
      selected = -1;
      draw_selection(set, tscroll_i);
    }
    if (option[27].clicked())
    {  //switch to unit placement
      set = 5;
      tscroll = 0;
      tscroll_i = 0;
      selected = -1;
      draw_selection(set, tscroll_i);
    }
    option[0].check(back_buffer);
    option[1].check(back_buffer);
    if (option[0].mousedown())//clicked())
    {
      if (tscroll > 0)
      {
        tscroll -= 0.2;
        if (tscroll < 0)
        {
          tscroll = 0;
        }
      }
      if (int(tscroll) != tscroll_i)
      {
        draw_selection(set, int(tscroll));
      }
    }
    if (option[1].mousedown())//clicked())
    {
      if (int(tscroll) + 13 <= datafile_size(set_datafile(set)))
      {
        tscroll += 0.2;
        if (int(tscroll) + 13 > datafile_size(set_datafile(set)))
        {
          tscroll = datafile_size(set_datafile(set)) - 13;
        }
      }
      if (int(tscroll) != tscroll_i)
      {
        draw_selection(set, int(tscroll));
      }
    }
    i = 2;
    while (i < 16)
    {
      option[i].check(back_buffer);
      if (option[i].clicked())
      {
        selected = i - 2 + int(tscroll);
      }
      i++;
    }
    get_mouse_mickeys(&mickeyx, &mickeyy);  
    map.scroll_x = int(scrx);
    map.scroll_y = int(scry);
    scrolled = 0;
    if (!(mouse_b & 1))
    {  //the screen can't scroll while the mouse button is down
      if (((mx <= 0) && (mickeyx < 0)) || (key[KEY_LEFT]))
      {
        if (scrx > 0)
        {
          scrx -= .25;
          scrolled = 1;
        }
      }
      if (((mx >= 639) && (mickeyx > 0)) || (key[KEY_RIGHT]))
      {
        if (scrx + 16 < map.l)
        {
          scrx += .25;
          scrolled = 1;
        }
      }
      if (((my >= 479) && (mickeyy > 0)) || (key[KEY_DOWN]))
      {
        if (scry + 10 < map.h)
        {
          scry += .25;
          scrolled = 1;
        }
      }
      if (((my <= 0) && (mickeyy < 0)) || (key[KEY_UP]))
      {
        if (scry > 0)
        {
          scry -= .25;
          scrolled = 1;
        }
      }
    }
    if ((map.scroll_x != int(scrx)) || (map.scroll_y != int(scry)))
    {  //if the map has scrolled, redraw the tiles
      map.scroll_x = int(scrx);
      map.scroll_y = int(scry);
    }
    if (scrolled == 0)
    {
      scrx = int(scrx);
      scry = int(scry);
    }
    if ((selected != -1) && (my < 400))
    {
      if (set != 5)
      {  //if it's a tile that's selected, not a unit
        draw_trans_tile(set, selected, mx - 20, my - 20);
      }
    }
    if ((mouse_b & 1) && (my < 400))
    {  //place a tile/unit on the map if the mouse is pressed or remove a unit
      i = mx / 40 + map.scroll_x;
      j = my / 40 + map.scroll_y;
      if ((key[KEY_LCONTROL]) || (key[KEY_RCONTROL]))
      {  //if the mouse clicks while holding ctrl, remove the unit the mouse is on
        z = check_for_unit(i, j);
        if (z != -1)
        {
          remove_unit(z);
        }
      }
      else if (selected != -1)
      {
        if (set != 5)  //if it's tiles, not units being placed
        {
          if (!map.tile[i][j].same_type(set, selected))
          {                       //from the tile to be placed
            if (set == 4)
            {
              if ((selected >= 0) && (selected <= 3))
              {  //if it's an HQ being placed, remove previous HQ for that player
                remove_previous_HQ(selected, mx, my, map.scroll_x, map.scroll_y);
              }
            }
            play_sound(TILEDOWN);
            map.tile[i][j].change_type(set, selected);
            minimap.create();  //recreate the minimap when a tile is changed
            z = check_for_unit(i, j);
          }
        }
        else  //if a unit is being placed
        {
          new_unit(i, j, selected / 4, selected % 4);
        }
      }
    }
    if (mouse_b & 2)
    {
      minimap.draw(true);
    }
    if (my < 400)
    {  //show the mouse's tile coordinates
      text_mode(-1);
      sprintf(msg, "X: %-1d", mx / 40 + map.scroll_x);
      textout(back_buffer, font, msg, 5, 470, BLACK);
      sprintf(msg, "Y: %-1d", my / 40 + map.scroll_y);
      textout(back_buffer, font, msg, 55, 470, BLACK);
      text_mode(0);
    }
    draw_mouse();    
  }
  return MEDIT;
}





void draw_selection(int set, int x)
{
  DATAFILE *selected;
  selected = set_datafile(set);
  int z = datafile_size(selected);
  int i = 0;
  while (i < 14)
  {
    if (i < z)
    {
      option[i + 2].init(40 * i + 32 + i, 405, 40, 40, "", (BITMAP *)selected[x + i].dat);
    }
    else
    {
      option[i + 2].init(0, 641, 0, 0);  //basically make it unclickable
    }
    i++;
  }
}

DATAFILE *set_datafile(int set)
{
  switch(set)
  {
    case 0:
      return land;
      break;
    case 1:
      return river;
      break;
    case 2:
      return sea;
      break;
    case 3:
      return shoal;
      break;
    case 4:
      return buildings;
      break;
    case 5:
      return mapunits;
      break;
  }
  return NULL;
}

int datafile_size(DATAFILE *data)
{
  int size = 0;
  while (data[size].type != DAT_END)
      size++;
  return size;
}





int save_map()
{
  int i;
  int j;
  int q = 0;
  char name[30] = "";
  char t[40] = "";
  static bool first = true;
  static bool failure = false;
  static string failstring = "";
  if (map.get_name() != "")
  {
    ofstream log("maps/mapedit.log", ios::app);
    if (!log.bad())
    {
      log << "Attempting to save the map...\n";
    }
    rectfill(back_buffer, 390, 446, 640, 453, LGREY);
    ofstream s("maps\\maplist.txt", ios::app);
    if (s.bad())
    {
      failure = true;
      failstring = "Unable to save to 'maplist.txt'";
    }
    else
    {
      sprintf(name, map.get_name().c_str());
      strcat(name, ".map");
      sprintf(t, "maps/");
      strcat(t, name);
      delete_map(name);
      s << "\n" << name;
      ofstream m(t);
      if (m.bad())
      {
        failure = true;
        failstring = "Unable to save ";
        failstring += name;
      }
      else
      {
        m << map.l << "\n";
        m << map.h << "\n";
        if (HQ_exists(3) == 1)  //if 4 player map
        {
          m << "4" << "\n";
        }
        else if (HQ_exists(2) == 1)  //if 3 player map
        {
          m << "3" << "\n";
        }
        else  //2 player map
        {
          m << "2" << "\n";
        }
        i = 0;
        while (i < map.h)  //saving the tiles
        {
          j = 0;
          while (j < map.l)
          {
            m << (map.tile[j][i].get_set() * 100) + map.tile[j][i].get_number() << " ";
            j++;
          }
          m << "\n";
          i++;
        }
        i = 0;
        while (i < 200)  //saving deployed units
        {
          if (mapunit[i].exist == 1)
          {
            m << mapunit[i].x << "\n";
            m << mapunit[i].y << "\n";
            m << mapunit[i].type << "\n";
            m << mapunit[i].player << "\n";
          }
          else
          {
            m << "-1\n";
            i = 200;
          }
          i++;
        }
        m << aiprofile;
      }
    }
    s.close();
    if (!log.bad())
    {
      log << "Attempting to rearrange map names...\n";
    }
    if (failure == false)
    {
      arrange_mapnames();
      if (!log.bad())
      {
        log << "Save-related functions for " << map.get_name() << " completed successfully.\n\n";
      }
      counter = 0;
      return MEDIT;
    }
  }
  else
  {
    failure = true;
    failstring = "The map needs a name";
  }
  if (failure == true)
  {
    if (first == true)
    {
      map_message("CLEAR");
      map_message(failstring);
      first = false;
    }
    map.draw_tiles();
    rectfill(back_buffer, 0, 401, 640, 480, LGREY);
    hline(back_buffer, 0, 400, 640, BLACK);  
    draw_units(map.scroll_x, map.scroll_y);
    map_message("-");
    if (key[KEY_ENTER])
    {
      failure = false;
      first = true;
      return MEDIT;
    }
  }
  return MSAVE;
}





void text_box(int x, int y, int w, int h, char *ret, int leng, int spaces)
{
  char orig[leng];
  int i = 0;
  int k;
  sprintf(orig, ret);
  k = 0;
  while (orig[k] != '\0')
  {
    i++;
    k++;
  }
  int exit = 0;
  int q = 0;
  BITMAP *bmp;
  bmp = create_bitmap(w,h);
  clear(bmp);
  rect(bmp,0,0,w-1,h-1,GREEN);
  rectfill(bmp,1,1,w-2,h-2,DGREY);
  textout_centre(bmp, font, orig, w / 2, 2, GREEN);
  draw_sprite(screen,bmp,x,y);
  clear_keybuf();
  while(exit == 0)
  {
    k = readkey();
    if(((k >> 8) == KEY_ENTER)) q = 1;
    else if(((k >> 8) == KEY_BACKSPACE) && i > 0) { i--; ret[i] = '\0'; }
    else if(((k >> 8) == KEY_BACKSPACE)) { ret[i] = '\0'; }
    else if(((k >> 8) == KEY_ESC))
    {
      q = 1;
      sprintf(ret, "_CANCEL_");
    }
    else if (((k >> 8) == KEY_SPACE) && (spaces == 0))
    {  //do nothing
    }
    else
    {
      if (i < leng)
      {
        ret[i] = k & 0xFF;
        ret[i+1] = '\0';
        i++;
      }
    }
    if (q == 1)
    {
      if (ret[0] != '\0')
      {
        exit = 1;
      }
      q = 0;
    }
    rectfill(bmp,1,1,w-2,h-2,DGREY);
    textprintf_centre(bmp,font,w/2,2,GREEN,"%s",ret);
    draw_sprite(screen,bmp,x,y);
  }
  counter = 0;
  destroy_bitmap(bmp);
}





void draw_minimap(int x, int y, string file)
{
  int i;
  int j;
  int z;
  int s;
  int n;
  bool redo = true;
  int color = 0;
  int p;
  static int l = 0;
  static int h = 0;
  static string previous = "";
  if (file == previous)
  {
    redo = false;
  }
  if (redo == true)
  {
    ifstream m(file.c_str());
    if (m.bad())
    {
      redo = false;
      return;
    }
    m >> l >> h >> p;
    clear_to_color(file_minimap, BLACK);
    i = 0;
    while (i < h)
    {
      j = 0;
      while (j < l)
      {
        m >> z;
        s = z / 100;
        n = z % 100;
        color = mapcolor(s, n);
        rectfill(file_minimap, 4 * j, 4 * i, 4 * j + 4, 4 * i + 4, color);
        if (s == 4)
        {
          if (n > 3)  //if a normal building
          {
            rect(file_minimap, j * 4, i * 4, (j * 4) + 3, (i * 4) + 3, BLACK);
          }
          else  //if an HQ
          {
            rect(file_minimap, j * 4, i * 4, (j * 4) + 3, (i * 4) + 3, WHITE);
          }
        }
        j++;
      }
      i++;
    }
    previous = file;
  }
  blit(file_minimap, back_buffer, 0, 0, x, y, l * 4, h * 4);
}





int mapcolor(int set, int num)
{
  int BRED = makecol(200, 0, 0);
  int BGREEN = makecol(0, 200, 0);
  int BBLUE = makecol(0, 0, 200);
  int BYELLOW = makecol(200, 200, 0);
  int color;
  if (set == 0)
  {
    if ((num == 0) || (num == 1) || (num > 4))
    {  //if it is a road
      color = DGREY;
    }
    else if (num == 2)
    {
      color = makecol(0, 100, 0);
    }
    else if (num == 3)
    {
      color = GREEN;
    }
    else if (num == 4)
    {
      color = makecol(190, 180, 20);
    }
  }
  else if ((set == 2) && (num == 1))  //reef
  {
    color = makecol(200, 200, 250);
  }
  else if (set == 3)  //shoal
  {
    color = makecol(225, 220, 140);
  }
  else if (set == 4)  //buildings
  {
    if (num < 4)
    {
      switch(num % 4)  //capitals
      {
        case 0:
          color = BRED;
          break;
        case 1:
          color = BBLUE;
          break;
        case 2:
          color = BGREEN;
          break;
        case 3:
          color = BYELLOW;
          break;
      }
    }
    else
    {
      switch(num % 5)  //other buildings (which can be neutral)
      {
        case 0:
          color = BRED;
          break;
        case 1:
          color = BBLUE;
          break;
        case 2:
          color = BGREEN;
          break;
        case 3:
          color = BYELLOW;
          break;
        case 4:
          color = LGREY;
          break;
      }
    }
  }
  else
  {
    color = BLUE;
  }
  return color;
}





void delete_map(char *file)
{
  vector<string> fname;
  string temp;
  char fullfile[50];
  int i = 0;
  int j = 0;
  int min;
  int t;
  int first_entry_deleted;
  sprintf(fullfile, "maps/");
  strcat(fullfile, file);
  delete_file(fullfile);
  ifstream m("maps/maplist.txt");
  while (!m.eof())  //read all the map names in
  {
    fname.push_back();
    getline(m, fname[i]);
    i++;
  }
  delete_file("maps/maplist.txt");
  t = i;
  i = 0;
  first_entry_deleted = 0;
  ofstream n("maps/maplist.txt");
  while (i < t)
  {
    if (strcmpi(file, fname[i].c_str()) != 0)  //put all the map names back except
    {                                         //for the file that was deleted
      if (i != 0)  //if it isn't the first entry, move down a
      {            //line before adding the next map name
        if (first_entry_deleted == 0)  //special case to keep a blank space from
        {                              //being the first entry in the file
          n << "\n";
        }
        else
        {
          first_entry_deleted = 0;  //if the first entry is deleted, it will avoid
        }                           //adding the "\n" at the beginning of the file
      }                             //and then move down normally from there
      n << fname[i];
    }
    else
    {
      if (i == 0)
      {
        first_entry_deleted = 1;
      }
    }
    i++;
  }
}

void draw_units(int scrollx, int scrolly)
{
  int i = 0;
  while (i < 200)
  {
    if (mapunit[i].exist == 1)
    {
      if ((mapunit[i].x >= scrollx) && (mapunit[i].x < scrollx + 16))
      {
        if ((mapunit[i].y >= scrolly) && (mapunit[i].y < scrolly + 10))
        {
          draw_unit(i, (mapunit[i].x - scrollx) * 40, (mapunit[i].y - scrolly) * 40);
        }
      }
    }
    i++;
  }
}

void clear_all_units()
{
  int i = 0;
  while (i < 200)
  {
    mapunit[i].exist = 0;
    i++;
  }
}

void draw_unit(int num, int x, int y)
{
  setunit t = mapunit[num];
  draw_sprite(back_buffer, (BITMAP *)mapunits[(t.type * 4) + t.player].dat, x, y);
}

void new_unit(int x, int y, int type, int player)
{
  new_unit(x, y, type, player, 1);
}

void new_unit(int x, int y, int type, int player, int sound)
{
  int n;
  int z = check_for_unit(x, y);
  if (z == -1)  //if no unit in this spot
  {
    n = find_free_unit();  //initialize a new one
    if (n != -1)
    {
      if (units_for_player(player) < 50)
      {
        if (sound == 1)
        {
          play_sound(UNITDOWN);
        }
        mapunit[n].exist = 1;
        mapunit[n].x = x;
        mapunit[n].y = y;
        mapunit[n].type = type;
        mapunit[n].player = player;
      }
    }
  }
  else  //if a unit is already there, redefine its attributes to what was selected
  {
    if (!((mapunit[z].type == type) && (mapunit[z].player == player)))
    {  //if a unit of the exact same type is here already, it won't do anything
      if (sound == 1)
      {
        play_sound(UNITDOWN);
      }
      mapunit[z].type = type;
      mapunit[z].player = player;
    }
  }
}

int check_for_unit(int x, int y)
{
  int i = 0;
  while (i < 200)
  {
    if (mapunit[i].exist == 1)
    {
      if ((mapunit[i].x == x) && (mapunit[i].y == y))
      {
        return i;
      }
    }
    i++;
  }
  return -1;
}

int find_free_unit()
{
  int i = 0;
  while (i < 200)
  {
    if (mapunit[i].exist == 1)
    {
      i++;
    }
    else
    {
      return i;
    }
  }
  return -1;
}

void remove_unit(int n)
{
  int i = n + 1;
  while (i < 199)
  {
    mapunit[n] = mapunit[i];
    n++;
    i++;
  }
}

void remove_previous_HQ(int player, int ignorex, int ignorey, int scrollx, int scrolly)
{
  int i = 0;
  int j;
  _tile *t;
  while (i < map.h)
  {
    j = 0;
    while (j < map.l)
    {
      if ((j != ignorex) || (i != ignorey))
      {
        t = &map.tile[j][i];
        if ((t->is_HQ()) && (t->owned_by(player)))
        {
          t->reset();
        }
      }
      j++;
    }
    i++;
  }
}





int mcheck()
{
  static int checked = 0;
  int x, y;
  char themessage[40];
  int i;
  map.draw_tiles();
  rectfill(back_buffer, 0, 401, 640, 480, LGREY);
  hline(back_buffer, 0, 400, 640, BLACK);  
  draw_units(map.scroll_x, map.scroll_y);
  if (checked == 0)
  {
    map_message("CLEAR");
    if (HQ_exists(0) == 0)
    {
      map_message("Player 1 has no HQ");
    }
    if (HQ_exists(1) == 0)
    {
      map_message("Player 2 has no HQ");
    }
    i = 0;
    while (i < 4)
    {
      if (HQ_exists(i) == 1)
      {
        if ((base_exists(i) == 0) && (munit_exists(i) == 0))
        {
          sprintf(themessage, "Player %-1d has no bases or units", i + 1);
          map_message(themessage);
        }
      }
      if ((base_exists(i) == 1) || (munit_exists(i) == 1))
      {
        if (HQ_exists(i) == 0)
        {
          sprintf(themessage, "Player %-1d has no HQ", i + 1);
          map_message(themessage);
        }
      }
      i++;
    }
    checked = 1;
  }
  map_message("-");
  if (key[KEY_ENTER])
  {
    checked = 0;
    return MEDIT;
  }
  return MCHECK;
}

void map_message(string message)
{
  int i = 0;
  static vector<string> display;
  text_mode(-1);
  if (message == "CLEAR")
  {
    display.resize(0);
  }
  else if (message == "-")
  {  //do nothing but display the previous messages
  }
  else
  {
    display.push_back(message);
  }
  rectfill(back_buffer, 140, 100, 500, 350, GREY);
  rect(back_buffer, 140, 100, 500, 350, BLACK);
  textout_centre(back_buffer, font, "Map Errors:", 320, 120, RED);
  textout_centre(back_buffer, font, "Press Enter", 320, 330, BLACK);  
  i = 0;
  while (i < display.size())
  {
    textout_centre(back_buffer, font, display[i].c_str(), 320, 145 + (12 * i), BLACK);
    i++;
  }
  text_mode(0);
}

int HQ_exists(int playernum)
{
  int x, y;//, z, s;
  _tile *t;
  y = 0;
  while (y < map.h)
  {
    x = 0;
    while (x < map.l)
    {
      t = &map.tile[x][y];
      if (t->is_HQ())
      {
        if (t->owned_by(playernum))
        {
          return 1;
        }
      }
      x++;
    }
    y++;
  }
  return 0;
}

int base_exists(int playernum)
{
  int x, y;//, z, s;
  _tile *t;
  y = 0;
  while (y < map.h)
  {
    x = 0;
    while (x < map.l)
    {
      t = &map.tile[x][y];
      if (t->is_unit_producing())
      {
        if (t->owned_by(playernum))
        {
          return 1;
        }
      }
      x++;
    }
    y++;
  }
  return 0;
}

int munit_exists(int playernum)
{
  int i = 0;
  while (i < 200)
  {
    if (mapunit[i].exist == 1)
    {
      if (mapunit[i].player == playernum)
      {
        return 1;
      }
    }
    i++;
  }
  return 0;
}

int units_for_player(int plyr)
{
  int n = 0;
  int i = 0;
  while (i < 200)
  {
    if (mapunit[i].exist == 1)
    {
      if (mapunit[i].player == plyr)
      {
        n++;
      }
    }
    i++;
  }
  return n;
}

int do_aiselect()
{
  static _button opt[3];
  static int first = 1;
  int i = 0;
  if (first == 1)
  {
    position_mouse(320, 200);
    set_mouse_range(200, 150, 440, 220);
    opt[0].init(210, 190, 70, 20, "Land");
    opt[1].init(285, 190, 70, 20, "Air");
    opt[2].init(360, 190, 70, 20, "Sea");
    first = 0;
  }
  rectfill(back_buffer, 200, 150, 440, 220, DGREY);
  rect(back_buffer, 200, 150, 440, 220, BLACK);
  text_mode(-1);
  textout_centre(back_buffer, font, "Select the map's AI profile", 320, 160, WHITE);
  switch(aiprofile)
  {
    case 0:
      textout_centre(back_buffer, font, "Current: Land", 320, 175, WHITE);
      break;
    case 1:
      textout_centre(back_buffer, font, "Current: Air", 320, 175, WHITE);
      break;
    case 2:
      textout_centre(back_buffer, font, "Current: Sea", 320, 175, WHITE);
      break;
  }
  text_mode(0);
  while (i < 3)
  {
    opt[i].check(back_buffer);
    if (opt[i].clicked())
    {
      aiprofile = i;
      first = 1;
      set_mouse_range(0, 0, 639, 479);
      return 0;  //ends do_aiselect()
    }
    i++;
  }
  draw_mouse();
  return 1;  //will continue doing do_aiselect()
}

typedef struct _maparrange
{
  string name;
  int players;
  int l, h;
  bool bad;
} _maparrange;

void arrange_mapnames()
{
  vector<_maparrange> arrange;
  _maparrange atemp;
  string temp;
  int i, j, min, y, z;
  char c[30];
  i = 0;
  ifstream m("maps/maplist.txt");
  while (!m.eof())  //read all the map names in
  {
    arrange.push_back();
    getline(m, arrange[i].name);
    sprintf(c, "maps/");
    strcat(c, arrange[i].name.c_str());
    ifstream in(c);
    if (in.bad())
    {
      arrange[i].bad = true;
    }
    else
    {
      in >> arrange[i].l >> arrange[i].h >> arrange[i].players;
      arrange[i].bad = false;
    }
    in.close();
    i++;
  }
  i = 0;
  while (i < arrange.size() - 1)
  {  //arrange filenames according to maporder
    min = i;  //not as fast as a mergesort, but it's not like it's going
    j = i;    //to be sorting thousands of map files or anything like that
    while (j < arrange.size())
    {
      if (maporder == 0)
      {  //arrange by name
        if (strcmpi(arrange[j].name.c_str(), arrange[min].name.c_str()) < 0)
        {
          min = j;
        }
      }
      if (maporder == 1)
      {  //arrange by number of players
        if ((!arrange[j].bad) && (!arrange[min].bad))
        {
          if (arrange[j].players < arrange[min].players)
          {
            min = j;
          }
          else if (arrange[j].players == arrange[min].players)
          {  //arrange by name if they have the same number of players
            if (strcmpi(arrange[j].name.c_str(), arrange[min].name.c_str()) < 0)
            {
              min = j;
            }
          }
        }
      }
      if (maporder == 2)
      {
        if ((!arrange[j].bad) && (!arrange[min].bad))
        {
          y = arrange[j].l * arrange[j].h;
          z = arrange[min].l * arrange[min].h;
          if (y < z)
          {
            min = j;
          }
          else if (y == z)
          {  //arrange by name if they have the same size
            if (strcmpi(arrange[j].name.c_str(), arrange[min].name.c_str()) < 0)
            {
              min = j;
            }
          }
        }
      }
      j++;
    }
    if (min != i)
    {
      atemp = arrange[i];
      arrange[i] = arrange[min];
      arrange[min] = atemp;
    }
    i++;
  }
  m.close();
  ofstream o("maps/maplist.txt");
  i = 0;
  while (i < arrange.size())
  {
    o << arrange[i].name;
    if (i < arrange.size() - 1)
    {
      o << "\n";
    }
    i++;
  }
}

void draw_trans_tile(int set, int num, int x, int y)
{
  DATAFILE *selected;
  if (translucency == 1)
  {
    switch(set)
    {
      case 0:
        selected = land;
        break;
      case 1:
        selected = river;
        break;
      case 2:
        selected = sea;
        break;
      case 3:
        selected = shoal;
        break;
      case 4:
        selected = buildings;
        break;
    }
    fblend_trans((BITMAP *)selected[num].dat, back_buffer, x, y, 170);
  }
}
