#include "empire.h"

const int FIRST          = -11;
const int LOAD           = -12;
const int OPTIONS        = -13;
const int GAME_OPTIONS   = -14;
const int GAME_LOAD      = -15;
const int INGAME_OPTIONS = -16;

int numplayers;

extern int dovsync;
extern int mspeed;
extern int volume;
extern int fullscreen;
extern int defaultgfx;

_button start[6];
_button pselect[6];
_button back;
_button ok;
_button plyr[8];
_button opt[10];

_player player[4];

_gameoptions gameoptions;

extern void draw_minimap(int x, int y, string file);
extern void arrange_mapnames();
//extern int get_set(int mapdat);

void description(int c);
void list_players(int numplayers, int selected);
void load_custom_ai(string mname);
int do_first();
int do_load();
int do_options();
int do_gameoptions();
int ingame_options();
int do_gameload();

int is_beach(int x, int y);
int beach_already_listed(int x, int y);

void get_connected_beaches();
void add_surrounding_beaches(int bnum, int x, int y);

vector<_connectedlocs> beaches;

int menu()
{
  static int menunum = FIRST;
  int t;
  switch (menunum)
  {
    case FIRST:
      menunum = do_first();
      break;
    case LOAD:
      menunum = do_load();
      break;
    case OPTIONS:
      menunum = do_options();
      break;
    case MAPEDIT:
      menunum = FIRST;
      return MAPEDIT;
      break;
    case GAME_OPTIONS:
      menunum = do_gameoptions();
      break;
    case INGAME_OPTIONS:
      menunum = ingame_options();
      break;
    case GAME_LOAD:
      menunum = do_gameload();
      break;
    case QUIT:
      return QUIT;
      break;
    default:        //default cases would lead out of the menu, so
      t = menunum;  //the menu has to open in FIRST next time
      menunum = FIRST;
      return t;
      break;
  }
  return MENU;
}





int do_first()
{
  static int drawbox = 1;
  if (drawbox == 1)
  {
    start[0].init(270, 150, 100, 20, "Skirmish");
    start[1].init(270, 180, 100, 20, "Load Game");
    start[2].init(270, 240, 100, 20, "Quit");
    start[3].init(270, 300, 100, 20, "Map Editor");
    start[4].init(270, 350, 100, 20, "Options");
    aiprofile = 0;  //reset the AI profile to the default
    drawbox = 0;
  }
  blit((BITMAP *)glb[0].dat, back_buffer, 0, 0, 95, 20, 450, 450);
  masked_blit((BITMAP *)glb[1].dat, back_buffer, 0, 0, 58, 0, 524, 128);  
  start[0].check(back_buffer);
  start[1].check(back_buffer);
  start[2].check(back_buffer);
  start[3].check(back_buffer);
  start[4].check(back_buffer);
  if (start[0].clicked())
  {
    drawbox = 1;
    return LOAD;
  }
  if (start[1].clicked())
  {
    drawbox = 1;
    return GAME_LOAD;
  }
  if ((start[2].clicked()) || (key[KEY_ESC]))
  {
    drawbox = 1;
    return QUIT;
  }
  if (start[3].clicked())
  {
    drawbox = 1;
    return MAPEDIT;
  }
  if (start[4].clicked())
  {
    drawbox = 1;
    return GAME_OPTIONS;
  }
  draw_mouse();
  return FIRST;
}





int do_load()
{
  static int drawfirst = 1;
  static int mapok = 1;
  static int highlighted = -1;
  static int delay = 0;
  static int lscroll = 0;
  static int mapnum;
  int a, b, c, d;
  int i;
  int j;
  int temp;
  int ok;
  int mx;
  int my;
  int sel;
  char p[30] = "";
  string name;
  static string n[50];
  if (drawfirst == 1)
  {
    ifstream map("maps/maplist.txt");
    if (map.bad())
    {
      textout(back_buffer, font, "Unable to load 'maplist.txt'", 5, 5, RED);
      mapok = 0;
    }
    i = 0;
    while (i < 50)
    {
      n[i] = "";
      i++;
    }
    opt[0].init(10, 455, 100, 20, "Back");
    if (mapok == 1)
    {
      i = 0;
      while (!map.eof())
      {
        getline(map, n[i]);
        sprintf(p, n[i].c_str());    //
        a = strlen(p) - 1;           //
        b = 0;                       //
        while (b < 4)                //
        {                            // this code removes the ".map"
          p[a] = '\0';               // from the end of the name
          a--;                       //
          b++;                       //
        }                            //
        n[i] = p;                    //
        i++;
      }
      if (i > 22)  //if the list will go beyond the load box
      {
        opt[1].init(195, 390, 85, 20, "Up");
        opt[2].init(285, 390, 85, 20, "Down");
      }
      mapnum = i;
      i = lscroll;
      while (i < lscroll + 22)
      {
        textout(back_buffer, font, n[i].c_str(), 200, 59 + (15 * (i - lscroll)), WHITE);
        i++;
      }
    }
    drawfirst = 0;
  }
  blit((BITMAP *)glb[11].dat, back_buffer, 0, 0, 0, 0, 640, 480);
  text_mode(-1);
  textout_centre(back_buffer, (FONT *)glb[2].dat, "SELECT THE BATTLEGROUND", 320, 410, BLACK);
  text_mode(0);
  rect(back_buffer, 195, 55, 370, 385, LGREY);
  rectfill(back_buffer, 196, 56, 369, 384, BLACK);
  i = lscroll;
  while (i < lscroll + 22)
  {
    textout(back_buffer, font, n[i].c_str(), 200, 57 + (15 * (i - lscroll)), WHITE);
    i++;
  }
  opt[0].check(back_buffer);
  if (mapnum > 22)
  {
    opt[1].check(back_buffer);
    opt[2].check(back_buffer);
    if (opt[1].clicked())
    {
      if (lscroll > 0)
      {
        lscroll--;
        drawfirst = 1;
      }
    }
    if (opt[2].clicked())
    {
      if (lscroll + 22 < mapnum)
      {
        lscroll++;
        drawfirst = 1;
      }
    }
  }
  if (opt[0].clicked())
  {
    drawfirst = 1;
    highlighted = -1;
    lscroll = 0;
    return FIRST;
  }
  mx = mouse_x;
  my = mouse_y;
  if ((mx > 200) && (mx < 370))
  {
    if ((my > 55) && (my < 385))
    {
      sel = (my - 55) / 15 + lscroll;
      if (n[sel].c_str() != "")
      {
        sprintf(p, "maps/");
        strcat(p, n[sel].c_str());
        strcat(p, ".map");
        ifstream m(p);
        ok = 1;
        if (m.bad())
        {
          ok = 0;
          m.close();
        }
        if (ok == 1)
        {
          m >> a >> b >> c;
          m.close();
          rectfill(back_buffer, 391, 146, 614, 384, BLACK);
          rect(back_buffer, 390, 145, 615, 385, VDGREY);
          textout(back_buffer, font, n[sel].c_str(), 400, 150, WHITE);
          textprintf(back_buffer, font, 400, 163, WHITE, "%-1d Players", c);
          draw_minimap(400, 178, p);
        }
      }
      if (mouse_b & 1)
      {
        sprintf(p, "maps/");
        strcat(p, n[sel].c_str());
        strcat(p, ".map");
        ok = 1;
        ifstream m(p);
        if (m.bad())
        {
          ok = 0;
        }
        if (ok == 1)
        {
          map.reset();
          map.set_name(n[sel]);
          m >> map.l >> map.h >> numplayers;
          i = 0;
          while (i < numplayers)
          {  //initialize all players participating in this game
            player[i].playing = 1;
            player[i].cash = 0;
            player[i].power = 0;
            i++;
          }
          while (i < 4)
          {  //make sure the other players aren't in the game
            player[i].playing = 0;
            i++;
          }
          i = 0;
          while (i < map.h)
          {
            j = 0;
            while (j < map.l)
            {
              m >> temp;
              map.tile[j][i].change_type(temp / 100, temp % 100);
              j++;
            }
            i++;
          }
          player[0].clear_units();  //get rid of any previous unit settings
          player[1].clear_units();
          player[2].clear_units();
          player[3].clear_units();
          player[0].powered = 0;
          player[1].powered = 0;
          player[2].powered = 0;
          player[3].powered = 0;
          i = 0;
          while (i < 50 * numplayers)  //loading any placed units
          {
            m >> a;
            if (a != -1)  //if there is a saved unit for this i
            {
              m >> b >> c >> d;
              j = player[d].create_unit(c, a, b, d);
            }
            else  //if a reads -1, there are no more saved units
            {
              i = 50 * numplayers;
            }
            i++;
          }
          m >> aiprofile;
          name = map.get_name();
          load_custom_ai(name);
          lscroll = 0;
          drawfirst = 1;
          highlighted = -1;
          get_connected_beaches();
          minimap.create();
          return OPTIONS;
        }
      }
    }
  }
  if (delay > 0)
  {
    delay--;
  }
  draw_mouse();
  return LOAD;
}

int ingame_options()
{
  static bool first = true;
  char c[10];
  if (first)
  {
    gameoptions.reset();
    back.init(0, 450, 95, 30, "Back");
    ok.init(545, 450, 95, 30, "OK");
    sprintf(c, "%-1d", gameoptions.funding);
    opt[0].init(113, 165, 80, 20, c);
    opt[1].init(250, 200, 80, 20, "Yes");
    opt[2].init(387, 235, 80, 20, "None");
    first = false;
  }
  blit((BITMAP *)glb[20].dat, back_buffer, 0, 0, 0, 0, 640, 480);
  text_mode(-1);
  textout_centre(back_buffer, (FONT *)glb[2].dat, "Game Settings", 320, 20, BLACK);
  textout(back_buffer, font, "Funds per Building", 100, 150, WHITE);
  textout(back_buffer, font, "Show Attacking Damage", 220, 185, WHITE);
  textout(back_buffer, font, "Turn Time Limit", 380, 220, WHITE);
  text_mode(0);
  opt[0].check(back_buffer);
  opt[1].check(back_buffer);
  opt[2].check(back_buffer);
  back.check(back_buffer);
  ok.check(back_buffer);
  if (opt[0].clicked())
  {
    gameoptions.funding += 1000;
    if (gameoptions.funding > 10000)
    {
      gameoptions.funding = 1000;
    }
    sprintf(c, "%-1d", gameoptions.funding);
    opt[0].init(113, 165, 80, 20, c);
  }
  if (opt[1].clicked())
  {
    if (gameoptions.show_damage)
    {
      gameoptions.show_damage = false;
      opt[1].init(250, 200, 80, 20, "No");
    }
    else
    {
      gameoptions.show_damage = true;
      opt[1].init(250, 200, 80, 20, "Yes");
    }
  }
  if (opt[2].clicked())
  {
    if (gameoptions.time == -999)
    {
      gameoptions.time = 1000;
    }
    else
    {
      gameoptions.time += 1000;
      if (gameoptions.time > 15000)
      {
        gameoptions.time = -999;
      }
    }
    if (gameoptions.time == -999)
    {
      opt[2].init(387, 235, 80, 20, "None");
    }
    else
    {
      sprintf(c, "%-1d seconds", gameoptions.time / 50);
      opt[2].init(387, 235, 80, 20, c);
    }
  }
  if (back.clicked())
  {
    first = true;
    return OPTIONS;
  }
  if (ok.clicked())
  {
    first = true;
    return LOGIC;
  }
  draw_mouse();
  return INGAME_OPTIONS;
}

int do_options()
{
  static int pselect = 0;
  static int drawfirst = 1;
  static int delay = 0;
  int selected = 0;
  int over[10];
  int i = 0;
  int j = 0;
  if (drawfirst == 1)
  {
    back.init(0, 460, 80, 20, "Back");
    i = 0;
    while (i < 4)
    {
      player[i].number = -1;
      player[i].playing = 1;
      player[i].team = i + 1;
      i++;
    }
    while (j < 2)
    {
      i = 0;
      while (i < 4)
      {
        plyr[i + (4 * j)].init(110 + (85 * i), 315 + (85 * j), 80, 80, "", character[i + (4 * j)].picture);
        over[i + (4 * j)] = 0;
        i++;
      }
      j++;
    }
    i = 0;
    while (i < numplayers)
    {
      opt[i].init(400, 40 + (40 * i), 80, 20, "Human");
      opt[i + 4].init(520, 30 + (40 * i), 40, 40, "", (BITMAP *)glb[14 + player[i].team].dat);
      i++;
    }
    delay = 120;  //to keep a player from being accidentally clicked
    drawfirst = 0;
  }
  textout(back_buffer, font, "Controller", 400, 20, WHITE);
  textout(back_buffer, font, "Team", 525, 20, WHITE);
  list_players(numplayers, pselect);  
  back.check(back_buffer);
  i = 0;
  while (i < numplayers)
  {
    if (player[i].playing == 1)
    {
      opt[i].check(back_buffer);
      opt[i + 4].check(back_buffer);
      if (opt[i].clicked())
      {
        if (opt[i].text == "Human")
        {
          opt[i].init(400, 40 + (40 * i), 80, 20, "AI");
        }
        else if (opt[i].text == "AI")
        {
          opt[i].init(400, 40 + (40 * i), 80, 20, "Human");
        }
      }
      if (opt[i + 4].clicked())
      {
        player[i].team++;
        if (player[i].team > 4)
        {
          player[i].team = 1;
        }
        opt[i + 4].init(520, 30 + (40 * i), 40, 40, "", (BITMAP *)glb[14 + player[i].team].dat);
      }
    }
    i++;
  }
  if (back.clicked())
  {
    pselect = 0;
    drawfirst = 1;
    return LOAD;
  }
  if (pselect >= numplayers)
  {
    i = 0;
    while (i < 8)
    {
      plyr[i].draw(back_buffer);
      i++;
    }
    ok.check(back_buffer);
    if (ok.clicked())
    {
      pselect = 0;
      drawfirst = 1;
      i = 0;
      while (i < 4)  //set whether players 3 and four are actually in the game
      {
        if (i < numplayers)
        {
          player[i].playing = 1;
          if (opt[i].text == "Human")
          {
            player[i].controller = HUMAN;
          }
          else
          {
            player[i].controller = AI;
          }
        }
        else
        {
          player[i].playing = 0;
        }
        i++;
      }
      pturn = 0;  //make player 1 start first
      loaded_game = 0;  //the game was not loaded from a saved file
      very_first_turn = 1;
      map.scroll_x = 0;
      map.scroll_y = 0;
      return INGAME_OPTIONS;
    }
    description(-2);
  }
  else
  {
    selected = 0;
    i = 0;
    while (i < 8)
    {
      plyr[i].draw(back_buffer);
      if (plyr[i].mouseover())
      {
        description(i);
        selected = 1;
      }
      if (delay <= 0)
      {
        if (plyr[i].clicked())
        {
          player[pselect].number = i;
          pselect++;
          if (pselect >= numplayers)
          {
            ok.init(545, 450, 95, 30, "OK");
          }
        }
      }
      else
      {
        delay--;
      }
      i++;
    }
  }
  draw_mouse();
  return OPTIONS;
}

void description(int c)
{
  string n, m, s, w, p, d;
  if ((c > -1) && (c < 8))
  {
    n = character[c].name;
    m = character[c].description;
    s = "Strength: ";
    switch(character[c].strength)
    {
      case 0:
        s += "Direct Attacks";
        break;
      case 1:
        s += "Ranged Attacks";
        break;
      case 2:
        s += "Land Units";
        break;
      case 3:
        s += "Air Units";
        break;
      case 4:
        s += "Sea Units";
        break;
      case 5:
        s += "None";
        break;
    }
    w = "Weakness: ";
    switch(character[c].weakness)
    {
      case 0:
        w += "Direct Attacks";
        break;
      case 1:
        w += "Ranged Attacks";
        break;
      case 2:
        w += "Land Units";
        break;
      case 3:
        w += "Air Units";
        break;
      case 4:
        w += "Sea Units";
        break;
      case 5:
        w += "None";
        break;
    }
    p = "Power: ";
    p += character[c].powername;
    d = "";
    switch(character[c].power)
    {
      case 0:
        d += "(Units gain 2 health)";
        break;
      case 1:
        d += "(More powerful direct attacks)";
        break;
      case 2:
        d += "(More powerful ranged attacks)";
        break;
      case 3:
        d += "(Deals 1 damage to each enemy unit)";
        break;
      case 4:
        d += "(Refreshes non-infantry units, but all units are weaker)";
        break;
      case 5:
        d += "(Kills 1/5 random enemy units)";
        break;
      case 6:
        d += "(Attacking ranged units have a 75% chance of firing twice)";
        break;
    }
  }
  else
  {
    n = "";
    m = "";
    p = "";
  }
  textout_centre(back_buffer, font, n.c_str(), 320, 242, WHITE);
  textout_centre(back_buffer, font, m.c_str(), 320, 252, WHITE);
  textout_centre(back_buffer, font, s.c_str(), 320, 272, GREEN);
  textout_centre(back_buffer, font, w.c_str(), 320, 282, RED);
  textout_centre(back_buffer, font, p.c_str(), 320, 292, WHITE);
  textout_centre(back_buffer, font, d.c_str(), 320, 302, LGREY);
}

void list_players(int numplayers, int selected)
{
  int i = 0;
  char m[15];
  while (i < numplayers)
  {
    text_mode(-1);
    sprintf(m, "Player %-1d", i + 1);
    rectfill(back_buffer, 7, 42 + (40 * i), 103, 58 + (40 * i), BLACK);
    rect(back_buffer, 5, 40 + (40 * i), 105, 60 + (40 * i), DGREY);
    rectfill(back_buffer, 7, 42 + (40 * i), 103, 58 + (40 * i), GREY);
    if (i == selected)
    {
      textout_centre(back_buffer, font, m, 55, 46 + (40 * i), RED);
    }
    else
    {
      textout_centre(back_buffer, font, m, 55, 46 + (40 * i), BLACK);
    }
    text_mode(0);
    if ((player[i].number > -1) && (player[i].number < 8))
    {
      textout(back_buffer, font, character[player[i].number].name.c_str(), 115, 47 + (40 * i), WHITE);
    }
    i++;
  }
}

int do_gameoptions()
{
  static int first = 1;
  static int previous_maporder;
  static _button back;
  static _button sync;
  static _button speed[2];
  static _button vol[2];
  static _button arrange;
  static _button screenmode;
  static _button screendepth;
  static _button trans;
  static _button part;
  static _button testsound;
  char c[10];
  if (first == 1)
  {
    previous_maporder = maporder;
    back.init(560, 460, 80, 20, "Back");
    if (dovsync == 0)
    {
      sync.init(270, 250, 100, 20, "Vsync: OFF");
    }
    else
    {
      sync.init(270, 250, 100, 20, "Vsync: ON");
    }
    sprintf(c, "Depth: ");
    switch(defaultgfx)
    {
      case 0:
        strcat(c, "16");
        break;
      case 1:
        strcat(c, "15");
        break;
      case 2:
        strcat(c, "32");
        break;
      case 3:
        strcat(c, "24");
        break;
    }
    screendepth.init(325, 310, 100, 20, c);
    if (fullscreen == 1)
    {
      screenmode.init(215, 310, 100, 20, "Fullscreen");
    }
    else
    {
      screenmode.init(215, 310, 100, 20, "Windowed");
    }
    vol[0].init(260, 40, 30, 20, "<");
    vol[1].init(350, 40, 30, 20, ">");
    testsound.init(270, 65, 100, 20, "Test");
    if (translucency == 1)
    {
      trans.init(260, 220, 120, 20, "Translucency: ON");
    }
    else
    {
      trans.init(260, 220, 120, 20, "Translucency: OFF");
    }
    if (particles == 1)
    {
      part.init(270, 190, 100, 20, "Particles: ON");
    }
    else
    {
      part.init(270, 190, 100, 20, "Particles: OFF");
    }
    switch(maporder)
    {
      case 0:
        sprintf(c, "Name");
        break;
      case 1:
        sprintf(c, "Number of Players");
        break;
      case 2:
        sprintf(c, "Map Size");
        break;
    }
    arrange.init(250, 130, 140, 20, c);
    speed[0].init(270, 370, 30, 20, "<");
    speed[1].init(340, 370, 30, 20, ">");
    first = 0;
  }
  blit((BITMAP*)glb[8].dat, back_buffer, 0, 0, 0, 0, 640, 480);
  text_mode(-1);
  textout_centre(back_buffer, font, "Arrange Maps by:", 320, 110, WHITE);
  textout_centre(back_buffer, font, "Stuff That Doesn't Really Affect Gameplay But Makes Things Look Nicer", 320, 175, WHITE);
  textout_centre(back_buffer, font, "Sound Volume", 320, 25, WHITE);
  textprintf_centre(back_buffer, font, 320, 45, WHITE, "%-1d", volume);
  textout_centre(back_buffer, font, "Mouse Speed (Higher value means slower mouse)", 320, 355, WHITE);
  textprintf_centre(back_buffer, font, 320, 375, WHITE, "%-1d", mspeed);
  textout_centre(back_buffer, font, "Screen mode change takes effect after the game is restarted", 320, 295, LGREY);
  text_mode(0);
  back.check(back_buffer);
  sync.check(back_buffer);
  vol[0].check(back_buffer);
  vol[1].check(back_buffer);
  testsound.check(back_buffer);
  speed[0].check(back_buffer);
  speed[1].check(back_buffer);
  screenmode.check(back_buffer);
  screendepth.check(back_buffer);
  trans.check(back_buffer);
  part.check(back_buffer);
  arrange.check(back_buffer);
  if (arrange.clicked())
  {
    maporder++;
    if (maporder >= 3) maporder = 0;
    switch(maporder)
    {
      case 0:
        sprintf(c, "Name");
        break;
      case 1:
        sprintf(c, "Number of Players");
        break;
      case 2:
        sprintf(c, "Map Size");
        break;
    }
    arrange.init(250, 130, 140, 20, c);
  }
  if (sync.clicked())
  {
    if (dovsync == 0)
    {
      dovsync = 1;
      sync.init(270, 250, 100, 20, "Vsync: ON");
    }
    else
    {
      dovsync = 0;
      sync.init(270, 250, 100, 20, "Vsync: OFF");
    }
  }
  if (screendepth.clicked())
  {
    defaultgfx++;
    if (defaultgfx > 2) defaultgfx = 0;
    sprintf(c, "Depth: ");
    switch(defaultgfx)
    {
      case 0:
        strcat(c, "16");
        break;
      case 1:
        strcat(c, "15");
        break;
      case 2:
        strcat(c, "32");
        break;
    }
    screendepth.init(325, 310, 100, 20, c);
  }
  if (trans.clicked())
  {
    if (translucency == 1)
    {
      translucency = 0;
      trans.init(260, 220, 120, 20, "Translucency: OFF");
    }
    else
    {
      translucency = 1;
      trans.init(260, 220, 120, 20, "Translucency: ON");
    }
  }
  if (part.clicked())
  {
    if (particles == 1)
    {
      particles = 0;
      part.init(270, 190, 100, 20, "Particles: OFF");
    }
    else
    {
      particles = 1;
      part.init(270, 190, 100, 20, "Particles: ON");
    }
  }   
  if (screenmode.clicked())
  {
    if (fullscreen == 1)
    {
      fullscreen = 0;
      screenmode.init(215, 310, 100, 20, "Windowed");
    }
    else
    {
      fullscreen = 1;
      screenmode.init(215, 310, 100, 20, "Fullscreen");
    }
  }   
  if (testsound.clicked())
  {
    play_sound(rand()%11);
  }
  if (vol[0].mousedown())
  {
    if (volume > 0) volume--;
    set_volume(volume, volume);
  }
  if (vol[1].mousedown())
  {
    if (volume < 255) volume++;
    set_volume(volume, volume);
  }
  if (speed[0].clicked())
  {
    if (mspeed > 1) mspeed--;
    set_mouse_speed(mspeed, mspeed);
  }
  if (speed[1].clicked())
  {
    if (mspeed < 9) mspeed++;
    set_mouse_speed(mspeed, mspeed);
  }
  if (back.clicked())
  {
    if (maporder != previous_maporder)
    {
      arrange_mapnames();
    }
    first = 1;
    return FIRST;
  }
  draw_mouse();
  return GAME_OPTIONS;
}

int do_gameload()
{
  int i, o, p, num, safety;
  int type, tilex, tiley, ammo, gas, ready, capturing, submerged, unum;
  float health;
  int thechoice = -1;
  int temp;
  char text[10];
  char d[30];
  char t[35];
  string mname;
  static int first = 1;
  static _button choice[10];
  static _button delsave[9];
  char path[10];
  if (first == 1)
  {
    o = 0;
    while (o < 9)
    {
      sprintf(path, "game%-1d.sav", o);
      ifstream n(path);
      if (n.bad())
      {
        choice[o].init(210, 80 + (o * 35), 140, 20, "Empty");
      }
      else
      {
        n >> text;
        choice[o].init(210, 80 + (o * 35), 140, 20, text);
      }
      delsave[o].init(375, 82 + (o * 35), 80, 16, "Delete");
      o++;
    }
    choice[9].init(250, 455, 140, 20, "Back");
    gameoptions.reset();
    first = 0;
  }
  blit((BITMAP *)glb[9].dat, back_buffer, 0, 0, 0, 0, 640, 480);
  blit((BITMAP *)glb[10].dat, back_buffer, 0, 0, 0, 0, 302, 49);
  i = 0;
  while (i < 10)
  {
    choice[i].check(back_buffer);
    if (choice[i].clicked())
    {
      thechoice = i;
    }
    if (i < 9)
    {
      delsave[i].check(back_buffer);
      if (delsave[i].clicked())
      {  //if the delete option was chosen for this save file
        sprintf(path, "game%-1d.sav", i);
        delete_file(path);
        choice[i].init(210, 80 + (i * 35), 140, 20, "Empty");
      }
    }
    i++;
  }
  if (((thechoice != -1) && (thechoice != 9)) || (key[KEY_Z]))  //Z = LAST DEBUG SAVE
  {
    if ((thechoice != -1) && (thechoice != 9))
    {
      sprintf(path, "game%-1d.sav", thechoice);
    }
    else
    {
      sprintf(path, "gamedebug.sav");
    }
    ifstream savefile(path);
    if (!(savefile.bad()))
    {
      map.reset();
      savefile >> d >> map.l >> map.h;
      o = 0;
      while (o < map.h)
      {
        p = 0;
        while (p < map.l)
        {
          savefile >> temp;
          map.tile[p][o].change_type(temp / 100, temp % 100);
          p++;
        }
        o++;
      }
      safety = 0;
      o = 0;
      while (o < 4)
      {
        player[o].clear_units();
        savefile >> d >> player[o].playing;
        if (player[o].playing == 1)
        {
          savefile >> d >> player[o].number;
          savefile >> d >> player[o].cash;
          savefile >> d >> player[o].power;
          savefile >> d >> player[o].controller;
          savefile >> d >> player[o].powered;
          savefile >> d >> unum;
          savefile >> d >> player[o].team;
          p = 0;
          while (p < unum)
          {
            savefile >> d >> type;
            savefile >> d >> tilex;
            savefile >> d >> tiley;
            savefile >> d >> health;
            savefile >> d >> ammo;
            savefile >> d >> gas;
            savefile >> d >> ready;
            savefile >> d >> capturing;
            savefile >> d >> submerged;
            num = player[o].create_unit(type, tilex, tiley, o);
            player[o].unit[num].health = health;
            player[o].unit[num].ammo = ammo;
            player[o].unit[num].gas = gas;
            player[o].unit[num].ready = ready;
            player[o].unit[num].capturing = capturing;
            player[o].unit[num].submerged = submerged;
            savefile >> d >> player[o].unit[num].load[0].loaded;
            savefile >> d >> player[o].unit[num].load[0].type;
            savefile >> d >> player[o].unit[num].load[0].health;
            savefile >> d >> player[o].unit[num].load[0].ammo;
            savefile >> d >> player[o].unit[num].load[0].gas;
            savefile >> d >> player[o].unit[num].load[0].subload.loaded;
            savefile >> d >> player[o].unit[num].load[0].subload.type;
            savefile >> d >> player[o].unit[num].load[0].subload.health;
            savefile >> d >> player[o].unit[num].load[0].subload.ammo;
            savefile >> d >> player[o].unit[num].load[0].subload.gas;
            savefile >> d >> player[o].unit[num].load[1].loaded;
            savefile >> d >> player[o].unit[num].load[1].type;
            savefile >> d >> player[o].unit[num].load[1].health;
            savefile >> d >> player[o].unit[num].load[1].ammo;
            savefile >> d >> player[o].unit[num].load[1].gas;
            savefile >> d >> player[o].unit[num].load[1].subload.loaded;
            savefile >> d >> player[o].unit[num].load[1].subload.type;
            savefile >> d >> player[o].unit[num].load[1].subload.health;
            savefile >> d >> player[o].unit[num].load[1].subload.ammo;
            savefile >> d >> player[o].unit[num].load[1].subload.gas;
            p++;
          }
        }
        o++;
      }
      savefile >> d >> pturn >> aiprofile >> gameoptions.funding >> gameoptions.show_damage >> gameoptions.time;
      getline(savefile, mname);  //this first one makes mname empty for some reason
      getline(savefile, mname);  //so I have to call it again to actually get the line
      map.set_name(mname);
      load_custom_ai(mname);
      loaded_game = 1;  //the game has been loaded from a file
      first = 1;
      get_connected_beaches();
      very_first_turn = 1;
      minimap.create();
      return LOGIC;
    }
  }
  else if (thechoice == 9)
  {
    first = 1;
    return FIRST;
  }
  draw_mouse();
  return GAME_LOAD;
}

void load_custom_ai(string mname)
{
  int i;
  char na[30];
  mname = "ai/" + mname;
  mname += ".txt";  //mname ends up being 'ai/<name of map>.txt'
  ifstream customai(mname.c_str());
  if (!(customai.bad()))
  {  //if a custom ai profile was found for this map
    aiprofile = CUSTOM;  //set aiprofile to use the custom profile
    i = 0;
    while (i < 18)  //then read in the custom ai profile from
    {               //the text file that was specified by mname
      customai >> na >> na >> build[CUSTOM][i].weight >> na >> build[CUSTOM][i].limit;
      i++;
    }
  }
}

void get_connected_beaches()
{
  int x, y, z;
  _loc d;
  beaches.clear();
  beaches.reserve(5);
  y = 0;
  while (y < map.h)
  {
    x = 0;
    while (x < map.l)
    {
      if (is_beach(x, y) == 1)
      {
        if (beach_already_listed(x, y) == 0)
        {
          d.x = x;
          d.y = y;
          beaches.push_back();
          beaches[beaches.size() - 1].loc.reserve(10);
          beaches[beaches.size() - 1].loc.push_back(d);
          add_surrounding_beaches(beaches.size() - 1, x, y);
        }
      }
      x++;
    }
    y++;
  }
}

void add_surrounding_beaches(int bnum, int x, int y)
{
  _loc d;
  if (x - 1 > -1)
  {
    if (is_beach(x - 1, y) == 1)
    {
      if (beach_already_listed(x - 1, y) == 0)
      {
        d.x = x - 1;
        d.y = y;
        beaches[bnum].loc.push_back(d);
        add_surrounding_beaches(bnum, x - 1, y);
      }
    }
  }
  if (x + 1 < map.l)
  {
    if (is_beach(x + 1, y) == 1)
    {
      if (beach_already_listed(x + 1, y) == 0)
      {
        d.x = x + 1;
        d.y = y;
        beaches[bnum].loc.push_back(d);
        add_surrounding_beaches(bnum, x + 1, y);
      }
    }
  }
  if (y - 1 > -1)
  {
    if (is_beach(x, y - 1) == 1)
    {
      if (beach_already_listed(x, y - 1) == 0)
      {
        d.x = x;
        d.y = y - 1;
        beaches[bnum].loc.push_back(d);
        add_surrounding_beaches(bnum, x, y - 1);
      }
    }
  }
  if (y + 1 < map.h)
  {
    if (is_beach(x, y + 1) == 1)
    {
      if (beach_already_listed(x, y + 1) == 0)
      {
        d.x = x;
        d.y = y + 1;
        beaches[bnum].loc.push_back(d);
        add_surrounding_beaches(bnum, x, y + 1);
      }
    }
  }  
}

int is_beach(int x, int y)
{
  int z;
  if (map.tile[x][y].get_set() == 3)
  {  //3 is the set for beaches (called shoals in mapedit)
    if (map.tile[x][y].get_number() < 25)  //shoal tiles 25-28 are actually sea transitions
    {
      return 1;
    }
  }
  if (map.tile[x][y].is_building(PORT))
  {
    return 1;
  }
  return 0;
}

int beach_already_listed(int x, int y)
{
  int i, j;
  _loc d;
  d.x = x;
  d.y = y;
  i = 0;
  while (i < beaches.size())
  {
    j = 0;
    while (j < beaches[i].loc.size())
    {
      if ((d.x == beaches[i].loc[j].x) && (d.y == beaches[i].loc[j].y))
      {
        return 1;
      }
      j++;
    }
    i++;
  }
  return 0;
}
