#include "empire.h"
#include "ranges.h"
#include "empai_path.h"

typedef struct _unitexplosion
{
  int tx;
  int ty;
  float frame;
  int exists;
} _unitexplosion;

vector<_unitexplosion> boom;
vector<_particle> p_effects;

extern void draw_tiles(int scrollx, int scrolly, int editing, int x1, int y1, int w, int h, int keep_units);
extern void draw_tiles(int scrollx, int scrolly, int editing, int keep_units);
extern void text_box(int x, int y, int w, int h, char *ret, int leng, int spaces);
extern int do_battle(_unit *a, _unit *d);
extern int HQ_exists(int playernum);
extern int base_exists(int playernum);
extern int do_ai(int plyr);
extern int any_unit_here(int tx, int ty);
extern float total_damage(_unit *a, _unit *d);

extern string unit_name(int type);
extern int unit_type(string name);

extern BITMAP *small_white;
extern BITMAP *small_yellow;
extern BITMAP *statbuf;
extern BITMAP *unitstatbuf;

int pturn;

const int NOTHING_HAPPENING  =0;
const int AI_TURN            =1;
const int IN_BATTLE          =2;
const int UNIT_SELECTED      =3;
const int UNIT_MOVING        =4;
const int SAVING_GAME        =5;
const int IN_GENERAL_MENU    =6;
const int IN_ACTION_MENU     =7;
const int IN_UNIT_BUILD_MENU =8;
const int UNIT_ATTACKING     =9;
const int UNIT_UNLOADING     =10;
const int POWER_ANIMATION    =11;
const int AI_POWER_ANIMATION =12;
const int ONE_TEAM_LEFT      =13;
const int BACK_TO_MAIN_MENU  =14;
const int WINNER             =15;
const int FADE_EXIT          =16;
const int TIME_UP_INDICATOR  =17;
const int AI_MENU            =18;

int very_first_turn;

vector<int> movelist;

void check_minimap(int &m);
void set_moves(int plyr, int unitnum, int tx, int ty);
void clear_moveselect();
void draw_path(_unit *u);
void supply_units(_unit *u);
void draw_unitstats(_unit *u);
void draw_playerstats(int plyr);
void transform_buildings(int plyr, int plyr2);
void repair_units(int plyr);
void scroll_to_hq(int plyr);
void scroll_to_location(int x, int y);
void play_moving_sound(int utype);
void decrease_gas(int plyr);
void init_explode(int x, int y);
void do_explodes();
void do_particles();
void do_power();
void capture_building(_unit* u);
void merge_units(_unit *merger, int tx, int ty);
void check_scrolling();
void check_scrolling(int forcex, int forcey);
void debug_savegame();
void time_up();
void ai_menu();
void describe_unit(int type);
bool player_defeated(int plyr);
bool move_overlap(_unit *u);
bool can_merge(_unit *a, _unit *b);
bool type_can_attack(_unit *a, _unit *d);
bool unit_unloadable_here(int ox, int oy, int tx, int ty, int type);
int attackable_unit_here(_unit *attacker, int tx, int ty);
int attackable_unit_here(_unit *attacker, int tx, int ty, bool ignore_teams);
int unit_here_thorough(int plyr, int tx, int ty, int ignore_n);
int moves_needed(int mtype, int tx, int ty);
int get_ltype(int tx, int ty);
int do_moveselect(int plyr, int u, int tx, int ty);
int list_distance(_unit *u);
int do_unitmenu(int menutype, int tx, int ty, int pturn);
int buildings_owned(int plyr);
int do_unloadmenu(_unit *u);
int rounded_health(float h);
int unit_exists(int plyr);
int do_savemenu();
int do_powerflash(int cnum);
int do_cancelattack_menu();
int do_cancelunload_menu();
int secure_base(int plyr);
string do_generalmenu();
string do_actionmenu(_unit *u);

typedef struct logic_variables
{
  logic_variables()
  {
    first = true;
  }
  bool first;
  bool cancel_attack;
  bool cancel_unload;
  int unitselected;
  int oldux, olduy;
  int attacker, defender;
  int unitx, unity;
  int movedthisturn;
  int unitmenu;
  int oldmx, oldmy, oldcapstatus, unloadstatus;
  int unloadnum;
  int windelay;
  int logicstate;
  int unitmoving;
  int time;
} logic_variables;

logic_variables var;

void init_logic();
void battle();
void windelay();
void powerflash();
void save_game();
void ai();
void ai_powerflash();
void nothing_happening();
void unit_moving();
void unit_selected();
void action_menu();
void unit_attacking();
void unit_unloading();
void build_menu();
void general_menu();

void show_movable_tiles(_unit *u);
void draw_attackables(vector<_loc> locations);
void show_unload_locations(vector<_loc> locations);
vector<_loc> find_attackables(_unit *u);
vector<_loc> find_unload_locations(_unit *u, int type);

int logic()
{
  static int t;
  int temp1, temp2;
  char c[20];
  if (very_first_turn == 1)
  {
    var.logicstate = NOTHING_HAPPENING;
    var.first = true;
    very_first_turn = 0;
  }
  if (var.first == true)
  {  //if it's a new turn
    init_logic();
    debug_savegame();  //save the game to debug later if the game crashes
    var.first = false;
  }
  temp1 = 0;
  while (temp1 < 4)
  {  //check each player to see if they are not beaten
    if (player[temp1].playing == 1)
    {
      if (player[temp1].defeated(temp1))
      {  //if they are defeated, but still on the map
        player[temp1].playing = 0;
        transform_buildings(temp1, -1);
        if (temp1 == pturn)
        {  //if the player was defeated on his own turn
          pturn++;  //it is the next person's turn
          while (player[pturn].playing != 1)
          {
            pturn++;
            if (pturn >= 4) pturn = 0;
          }
        }
      }
    }
    temp1++;
  }
  if ((var.logicstate != ONE_TEAM_LEFT) && (var.logicstate != WINNER))
  {
    temp1 = 0;
    temp2 = -1;
    while (temp1 < 4)
    {  //this loop sees if there's more than one team left in the game
      if (player[temp1].playing == 1)
      {
        if (temp2 > -1)
        {
          if (player[temp1].team != temp2)
          {
            temp2 = -2;  //found a different team
          }
        }
        else
        {  //the team of the first player in the game
          if (temp2 == -1)
          {
            temp2 = player[temp1].team;
          }
        }
      }
      temp1++;
    }
    if (temp2 != -2)
    {
      var.logicstate = ONE_TEAM_LEFT;
      var.windelay = 20;
    }
  }
  map.draw_tiles();
  if (gameoptions.time != -999)
  {  //if there is a time limit
    if ((var.logicstate != TIME_UP_INDICATOR) && (var.logicstate != AI_TURN) && (var.logicstate != AI_POWER_ANIMATION))
    {
      text_mode(-1);
      sprintf(c, "Time Left: %-1ds", var.time / 50);
      if (translucency == 1)
      {
        fblend_rect_trans(back_buffer, 318 - text_length(font, c) / 2, 0, text_length(font, c) + 4, 12, DGREY, 190);
      }
      else
      {
        rectfill(back_buffer, 318 - text_length(font, c) / 2, 0, 322 + text_length(font, c) / 2, 12, DGREY);
      }
      textout_centre(back_buffer, font, c, 320, 0, WHITE);
      text_mode(0);
      if (var.time < 1)
      {
        pturn++;
        while (player[pturn].playing != 1)
        {
          pturn++;
          if (pturn >= 4) pturn = 0;
        }
        var.logicstate = TIME_UP_INDICATOR;
      }
    }
  }
  do_particles();
  switch(var.logicstate)
  {
    case AI_TURN:
      ai();
      if (mouse_rclicked() == 1)
      {
        var.logicstate = AI_MENU;
      }
      break;
    case AI_POWER_ANIMATION:
      ai_powerflash();
      break;
    case NOTHING_HAPPENING:
      var.time--;
      do_explodes();
      nothing_happening();
      draw_mouse();
      break;
    case IN_BATTLE:
      battle();
      break;
    case UNIT_SELECTED:
      var.time--;
      unit_selected();
      draw_mouse();
      break;
    case UNIT_MOVING:
      unit_moving();
      draw_mouse();
      break;
    case UNIT_ATTACKING:
      var.time--;
      unit_attacking();
      draw_mouse();
      break;
    case UNIT_UNLOADING:
      var.time--;
      unit_unloading();
      draw_mouse();
      break;
    case SAVING_GAME:
      save_game();
      draw_mouse();
      break;
    case AI_MENU:
      ai_menu();
      draw_mouse();
      break;
    case IN_GENERAL_MENU:
      general_menu();
      draw_mouse();
      break;
    case IN_ACTION_MENU:
      action_menu();
      draw_mouse();
      break;
    case IN_UNIT_BUILD_MENU:
      var.time--;
      build_menu();
      draw_mouse();
      break;
    case POWER_ANIMATION:
      powerflash();
      break;
    case ONE_TEAM_LEFT:
      do_particles();
      do_explodes();
      windelay();
      break;
    case WINNER:
      var.first = 1;
      return GAMEOVER;
    case BACK_TO_MAIN_MENU:
      t = 0;
      var.logicstate = FADE_EXIT;
      break;
    case FADE_EXIT:
      if ((t < 24) && (translucency == 1))
      {
        fblend_rect_trans(back_buffer, 0, 0, 640, 480, BLACK, t * 10);
        t++;
      }
      else
      {
        clear(back_buffer);
        player[0].clear_units();
        player[1].clear_units();
        player[2].clear_units();
        player[3].clear_units();
        var.first = 1;
        return MENU;
      }
      break;
    case TIME_UP_INDICATOR:
      time_up();
      break;
  }
  return LOGIC;
}

void time_up()
{
  static bool first = true;
  static int t;
  if (first)
  {
    t = 50;
    first = false;
    play_sound(TANKFIRE);
  }
  text_mode(-1);
  textout_centre(back_buffer, (FONT *)glb[2].dat, "TIME UP", 320, 200, BLACK);
  text_mode(0);
  t--;
  if (t < 0)
  {
    var.first = true;
    var.logicstate = NOTHING_HAPPENING;
    first = true;
  }
}

void ai_menu()
{
  static bool first = true;
  static _button items[2];
  if (first)
  {
    items[0].init(501, 1, 137, 29, "Quit to Menu");
    items[1].init(501, 61, 137, 29, "Cancel");
    position_mouse(570, 45);
    set_mouse_range(500, 0, 639, 91);
    first = false;
  }
  rect(back_buffer, 500, 0, 639, 91, ORANGE);
  rectfill(back_buffer, 501, 1, 638, 90, LGREY);
  items[0].check(back_buffer);
  items[1].check(back_buffer);
  if (items[0].clicked())
  {
    first = true;
    var.logicstate = BACK_TO_MAIN_MENU;
    set_mouse_range(0, 0, 639, 479);
  }
  if (items[1].clicked())
  {
    first = true;
    var.logicstate = AI_TURN;
    set_mouse_range(0, 0, 639, 479);
  }
}
    

void init_logic()
{
  int z;
  var.unloadstatus = 0;
  var.unloadnum = 0;
  var.cancel_attack = 0;
  var.cancel_unload = 0;
  var.movedthisturn = 0;
  player[pturn].powered = 0;  //if the player was powered last turn, dispel it now
  if (!((player[pturn].controller == AI) && (player[pturn].units_in_play() > 0)))
  {  //if the player is human or an AI with no units, scroll to the HQ
    scroll_to_hq(pturn);
    map.draw_tiles();
  }
  check_scrolling(map.scroll_x, map.scroll_y);  //if I don't do this, the static floats
  var.first = false;                            //in check_scrolling aren't the right
  z = 0;                                        //ones and bad things happen
  while (z < 4)
  {
    if (player[z].playing == 1)
    {
      if (loaded_game == 0)  //if the game has just been loaded from a
      {                      //file, the units should not be refreshed
        player[z].ready_units();
      }
    }
    z++;
  }
  if (gameoptions.time != -999)
  {
    var.time = gameoptions.time;
  }
  boom.resize(0);  //remove all explosions from existence
  p_effects.resize(0);  //same for particles
  if (loaded_game == 0)  //likewise, the player does not receive more cash
  {                      //and units are not repaired when the game is loaded
    player[pturn].cash += buildings_owned(pturn) * gameoptions.funding;
    if (player[pturn].cash > 1000000) player[pturn].cash = 1000000;
    repair_units(pturn);
    decrease_gas(pturn);
  }
  if (loaded_game == 1)  //next turn, it won't matter whether the game
  {                      //was originally loaded from a file or not
    loaded_game = 0;
  }
  position_mouse(320, 240);
}

void battle()
{
  int pa = var.attacker / 100;
  int ua = var.attacker % 100;
  int pd = var.defender / 100;
  int ud = var.defender % 100;
  int battle = do_battle(&player[pa].unit[ua], &player[pd].unit[ud]);
  if (battle == 0)  //if the battle just ended
  {
    var.logicstate = NOTHING_HAPPENING;
  }
}
  
void windelay()
{
  if (var.windelay <= 0)
  {
    var.logicstate = WINNER;
  }
  else
  {
    var.windelay--;
  }
}

void powerflash()
{
  if (do_powerflash(player[pturn].number) == -1)
  {  //if the animation has just ended
    var.logicstate = NOTHING_HAPPENING;
  }
}

void ai_powerflash()
{
  if (do_powerflash(player[pturn].number) == -1)
  {
    var.logicstate = AI_TURN;
  }
}

void save_game()
{
  if (do_savemenu() == 0)
  {  //if the savemenu has just closed
    var.logicstate = NOTHING_HAPPENING;
  }
}

void ai()
{
  int temp1 = do_ai(pturn);
  int ai_power = temp1 / 10;  //if the AI uses its power, it indicates that in temp1's tens column
  if (ai_power == 1)
  {
    var.logicstate = AI_POWER_ANIMATION;
  }
  temp1 %= 10;  //ignore the powerflash information and just get a 1 or 0
  if (temp1 == 1)  //if do_ai() has indicated that it is finished
  {
    var.logicstate = NOTHING_HAPPENING;
    pturn++;  //switch to the next player
    while (player[pturn].playing != 1)
    {
      pturn++;
      if (pturn >= 4) pturn = 0;
    }
    var.first = 1;
  }
}

void nothing_happening()
{
  int t, tx, ty, mx, my;
  _unit *u;
  draw_playerstats(pturn);
  mx = mouse_x;
  my = mouse_y;
  check_scrolling();
  if (mx >= map.offset_x)
  {
    tx = map.scroll_x + (mx - map.offset_x) / 40;
  }
  else
  {
    tx = map.scroll_x - 1 + (mx - map.offset_x) / 40;
  }
  if (my >= map.offset_y)
  {
    ty = map.scroll_y + (my - map.offset_y) / 40;
  }
  else
  {
    ty = map.scroll_y - 1 + (my - map.offset_y) / 40;
  }
  t = map.tile[tx][ty].unit_here();
  if (player[pturn].controller == AI)
  {  //if the AI turn just started, set the logicstate accordingly
    var.logicstate = AI_TURN;
    return;
  }
  if (t != -1)
  {
    draw_unitstats(&player[t / 100].unit[t % 100]);
  }
  if (key[KEY_SPACE])
  {
    minimap.draw(false);
  }
  else if ((key[KEY_LSHIFT]) || (key[KEY_RSHIFT]))
  {  //draws a ranged-attack unit's range
    if (t != -1)
    {
      if (player[t / 100].unit[t % 100].attacktype == RANGED)
      {
        draw_attackrange(&player[t / 100].unit[t % 100]);
      }
    }
  }
  else if (mouse_clicked() == 1)
  {
    if ((t != -1) && (t / 100 == pturn))
    {  //if one of the player's units is here
      u = &player[pturn].unit[t % 100];
      if (u->ready == 1)
      {  //if a unit is here and ready, select it
        var.unitselected = t % 100;
        var.oldux = u->tilex;
        var.olduy = u->tiley;
        var.oldcapstatus = u->capturing;
        var.unloadstatus = 0;
        var.movedthisturn = 0;
        map.create_limited_pathmap(pturn, u->movetype, u->tilex, u->tiley, u->move + 1);
        var.logicstate = UNIT_SELECTED;
      }
    }
    else if (t == -1)
    {  //if there is no unit here, check for a building that can make units
      if (map.tile[tx][ty].is_unit_producing())
      {
        if (map.tile[tx][ty].owned_by(pturn))
        {
          var.unitmenu = map.tile[tx][ty].building_type();
          var.logicstate = IN_UNIT_BUILD_MENU;
          var.unitx = tx;
          var.unity = ty;
          var.oldmx = mx;
          var.oldmy = my;
        }
      }
    }
  }
  else if (mouse_rclicked() == 1)
  {  //if the mouse is right-clicked, bring up the general menu
    var.oldmx = mx;  //save the mouse location to be put back after the menu closes
    var.oldmy = my;
    var.logicstate = IN_GENERAL_MENU;
  }
}

void build_menu()
{
  int t = do_unitmenu(var.unitmenu, var.unitx, var.unity, pturn);
  if (t == 1)  //do_unitmenu should return 1 when a unit has been
  {            //created or if the player cancels the unitmenu
    var.logicstate = NOTHING_HAPPENING;
  }
}

void general_menu()
{
  string s = do_generalmenu();
  if (s != "-")
  {
    if (s == "End Turn")
    {
      pturn++;
      while (player[pturn].playing != 1)
      {
        pturn++;
        if (pturn >= 4) pturn = 0;
      }
      var.first = true;
      var.logicstate = NOTHING_HAPPENING;
    }
    else if (s == "Power")
    {
      player[pturn].powered = 1;
      player[pturn].power = 0;
      do_power();
      var.logicstate = POWER_ANIMATION;
      play_sound(BLAST);
    }
    else if (s == "Quit to Menu")
    {
      pturn = 0;
      var.logicstate = BACK_TO_MAIN_MENU;
      position_mouse(var.oldmx, var.oldmy);
    }
    else if (s == "Save Game")
    {
      var.logicstate = SAVING_GAME;
    }
    else if (s == "Cancel")
    {
      var.logicstate = NOTHING_HAPPENING;
    }
    position_mouse(var.oldmx, var.oldmy);
  }
}

void unit_moving()
{
  _unit *u = &player[pturn].unit[var.unitselected];
  u->do_movement();
  u->draw();
  if (!u->is_moving())  //if the unit has just stopped moving
  {
    var.oldmx = mouse_x;
    var.oldmy = mouse_y;
    var.logicstate = IN_ACTION_MENU;
  }
}

void unit_selected()
{
  int mx = mouse_x;
  int my = mouse_y;
  int tx, ty;
  if (mx >= map.offset_x)
  {
    tx = map.scroll_x + (mx - map.offset_x) / 40;
  }
  else
  {
    tx = map.scroll_x - 1 + (mx - map.offset_x) / 40;
  }
  if (my >= map.offset_y)
  {
    ty = map.scroll_y + (my - map.offset_y) / 40;
  }
  else
  {
    ty = map.scroll_y - 1 + (my - map.offset_y) / 40;
  }
  int t;
  bool ok;
  _unit *u;
  check_scrolling();
  do_moveselect(pturn, var.unitselected, tx, ty);
  if (mouse_clicked() == 1)
  {
    u = &player[pturn].unit[var.unitselected];
    t = map.tile[tx][ty].unit_here();
    ok = false;
    if ((t != -1) && (t / 100 == pturn))
    {  //if another of the player's units is here
      if (movelist.size() == 0)  //the unit hasn't moved at all, so the unit
      {                          //detected on the tile is just the selected unit
        ok = true;
      }
      else if (player[pturn].unit[t % 100].can_load_unit(u) == 1)
      {  //if a unit is here but can load the selected unit, everything's OK
        ok = true;
      }
      else if (player[pturn].unit[t % 100].type == u->type)
      {  //or if it is the same unit type and is damaged, they can merge
        if (can_merge(u, &player[pturn].unit[t % 100]))
        {
          ok = true;
        }
      }
    }
    else
    {  //there is no unit or an allied unit here, since you can't move onto enemy units
      if (map.tile[tx][ty].get_step() <= u->move)
      {  //only have movement if the mouse is on a movable tile
        ok = true;
      }
      if (t != -1)
      {  //if there is an allied unit here
        ok = false;
      }
    }
    if (ok == true)
    {
      if (movelist.size() == 0)  //so do_actionmenu can tell if a unit has been ordered
      {                          //to move, which is important for ranged-attack units
        var.movedthisturn = 0;
      }
      else
      {
        var.movedthisturn = 1;
        u->capturing = -1;  //stops any capture process
        play_moving_sound(u->type);
      }
      u->set_moves(movelist);
      var.logicstate = UNIT_MOVING;
      do_moveselect(-1, -1, -1, -1);  //this resets do_moveselect's static ints
    }
  }
}

void action_menu()
{
  _unit *u = &player[pturn].unit[var.unitselected];
  _unit *temp;
  string s = do_actionmenu(u);
  int x, y;
  static int z = -2;
  if (z == -2)
  {
    z = unit_here_thorough(pturn, u->tilex, u->tiley, var.unitselected);
  }
  if (z != -1)
  {
    temp = &player[pturn].unit[z];
    map.draw_tiles(temp->tilex - map.scroll_x, temp->tiley - map.scroll_y, 1, 1, temp);
  }
  if (s != "-")
  {
    u->ready = 0;
    if (s == "Attack")
    {
      var.logicstate = UNIT_ATTACKING;
      mouse_bitmap = (BITMAP *)mouse[1].dat;  //change the mouse to a crosshair
    }
    else if (s == "Supply")
    {
      supply_units(u);
    }
    else if (s == "Capture")
    {
      capture_building(u);
    }
    else if (s == "Load")
    {
      player[pturn].unit[z].load_unit(u);
      map.tile[u->tilex][u->tiley].set_unit(pturn, z);  //makes sure unitmap is
      u->exists = 0;                                    //correct for this spot
    }
    else if (s == "Unload")
    {
      var.logicstate = UNIT_UNLOADING;
    }
    else if (s == "Merge")
    {
      merge_units(u, u->tilex, u->tiley);
    }
    else if (s == "Dive")
    {
      u->submerged = 1;
    }
    else if (s == "Surface")
    {
      u->submerged = 0;
    }
    else if (s == "Cancel")
    {
      u->ready = 1;
      if (z != -1)
      {
        x = u->tilex;
        y = u->tiley;
      }
      u->set_tiles(var.oldux, var.olduy);
      if (z != -1)
      {
        map.tile[x][y].set_unit(pturn, z);  //if merge or load was canceled, restore unit value
      }
      u->capturing = var.oldcapstatus;
      var.movedthisturn = 0;
    }
    if (var.logicstate == IN_ACTION_MENU)
    {  //if the action does not bring up a new menu or anything
      var.logicstate = NOTHING_HAPPENING;  //go back to waiting for more input
    }
    position_mouse(var.oldmx, var.oldmy);
    z = -2;
  }
}

void unit_attacking()
{
  static bool first = true;
  static vector<_loc> attackables;
  _unit *u = &player[pturn].unit[var.unitselected];
  int tx, ty, z, temp1, temp2;
  int really_cancel;
  int mx = mouse_x;
  int my = mouse_y;
  int damage, dx, dy;
  char damagepercent[5];
  if (first == true)
  {
    attackables = find_attackables(u);
    first = false;
  }
  check_scrolling();
  draw_attackables(attackables);
  if (var.cancel_attack == false)
  {
    tx = (mx + 7 - map.offset_x) / 40 + map.scroll_x;
    ty = (my + 7 - map.offset_y) / 40 + map.scroll_y;
    if (gameoptions.show_damage)
    {
      z = attackable_unit_here(u, tx, ty, true);
      if (z != -1)
      {
        damage = int(total_damage(u, &player[z / 100].unit[z % 100]));
        sprintf(damagepercent, "%-1d%%", damage);
        dx = mx + 14 - map.offset_x;
        dy = my + 14 - map.offset_y;
        textout(back_buffer, font, damagepercent, dx, dy, WHITE);
        rect(back_buffer, dx - 1, dy, dx + text_length(font, damagepercent), dy + 10, DGREY);
      }
    }
    if (mouse_rclicked() == 1)
    {
      var.cancel_attack = true;
    }
    if (mouse_clicked() == 1)
    {  //the (mx + 7) and (my + 7) are because the crosshair's center is 7 pixels away
      z = attackable_unit_here(u, tx, ty, true);
      if (z != -1)
      {
        first = true;
        var.logicstate = IN_BATTLE;
        var.attacker = (pturn * 100) + var.unitselected;
        var.defender = z;
        var.unitselected = -1;
        mouse_bitmap = (BITMAP *)mouse[0].dat;  //change the mouse back to normal
      }
    }
  }
  else if (var.cancel_attack == true)
  {
    mouse_bitmap = (BITMAP *)mouse[0].dat;  //normal mouse again
    really_cancel = do_cancelattack_menu();
    if (really_cancel == 0)
    {  //if "Continue Attack" has been selected
      mouse_bitmap = (BITMAP *)mouse[1].dat;  //mouse goes back to a crosshair
      temp1 = (u->tilex - map.scroll_x) * 40;
      temp2 = (u->tiley - map.scroll_y) * 40;
      position_mouse(temp1 + 20, temp2 + 20);
      var.cancel_attack = false;
    }
    else if (really_cancel == 1)
    {  //if "Cancel Attack" has been selected
      temp1 = (u->tilex - map.scroll_x) * 40;
      temp2 = (u->tiley - map.scroll_y) * 40;      
      u->ready = 1;
      u->set_tiles(var.oldux, var.olduy);
      position_mouse(temp1 + 20, temp2 + 20);
      var.cancel_attack = false;
      first = true;
      var.logicstate = NOTHING_HAPPENING;
    }  //if it returns -1, an option hasn't been selected yet
  }
}

vector<_loc> find_attackables(_unit *u)
{
  vector<_loc> a;
  _loc t;
  int x, y, i, max, min;
  a.resize(0);
  a.reserve(4);
  if (u->attacktype == DIRECT)
  {  //search for attackable units on adjacent spaces
    i = 0;
    while (i < 4)
    {
      switch(i)
      {
        case 0:
          x = u->tilex + 1;
          y = u->tiley;
          break;
        case 1:
          x = u->tilex - 1;
          y = u->tiley;
          break;
        case 2:
          x = u->tilex;
          y = u->tiley - 1;
          break;
        case 3:
          x = u->tilex;
          y = u->tiley + 1;
          break;
      }
      if (attackable_unit_here(u, x, y, true) != -1)
      {  //finds all attackables, including teammates
        t.x = x;
        t.y = y;
        a.push_back(t);
      }
      i++;
    }
  }
  else if (u->attacktype == RANGED)
  {  //search for attackable units anywhere within range
    max = get_rangemax(u->type);
    min = get_rangemin(u->type);
    y = u->tiley - max;
    if (y < 0) y = 0;
    while ((y <= u->tiley + max) && (y < map.h))
    {
      x = u->tilex - max;
      if (x < 0) x = 0;
      while ((x <= u->tilex + max) && (x < map.l))
      {
        i = tile_distance(x, y, u->tilex, u->tiley);
        if ((i >= min) && (i <= max))
        {
          if (attackable_unit_here(u, x, y, true) != -1)
          {
            t.x = x;
            t.y = y;
            a.push_back(t);
          }
        }
        x++;
      }
      y++;
    }
  }
  return a;
}

void draw_attackables(vector<_loc> locations)
{
  static int r = 0;
  int i, m, t1, t2, u;
  r += 3;
  if (r > 256)
  {
    r -= 256;
  }
  i = 0;
  m = locations.size();
  while (i < m)
  {  //rotates a large crosshair over each attackable enemy
    t1 = (locations[i].x - map.scroll_x) * 40 + map.offset_x;
    t2 = (locations[i].y - map.scroll_y) * 40 + map.offset_y;
    u = map.tile[locations[i].x][locations[i].y].unit_here();
    if (player[u / 100].team == player[pturn].team)
    {  //if this attackable unit is on an allied team
      hline(back_buffer, t1, t2, t1 + 10, GREEN);
      hline(back_buffer, t1, t2 + 1, t1 + 10, GREEN);
      hline(back_buffer, t1 + 29, t2, t1 + 39, GREEN);
      hline(back_buffer, t1 + 29, t2 + 1, t1 + 39, GREEN);
      hline(back_buffer, t1, t2 + 38, t1 + 10, GREEN);
      hline(back_buffer, t1, t2 + 39, t1 + 10, GREEN);
      hline(back_buffer, t1 + 29, t2 + 38, t1 + 39, GREEN);
      hline(back_buffer, t1 + 29, t2 + 39, t1 + 39, GREEN);
      vline(back_buffer, t1, t2, t2 + 10, GREEN);
      vline(back_buffer, t1 + 1, t2, t2 + 10, GREEN);
      vline(back_buffer, t1 + 38, t2, t2 + 10, GREEN);
      vline(back_buffer, t1 + 39, t2, t2 + 10, GREEN);
      vline(back_buffer, t1, t2 + 29, t2 + 39, GREEN);
      vline(back_buffer, t1 + 1, t2 + 29, t2 + 39, GREEN);
      vline(back_buffer, t1 + 38, t2 + 29, t2 + 39, GREEN);
      vline(back_buffer, t1 + 39, t2 + 29, t2 + 39, GREEN);
    }  //(draws a green square-like target thingy)
    else
    {
      rotate_sprite(back_buffer, (BITMAP *)glb[13].dat, t1 - 10, t2 - 10, itofix(r));
    }
    i++;
  }
}

int attackable_unit_here(_unit *attacker, int tx, int ty)
{
  return attackable_unit_here(attacker, tx, ty, false);
}

int attackable_unit_here(_unit *attacker, int tx, int ty, bool ignore_teams)
{
  int u = map.tile[tx][ty].unit_here();
  _unit *defender;
  int d;
  if ((u != -1) && (u / 100 != attacker->color))
  {
    defender = &player[u / 100].unit[u % 100];
    if (player[attacker->color].team == player[defender->color].team)
    {  //if the players are on the same team
      if (!ignore_teams)
      {  //if teams are being recognized
        return -1;
      }
    }
    if (type_can_attack(attacker, defender))
    {  //if the attacker could, in theory, attack the defender
      d = tile_distance(attacker->tilex, attacker->tiley, tx, ty);
      if (attacker->attacktype == DIRECT)
      {  //if the attacker is direct and next to the defender, it can attack
        if (d == 1)
        {
          return u;
        }
      }
      else if (attacker->attacktype == RANGED)
      {
        if ((d >= get_rangemin(attacker->type)) && (d <= get_rangemax(attacker->type)))
        {  //if the attacker has the defender within its firing range, it can attack
          return u;
        }
      }
    }
  }
  return -1;
}

void unit_unloading()
{
  static bool first = true;
  static bool choosing_unit = true;
  static bool two_units;
  static int number_unloaded;
  static int unloadee;
  static int unloadnum;
  static vector<_loc> locations;
  _unit *u = &player[pturn].unit[var.unitselected];
  _unit *v;
  int tx, ty, temp1, temp2;
  int mx = mouse_x;
  int my = mouse_y;
  int really_cancel;
  check_scrolling();
  if (first == true)
  {
    choosing_unit = true;
    unloadee = -1;
    first = false;
    locations.resize(0);
    locations.reserve(2);
    if ((u->load[0].loaded == 1) && (u->load[1].loaded == 1))
    {  //the lander is the only unit which can load two other units
      two_units = true;
    }
    else
    {
      two_units = false;
    }
  }
  if (choosing_unit == true)
  {
    unloadnum = do_unloadmenu(u);
    if (unloadnum > -1)
    {
      choosing_unit = false;
      if (unloadnum != 2)
      {
        locations = find_unload_locations(u, u->load[unloadnum].type);
        position_mouse(var.oldmx, var.oldmy);
      }
      else
      {  //if unloadnum == 2 then the cancel button has been pressed
        if (number_unloaded == 0)
        {  //if it hasn't unloaded anything, it can return to its original state
          u->set_tiles(var.oldux, var.olduy);
          u->ready = 1;
        }
        first = true;
        number_unloaded = 0;
        var.unitselected = -1;
        var.logicstate = NOTHING_HAPPENING;
      }
    }
  }
  else if (var.cancel_unload == false)
  {
    show_unload_locations(locations);
    if (mouse_rclicked() == 1)
    {
      var.cancel_unload = true;
    }
    if (mouse_clicked() == 1)
    {
      if (mx >= map.offset_x)
      {
        tx = map.scroll_x + (mx - map.offset_x) / 40;
      }
      else
      {
        tx = map.scroll_x - 1 + (mx - map.offset_x) / 40;
      }
      if (my >= map.offset_y)
      {
        ty = map.scroll_y + (my - map.offset_y) / 40;
      }
      else
      {
        ty = map.scroll_y - 1 + (my - map.offset_y) / 40;
      }
      if (unit_unloadable_here(u->tilex, u->tiley, tx, ty, u->load[unloadnum].type))
      {
        u->load[unloadnum].loaded = 0;
        unloadee = player[pturn].create_unit(u->load[unloadnum].type, tx, ty, pturn);
        v = &player[pturn].unit[unloadee];
        v->gas = u->load[unloadnum].gas;
        v->ammo = u->load[unloadnum].ammo;
        v->health = u->load[unloadnum].health;
        if (u->load[unloadnum].subload.loaded == 1)
        {
          v->load[0].loaded = 1;
          v->load[0].type = u->load[unloadnum].subload.type;
          v->load[0].gas = u->load[unloadnum].subload.gas;
          v->load[0].ammo = u->load[unloadnum].subload.ammo;
          v->load[0].health = u->load[unloadnum].subload.health;
          u->load[unloadnum].subload.loaded = 0;
        }
        number_unloaded++;
        if ((number_unloaded == 1) && (two_units == true))
        {  //if it is a lander, it can unload both units in one turn
          first = true;
          if ((!u->can_unload_unit(0)) && (!u->can_unload_unit(1)))
          {  //but if there is no place to unload a second unit
            u->ready = 0;
            number_unloaded = 0;
            var.logicstate = NOTHING_HAPPENING;
          }
        }
        else
        {
          u->ready = 0;
          first = true;
          number_unloaded = 0;
          var.logicstate = NOTHING_HAPPENING;
        }
      }
    }
  }
  else if (var.cancel_unload == true)
  {
    really_cancel = do_cancelunload_menu();
    if (really_cancel == 0)
    {
      temp1 = (u->tilex - map.scroll_x) * 40;
      temp2 = (u->tiley - map.scroll_y) * 40;
      position_mouse(temp1 + 20, temp2 + 20);
      var.cancel_unload = false;
    }
    else if (really_cancel == 1)
    {
      temp1 = (u->tilex - map.scroll_x) * 40;
      temp2 = (u->tiley - map.scroll_y) * 40;
      position_mouse(temp1 + 20, temp2 + 20);
      if (number_unloaded == 0)
      {  //if it hasn't unloaded anything yet, it can return to its original position
        u->set_tiles(var.oldux, var.olduy);
        u->ready = 1;
      }
      else
      {
        u->ready = 0;
      }
      first = true;
      number_unloaded = 0;
      var.cancel_unload = false;
      var.logicstate = NOTHING_HAPPENING;
    }
  }
}

vector<_loc> find_unload_locations(_unit *u, int type)
{
  int x, y, i;
  vector<_loc> a;
  _loc t;
  a.reserve(0);
  a.resize(0);
  i = 0;
  while (i < 4)
  {
    switch(i)
    {
      case 0:
        x = u->tilex - 1;
        y = u->tiley;
        break;
      case 1:
        x = u->tilex + 1;
        y = u->tiley;
        break;
      case 2:
        x = u->tilex;
        y = u->tiley - 1;
        break;
      case 3:
        x = u->tilex;
        y = u->tiley + 1;
        break;
    }
    if ((x > -1) && (x < map.l) && (y > -1) && (y < map.h))
    {
      if (unit_unloadable_here(u->tilex, u->tiley, x, y, type) == true)
      {
        t.x = x;
        t.y = y;
        a.push_back(t);
      }
    }
    i++;
  }
  return a;
}

void show_unload_locations(vector<_loc> locations)
{
  int i = 0;
  int m = locations.size();
  int x, y;
  while (i < m)
  {  //highlight each good unload location
    x = (locations[i].x - map.scroll_x) * 40 + map.offset_x;
    y = (locations[i].y - map.scroll_y) * 40 + map.offset_y;
    if (translucency == 1)
    {
      fblend_trans(small_white, back_buffer, x, y, 170);
    }
    else
    {
      rect(back_buffer, x, y, x + 40, y + 40, WHITE);
    }
    i++;
  }
}

bool unit_unloadable_here(int ox, int oy, int tx, int ty, int type)
{
  int s = map.tile[tx][ty].get_set();
  int n = map.tile[tx][ty].get_number();
  bool rivers = false;
  bool mountains = false;
  bool ok = false;
  if ((type == INFANTRY) || (type == MECH))
  {  //infantry and mech units can go in rivers
    rivers = true;
    mountains = true;
  }
  if ((s == 0) || (s == 3) || (s == 4))
  {  //if the tile is land, shoal, or building
    ok = true;
    if ((s == 0) && (n == 4))
    {  //if it is a mountain
      if (mountains == false)
      {
        ok = false;
      }
    }
  }
  else if ((s == 1) && (rivers == true))
  {  //if it is a river tile and the unit can go in rivers
    ok = true;
  }
  if (map.tile[tx][ty].unit_here() != -1)
  {  //can't unload if a unit is on the tile already
    ok = false;
  }
  if (tile_distance(ox, oy, tx, ty) != 1)
  {  //make sure the distance between unloader and unloadee is 1
    ok = false;
  }
  return ok;
}

void check_scrolling()
{
  check_scrolling(-1, -1);
}

void check_scrolling(int forcex, int forcey)
{
  int mx = mouse_x;
  int my = mouse_y;
  if (!(mouse_b & 1))
  {  //the screen shouldn't scroll while the mouse button is down
    if ((mx == 0) || (key[KEY_LEFT]))
    {
      if (map.scroll_x > 0)
      {
        map.offset_x += 10;
        if (map.offset_x >= 40)
        {
          map.scroll_x--;
          map.offset_x -= 40;
        }
      }
    }
    if ((mx == 639) || (key[KEY_RIGHT]))
    {
      if (!((map.scroll_x + 17 > map.l) && (map.offset_x < 10)))
      {
        map.offset_x -= 10;
        if (map.offset_x < 0)
        {
          map.scroll_x++;
          map.offset_x += 40;
        }
      }
    }
    if ((my == 479) || (key[KEY_DOWN]))
    {
      if (!((map.scroll_y + 13 > map.h) && (map.offset_y < 10)))
      {
        map.offset_y -= 10;
        if (map.offset_y < 0)
        {
          map.scroll_y++;
          map.offset_y += 40;
        }
      }
    }
    if ((my == 0) || (key[KEY_UP]))
    {
      if (map.scroll_y > 0)
      {
        map.offset_y += 10;
        if (map.offset_y >= 40)
        {
          map.scroll_y--;
          map.offset_y -= 40;
        }
      }
    }
  }
  if ((forcex != -1) && (forcey != -1))
  {
    map.scroll_x = forcex;
    map.scroll_y = forcey;
    map.offset_x = 0;
    map.offset_y = 0;
  }  
}

int moves_needed(int mtype, int tx, int ty)
{        //Infantry, Tires, Tread, Air, Mech, Sea, Lander
  int movegrid[56] = {1, 1, 1, 1, 1,99,99,  //Buildings        0
                      1, 2, 1, 1, 1,99,99,  //Plains           1
                      1, 1, 1, 1, 1,99, 1,  //Shoal            2
                      1, 3, 2, 1, 1,99,99,  //Forest           3
                      2,99,99, 1, 1,99,99,  //Mountain         4
                      2,99,99, 1, 1,99,99,  //River            5
                      1, 1, 1, 1, 1,99,99,  //Road             6
                     99,99,99, 1,99, 1, 1}; //Sea              7
  int ltype = get_ltype(tx, ty);
  if (ltype == 0)
  {
    if ((mtype == M_SEA) || (mtype == M_LANDER))  //sea units can go to ports
    {
      if (map.tile[tx][ty].is_building(PORT))
      {
        return 1;
      }
    }
  }
  return movegrid[mtype + (ltype * 7)];
}

int get_ltype(int tx, int ty)
{
  int s;
  int z;
  s = map.tile[tx][ty].get_set();
  z = map.tile[tx][ty].get_number();
  if (s == 4)  //buildings
  {
    return 0;
  }
  else if (s == 0)  //land
  {
    if (z == 2)  //forest
    {
      return 3;
    }
    else if (z == 4)  //mountain
    {
      return 4;
    }
    else if (z == 3)  //plains
    {
      return 1;
    }
    else  //road
    {
      return 6;
    }
  }
  else if (s == 3)  //shoal
  {
    if (z < 25)
    {
      return 2;
    }
    else  //tiles 25 through 28 are sea tiles, but are transitions from shoals
    {
      return 7;
    }
  }
  else if (s == 1)  //river
  {
    return 5;
  }
  else //sea
  {
    return 7;
  }
}

int do_moveselect(int plyr, int u, int tx, int ty)
{
  static int first = 1;
  static int lastx;
  static int lasty;
  int i;
  int dir;
  int findpath;
  int temp;
  int w, q;
  int move;
  if ((tx == -1) && (ty == -1))  //if -1 for tx and ty, reset the static ints
  {
    movelist.resize(0);
    u = -1;
    first = 1;
    return 0;
  }
  _unit *theunit = &player[plyr].unit[u];
  if (first == 1)
  {
    lastx = theunit->tilex;
    lasty = theunit->tiley;
    findpath = 1;
    first = 0;
  }
  else if ((tx != lastx) || (ty != lasty))
  {
    move = theunit->move;
    if (move > theunit->gas)
    {
      move = theunit->gas;
    }
    findpath = 0;
    if (tile_distance(lastx, lasty, tx, ty) == 1)
    {  //if the mouse hasn't skipped a tile or anything like that
      if (list_distance(theunit) + moves_needed(theunit->movetype, tx, ty) <= move)
      {  //if the movement is still within the unit's range
        if (map.tile[tx][ty].get_step() <= theunit->move)
        {
          if (ty == lasty + 1)
          {
            dir = DOWN;
          }
          if (ty == lasty - 1)
          {
            dir = UP;
          }
          if (tx == lastx + 1)
          {
            dir = RIGHT;
          }
          if (tx == lastx - 1)
          {
            dir = LEFT;
          }
          movelist.push_back(dir);
          if (move_overlap(theunit))
          {
            findpath = 1;
          }
        }
      }
      else
      {
        findpath = 1;
      }
    }
    else
    {  //if the path is not connected
      findpath = 1;
    }
    if ((tx == theunit->tilex) && (ty == theunit->tiley))
    {  //if the mouse is over the unit's original position, reset the movelist
      findpath = 0;  //also, don't bother getting a best path
      movelist.resize(0);
    }
    if ((findpath == 1) && (map.tile[tx][ty].get_step() <= theunit->move))
    {  //find the best path from (tx, ty) to the unit's location
      vector<_aipath> t = best_aipath(plyr, theunit->movetype, theunit->tilex, theunit->tiley, tx, ty);
      q = t.size();
      i = 0;
      movelist.resize(0);
      while (i < q)
      {
        movelist.push_back(t[i].dir);
        i++;
      }
    }
    if (map.tile[tx][ty].get_step() <= theunit->move)
    {
      lastx = tx;
      lasty = ty;
    }
  }
  show_movable_tiles(theunit);
  draw_path(theunit);
  theunit->draw(false);
  return u;
}

void show_movable_tiles(_unit *u)
{
  int i, j;
  int ymin = u->tiley - u->move;
  int ymax = u->tiley + u->move;
  int xmin = u->tilex - u->move;
  int xmax = u->tilex + u->move;
  int x, y;
  j = ymin;
  if (j < 0) j = 0;
  while ((j <= ymax) && (j < map.h))
  {
    i = xmin;
    while ((i <= xmax) && (i < map.l))
    {
      if (map.tile[i][j].get_step() <= u->move)
      {
        x = (i - map.scroll_x) * 40 + map.offset_x;
        y = (j - map.scroll_y) * 40 + map.offset_y;
        if (translucency == 1)
        {
          fblend_trans(small_white, back_buffer, x, y, 170);
        }
        else
        {
          rect(back_buffer, x, y, x + 40, y + 40, WHITE);
        }
      }
      i++;
    }
    j++;
  }
}

void draw_path(_unit *u)
{
  int i = 0;
  int tx = u->tilex;
  int ty = u->tiley;
  int x = (u->tilex - map.scroll_x) * 40 + map.offset_x;
  int y = (u->tiley - map.scroll_y) * 40 + map.offset_y;
  if (translucency == 1)
  {
    fblend_trans(small_yellow, back_buffer, x, y, 170);
  }
  else
  {
    rectfill(back_buffer, x, y, x + 40, y + 40, YELLOW);
  }
  while (i < movelist.size())
  {
    switch(movelist[i])
    {
      case LEFT:
        tx -= 1;
        break;
      case RIGHT:
        tx += 1;
        break;
      case UP:
        ty -= 1;
        break;
      case DOWN:
        ty += 1;
        break;
    }
    x = (tx - map.scroll_x) * 40 + map.offset_x;
    y = (ty - map.scroll_y) * 40 + map.offset_y;
    if (translucency == 1)
    {
      fblend_trans(small_yellow, back_buffer, x, y, 120);
    }
    else
    {
      rect(back_buffer, x, y, x + 40, y + 40, YELLOW);
      rect(back_buffer, x + 1, y + 1, x + 39, y + 39, YELLOW);
      rect(back_buffer, x + 2, y + 2, x + 38, y + 38, YELLOW);
    }
    i++;
  }
}

int list_distance(_unit *u)
{
  int i = 0;
  int moves = 0;
  int x = u->tilex;
  int y = u->tiley;
  while (i < movelist.size())
  {
    switch(movelist[i])
    {
      case UP:
        y -= 1;
        break;
      case DOWN:
        y += 1;
        break;
      case LEFT:
        x -= 1;
        break;
      case RIGHT:
        x += 1;
        break;
    }
    moves += moves_needed(u->movetype, x, y);
    i++;
  }
  return moves;
}

bool move_overlap(_unit *u)
{
  int i = 0;
  int j;
  int tx, ty;
  int x = u->tilex;
  int y = u->tiley;
  vector<_loc> a;
  _loc l;
  tx = x;
  ty = y;
  while (i < movelist.size())
  {
    switch(movelist[i])
    {
      case UP:
        y -= 1;
        break;
      case DOWN:
        y += 1;
        break;
      case LEFT:
        x -= 1;
        break;
      case RIGHT:
        x += 1;
        break;
    }
    j = 0;
    while (j < a.size())
    {
      if ((x == a[j].x) && (y == a[j].y))
      {
        return true;
      }
      j++;
    }
    l.x = x;
    l.y = y;
    a.push_back(l);
    i++;
  }
  return false;
}

string do_actionmenu(_unit *u)
{
  int i, tx, ty;
  int q, z;
  static int bnum;
  bool attack;
  bool supply;
  bool load;
  bool merge;
  static _button items[5];
  static int first = 1;
  static int x1, y1, x2, y2;
  string item[5];
  if (first == 1)
  {
    i = 0;
    while (i < 5)
    {
      item[i] = "-";
      i++;
    }
    if ((u->tilex - map.scroll_x) * 40 < 350)
    {
      x1 = 500;
      x2 = 639;
    }
    else
    {
      x1 = 0;
      x2 = 139;
    }
    y1 = 0;
    i = 0;
    load = false;
    q = unit_here_thorough(u->color, u->tilex, u->tiley, u->number);
    if (q != -1)
    {  //if another unit is here, check if it can load the selected unit
      if (player[u->color].unit[q].can_load_unit(u) == 1)
      {  
        load = true;
      }
    }
    if (load == true)
    {
      item[i] = "Load";
      i++;
    }
    merge = false;
    q = unit_here_thorough(u->color, u->tilex, u->tiley, u->number);
    if (q != -1)
    {
      if (load != 1)
      {  //there is another unit here, and it cannot be load, so it must be a merge
        merge = true;
        item[i] = "Merge";
        i++;
      }
    }
    attack = false;
    if (u->ammo > 0)
    {
      if (u->attacktype == DIRECT)
      {
        q = 0;
        while (q < 4)
        {
          switch(q)
          {
            case 0:
              tx = u->tilex + 1;
              ty = u->tiley;
              break;
            case 1:
              tx = u->tilex - 1;
              ty = u->tiley;
              break;
            case 2:
              tx = u->tilex;
              ty = u->tiley - 1;
              break;
            case 3:
              tx = u->tilex;
              ty = u->tiley + 1;
              break;
          }
          if (attackable_unit_here(u, tx, ty, true) != -1)
          {
            attack = true;
            q = 4;  //found an attackable enemy, further checks not necessary
          }
          q++;
        }
      }
      else  //if not direct, must either be ranged or -1 and I don't
      {     //have to worry about -1 attacktypes, since their ammo is 0
        if ((enemy_in_range(u) != -1) && (var.movedthisturn == 0))
        {
          attack = true;
        }
      }
    }
    if ((attack == true) && (load == false) && (merge == false))
    {  //unit can't attack when it can be loaded or merged
      item[i] = "Attack";
      i++;
    }
    supply = false;
    if (u->type == APC)
    {
      z = 0;
      while (z < 4)
      {
        switch(z)
        {
          case 0:
            tx = u->tilex + 1;
            ty = u->tiley;
            break;
          case 1:
            tx = u->tilex - 1;
            ty = u->tiley;
            break;
          case 2:
            tx = u->tilex;
            ty = u->tiley - 1;
            break;
          case 3:
            tx = u->tilex;
            ty = u->tiley + 1;
            break;
        }
        q = any_unit_here(tx, ty);
        if ((q != -1) && (q / 100 == u->color))
        {  //if there is a friendly unit adjacent to this APC
          supply = true;
          z = 4;  //found an supply target
        }
        z++;
      }
    }
    if ((supply == true) && (load == false) && (merge == false))
    {  //can't supply either when it can be loaded or merged
      item[i] = "Supply";
      i++;
    }
    if (((u->type == INFANTRY) || (u->type == MECH)) && (merge == false))
    {
      if (map.tile[u->tilex][u->tiley].is_building())
      {
        if (!map.tile[u->tilex][u->tiley].owned_by(u->color))
        {  //note: players CAN be jerks and capture allied bases, cities, HQs...
          item[i] = "Capture";
          i++;
        }
      }
    }
    if ((load == false) && (merge == false))
    {
      q = 0;
      while (q < 2)
      {
        if (u->can_unload_unit(q))
        {
          item[i] = "Unload";
          i++;
          q = 2;
        }
        q++;
      }
    }
    if (merge == false)
    {
      if (u->type == SUB)
      {
        if (u->submerged == 1)
        {
          item[i] = "Surface";
        }
        else
        {
          item[i] = "Dive";
        }
        i++;
      }
    }
    if ((load == false) && (merge == false))
    {
      item[i] = "Standby";
      i++;
    }
    item[i] = "Cancel";
    i++;
    i = 0;
    bnum = 0;
    y2 = 1;
    while (i < 5)
    {
      if (item[i] != "-")
      {
        items[i].init(x1 + 1, y2, x2 - (x1 + 2), 30, item[i].c_str());
        y2 += 31;
        bnum++;
      }
      else
      {
        i = 5;
      }
      i++;
    }
    position_mouse(x1 + 70, y1 + 15);  //mouse positioned on middle of Standby button
    set_mouse_range(x1, y1, x2, y2);
    first = 0;
  }
  rectfill(back_buffer, x1, y1, x2, y2, LGREY);
  rect(back_buffer, x1, y1, x2, y2, ORANGE);
  i = 0;
  while (i < bnum)
  {
    items[i].check(back_buffer);
    if (items[i].clicked())
    {
      first = 1;
      set_mouse_range(0, 0, 639, 479);  //return the mouse boundries to normal
      return items[i].text;
    }
    i++;
  }
  return "-";
}

int do_unitmenu(int type, int tx, int ty, int pturn)
{
  DATAFILE *bigunits = (DATAFILE *)units[4].dat;
  static int first = 1;
  static int ok[18];  //each ok[] corresponds to a unit type
  static _button items[11];  //maximum number of buttons possible at once is 11
  static int lastitem;
  static int m_over;
  static bool limit;
  static _unit temp_unit;  
  int i;
  int j;
  if (first == 1)
  {
    limit = false;
    i = 0;
    while (i < 18)
    {
      ok[i] = 0;
      i++;
    }
    switch(type)
    {
      case BASE:
        ok[ANTI_AIR]  = 1;
        ok[APC]       = 1;
        ok[ARTILLERY] = 1;
        ok[INFANTRY]  = 1;
        ok[MD_TANK]   = 1;
        ok[MECH]      = 1;
        ok[MISSILES]  = 1;
        ok[RECON]     = 1;
        ok[ROCKETS]   = 1;
        ok[TANK]      = 1;
        break;
      case AIRPORT:
        ok[B_COPTER] = 1;
        ok[BOMBER]   = 1;
        ok[FIGHTER]  = 1;
        ok[T_COPTER] = 1;
        break;
      case PORT:
        ok[B_SHIP]  = 1;
        ok[CRUISER] = 1;
        ok[LANDER]  = 1;
        ok[SUB]     = 1;
        break;
    }
    if (player[pturn].units_in_play() >= 50)  //if the player cannot make more units
    {
      i = 0;
      while (i < 18)
      {
        ok[i] = 0;
        i++;
      }
      text_mode(-1);
      textout(back_buffer, font, "Unit Limit Reached", 50, 290, BLACK);
      text_mode(0);
      limit = true;
    }
    i = 0;
    j = 0;
    while (i < 18)
    {
      if (ok[i] == 1)
      {
        items[j].init(50, 50 + (25 * j), 100, 20, unit_name(i));
        j++;
      }
      i++;
    }
    items[j].init(50, 310, 100, 20, "Cancel");
    lastitem = j;
    m_over = -1;
    set_mouse_range(40, 40, 400, 350);
    position_mouse(220, 195);
    first = 0;
  }
  draw_playerstats(pturn);
  rect(back_buffer, 40, 40, 400, 350, ORANGE);
  rectfill(back_buffer, 41, 41, 399, 349, LGREY);
  j = 0;
  i = 0;
  while (i < lastitem)
  {
    items[i].check(back_buffer);
    i++;
  }
  i = 0;
  while ((i < lastitem) && (limit == false))
  {
    if (items[i].mouseover() == 1)
    {
      j = 1;
      if (m_over != i)
      {
        temp_unit.create(unit_type(items[i].text), -1, -1, -1, -1);
      }
      rectfill(back_buffer, 250, 50, 350, 60, LGREY);
      text_mode(-1);
      if (temp_unit.price <= player[pturn].cash)
      {
        textprintf(back_buffer, font, 250, 50, BLACK, "Price: %-1d", temp_unit.price);
      }
      else
      {
        textprintf(back_buffer, font, 250, 50, RED, "Price: %-1d", temp_unit.price);
      }
      text_mode(0);
      rectfill(back_buffer, 210, 130, 360, 280, LGREY);
      draw_sprite_h_flip(back_buffer, (BITMAP *)bigunits[(temp_unit.type * 4) + pturn].dat, 210, 130);
      describe_unit(temp_unit.type);
      m_over = i;
    }
    if (items[i].clicked())
    {
      temp_unit.create(unit_type(items[i].text), -1, -1, -1, -1);
      if (player[pturn].cash >= temp_unit.price)
      {
        player[pturn].cash -= temp_unit.price;
        player[pturn].create_unit(temp_unit.type, tx, ty, pturn);
        set_mouse_range(0, 0, 639, 479);
        position_mouse(var.oldmx, var.oldmy);
        m_over = -1;
        first = 1;
        return 1;
      }
    }
    i++;
  }
  if (limit == true)
  {  //the 50-unit limit has been hit
    text_mode(-1);
    textout(back_buffer, font, "Unit Limit Reached", 50, 290, BLACK);
    text_mode(0);   
  }
  if (j == 0)  //if the mouse isn't over any button
  {
    m_over = -1;
  }
  items[lastitem].check(back_buffer);
  if (items[lastitem].clicked())  //cancel button
  {
    set_mouse_range(0, 0, 639, 479);
    position_mouse(var.oldmx, var.oldmy);
    m_over = -1;
    first = 1;
    return 1;
  }
  return 0;
}

void describe_unit(int type)
{
  text_mode(-1);
  switch(type)
  {
    case ANTI_AIR:
      textout_centre(back_buffer, font, "Takes care of those pesky enemy", 275, 270, BLACK);
      textout_centre(back_buffer, font, "air units, and works well against", 275, 285, BLACK);
      textout_centre(back_buffer, font, "Infantry and Mech units as well.", 275, 300, BLACK);
      break;
    case APC:
      textout_centre(back_buffer, font, "Can't attack, but is very helpful due", 275, 270, BLACK);
      textout_centre(back_buffer, font, "to its ability to resupply other units", 275, 285, BLACK);
      textout_centre(back_buffer, font, "and transport an Infantry or Mech.", 275, 300, BLACK);
      break;
    case ARTILLERY:
      textout_centre(back_buffer, font, "A cheap, effective ranged attacker", 275, 270, BLACK);
      textout_centre(back_buffer, font, "that is perfect for defending your", 275, 285, BLACK);
      textout_centre(back_buffer, font, "buildings or giving your attacking", 275, 300, BLACK);
      textout_centre(back_buffer, font, "units a little backup.", 275, 315, BLACK);
      break;
    case B_COPTER:
      textout_centre(back_buffer, font, "Good for making life hard for an", 275, 270, BLACK);
      textout_centre(back_buffer, font, "enemy's land and sea forces, but it", 275, 285, BLACK);
      textout_centre(back_buffer, font, "will get torn to pieces by Cruisers,", 275, 300, BLACK);
      textout_centre(back_buffer, font, "Anti-Air, and Fighters, so be careful.", 275, 315, BLACK);
      break;
    case B_SHIP:
      textout_centre(back_buffer, font, "Keep it safe from Subs and Bombers", 275, 270, BLACK);
      textout_centre(back_buffer, font, "and this unit will make your enemy's", 275, 285, BLACK);
      textout_centre(back_buffer, font, "land forces learn to stay far, far", 275, 300, BLACK);
      textout_centre(back_buffer, font, "away from the coastline.", 275, 315, BLACK);
      break;
    case BOMBER:
      textout_centre(back_buffer, font, "Expensive, but perfect for getting rid", 275, 270, BLACK);
      textout_centre(back_buffer, font, "of tanks, infantry, artillery, and just", 275, 285, BLACK);
      textout_centre(back_buffer, font, "about anything else that doesn't fly or", 275, 300, BLACK);
      textout_centre(back_buffer, font, "hide underwater.", 275, 315, BLACK);
      break;
    case CRUISER:
      textout_centre(back_buffer, font, "This unit will swat down flying units", 275, 270, BLACK);
      textout_centre(back_buffer, font, "and sink submarines with ease, but it", 275, 285, BLACK);
      textout_centre(back_buffer, font, "is very lightly armored and therefore", 275, 300, BLACK);
      textout_centre(back_buffer, font, "very bad at withstanding damage,", 275, 315, BLACK);
      break;
    case FIGHTER:
      textout_centre(back_buffer, font, "It can't hit anything but other air", 275, 270, BLACK);
      textout_centre(back_buffer, font, "units, but its range and power make it", 275, 285, BLACK);
      textout_centre(back_buffer, font, "very helpful when faced with Bombers.", 275, 300, BLACK);
      break;
    case INFANTRY:
      textout_centre(back_buffer, font, "This unit's small cost and ability to", 275, 270, BLACK);
      textout_centre(back_buffer, font, "capture buildings make it very helpful", 275, 285, BLACK);
      textout_centre(back_buffer, font, "despite its lack of firepower and its", 275, 300, BLACK);
      textout_centre(back_buffer, font, "overall weakness.", 275, 315, BLACK);
      break;
    case LANDER:
      textout_centre(back_buffer, font, "A must for any sea-based attack on", 275, 270, BLACK);
      textout_centre(back_buffer, font, "an enemy land, this unit can hold two", 275, 285, BLACK);
      textout_centre(back_buffer, font, "land-based units and drop them off", 275, 300, BLACK);
      textout_centre(back_buffer, font, "at the enemy's doorstep.", 275, 315, BLACK);
      break;
    case MD_TANK:
      textout_centre(back_buffer, font, "This tank will create large, smoking,", 275, 270, BLACK);
      textout_centre(back_buffer, font, "tank-cannon-sized holes in any land", 275, 285, BLACK);
      textout_centre(back_buffer, font, "unit unfortunate enough to be nearby.", 275, 300, BLACK);
      break;
    case MECH:
      textout_centre(back_buffer, font, "Basically an Infantry with a little less", 275, 270, BLACK);
      textout_centre(back_buffer, font, "movement and a lot more firepower.", 275, 285, BLACK);
      break;
    case MISSILES:
      textout_centre(back_buffer, font, "Weak, with little movement, but able", 275, 270, BLACK);
      textout_centre(back_buffer, font, "to remove any offending air units", 275, 285, BLACK);
      textout_centre(back_buffer, font, "from your airspace very, very quickly.", 275, 300, BLACK);
      break;
    case RECON:
      textout_centre(back_buffer, font, "Weak but fast and relatively cheap, it's", 275, 270, BLACK);
      textout_centre(back_buffer, font, "useful as a way to keep opponents", 275, 285, BLACK);
      textout_centre(back_buffer, font, "from capturing buildings easily.", 275, 300, BLACK);
      break;
    case ROCKETS:
      textout_centre(back_buffer, font, "With an attack range only exceeded", 275, 270, BLACK);
      textout_centre(back_buffer, font, "by the Battleship, this unit is perfect", 275, 285, BLACK);
      textout_centre(back_buffer, font, "for blowing up powerful enemy units", 275, 300, BLACK);
      textout_centre(back_buffer, font, "from a safe distance.", 275, 315, BLACK);
      break;
    case SUB:
      textout_centre(back_buffer, font, "Destroy enemy Landers and Battleships", 275, 270, BLACK);
      textout_centre(back_buffer, font, "while safely underwater.  Just be sure", 275, 285, BLACK);
      textout_centre(back_buffer, font, "there aren't any Cruisers nearby.", 275, 300, BLACK);
      break;
    case T_COPTER:
      textout_centre(back_buffer, font, "Quick and easy transport for Infantry", 275, 270, BLACK);
      textout_centre(back_buffer, font, "or Mech units, as long as there's no", 275, 285, BLACK);
      textout_centre(back_buffer, font, "anti-air units nearby.", 275, 300, BLACK);
      break;
    case TANK:
      textout_centre(back_buffer, font, "An effective general-purpose land unit", 275, 270, BLACK);
      textout_centre(back_buffer, font, "that can badly damage anything in its", 275, 285, BLACK);
      textout_centre(back_buffer, font, "way, except for bigger tanks.", 275, 300, BLACK);
      break;
  }
  text_mode(0);
}

void supply_units(_unit *u)
{
  int q;
  int x, y;
  int i = 0;
  while (i < 4)
  {
    switch(i)
    {
      case 0:
        x = u->tilex - 1;
        y = u->tiley;
        break;
      case 1:
        x = u->tilex + 1;
        y = u->tiley;
        break;
      case 2:
        x = u->tilex;
        y = u->tiley - 1;
        break;
      case 3:
        x = u->tilex;
        y = u->tiley + 1;
        break;
    }
    if ((x > -1) && (x < map.l) && (y > -1) && (y < map.h))
    {
      q = map.tile[x][y].unit_here();
      if ((q != -1) && (q / 100 == u->color))
      {
        player[u->color].unit[q % 100].supply();
      }
    }
    i++;
  }
}

void draw_unitstats(_unit *u)
{
  int i = 0;
  int bigbuf = 0;
  while (i < 2)
  {
    if (u->load[i].loaded != 0)
    {
      bigbuf = 1;
    }
    i++;
  }
  clear_to_color(unitstatbuf, DGREY);
  text_mode(-1);
  textprintf(unitstatbuf, font, 5, 3, WHITE, "Health: %-1d", rounded_health(u->health));
  textprintf(unitstatbuf, font, 5, 13, WHITE, "Ammo: %-1d", u->ammo);
  textprintf(unitstatbuf, font, 5, 23, WHITE, "Gas: %-1d", u->gas);
  text_mode(0);
  if (u->load[0].loaded == 1)
  {
    textprintf(unitstatbuf, font, 5, 40, WHITE, "%-1s %-1d", unit_name(u->load[0].type).c_str(), rounded_health(u->load[0].health));
  }
  if (u->load[1].loaded == 1)
  {
    textprintf(unitstatbuf, font, 5, 50, WHITE, "%-1s %-1d", unit_name(u->load[1].type).c_str(), rounded_health(u->load[1].health));
  }
  if (bigbuf == 0)
  {
    if (u->tilex - map.scroll_x > 5)
    {
      if (translucency == 1)
      {
        fblend_trans(unitstatbuf, back_buffer, 0, 445, 170);
      }
      else
      {
        draw_sprite(back_buffer, unitstatbuf, 0, 445);
      }
    }
    else
    {
      if (translucency == 1)
      {
        fblend_trans(unitstatbuf, back_buffer, 540, 445, 170);
      }
      else
      {
        draw_sprite(back_buffer, unitstatbuf, 540, 445);
      }
    }
  }
  else
  {
    if (u->tilex - map.scroll_x > 5)
    {
      if (translucency == 1)
      {
        fblend_trans(unitstatbuf, back_buffer, 0, 400, 170);
      }
      else
      {
        draw_sprite(back_buffer, unitstatbuf, 0, 400);
      }
    }
    else
    {
      if (translucency == 1)
      {
        fblend_trans(unitstatbuf, back_buffer, 540, 400, 170);
      }
      else
      {
        draw_sprite(back_buffer, unitstatbuf, 540, 400);
      }
    }
  }
}

string do_generalmenu()
{
  static _button items[5];
  static int first = 1;
  static int i;
  int j, k;
  if (first == 1)
  {
    i = 0;
    items[0].init(501, 1, 137, 29, "End Turn");
    items[1].init(501, 31, 137, 29, "Quit to Menu");
    if (player[pturn].power == 1000)
    {
      items[2].init(501, 61, 137, 29, "Power");
      i = 1;
    }
    items[2 + i].init(501, 61 + (30 * i), 137, 29, "Save Game");
    items[3 + i].init(501, 91 + (30 * i), 137, 29, "Cancel");
    position_mouse(570, 15);
    set_mouse_range(500, 0, 639, 121 + (30 * i));
    first = 0;
  }
  rect(back_buffer, 500, 0, 639, 121 + (30 * i), ORANGE);
  rectfill(back_buffer, 501, 1, 638, 120 + (30 * i), LGREY);
  if (player[pturn].power < 1000)
  {
    j = 4;
  }
  else
  {
    j = 5;
  }
  k = 0;
  while (k < j)
  {
    items[k].check(back_buffer);
    if (items[k].clicked())
    {
      set_mouse_range(0, 0, 639, 479);
      first = 1;
      return items[k].text;
    }
    k++;
  }
  if (mouse_rclicked() == 1)
  {
    set_mouse_range(0, 0, 639, 479);
    first = 1;
    return "Cancel";
  }
  return "-";
}

int buildings_owned(int plyr)
{
  int temp1, temp2, z;
  int num = 0;
  temp1 = 0;
  while (temp1 < map.h)
  {
    temp2 = 0;
    while (temp2 < map.l)
    {
      if (map.tile[temp2][temp1].owned_by(plyr))
      {
        num++;
      }
      temp2++;
    }
    temp1++;
  }
  return num;
}

bool type_can_attack(_unit *a, _unit *d)
{
  int ta = a->type;
  int td = d->type;
  if (a->ammo > 0)
  {
    switch(d->basetype)
    {
      case LAND:
        if (a->basetype == LAND)
        {
          if (ta != MISSILES)
          {
            return true;
          }
        }
        else
        {
          if ((ta == B_COPTER) || (ta == BOMBER) || (ta == B_SHIP))
          {
            return true;
          }
        }
        break;
      case AIR:
        if (a->basetype == AIR)
        {
          if (ta != BOMBER)
          {
            if (ta == B_COPTER)
            {
              if ((td != BOMBER) && (td != FIGHTER))
              {
                return true;
              }
            }
            else
            {
              return true;
            }
          }
        }
        else if (a->basetype == LAND)
        {
          if ((td == BOMBER) || (td == FIGHTER))
          {
            if ((ta == MISSILES) || (ta == ANTI_AIR))
            {
              return true;
            }
          }
          else
          {
            if (!((ta == ARTILLERY) || (ta == ROCKETS)))
            {
              return true;
            }
          }
        }
        else if (ta == CRUISER)  //cruiser is the only sea unit w/ anti-air ability
        {
          return true;
        }
        break;
      case SEA:
        if (a->basetype == SEA)
        {
          if (ta == CRUISER)
          {  //cruisers can only attack air units and subs
            if (td == SUB)
            {
              return true;
            }
          }
          else
          {
            if ((td == SUB) && (d->submerged == 1))
            {  //battleships can't hit submerged subs
              if ((ta == SUB) || (ta == CRUISER))  //but subs and cruisers can
              {
                return true;
              }
              else
              {
                return false;
              }
            }
            return true;
          }
        }
        else if (a->basetype == LAND)
        {
          if ((ta == TANK) || (ta == MD_TANK) || (ta == ARTILLERY) || (ta == ROCKETS))
          {
            if ((td == SUB) && (d->submerged == 1))
            {  //can't hit an underwater sub from land
              return false;
            }
            else
            {
              return true;
            }
          }
        }
        else
        {
          if ((ta == BOMBER) || (ta == B_COPTER))
          {
            if ((td == SUB) && (d->submerged == 1))
            {  //can't hit a submerged sub from air either
              return false;
            }
            else
            {
              return true;
            }
          }
        }
        break;
    }
  }
  return false;
}

void draw_playerstats(int plyr)
{
  int z = plyr / 10;  //AI players send draw location information in the plyr int as well
  plyr %= 10;  //it is in the tens column, so regular player information is untouched
  int mx = mouse_x;
  int my = mouse_y;
  int col;
  switch(plyr)
  {
    case 0:
      col = RED;
      break;
    case 1:
      col = BLUE;
      break;
    case 2:
      col = DGREEN;
      break;
    case 3:
      col = DYELLOW;
      break;
  }
  clear_to_color(statbuf, DGREY);
  draw_sprite(statbuf, character[player[plyr].number].picture, 25, 0);
  ellipsefill(statbuf, 65, 9, 65, 5, col);
  ellipsefill(statbuf, 65, 19, 65, 5, col);
  text_mode(-1);
  textprintf(statbuf, font, 5, 4, WHITE, "Player %-1d", plyr + 1);
  textprintf(statbuf, font, 5, 14, WHITE, "Funds: %-1d", player[plyr].cash);
  if (player[plyr].power == 1000)  //if the power gauge is full, make it stand out
  {
    rectfill(statbuf, 0, 80, 130, 95, WHITE);
    textprintf_centre(statbuf, font, 65, 83, col, "Power: %-1d", player[plyr].power);
  }
  else
  {
    rectfill(statbuf, 0, 80, (player[plyr].power * 130) / 1000, 95, col);
    textprintf_centre(statbuf, font, 65, 83, WHITE, "Power: %-1d", player[plyr].power);
  }
  text_mode(0);
  if (player[plyr].controller == AI)
  {  //for the AI, draw position was sent in 'plyr' in the tens column, and was sent to 'z'
    if (z == 1)
    {
      if (translucency == 1)
      {
        fblend_trans(statbuf, back_buffer, 0, 0, 100);
      }
      else
      {
        draw_sprite(back_buffer, statbuf, 0, 0);
      }
    }
    else
    {
      if (translucency == 1)
      {
        fblend_trans(statbuf, back_buffer, 510, 0, 100);
      }
      else
      {
        draw_sprite(back_buffer, statbuf, 510, 0);
      }
    }
  }
  else
  {  //for a human, the draw position depends on the mouse location*/
    if (mx > 320)
    {
      if (translucency == 1)
      {
        fblend_trans(statbuf, back_buffer, 0, 0, 170);
      }
      else
      {
        draw_sprite(back_buffer, statbuf, 0, 0);
      }
    }
    else
    {
      if (translucency == 1)
      {
        fblend_trans(statbuf, back_buffer, 510, 0, 170);
      }
      else
      {
        draw_sprite(back_buffer, statbuf, 510, 0);
      }
    }
  }
}

int unit_here_thorough(int plyr, int tx, int ty, int ignore_n)
{
  int i = 0;
  _unit *u;
  while (i < 50)
  {
    if (i != ignore_n)
    {
      u = &player[plyr].unit[i];
      if (u->exists == 1)
      {
        if ((u->tilex == tx) && (u->tiley == ty))
        {
          return i;
        }
      }
    }
    i++;
  }
  return -1;
}

int do_unloadmenu(_unit *u)
{
  static _button b[3];
  static int first = 1;
  static int oldmx, oldmy;
  if (first == 1)
  {
    oldmx = mouse_x;
    oldmy = mouse_y;
    if (u->load[0].loaded == 1)
    {
      b[0].init(501, 1, 137, 29, unit_name(u->load[0].type).c_str());
    }
    else
    {
      b[0].init(501, 1, 137, 29, "-");
    }
    if (u->load[1].loaded == 1)
    {
      b[1].init(501, 31, 137, 29, unit_name(u->load[1].type).c_str());
    }
    else
    {
      b[1].init(501, 31, 137, 29, "-");
    }
    b[2].init(501, 61, 137, 29, "Cancel");
    position_mouse(570, 15);
    set_mouse_range(500, 0, 640, 91);
    first = 0;
  }
  rect(back_buffer, 500, 0, 639, 91, ORANGE);
  rectfill(back_buffer, 501, 1, 638, 90, LGREY);
  b[0].check(back_buffer);
  b[1].check(back_buffer);
  b[2].check(back_buffer);
  if ((b[0].clicked()) && (b[0].text != "-"))
  {
    set_mouse_range(0, 0, 639, 479);
    position_mouse(oldmx, oldmy);
    first = 1;
    return 0;
  }
  if ((b[1].clicked()) && (b[1].text != "-"))
  {
    set_mouse_range(0, 0, 639, 479);
    position_mouse(oldmx, oldmy);
    first = 1;
    return 1;
  }
  if (b[2].clicked())
  {
    set_mouse_range(0, 0, 639, 479);
    position_mouse(oldmx, oldmy);
    first = 1;
    return 2;
  }
  return -1;
}

int do_cancelunload_menu()
{
  static _button b[2];
  static int first = 1;
  if (first == 1)
  {
    position_mouse(570, 15);
    set_mouse_range(501, 1, 639, 59);
    b[0].init(501, 1, 137, 29, "Continue Unload");
    b[1].init(501, 31, 137, 29, "Cancel Unload");
    first = 0;
  }
  rect(back_buffer, 500, 0, 639, 61, ORANGE);
  rectfill(back_buffer, 501, 1, 638, 60, LGREY);
  b[0].check(back_buffer);
  b[1].check(back_buffer);
  if (b[0].clicked())
  {
    set_mouse_range(0, 0, 639, 479);
    first = 1;
    return 0;
  }
  if (b[1].clicked())
  {
    set_mouse_range(0, 0, 639, 479);
    first = 1;
    return 1;
  }
  return -1;
}

int rounded_health(float h)
{
  int whole = int(h);
  int part = int((h - float(whole)) * 10);
  if ((whole == 0) && (h > 0))
  {
    return 1;
  }
  else if (whole == 10)
  {
    return 10;
  }
  else
  {
    if (part >= 5)
    {
      return whole + 1;
    }
    else
    {
      return whole;
    }
  }
}

void transform_buildings(int plyr, int plyr2)
{
  int i, j, z;
  _tile *t;
  i = 0;
  while (i < map.l)
  {
    j = 0;
    while (j < map.h)
    {
      t = &map.tile[i][j];
      if (t->is_building())
      {
        if (t->owned_by(plyr))
        {
          if (t->is_HQ())
          {
            t->change_to_city();
            t->change_owner(plyr2);
          }
          else
          {  //building here
            t->change_owner(plyr2);
          }
        }
      }
      j++;
    }
    i++;
  }
  minimap.create();
}

void repair_units(int plyr)
{
  int i = 0;
  int z, btype;
  bool rep;
  float oldh;
  _unit *u;
  _tile *t;
  while (i < 50)
  {
    u = &player[plyr].unit[i];
    if (u->exists == 1)
    {
      rep = false;
      t = &map.tile[u->tilex][u->tiley];
      if (t->is_building())
      {
        if (t->owned_by(plyr))
        {
          btype = t->building_type();
          switch(u->basetype)
          {
            case LAND:
              if ((btype == CITY) || (btype == HQ) || (btype == BASE))
              {
                rep = true;
              }
              break;
            case SEA:
              if (btype == PORT)
              {
                rep = true;
              }
              break;
            case AIR:
              if (btype == AIRPORT)
              {
                rep = true;
              }
              break;
          }
        }
      }
      if (rep == true)  //if the unit is on a friendly base
      {
        u->supply();  //resupply the unit
        if (u->health < 10)  //if the unit is damaged, add 2 health but take some cash
        {
          oldh = u->health;
          u->health += 2;
          if (u->health > 10)
          {
            u->health = 10;
          }
          player[plyr].cash -= int((u->health - oldh) / 20 * u->price);
          if (player[plyr].cash < 0)
          {
            player[plyr].cash = 0;
          }
        }
      }
    }
    i++;
  }
}

int do_savemenu()
{
  static int first = 1;
  static _button slot[10];
  int i, o, p;
  char path[10];
  char text[10];
  char name[20] = "";
  char t[35];
  _tile *tile;
  sprintf(t, map.get_name().c_str());
  if (first == 1)
  {
    position_mouse(320, 245);
    set_mouse_range(240, 100, 400, 390);
    i = 0;
    while (i < 9)
    {
      sprintf(path, "game%-1d.sav", i);
      ifstream n(path);
      if (n.bad())
      {
        slot[i].init(250, 110 + (i * 25), 140, 20, "Empty");
      }
      else
      {
        n >> text;
        slot[i].init(250, 110 + (i * 25), 140, 20, text);
      }
      i++;
    }
    slot[9].init(250, 360, 140, 20, "Cancel");
    first = 0;
  }
  rect(back_buffer, 240, 100, 400, 390, ORANGE);
  rectfill(back_buffer, 241, 101, 399, 389, LGREY);
  i = 0;
  while (i < 10)
  {
    slot[i].check(back_buffer);
    if (slot[i].clicked())
    {
      if (i == 9)  //Cancel was clicked
      {
        first = 1;
        set_mouse_range(0, 0, 639, 479);
        return 0;
      }
      else
      {
        if (slot[i].text != "Empty")
        {
          sprintf(name, slot[i].text.c_str());
        }
        text_box(240, 200, 160, 20, name, 15, 0);
        if (strcmp(name, "_CANCEL_") == 0)
        {  //if ESC was pressed in text_box, don't save
          first = 1;
          set_mouse_range(0, 0, 639, 479);
          return 0;
        }
        sprintf(path, "game%-1d.sav", i);
        ofstream savefile(path);
        if (!(savefile.bad()))
        {
          savefile << name << "\n" << map.l << "\n" << map.h << "\n";
          o = 0;
          while (o < map.h)
          {
            p = 0;
            while (p < map.l)
            {
              tile = &map.tile[p][o];
              savefile << ((tile->get_set() * 100) + tile->get_number());
              if (p != map.l - 1)
              {
                savefile << " ";
              }
              p++;
            }
            savefile << "\n";
            o++;
          }
          o = 0;
          while (o < 4)
          {
            savefile << "playing " << player[o].playing << "\n";
            if (player[o].playing == 1)
            {
              savefile << "number " << player[o].number << "\n";
              savefile << "cash " << player[o].cash << "\n";
              savefile << "power " << player[o].power << "\n";
              savefile << "controller " << player[o].controller << "\n";
              savefile << "powered " << player[o].powered << "\n";
              savefile << "units " << player[o].units_in_play() << "\n";
              savefile << "team " << player[o].team << "\n";
            }
            p = 0;
            if (player[o].playing != 1)
            {
              p = 50;
            }
            while (p < 50)
            {
              if (player[o].unit[p].exists == 1)
              {
                savefile << "unittype " << player[o].unit[p].type << "\n";
                savefile << "unittilex " << player[o].unit[p].tilex << "\n";
                savefile << "unittiley " << player[o].unit[p].tiley << "\n";
                savefile << "unithealth " << player[o].unit[p].health << "\n";
                savefile << "unitammo " << player[o].unit[p].ammo << "\n";
                savefile << "unitgas " << player[o].unit[p].gas << "\n";
                savefile << "unitready " << player[o].unit[p].ready << "\n";
                savefile << "unitcapturing " << player[o].unit[p].capturing << "\n";
                savefile << "unitsubmerged " << player[o].unit[p].submerged << "\n";
                savefile << "unitload0loaded " << player[o].unit[p].load[0].loaded << "\n";
                savefile << "unitload0type " << player[o].unit[p].load[0].type << "\n";
                savefile << "unitload0health " << player[o].unit[p].load[0].health << "\n";
                savefile << "unitload0ammo " << player[o].unit[p].load[0].ammo << "\n";
                savefile << "unitload0gas " << player[o].unit[p].load[0].gas << "\n";
                savefile << "unitload0subloaded " << player[o].unit[p].load[0].subload.loaded << "\n";
                savefile << "unitload0subtype " << player[o].unit[p].load[0].subload.type << "\n";
                savefile << "unitload0subhealth " << player[o].unit[p].load[0].subload.health << "\n";
                savefile << "unitload0subammo " << player[o].unit[p].load[0].subload.ammo << "\n";
                savefile << "unitload0subgas " << player[o].unit[p].load[0].subload.gas << "\n";
                savefile << "unitload1loaded " << player[o].unit[p].load[1].loaded << "\n";
                savefile << "unitload1type " << player[o].unit[p].load[1].type << "\n";
                savefile << "unitload1health " << player[o].unit[p].load[1].health << "\n";
                savefile << "unitload1ammo " << player[o].unit[p].load[1].ammo << "\n";
                savefile << "unitload1gas " << player[o].unit[p].load[1].gas << "\n";
                savefile << "unitload1subloaded " << player[o].unit[p].load[1].subload.loaded << "\n";
                savefile << "unitload1subtype " << player[o].unit[p].load[1].subload.type << "\n";
                savefile << "unitload1subhealth " << player[o].unit[p].load[1].subload.health << "\n";
                savefile << "unitload1subammo " << player[o].unit[p].load[1].subload.ammo << "\n";
                savefile << "unitload1subgas " << player[o].unit[p].load[1].subload.gas << "\n";
              }
              p++;
            }
            o++;
          }
          savefile << "pturn " << pturn << "\n" << aiprofile << "\n";
          savefile << gameoptions.funding << "\n" << gameoptions.show_damage << "\n" << gameoptions.time << "\n" << t;
        }
        first = 1;
        set_mouse_range(0, 0, 639, 479);
        return 0;
      }
    }
    i++;
  }
  return 1;  //returns 1 if it isn't finished
}

void scroll_to_hq(int plyr)
{
  int x, y, z;
  y = 0;
  while (y < map.h)
  {
    x = 0;
    while (x < map.l)
    {
      if (map.tile[x][y].is_HQ())
      {
        if (map.tile[x][y].owned_by(plyr))
        {
          map.scroll_x = x - 8;  //center on the HQ
          map.scroll_y = y - 6;
          if (map.scroll_x < 0) map.scroll_x = 0;  //make sure it doesn't go past the map ends
          if (map.scroll_x + 16 > map.l) map.scroll_x = map.l - 16;
          if (map.scroll_y < 0) map.scroll_y = 0;
          if (map.scroll_y + 12 > map.h) map.scroll_y = map.h - 12;
          x = 5000;  //just to get out of the loop really fast
          y = 5000;
        }
      }
      x++;
    }
    y++;
  }
}

void scroll_to_location(int x, int y)
{
  map.scroll_x = x - 8;  //center on chosen tile
  map.scroll_y = y - 6;
  map.offset_x = 0;
  map.offset_y = 0;
  if (map.scroll_x < 0) map.scroll_x = 0;  //make sure it doesn't go past the map ends
  if (map.scroll_x + 16 > map.l) map.scroll_x = map.l - 16;
  if (map.scroll_y < 0) map.scroll_y = 0;
  if (map.scroll_y + 12 > map.h) map.scroll_y = map.h - 12;
}

void play_moving_sound(int utype)
{
  switch(utype)
  {
    case ANTI_AIR:
      play_sound(TANKMOVE);
      break;
    case APC:
      play_sound(ENGINE);
      break;
    case ARTILLERY:
      play_sound(TANKMOVE);
      break;
    case B_COPTER:
      play_sound(CHOPPER);
      break;
    case B_SHIP:
      play_sound(SEABOAT);
      break;
    case BOMBER:
      play_sound(JET);
      break;
    case CRUISER:
      play_sound(SEABOAT);
      break;
    case FIGHTER:
      play_sound(JET);
      break;
    case INFANTRY:
      play_sound(MARCH);
      break;
    case LANDER:
      play_sound(SEABOAT);
      break;
    case MD_TANK:
      play_sound(TANKMOVE);
      break;
    case MECH:
      play_sound(MARCH);
      break;
    case MISSILES:
      play_sound(ENGINE);
      break;
    case RECON:
      play_sound(ENGINE);
      break;
    case ROCKETS:
      play_sound(TANKMOVE);
      break;
    case SUB:
      play_sound(SEABOAT);
      break;
    case T_COPTER:
      play_sound(CHOPPER);
      break;
    case TANK:
      play_sound(TANKMOVE);
      break;
  }
}

int do_powerflash(int cnum)
{
  static int first = 1;
  static int x;
  BITMAP *temp;
  static BITMAP *thebmp;
  int i, h, col;
  if (first == 1)
  {
    x = 664;
    temp = create_bitmap(text_length((FONT *)glb[2].dat, character[cnum].powername.c_str()), 40);
    clear_to_color(temp, TRANS);
    text_mode(-1);
    textout(temp, (FONT *)glb[2].dat, character[cnum].powername.c_str(), 0, 5, WHITE);
    text_mode(0);
    thebmp = create_bitmap(temp->w * 3, temp->h * 3);
    clear_to_color(thebmp, TRANS);
    stretch_sprite(thebmp, temp, 0, 0, thebmp->w, thebmp->h);
    destroy_bitmap(temp);
    first = 0;
  }
  h = 240 - (thebmp->h / 2);
  if (x + thebmp->w > -300)
  {
    switch(pturn)
    {
      case 0:
        col = RED;
        break;
      case 1:
        col = BLUE;
        break;
      case 2:
        col = GREEN;
        break;
      case 3:
        col = makecol(210, 210, 0);
        break;
    }
    if (character[cnum].power == 3)
    {  //if the power is to damage all enemy units
      fblend_rect_trans(back_buffer, 0, 0, 640, 480, col, 90);  //shade the screen with the player's color
    }
    rectfill(back_buffer, 0, 170, 640, 310, col);
    hline(back_buffer, 0, 168, 640, col);
    hline(back_buffer, 0, 312, 640, col);
    hline(back_buffer, 0, 165, 640, col);
    hline(back_buffer, 0, 315, 640, col);
    hline(back_buffer, 0, 161, 640, col);
    hline(back_buffer, 0, 319, 640, col);
    hline(back_buffer, 0, 156, 640, col);
    hline(back_buffer, 0, 324, 640, col);
    rectfill(back_buffer, x, h, x + thebmp->w, h + thebmp->h, col);
    x -= 12;
    draw_sprite(back_buffer, thebmp, x, h);
    return 1;  //return something other than -1 to continue animation
  }
  else
  {
    destroy_bitmap(thebmp);
    first = 1;
    return -1;  //return -1 to end the animation
  }
}

void decrease_gas(int plyr)
{
  int i = 0;
  while (i < 50)
  {
    if (player[plyr].unit[i].exists == 1)
    {
      if ((player[plyr].unit[i].basetype == AIR) || (player[plyr].unit[i].basetype == SEA))
      {
        player[plyr].unit[i].gas -= 2;
        if (player[plyr].unit[i].submerged == 1)
        {  //submerged subs lose 4 gas per turn instead of 2
          player[plyr].unit[i].gas -= 2;
        }
        if (player[plyr].unit[i].gas <= 0)
        {
          player[plyr].unit[i].gas = 0;
          player[plyr].unit[i].kill();
        }
      }
    }
    i++;
  }
}

void init_explode(int tx, int ty)
{
  int i;
  boom.push_back();
  i = boom.size() - 1;
  boom[i].exists = 1;
  boom[i].tx = tx;
  boom[i].ty = ty;
  boom[i].frame = 0;
}

void create_particle(int x, int y, int type)
{
  int i = 0;
  bool created = false;
  if (particles == 0)
  {
    return;
  }
  while ((i < p_effects.size()) && (!created))
  {
    if (!p_effects[i].exists)
    {
      p_effects[i].create(x, y, type);
      created = true;
    }
    i++;
  }
  if (!created)
  {
    p_effects.push_back();
    i = p_effects.size() - 1;
    p_effects[i].create(x, y, type);
  }
}

void do_explodes()
{
  DATAFILE *anim = (DATAFILE *)explosions[1].dat;
  int i = 0;
  int x, y;
  int all_empty = 1;
  while (i < boom.size())
  {
    if (boom[i].exists == 1)
    {
      all_empty = 0;
      if (boom[i].frame == 0)  //if the explosion has just begun
      {
        play_sound(EXPLOSION);
      }
      boom[i].frame += 1.5;
      if (int(boom[i].frame) > 29)
      {
        boom[i].exists = 0;
      }
      else
      {
        x = (boom[i].tx - map.scroll_x) * 40 + map.offset_x;
        y = (boom[i].ty - map.scroll_y) * 40 + map.offset_y;
        create_particle(boom[i].tx * 40 + 20, boom[i].ty * 40 + 20, 0);
        draw_sprite(back_buffer, (BITMAP *)anim[int(boom[i].frame)].dat, x, y);
      }
    }
    i++;
  }
  if ((all_empty == 1) && (boom.size() > 0))
  {  //if there are no explosions going on, but the vector has items in it
    boom.resize(0);  //remove those useless items
  }
}

void do_particles()
{
  bool all_empty = true;
  int i = 0;
  while (i < p_effects.size())
  {
    if (p_effects[i].exists)
    {
      all_empty = false;
      p_effects[i].move();
      p_effects[i].draw();
    }
    i++;
  }
  if ((all_empty) && (p_effects.size() > 0))
  {
    p_effects.resize(0);
  }
}

void do_power()
{
  int i, j, r, t;
  switch(character[player[pturn].number].power)
  {
    case 0:  //+2 unit health
      i = 0;
      while (i < 50)
      {
        if (player[pturn].unit[i].exists == 1)
        {
          player[pturn].unit[i].health += 2;
          if (player[pturn].unit[i].health > 10)
          {
            player[pturn].unit[i].health = 10;
          }
        }
        i++;
      }
      break;
    case 3:  //-1 enemy unit health
      j = 0;
      while (j < 4)
      {
        if ((player[j].playing == 1) && (j != pturn))
        {
          if (player[j].team != player[pturn].team)
          {  //if this player isn't on the powered player's team
            i = 0;
            while (i < 50)
            {  //start dealing damage
              if (player[j].unit[i].exists == 1)
              {
                player[j].unit[i].health--;
                if (player[j].unit[i].health <= 0)
                {
                  player[j].unit[i].health = 1;
                }
              }
              i++;
            }
          }
        }
        j++;
      }
      break;
    case 4:  //refresh non-infantry units
      i = 0;
      while (i < 50)
      {
        if (player[pturn].unit[i].exists == 1)
        {
          if ((player[pturn].unit[i].type != INFANTRY) && (player[pturn].unit[i].type != MECH))
          {
            player[pturn].unit[i].ready = 1;
          }
        }
        i++;
      }
      break;
    case 5:  //kill random 1/5 enemy units
      i = 0;
      t = 0;
      r = 0;
      while (i < 4)
      {
        if ((player[i].playing == 1) && (i != pturn))
        {
          if (player[i].team != player[pturn].team)
          {
            t += player[i].units_in_play();
          }
        }
        i++;
      }
      r = t % 5;
      t /= 5;      //if there are < 5, 1 dies
      if (r != 0)  //if there are 5 exactly, 1 dies
      {            //if there are > 5 but <= 10, 2 die
        t++;
      }
      r = 0;
      while (r < t)
      {
        j = rand()%4;
        if ((j != pturn) && (player[j].team != player[pturn].team))
        {
          i = rand()%50;
          if (player[j].unit[i].exists == 1)
          {
            player[j].unit[i].kill();
            r++;
          }
        }
      }
      break;
  }
}

int do_cancelattack_menu()
{
  static _button b[2];
  static int first = 1;
  if (first == 1)
  {
    position_mouse(570, 15);
    set_mouse_range(501, 1, 639, 59);
    b[0].init(501, 1, 137, 29, "Continue Attack");
    b[1].init(501, 31, 137, 29, "Cancel Attack");
    b[0].draw(back_buffer);
    b[1].draw(back_buffer);
    first = 0;
  }
  rect(back_buffer, 500, 0, 639, 61, ORANGE);
  rectfill(back_buffer, 501, 1, 638, 60, LGREY);
  b[0].check(back_buffer);
  b[1].check(back_buffer);
  if (b[0].clicked())
  {
    set_mouse_range(0, 0, 639, 479);
    first = 1;
    return 0;
  }
  if (b[1].clicked())
  {
    set_mouse_range(0, 0, 639, 479);
    first = 1;
    return 1;
  }
  return -1;
}

int secure_base(int plyr)
{
  int x, y, z, u;
  y = 0;
  while (y < map.h)
  {
    x = 0;
    while (x < map.l)
    {
      if (map.tile[x][y].is_unit_producing())
      {
        if (map.tile[x][y].owned_by(plyr))
        {  //if it belongs to the player
          u = map.tile[x][y].unit_here();
          if ((u == -1) || (u / 100 == plyr) || (player[u / 100].team == player[plyr].team))
          {  //there is no unit here or a unit that belongs to this player or an ally
            return 1;
          }
        }
      }
      x++;
    }
    y++;
  }
  return 0;
}

void capture_building(_unit* u)
{
  int temp1, temp2, z;
  if (u->capturing == -1)
  {  //just started a capture
    u->capturing = 20;
    u->capturing -= rounded_health(u->health);
  }
  else  //already in the process of capturing
  {
    u->capturing -= rounded_health(u->health);
    if (u->capturing <= 0)
    {  //if the building has been captured
      u->capturing = -1;
      if (map.tile[u->tilex][u->tiley].is_HQ())
      {
        z = map.tile[u->tilex][u->tiley].owner();
        transform_buildings(z, u->color);  //captured player's buildings
        player[z].clear_units();           //go to the capturer
        player[z].playing = 0;
      }
      else
      {
        map.tile[u->tilex][u->tiley].change_owner(u->color);
      }
      minimap.create();
    }
  }
}

bool can_merge(_unit *a, _unit *b)
{
  int numloaded = 0;
  if ((a->health < 10) || (b->health < 10))
  {
    if (a->load[0].loaded == 1)
    {
      numloaded++;
    }
    if (a->load[1].loaded == 1)
    {
      numloaded++;
    }
    if (b->load[0].loaded == 1)
    {
      numloaded++;
    }
    if (b->load[1].loaded == 1)
    {
      numloaded++;
    }
    if (numloaded == 0)
    {
      return true;
    }
    if (numloaded == 1)
    {
      if ((a->type == APC) || (a->type == LANDER) || (a->type == T_COPTER))
      {
        return true;
      }
    }
    if (numloaded == 2)
    {
      if (a->type == LANDER)
      {
        return true;
      }
    }
  }
  return false;
}

void merge_units(_unit* merger, int tx, int ty)
{
  int u = unit_here_thorough(merger->color, tx, ty, merger->number);
  int h;
  _unit* mergee = &player[merger->color].unit[u];
  merger->gas += mergee->gas;
  if (merger->gas > 99)
  {
    merger->gas = 99;
  }
  merger->ammo += mergee->ammo;
  if (merger->ammo > 99)
  {
    merger->ammo = 99;
  }
  merger->health += float(rounded_health(mergee->health));
  if (merger->health > 10)
  {
    merger->health = 10;
  }
  merger->capturing = mergee->capturing;
  if (mergee->load[0].loaded == 1)
  {
    if (merger->load[0].loaded == 0)
    {
      merger->load[0] = mergee->load[0];
    }
    else
    {
      merger->load[1] = mergee->load[0];
    }
  }
  if (mergee->load[1].loaded == 1)
  {
    if (merger->load[0].loaded == 0)
    {
      merger->load[0] = mergee->load[1];
    }
    else
    {
      merger->load[1] = mergee->load[1];
    }
  }
  map.tile[tx][ty].set_unit(merger->color, merger->number);
  mergee->exists = 0;
}

void debug_savegame()
{

  int i, o, p;
  char path[10];
  char text[10];
  char name[20] = "";
  char t[35];
  _tile *tile;

  ofstream savefile("gamedebug.sav");
  if (!(savefile.bad()))
  {
    savefile << "Debuggery\n" << map.l << "\n" << map.h << "\n";
    o = 0;
    while (o < map.h)
    {
      p = 0;
      while (p < map.l)
      {
        tile = &map.tile[p][o];
        savefile << ((tile->get_set() * 100) + tile->get_number());
        if (p != map.l - 1)
        {
          savefile << " ";
        }
        p++;
      }
      savefile << "\n";
      o++;
    }
    o = 0;
    while (o < 4)
    {
      savefile << "playing " << player[o].playing << "\n";
      if (player[o].playing == 1)
      {
        savefile << "number " << player[o].number << "\n";
        savefile << "cash " << player[o].cash << "\n";
        savefile << "power " << player[o].power << "\n";
        savefile << "controller " << player[o].controller << "\n";
        savefile << "powered " << player[o].powered << "\n";
        savefile << "units " << player[o].units_in_play() << "\n";
        savefile << "team " << player[o].team << "\n";
      }
      p = 0;
      if (player[o].playing != 1)
      {
        p = 50;
      }
      while (p < 50)
      {
        if (player[o].unit[p].exists == 1)
        {
          savefile << "unittype " << player[o].unit[p].type << "\n";
          savefile << "unittilex " << player[o].unit[p].tilex << "\n";
          savefile << "unittiley " << player[o].unit[p].tiley << "\n";
          savefile << "unithealth " << player[o].unit[p].health << "\n";
          savefile << "unitammo " << player[o].unit[p].ammo << "\n";
          savefile << "unitgas " << player[o].unit[p].gas << "\n";
          savefile << "unitready " << player[o].unit[p].ready << "\n";
          savefile << "unitcapturing " << player[o].unit[p].capturing << "\n";
          savefile << "unitsubmerged " << player[o].unit[p].submerged << "\n";
          savefile << "unitload0loaded " << player[o].unit[p].load[0].loaded << "\n";
          savefile << "unitload0type " << player[o].unit[p].load[0].type << "\n";
          savefile << "unitload0health " << player[o].unit[p].load[0].health << "\n";
          savefile << "unitload0ammo " << player[o].unit[p].load[0].ammo << "\n";
          savefile << "unitload0gas " << player[o].unit[p].load[0].gas << "\n";
          savefile << "unitload0subloaded " << player[o].unit[p].load[0].subload.loaded << "\n";
          savefile << "unitload0subtype " << player[o].unit[p].load[0].subload.type << "\n";
          savefile << "unitload0subhealth " << player[o].unit[p].load[0].subload.health << "\n";
          savefile << "unitload0subammo " << player[o].unit[p].load[0].subload.ammo << "\n";
          savefile << "unitload0subgas " << player[o].unit[p].load[0].subload.gas << "\n";
          savefile << "unitload1loaded " << player[o].unit[p].load[1].loaded << "\n";
          savefile << "unitload1type " << player[o].unit[p].load[1].type << "\n";
          savefile << "unitload1health " << player[o].unit[p].load[1].health << "\n";
          savefile << "unitload1ammo " << player[o].unit[p].load[1].ammo << "\n";
          savefile << "unitload1gas " << player[o].unit[p].load[1].gas << "\n";
          savefile << "unitload1subloaded " << player[o].unit[p].load[1].subload.loaded << "\n";
          savefile << "unitload1subtype " << player[o].unit[p].load[1].subload.type << "\n";
          savefile << "unitload1subhealth " << player[o].unit[p].load[1].subload.health << "\n";
          savefile << "unitload1subammo " << player[o].unit[p].load[1].subload.ammo << "\n";
          savefile << "unitload1subgas " << player[o].unit[p].load[1].subload.gas << "\n";
        }
        p++;
      }
      o++;
    }
    savefile << "pturn " << pturn << "\n" << aiprofile << "\n";
    savefile << gameoptions.funding << "\n" << gameoptions.show_damage << "\n" << gameoptions.time << "\n" << t;
  }
  savefile.close();
}
