#include "empire.h"
#include "ranges.h"
#include "empai_path.h"

const int action_move    = 0;
const int action_attack  = 1;
const int action_capture = 2;
const int action_load    = 3;
const int action_unload1 = 4;
const int action_unload2 = 5;
const int action_standby = 6;
const int action_supply  = 7;
const int action_merge   = 8;

extern void apply_player_bonuses(float& basic, _unit *a, _unit *d);
extern void play_moving_sound(int utype);
extern void do_explodes();
extern void transform_buildings(int plyr, int plyr2);
extern void supply_units(_unit *u);
extern void draw_playerstats(int plyr);
extern void do_power();
extern void scroll_to_location(int x, int y);
extern void capture_building(_unit *u);
extern void merge_units(_unit *merger, int tx, int ty);
extern bool type_can_attack(_unit *a, _unit *d);
extern int basic_damage(int a, int d);
extern int defbonus(int tx, int ty);
extern int unit_here_thorough(int plyr, int tx, int ty, int ignore_n);
extern int do_battle(_unit *a, _unit *d);
extern int rounded_health(float h);
extern int get_tilenum(int mapdat);
extern int rounded_health(float h);
extern void show_movable_tiles(_unit *u);

extern string unit_name(int type);

typedef struct _action
{
  int type;
  _loc loc;
} _action;

_action action[3];

typedef struct _actionset
{
  _action action[3];
} _actionset;

typedef struct _buildorder
{
  int unit;
  float ratio;
} _buildorder;

bool enemy_threat(int plyr);
bool enemy_within_radius(int plyr, int center_x, int center_y, int r);
bool can_get_to_aitarget(_unit *a, _aitarget d);
void act(_unit *u, _action a);
void make_new_units(int plyr);
void set_best_path(_unit *u, int tx, int ty);
int get_damage_cost(_unit *a, _unit *d);
int any_unit_here(int tx, int ty);
int next_to_enemy(int plyr, int tx, int ty);
int needy(int unit_id);
int check_can_build(int plyr, int price[], int num[]);
int next_to_needy_friendly(int plyr, int tx, int ty);
int intmax(int a, int b);
int can_unload_from_here(int x, int y, int mountains);
float get_ratio(int i, int weight, int limit, int num);
_actionset ponder_action(_unit *u);
_aitarget best_target();
_aitarget aitarget_here(_unit *u, int tx, int ty);

_action reserve_action;
_loc target_loc;

int in_battle, atk, def;
_aibuild build[4][18];
vector<_unit*> lander;
vector<_unit*> need_transport;
vector<_loc> base;
vector<_aitarget> targets;
_loc capital;
vector<_aitarget> list_targets(_unit *u);
extern vector<_connectedlocs> beaches;

void check_capturing(_unit *u);
void check_attackable_units(_unit *u);
void check_low_health(_unit *u);
void check_closest_capturable(_unit *u);
void check_closest_attackable(_unit *u);
void check_APC_options(_unit *u);
void check_tcopter_options(_unit *u);
void check_lander_options(_unit *u);
void check_blocking_base(_unit *u);
void check_convenient_APC(_unit *u);
void check_available_copter(_unit *u);
void check_enemy_bases(_unit *u);
void check_available_lander(_unit *u);
void check_unload(_unit *u, _loc targetbeach);

int do_ai(int plyr)
{
  static int first = 1;
  static int i = 0;
  static int anum = 0;
  static int t = 0;
  static _actionset a;
  static int draw_stats, last_statpos;
  static int initial_delay, unit_delay;
  int t1, t2, t3, t4;
  int unit_moving;
  int powerflash = 0;
  _tile *thetile;
  _loc temploc;
  if (first == 1)
  {
    lander.clear();
    need_transport.clear();
    player[plyr].sort_units();    
    i = 0;
    while (i < 50)
    {
      if (player[plyr].unit[i].exists == 1)
      {
        if (player[plyr].unit[i].type == LANDER)
        {  //this creates a vector of pointers to landers, handy later on
          lander.push_back(&player[plyr].unit[i]);
        }
      }
      i++;
    }
    t2 = 0;
    while (t2 < map.h)
    {
      t1 = 0;
      while (t1 < map.l)
      {
        thetile = &map.tile[t1][t2];
        if (thetile->owned_by(plyr))
        {
          if (thetile->is_unit_producing())
          {  //if it belongs to the player and produces units
            temploc.x = t1;
            temploc.y = t2;
            base.push_back(temploc);  //create a vector of base locations
          }
          else if (thetile->is_HQ())
          {  //mark the location of the player's HQ
            capital.x = t1;
            capital.y = t2;
          }
        }
        t1++;
      }
      t2++;
    }
    i = 0;
    t = 0;
    first = 0;
    anum = -2;
    in_battle = 0;
    atk = -1;
    def = -1;
    draw_stats = 0;
    last_statpos = -1;
    initial_delay = 0;
    scroll_to_location(capital.x, capital.y);
    if (player[plyr].power == 1000)
    {
      if (character[player[pturn].number].power != 4)
      {  //if the power is not the "refresh units" one
        player[plyr].powered = 1;
        player[plyr].power = 0;
        do_power();
        powerflash = 1;  //start the power animation
        play_sound(BLAST);
      }
    }
    counter = 0;
  }
  if (initial_delay < 15)
  {  //have a little delay before the units start doing stuff
    initial_delay++;
  }
  else if (in_battle == 0)
  {
    do_explodes();
    draw_playerstats(plyr + (draw_stats * 10));  //see draw_playerstats for details on this
    if (i < 50)
    {
      _unit *z = &player[plyr].unit[i];
      if (z->exists == 1)
      {
        if (z->ready == 1)
        {
          if (unit_delay < 15)
          {  //have a little delay between units as well
            unit_delay++;
          }
          else if (anum == -2)
          {
            scroll_to_location(z->tilex, z->tiley);  //focus on the unit
            map.create_pathmap(plyr, z->movetype, z->tilex, z->tiley);
            show_movable_tiles(z);
            counter = 0;  //reset the counter, since creating the pathmap might take a while
            t1 = (z->tilex - map.scroll_x) * 40;
            t2 = (z->tiley - map.scroll_y) * 40;
            switch(z->color)
            {
              case 0:
                t3 = ORANGE;
                break;
              case 1:
                t3 = BLUE;
                break;
              case 2:
                t3 = GREEN;
                break;
              case 3:
                t3 = YELLOW;
                break;
            }  //draw a rectangle around the unit, colored the same as the unit's team
            rect(back_buffer, t1 + 1, t2 + 1, t1 + 39, t2 + 39, t3);
            anum = -1;
          }
          else if (anum == -1)
          {  //if it is the first action for the unit, find good actions to do
            show_movable_tiles(z);
            targets.resize(0);
            a = ponder_action(z);
            anum = 0;
            t = 0;
            counter = 0;  //this may have taken a while, but nothing happened on
          }               //screen, so just set the counter like it took no time
          else if (t < 25)  //the unit's range is displayed for 25 logic loops (.5 seconds)
          {  //in other words, it shows the range while thinking, then pauses before acting
            show_movable_tiles(z);
            z->draw(false);
            t++;
            if (t == 25)
            {  //if it has finished with the pause, clear the range from the screen
              if (z->tilex - map.scroll_x < 4)
              {
                draw_stats = 2;
              }
              else
              {
                draw_stats = 1;
              }
            }
          }
          else
          {
            if (!z->is_moving())
            {  //if the unit has is finished with an action or starting the first
              switch(anum)
              {
                case 0:
                case 1:
                case 2:
                  act(&player[plyr].unit[i], a.action[anum]);
                  anum++;
                  if (z->exists == 0)
                  {  //if a battle or being loaded into a transport causes it to disappear
                    z->ready = 0;
                    anum = -2;
                    t = 0;
                  }
                  break;
                case 3:  //if the final action has just been done, this unit is finished
                  z->ready = 0;
                  anum = -2;
                  t = 0;
                  break;
              }
            }
            else
            {
              z->do_movement();
              z->draw();
            }
          }
        }
        else  //if the unit is not ready, go to the next one
        {
          i++;
          unit_delay = 0;
        }
      }
      else  //if the unit does not exist, go to the next one
      {
        i++;
        unit_delay = 0;
      }
    }
    if ((i == 50))// && (z.ready != 1))  //if it has just finished with the 50th unit
    {
      if (player[plyr].power == 1000)
      {
        if (character[player[pturn].number].power == 4)
        {  //if the power is the "refresh units" one
          player[plyr].powered = 1;
          player[plyr].power = 0;
          do_power();
          powerflash = 1;  //start the power animation
          play_sound(BLAST);
          i = 0;  //go back through all the units
        }
      }
      if (t == 0)
      {
        make_new_units(plyr);
        counter = 0;  //this also tends to take a while, but has no on-screen effect
        t++;
      }
      else if (t < 35)
      {  //pause for a little over half a second after the units are made
        t++;
      }
      else
      {
        first = 1;
        t = 0;
        set_mouse_range(0, 0, 639, 479);
        return 1;  //indicate that it is done
      }
    }
  }
  else  //if there is a battle animation going on
  {
    t1 = atk / 100;
    t2 = atk % 100;
    t3 = def / 100;
    t4 = def % 100;
    in_battle = do_battle(&player[t1].unit[t2], &player[t3].unit[t4]);
    return 0;
  }
  if (powerflash != 1)
  {
    return 0;  //indicate that it is not finished
  }
  else
  {
    return 10;
  }
}

_actionset ponder_action(_unit *u)
{
  _actionset aset;
  _loc d;
  _aitarget t;
  int temp1, temp2, temp3, temp4;
  action[0].type = action_standby;
  action[0].loc.x = -1;
  action[0].loc.y = -1;
  action[1].type = action_standby;
  action[1].loc.x = -1;
  action[1].loc.y = -1;
  action[2].type = action_standby;  //third action only used for unloading landers
  action[2].loc.x = -1;
  action[2].loc.y = -1;
  reserve_action.type = action_standby;
  target_loc.x = -1;
  target_loc.y = -1;
  ofstream debug("time.txt", ios::app);
  debug << "Unit type: " << unit_name(u->type) << "\n";
  debug << "Start time: " << counter << "\n";
  debug.flush();
  targets = list_targets(u);
  check_capturing(u);
  check_attackable_units(u);
  check_low_health(u);
  if (action[0].type == action_standby)
  {  //if it didn't capture, doesn't need to get fixed, and can't attack this turn
    if ((u->type == INFANTRY) || (u->type == MECH))
    {  //if it can capture things, head for the closest capturable building
      check_closest_capturable(u);
    }
    if ((u->type != APC) && (u->type != T_COPTER) && (u->type != LANDER))
    {
      if (action[0].type == action_standby)
      {
        check_closest_attackable(u);
      }
    }
    else if (u->type == APC)
    {
      check_APC_options(u);
    }
    else if (u->type == T_COPTER)
    {
      check_tcopter_options(u);
    }
    else
    {  //if the unit is a lander
      check_lander_options(u);
    }
  }
  if ((u->type == INFANTRY) || (u->type == MECH))
  {
    check_convenient_APC(u);
    if (action[0].type == action_standby)
    {
      check_available_copter(u);
    }
  }
  if ((action[0].type == action_standby) && (reserve_action.type == action_standby))
  {  //if there are no enemies to attack or anything else to do, cover an enemy base
    check_enemy_bases(u);
  }
  if ((u->basetype == LAND) && (action[0].type == action_standby))
  {  //check for a lander if the unit can't do anything and could be moved in a lander
    check_available_lander(u);
  }
  if (action[0].type == action_standby)
  {  //make sure it isn't preventing other units from being built
    if (reserve_action.type != action_standby)
    {  //if it found a location to move to, but it was very far away
      action[0] = reserve_action;  //move to it now, since there were no transports
    }
    else
    {
      check_blocking_base(u);
    }
  }
  if ((u->type != APC) && (u->type != LANDER) && (u->type != T_COPTER))
  {  //if it isn't a transport
    if (u->basetype == LAND)
    {
      if (action[0].type == action_standby)
      {  //if it still isn't doing anything
        need_transport.push_back(u);
      }
    }
  }
  debug << "End time: " << counter << "\n\n";
  aset.action[0] = action[0];
  aset.action[1] = action[1];
  aset.action[2] = action[2];
  return aset;
}

void act(_unit *u, _action a)
{
  int i;
  int q;
  switch(a.type)
  {
    case action_move:
      if ((u->tilex != a.loc.x) || (u->tiley != a.loc.y))
      {  //a crash safeguard: units don't move if they're already at the destination
        if ((a.loc.x != -1) && (a.loc.y != -1))
        {
          set_best_path(u, a.loc.x, a.loc.y);
          play_moving_sound(u->type);
          u->do_movement();
        }
        else
        {  //move should never be called for location (-1, -1), so log this error
          ofstream debug("movement_error.txt", ios::app);
          debug << "A " << unit_name(u->type).c_str() << " unit at (" << u->tilex;
          debug << ", " << u->tiley << ") tried to move to point (-1, -1).\n\n";
        }
      }
      break;
    case action_attack:
      in_battle = 1;
      def = any_unit_here(a.loc.x, a.loc.y);
      atk = (u->color * 100) + u->number;
      break;
    case action_capture:
      capture_building(u);
      break;
    case action_load:
      q = unit_here_thorough(u->color, u->tilex, u->tiley, u->number);
      player[u->color].unit[q].load_unit(u);      
      map.tile[u->tilex][u->tiley].set_unit(u->color, q);
      player[u->color].unit[u->number].exists = 0;
      break;
    case action_unload1:
      u->load[0].loaded = 0;
      i = player[u->color].create_unit(u->load[0].type, a.loc.x, a.loc.y, u->color);
      player[u->color].unit[i].gas = u->load[0].gas;
      player[u->color].unit[i].ammo = u->load[0].ammo;
      player[u->color].unit[i].health = u->load[0].health;
      if (u->load[0].subload.loaded == 1)
      {
        player[u->color].unit[i].load[0].loaded = 1;
        player[u->color].unit[i].load[0].type = u->load[0].subload.type;
        player[u->color].unit[i].load[0].gas = u->load[0].subload.gas;
        player[u->color].unit[i].load[0].ammo = u->load[0].subload.ammo;
        player[u->color].unit[i].load[0].health = u->load[0].subload.health;
        u->load[0].subload.loaded = 0;
      }
      break;
    case action_unload2:
      u->load[1].loaded = 0;
      i = player[u->color].create_unit(u->load[1].type, a.loc.x, a.loc.y, u->color);
      player[u->color].unit[i].gas = u->load[1].gas;
      player[u->color].unit[i].ammo = u->load[1].ammo;
      player[u->color].unit[i].health = u->load[1].health;
      if (u->load[1].subload.loaded == 1)
      {
        player[u->color].unit[i].load[0].loaded = 1;
        player[u->color].unit[i].load[0].type = u->load[1].subload.type;
        player[u->color].unit[i].load[0].gas = u->load[1].subload.gas;
        player[u->color].unit[i].load[0].ammo = u->load[1].subload.ammo;
        player[u->color].unit[i].load[0].health = u->load[1].subload.health;
        u->load[1].subload.loaded = 0;
      }      
      break;
    case action_standby:
      break;  //do nothing on standby
    case action_supply:
      supply_units(u);
      break;
    case action_merge:
      merge_units(u, u->tilex, u->tiley);
      break;
  }
}

void check_capturing(_unit *u)
{
  _loc d;
  if ((u->type != INFANTRY) && (u->type != MECH))
  {
    return;
  }
  if (u->capturing != -1)  //if it is already capturing some building
  {
    action[0].type = action_capture;
    action[0].loc.x = u->tilex;
    action[0].loc.y = u->tiley;
  }
  else
  {
    d = capturable_building(u);
    if (d.x != -1)  //if there is a capturable building in range
    {
      if ((d.x == u->tilex) && (d.y == u->tiley))
      {  //if it is already on the capturable building
        action[0].type = action_capture;
        action[0].loc = d;
      }
      else
      {  //if not, move there
        action[0].type = action_move;
        action[0].loc = d;
        action[1].type = action_capture;
        action[1].loc = d;
      }
    }
  }
}

void check_attackable_units(_unit *u)
{
  _aitarget t;
  _loc d;
  if ((action[0].type != action_standby) || (u->attacktype == -1))
  {  //if the unit is capturing or can't attack at all
    return;
  }
  t = best_target();
  if (u->attacktype == RANGED)
  {
    if (t.type != -1)  //if a target has been found, the unit will attack
    {
      action[0].type = action_attack;
      action[0].loc = t.loc;
    }
  }
  else  //a direct attacker
  {
    if (t.type != -1)
    {
      d = loc_to_attack(u, t);
      if ((u->tilex == d.x) && (u->tiley == d.y))
      {  //if the unit is already in the best position to attack
        action[0].type = action_attack;
        action[0].loc = t.loc;
      }
      else
      {
        if (d.x != -1)
        {
          action[0].type = action_move;
          action[0].loc = d;
          action[1].type = action_attack;
          action[1].loc = t.loc;
        }
      }
    }
  }
}

void check_low_health(_unit *u)
{
  _loc d;
  if (action[0].type != action_standby)
  {  //if it's attacking something, never mind low health
    return;
  }
  if ((u->health < 7) || (u->gas < 15) || ((u->ammo < 3) && (u->attacktype != -1)))
  {  //if the unit has taken serious damage or is low on gas or ammo (and can attack)
    d = closest_free_building(u->color, u->number, u->movetype, u->move, u->basetype, u->tilex, u->tiley);
    if (d.x != -1)  //if there is a free friendly building, head for it
    {
      if ((d.x != u->tilex) || (d.y != u->tiley))
      {  //if it isn't already sitting on the best place
        action[0].type = action_move;
        action[0].loc = d;
      }
    }
    if (u->health < 5)
    {  //if the unit is very low on health, look for a merge instead
      d = unhealthy_unit_nearby(u, u->tilex, u->tiley);
      if (d.x != -1)
      {
        action[0].type = action_move;
        action[0].loc = d;
        action[1].type = action_merge;
        action[1].loc = d;
      }
    }
  }
}

void check_closest_capturable(_unit *u)
{  //assumes the unit can capture buildings
  int real_move = u->move;
  if (real_move > u->gas)
  {
    real_move = u->gas;
  }
  target_loc.x = -1;
  target_loc.y = -1;
  _loc d = closest_move_to_enemy_building(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley, 1);
  if (d.x != -1)
  {
    if ((d.x != u->tilex) || (d.y != u->tiley))
    { //if the closest move is not where it already is
      action[0].type = action_move;
      action[0].loc = d;
      if (target_loc.x == -1)
      {
        ofstream err("movement_error.txt", ios::app);
        err << "target_loc.x was -1 in check_closest_capturable() for ";
        err << unit_name(u->type) << "unit at (" << u->tilex << ", " << u->tiley << ")\n\n";
        err.close();
      }
      else if (map.tile[target_loc.x][target_loc.y].get_step() > u->move * 12)
      {  //if the destination is REALLY FAR AWAY
        reserve_action = action[0];
        action[0].type = action_standby;
      }
    }
  }
}

void check_closest_attackable(_unit *u)
{  //assumes the unit can attack
  _loc d;
  d.x = -1;
  d.y = -1;
  int real_move;
  real_move = u->move;
  target_loc.x = -1;
  target_loc.y = -1;
  if (u->gas < real_move)
  {
    real_move = u->gas;
  }
  if (u->attacktype == DIRECT)
  {  //if it is a direct attacker, head for the nearest enemy unit
    d = closest_move_to_enemy_unit(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley);
    if (d.x != -1)
    {
      if ((d.x != u->tilex) || (d.y != u->tiley))
      { //if the closest move is not where it already is
        action[0].type = action_move;
        action[0].loc = d;
      }
    }
    else  //no enemy units, head for nearest enemy base
    {
      d = closest_move_to_enemy_building(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley, 0);
      if (d.x != -1)
      {
        if ((d.x != u->tilex) || (d.y != u->tiley))
        { //if the closest move is not where it already is
          action[0].type = action_move;
          action[0].loc = d;
        }
      }
    }
  }
  else
  {  //if it is a ranged attacker
    d = loc_for_ranged_attack(u, u->tilex, u->tiley, get_rangemin(u->type), get_rangemax(u->type));
    if (d.x != -1)
    {
      d = closest_move_to_destination(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley, d.x * 100 + d.y, 0);
    }
    else
    {
      d = closest_move_to_enemy_unit(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley);
    }
    if (d.x != -1)
    {  
      if ((d.x != u->tilex) || (d.y != u->tiley))
      { //if the closest move is not where it already is
        action[0].type = action_move;
        action[0].loc = d;
      }
    }
  }
  if (action[0].type != action_standby)
  {
    if (target_loc.x == -1)
    {
      ofstream err("movement_error.txt", ios::app);
      err << "target_loc.x was -1 in check_closest_attackable() for ";
      err << unit_name(u->type) << "unit at (" << u->tilex << ", " << u->tiley << ")\n\n";
      err.close();
    }
    else if (map.tile[target_loc.x][target_loc.y].get_step() > u->move * 12)
    {  //if location is really far away
      reserve_action = action[0];
      action[0].type = action_standby;
    }
  }
}

void check_APC_options(_unit *u)
{
  _loc d;
  int real_move = u->move;
  int x, y;
  if (real_move > u->gas)
  {
    real_move = u->gas;
  }
  if (u->load[0].loaded == 1)
  {  //if it's carrying a unit
    d = closest_move_to_enemy_building(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley, 1);
    if (d.x != -1)
    {  //if it can get to an enemy building
      x = d.x;
      y = d.y;
      d = closest_move_to_destination(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley, (x * 100) + y, 1);
      if (d.x != -1)
      {
        action[0].type = action_move;
        action[0].loc = d;
        if (tile_distance(d.x, d.y, x, y) == 1)
        {  //if the final move brings it one move away from the building
          action[1].type = action_unload1;
          action[1].loc.x = x;
          action[1].loc.y = y;
       }
      }
    }
    else
    {  //it can't get to a building, so go for an enemy unit instead
      d = closest_move_to_enemy_unit(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley);
      if (d.x != -1)
      {
        x = d.x;
        y = d.y;
        d = closest_move_to_destination(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley, (x * 100) + y, 2);
        if (d.x != -1)
        {
          action[0].type = action_move;
          action[0].loc = d;
        }
      }
    }
    if (action[1].type == action_standby)
    {  //try to unload whenever it has something loaded
      if (action[0].type == action_move)
      {
        d = unloadable_point(action[0].loc.x, action[0].loc.y, 1);
      }
      else
      {
        d = unloadable_point(u->tilex, u->tiley, 1);
      }
      if (d.x != -1)
      {
        if (action[0].type == action_standby)
        {
          action[0].type = action_unload1;
          action[0].loc = d;
        }
        else
        {
          action[1].type = action_unload1;
          action[1].loc = d;
        }
      }
    }
  }
  else
  {  //if not loaded, resupply any units that need it
    d = closest_move_to_needy_friendly(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley);
    if (d.x != -1)
    {
      if ((d.x != u->tilex) || (d.y != u->tiley))
      {
        action[0].type = action_move;
        action[0].loc = d;
        if (next_to_needy_friendly(u->color, d.x, d.y) == 1)
        {
          action[1].type = action_supply;
          action[1].loc = d;
        }
      }
      else
      {
        action[0].type = action_supply;
        action[0].loc = d;
      }
    }
  }
  if (action[1].type == action_standby)
  {  //if doing nothing, resupply whatever friendly units are around
    d.x = u->tilex;
    d.y = u->tiley;
    action[1].type = action_supply;
    action[1].loc = d;
  }
}

void check_tcopter_options(_unit *u)
{
  _loc d, t;
  int x, y, real_move;
  bool repeat = true;
  bool repeated = false;
  d.x = -1;
  d.y = -1;
  real_move = u->move;
  if (real_move > u->gas)
  {
    real_move = u->gas;
  }
  if (u->load[0].loaded != 0)
  {  //if the copter has a passenger
    d = nearest_enemy_building(u->color, u->tilex, u->tiley);
  }
  else
  {
    y = 0;
    x = 999;
    while (y < need_transport.size())
    {      
      if ((need_transport[y]->type == INFANTRY) || (need_transport[y]->type == MECH))
      {
        t = best_copter_adjacent_space(need_transport[y]->tilex, need_transport[y]->tiley);
        if (t.x != -1)
        {
          if (map.tile[t.x][t.y].get_step() < x)
          {
            x = map.tile[t.x][t.y].get_step();
            d = t;
          }
        }
      }
      y++;
    }
  }
  while (repeat == true)
  {
    x = d.x;
    y = d.y;
    if (any_unit_here(x, y) == -1)
    {  //if the target space is empty
      repeat = false;
      if (u->load[0].loaded == 1)
      {
        d = closest_move_to_destination(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley, (d.x * 100) + d.y, 1);
      }
      else
      {
        d = closest_move_to_destination(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley, (d.x * 100) + d.y, 0);
      }
      if (d.x != -1)
      {
        action[0].type = action_move;
        action[0].loc = d;
        if ((tile_distance(x, y, d.x, d.y) == 1) && (u->load[0].loaded == 1))
        {  //if the move takes it to one away from the carried unit's target
          action[1].type = action_unload1;
          action[1].loc.x = x;
          action[1].loc.y = y;
        }
      }
      else
      {
        if ((tile_distance(x, y, u->tilex, u->tiley) == 1) && (u->load[0].loaded == 1))
        {  //if it is already one away from the carried unit's target
          action[0].type = action_unload1;
          action[0].loc.x = x;
          action[0].loc.y = y;
        }
      }
    }
    else
    {  //if there is a unit on that space
      if (repeated == true)
      {
        repeat = false;
      }
      repeated = true;
      d = a_free_space(u, x, y);
    }
  }
}

void check_lander_options(_unit *u)
{
  bool to_enemy = false;
  int capper = 0;
  int i, t, dist;
  _loc d, targetbeach;
  targetbeach.x = -1;
  targetbeach.y = -1;
  dist = 999;
  if ((u->load[0].loaded == 1) || (u->load[1].loaded == 1))
  {  //if it has a passenger
    if ((u->load[0].loaded == 1) && (u->load[1].loaded == 1))
    {  //if it is full
      to_enemy = true;
    }
    if (to_enemy == true)
    {
      capper = 0;
      if (u->load[0].loaded == 1)
      {
        if ((u->load[0].type == INFANTRY) || (u->load[0].type == MECH))
        {
          capper = 1;
        }
      }
      if (u->load[1].loaded == 1)
      {
        if ((u->load[1].type == INFANTRY) || (u->load[1].type == MECH))
        {
          capper = 1;
        }
      }
      d = closest_enemy_beach(u->color, u->tilex, u->tiley, capper);
      if (d.x != -1)
      {
        targetbeach = d;
      }
    }
    else  //if it doesn't have both slots filled
    {  //check to see if it's on enemy territory
      i = M_TREAD;
      capper = 0;
      if (u->load[0].loaded == 1)
      {
        if ((u->load[0].type == INFANTRY) || (u->load[0].type == MECH))
        {
          capper = 1;
          i = M_MECH;
        }
      }
      if (u->load[1].loaded == 1)
      {
        if ((u->load[1].type == INFANTRY) || (u->load[1].type == MECH))
        {
          capper = 1;
          i = M_MECH;
        }
      }
      d = reachable_enemy_building(u->color, i, u->tilex, u->tiley, capper);
      if (d.x != -1)
      {  //if it is (so it maybe could only unload one unit last turn), unload now
        d.x = u->tilex;
        d.y = u->tiley;
        check_unload(u, d);
      }
    }
  }
  else
  {  //no passengers, find the closest unit in need of transportation
    i = 0;
    while (i < need_transport.size())
    {
      if (need_transport[i]->basetype == LAND)
      {
        d = closest_beach_for_lander(u->color, need_transport[i]->tilex, need_transport[i]->tiley, u);
        if (d.x != -1)
        {
          if (map.tile[d.x][d.y].get_step() < dist)
          {
            targetbeach = d;
            dist = map.tile[d.x][d.y].get_step();
          }
        }
      }
      i++;
    }
  }
  if (targetbeach.x != -1)
  {
    t = (targetbeach.x * 100) + targetbeach.y;
    d = closest_move_to_destination(u->color, u->number, M_LANDER, u->move, u->tilex, u->tiley, t, 0);
    if (d.x != -1)
    {
      action[0].type = action_move;
      action[0].loc = d;
      if ((d.x == targetbeach.x) && (d.y == targetbeach.y))
      {  //if it reaches its destination at the end of the move
        check_unload(u, targetbeach);
      }
    }
  }
}

void check_unload(_unit *u, _loc targetbeach)
{
  int actnum = 1;
  _loc d;
  if (u->load[0].loaded == 1)
  {
    if ((u->load[0].type == INFANTRY) || (u->load[0].type == MECH))
    {
      d = unloadable_point(targetbeach.x, targetbeach.y, 1);
    }
    else
    {
      d = unloadable_point(targetbeach.x, targetbeach.y, 0);
    }
    if (d.x != -1)
    {
      action[actnum].type = action_unload1;
      action[actnum].loc = d;
      actnum++;
    }
  }
  if (u->load[1].loaded == 1)
  {
    if (actnum == 1)
    {  //if there wasn't a unit in load[0]
      d.x = -1;
      d.y = -1;
    }
    if ((u->load[1].type == INFANTRY) || (u->load[1].type == MECH))
    {
      d = unloadable_point(targetbeach.x, targetbeach.y, 1, d);
    }
    else
    {
      d = unloadable_point(targetbeach.x, targetbeach.y, 0, d);
    }
    if (d.x != -1)
    {
      action[actnum].type = action_unload2;
      action[actnum].loc = d;
    }
  }
}

void check_blocking_base(_unit *u)
{
  _loc d;
  if (friendly_unit_maker_here(u->tilex, u->tiley, u->color) == true)
  {
    if (u->type != LANDER)
    {  //unless the unit's a lander, move off the unit-producing building
      d = a_free_space(u, u->tilex, u->tiley);
      if (d.x != -1)
      {
        action[0].type = action_move;
        action[0].loc = d;
      }
    }
    else
    {  //if it's a lander, move to a reachable friendly beach or stay at port
      d = reachable_friendly_beach(u->color, u->number, u->tilex, u->tiley, u->move);
      if (d.x != -1)
      {
        action[0].type = action_move;
        action[0].loc = d;
      }
    }
  }
}

void check_convenient_APC(_unit *u)
{
  int x, y, real_move, z;
  _loc d;
  real_move = u->move;
  if (real_move > u->gas)
  {
    real_move = u->gas;
  }
  if (((action[0].type == action_move) && (action[1].type == action_standby)) || (action[0].type == action_standby))
  {  //if it isn't moving, or moving somewhere but not doing anything when at the destination
    d = empty_APC_nearby(u, real_move);
    if (d.x != -1)
    {  //if there is an empty APC reachable this turn
      action[0].type = action_move;
      action[0].loc = d;
      action[1].type = action_load;
      action[1].loc = d;
    }
  }
}

void check_available_copter(_unit *u)
{
  _loc d;
  int z, real_move;
  real_move = u->move;
  if (real_move > u->gas)
  {
    real_move = u->gas;
  }
  d = closest_move_to_empty_copter(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley);
  if (d.x != -1)
  {  //if there is an empty T-Copter available
    action[0].type = action_move;
    action[0].loc = d;
    z = unit_here_thorough(u->color, d.x, d.y, u->number);
    if (z != -1)
    {  //if there is a unit at the final move point, it must be the copter
      action[1].type = action_load;
      action[1].loc = d;
    }
  }
}

void check_enemy_bases(_unit *u)
{
  int real_move = u->move;
  _loc d;
  if (real_move > u->gas)
  {
    real_move = u->gas;
  }
  if ((u->attacktype == DIRECT) || (u->attacktype == RANGED))
  {  //if it isn't an APC
    d = reachable_enemy_building(u->color, u->movetype, u->tilex, u->tiley, 0, 1);
    if (d.x != -1)
    {  //if there are enemy unit-producing buildings nearby
      d = closest_move_to_destination(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley, (d.x * 100) + d.y, 0);
      if (d.x != -1)
      {
        action[0].type = action_move;
        action[0].loc = d;
        if (map.tile[d.x][d.y].get_step() > u->move * 12)
        {  //if the target location is really far away
          reserve_action = action[0];
          action[0].type = action_standby;
        }
      }
    }
  }
}

void check_available_lander(_unit *u)
{
  int real_move = u->move;
  int z;
  _loc d;
  if (real_move > u->gas)
  {
    real_move = u->gas;
  }
  target_loc.x = -1;
  target_loc.y = -1;
  if ((u->type != APC) || (action[0].type == action_unload1))
  {  //if it isn't an APC, or is an APC with a unit loaded into it
    d = closest_move_to_available_lander(u->color, u->number, u->movetype, real_move, u->tilex, u->tiley);
    if (d.x != -1)
    {  //if there is an empty lander available
      action[0].type = action_move;
      action[0].loc = d;
      z = unit_here_thorough(u->color, d.x, d.y, u->number);
      if (z != -1)
      {  //if there is a unit at the final move point, it must be the lander
        action[1].type = action_load;
        action[1].loc = d;
      }
    }
  }
}

void set_best_path(_unit *u, int tx, int ty)
{
  int i, q;
  vector<int> list;
  list.reserve(10);
  vector<_aipath> t = best_aipath(u->color, u->movetype, u->tilex, u->tiley, tx, ty);
  q = t.size();
  i = 0;
  while (i < q)
  {
    list.push_back(t[i].dir);
    i++;
  }
  u->set_moves(list);
}

void make_new_units(int plyr)
{
  static int price[18];
  static int first = 1;
  int i, j, min, built_unit, z;
  int can_build;
  bool conserve_money = false;
  vector<_buildorder> order;
  _buildorder temp;
  _unit t;
  _loc l;
  int num[18];
  if (first == 1)
  {
    i = 0;
    while (i < 18)
    {
      t.create(i, -1, -1, -1, -1);
      price[i] = t.price;
      i++;
    }
    first = 0;
  }
  i = 0;
  while (i < 18)
  {
    num[i] = 0;
    i++;
  }
  order.resize(18);
  i = 0;
  while (i < 50)
  {  //this loop finds how many units of each type the player has on the field
    if (player[plyr].unit[i].exists == 1)
    {
      num[player[plyr].unit[i].type]++;
    }
    i++;
  }
  can_build = check_can_build(plyr, price, num);
  while (can_build == 1)
  {
    i = 0;
    while (i < 18)
    {
      order[i].unit = i;
      order[i].ratio = get_ratio(i, build[aiprofile][i].weight, build[aiprofile][i].limit, num[i]);
      i++;
    }
    i = 0;
    while (i < order.size() - 1)
    {  //arrange order in order of smallest ratio to largest
      min = i;
      j = i;
      while (j < order.size())
      {
        if (order[j].ratio < order[min].ratio)
        {
          min = j;
        }
        j++;
      }
      if (min != i)
      {
        temp = order[i];
        order[i] = order[min];
        order[min] = temp;
      }
      i++;
    }
    built_unit = -1;
    i = 0;
    while ((built_unit == -1) && (conserve_money == false))
    {
      if (price[order[i].unit] <= player[plyr].cash)
      {  //if the player can afford the unit
        if (num[i] <= build[aiprofile][i].limit)
        {  //if there aren't already too many of that type
          l = open_build_loc(plyr, order[i].unit);
          if (l.x != -1)  //if there is a building that can make this unit
          {
            z = player[plyr].create_unit(order[i].unit, l.x, l.y, plyr);
            player[plyr].cash -= price[order[i].unit];
            built_unit = order[i].unit;
          }
        }
      }
      else
      {  //if the player can't afford the unit
        if (num[i] <= build[aiprofile][i].limit)
        {  //if it hasn't hit the limit for this unit type
          l = open_build_loc(plyr, order[i].unit);
          if (l.x != -1)
          {  //if there is an open build location for the unit
            if (enemy_threat(plyr) == false)
            {  //if the enemy is far away, build up cash for a better unit
              conserve_money = true;
              if (num[INFANTRY] + num[MECH] < 4)
              {  //unless there are few or no building cappers
                l = open_build_loc(plyr, INFANTRY);
                if (l.x != -1)
                {  //and if an infantry or mech could be built
                  if (player[plyr].cash >= price[MECH])
                  {  //build a mech
                    conserve_money = false;
                    z = player[plyr].create_unit(MECH, l.x, l.y, plyr);
                    player[plyr].cash -= price[MECH];
                    built_unit = MECH;                    
                  }
                  else if (player[plyr].cash >= price[INFANTRY])
                  {  //or an infantry, depending on the financial situation
                    conserve_money = false;
                    z = player[plyr].create_unit(INFANTRY, l.x, l.y, plyr);
                    player[plyr].cash -= price[INFANTRY];
                    built_unit = INFANTRY;
                  }
                }
              }
            }
          }
        }
      }
      i++;
    }
    if (conserve_money == false)
    {
      num[built_unit]++;  //increase unit counter to include new build
      can_build = check_can_build(plyr, price, num);
    }
    else
    {
      can_build = 0;
    }
  }
}

int check_can_build(int plyr, int price[], int num[])
{
  int i = 0;
  _loc l;
  if (player[plyr].units_in_play() >= 50)
  {  //if the player has reached the unit limit
    return 0;
  }
  while (i < 18)
  {  //for every type of unit:
    if (num[i] < build[aiprofile][i].limit)
    {  //if the limit for this unit hasn't been reached
      if (price[i] <= player[plyr].cash)
      {  //if the player can afford the unit
        l = open_build_loc(plyr, i);
        if (l.x != -1)
        {  //if there is a building that can build the unit this turn
          return 1;  //then the player can build
        }
      }
    }
    i++;
  }
  return 0;
}


float get_ratio(int i, int weight, int limit, int num)
{
  float r = 100;
  if ((weight > 0) && (limit > num))
  {  //the lower the ratio, the higher the build priority
    r = float(num + 1) / float(weight);
  }  //if the weight is 0 or the limit is reached, the ratio stays at 100;
  return r;
}

vector<_aitarget> list_targets(_unit *u)
{
  _aitarget t;
  int x, y, min, max, dist;
  vector<_aitarget> a;
  a.resize(0);
  if (u->attacktype == DIRECT)
  {
    y = u->tiley - u->move - 1;
    if (y < 0) y = 0;
    while ((y <= u->tiley + u->move + 1) && (y < map.h))
    {
      x = u->tilex - u->move - 1;
      if (x < 0) x = 0;
      while ((x <= u->tilex + u->move + 1) && (x < map.l))
      {
        t = aitarget_here(u, x, y);
        if (t.type != -1)
        {  //if there is a viable target here
          if (can_get_to_aitarget(u, t))
          {  //even if the unit is in range, it may not be attackable due to other units
            a.push_back(t);
          }
        }
        x++;
      }
      y++;
    }
  }
  else if (u->attacktype == RANGED)
  {
    min = get_rangemin(u->type);
    max = get_rangemax(u->type);
    y = u->tiley - max;
    if (y < 0) y = 0;
    while ((y <= u->tiley + max) && (y < map.h))
    {
      x = u->tilex - max;
      if (x < 0) x = 0;
      while ((x <= u->tilex + max) && (x < map.l))
      {
        dist = tile_distance(u->tilex, u->tiley, x, y);
        if ((dist >= min) && (dist <= max))
        {  //make sure the location to be checked is in firing range
          t = aitarget_here(u, x, y);
          if (t.type != -1)  //if there is a viable target here
          {
            a.push_back(t);
          }
        }
        x++;
      }
      y++;
    }
  }
  return a;
}

_aitarget best_target()
{
  _aitarget best;
  best.damage_cost = 0;
  best.type = -1;
  int i = 0;
  int s = targets.size();
  while (i < s)
  {
    if (targets[i].damage_cost > best.damage_cost)
    {
      best = targets[i];
    }
    i++;
  }
  return best;
}

_aitarget aitarget_here(_unit *u, int tx, int ty)
{
  _aitarget p;
  _unit *t;
  int i, q;
  p.type = -1;
  q = any_unit_here(tx, ty);
  if (q != -1)
  {
    t = &player[q / 100].unit[q % 100];
    if ((t->color != u->color) && (player[t->color].team != player[u->color].team) && (type_can_attack(u, t)))
    {
      p.type = t->type;
      p.loc.x = tx;
      p.loc.y = ty;
      p.health = t->health;
      p.damage_cost = get_damage_cost(u, t);
    }
  }
  return p;
}

int get_damage_cost(_unit *a, _unit *d)
{
  float basic = float(basic_damage(a->type, d->type)) * a->health / 10;
  int def = defbonus(d->tilex, d->tiley);  //most of this code lifted from battle.cpp
  if (d->basetype == AIR)
  {  //air units have no terrain defense bonus
    def = 0;
  }
  apply_player_bonuses(basic, a, d);
  float damage = basic - ((basic * float(def)) / 10);
  int cost = int(damage * d->price);
  return cost;
}

bool can_get_to_aitarget(_unit *a, _aitarget d)
{  //checks all 4 tiles adjacent to D to see if one is in range of A
  int x, y, z, i;
  i = 0;
  while (i < 4)
  {
    switch(i)
    {
      case 0:
        x = d.loc.x + 1;
        y = d.loc.y;
        break;
      case 1:
        x = d.loc.x - 1;
        y = d.loc.y;
        break;
      case 2:
        x = d.loc.x;
        y = d.loc.y + 1;
        break;
      case 3:
        x = d.loc.x;
        y = d.loc.y - 1;
        break;
    }
    if ((x > -1) && (x < map.l) && (y > -1) && (y < map.h))
    {
      if (map.tile[x][y].get_step() <= a->move)
      {
        z = map.tile[x][y].unit_here();
        if ((z == -1) || ((a->tilex == x) && (a->tiley == y)))
        {  //make sure there's no unit here (besides maybe the attacker itself)
          return true;
        }
      }
    }
    i++;
  }
  return false;
}

int any_unit_here(int tx, int ty)
{
  if ((tx > -1) && (ty > -1) && (tx < map.l) && (ty < map.h))
  {
    return map.tile[tx][ty].unit_here();
  }
  return -1;
}

int next_to_enemy(int plyr, int tx, int ty)
{
  int z;
  z = any_unit_here(tx + 1, ty);
  if (z != -1)
  {
    if (z / 100 != plyr)
    {
      return 1;
    }
  }
  z = any_unit_here(tx - 1, ty);
  if (z != -1)
  {
    if (z / 100 != plyr)
    {
      return 1;
    }
  }
  z = any_unit_here(tx, ty + 1);
  if (z != -1)
  {
    if (z / 100 != plyr)
    {
      return 1;
    }
  }
  z = any_unit_here(tx, ty - 1);
  if (z != -1)
  {
    if (z / 100 != plyr)
    {
      return 1;
    }
  }
  return 0;   
}

int needy(int unit_id)
{
  int p = unit_id / 100;
  int u = unit_id % 100;
  if ((player[p].unit[u].gas < 25) || ((player[p].unit[u].ammo < 4) && (player[p].unit[u].attacktype != -1)))
  {
    return 1;
  }
  else
  {
    return 0;
  }
}

int next_to_needy_friendly(int plyr, int tx, int ty)
{
  int z;
  z = needy(any_unit_here(tx + 1, ty));
  if (z == 1)
  {
    return 1;
  }
  z = needy(any_unit_here(tx - 1, ty));
  if (z == 1)
  {
    return 1;
  }
  z = needy(any_unit_here(tx, ty + 1));
  if (z == 1)
  {
    return 1;
  }
  z = needy(any_unit_here(tx, ty - 1));
  if (z == 1)
  {
    return 1;
  }
  return 0;
}

int intmax(int a, int b)
{
  if (a > b)
  {
    return a;
  }
  else
  {
    return b;
  }
}

int can_unload_from_here(int x, int y, int mountains)
{
  _loc d = unloadable_point(x, y, mountains);
  if (d.x != -1)
  {
    return 1;
  }
  return 0;
}

bool enemy_threat(int plyr)
{  //checks to see whether enemy units are near a base or the HQ
  int i = 0;
  int z = base.size();
  int x, y, r, t;
  _unit* u;
  while (i < z)
  {
    if (enemy_within_radius(plyr, base[i].x, base[i].y, 10) == true)
    {
      return true;
    }
    i++;
  }
  if (enemy_within_radius(plyr, capital.x, capital.y, 10) == true)
  {
    return true;
  }
  return false;
}

bool enemy_within_radius(int plyr, int center_x, int center_y, int r)
{
 int x, y, t;
  y = center_y - r;
  while (y <= center_y + r)
  {
    x = center_x - r;
    while (x <= center_x + r)
    {
      if ((x > 0) && (x < map.l) && (y > 0) && (y < map.h)
        && (tile_distance(x, y, center_x, center_y) <= r))
      {
        t = any_unit_here(x, y);
        if (t != -1)
        {
          if (player[t / 100].team != player[plyr].team)
          {  //doesn't check whether the enemy unit can get to the base
            return true;  //only if it's within R tiles
          }  //yeah, I know it needs work
        }
      }
      x++;
    }
    y++;
  }
  return false;
}
