#include "empire.h"

const int CAMPAIGN_SELECTCAMPAIGN = 0;
const int CAMPAIGN_SELECTSTAGE    = 1;
const int CAMPAIGN_INGAME         = 2;
const int CAMPAIGN_QUIT           = 3;

extern _button back;
extern _button opt[10];
extern DATAFILE *glb;

_button next;

typedef struct _campaignvars
{
  int state;
  int totalstages;
  int lastcompleted;
};

typedef struct _campchoice
{
  string text;
  string location;
};

_campaignvars cv;

void select_campaign();
void select_stage();
void in_campaign_game();

int campaign()
{
  static bool first = true;
  if (first)
  {
    cv.state = CAMPAIGN_SELECTCAMPAIGN;
    first = false;
  }
  switch(cv.state)
  {
    case CAMPAIGN_SELECTCAMPAIGN:
      select_campaign();
      break;
    case CAMPAIGN_SELECTSTAGE:
      select_stage();
      break;
    case CAMPAIGN_INGAME:
      in_campaign_game();
      break;
  }
  if (cv.state == CAMPAIGN_QUIT)
  {
    first = true;
    return MENU;
  }
  return CAMPAIGN;
}

void select_campaign()
{
  static bool first = true;
  static bool ok;
  static vector<_campchoice> camps;
  static int selected;
  static BITMAP *pic[10];
  string s;
  int i, l, lasty;
  if (first)
  {
    glb = (DATAFILE *)graphics[2].dat;
    ok = true;
    selected = -1;
    back.init(5, 445, 80, 30, "Back");
    ifstream c("campaign/campaigns.txt");
    if (c.bad())
    {
      ok = false;
    }
    else
    {
      next.init(555, 445, 80, 30, "Next");
      camps.resize(0);
      while (!c.eof())
      {
        camps.push_back();
        getline(c, camps[camps.size() - 1].text);
        getline(c, camps[camps.size() - 1].location);
      }
      lasty = 145;
      i = 0;
      while ((i < camps.size()) && (i < 10))
      {
        s += "campaign/";
        s += camps[i].location;
        s += "/";
        s += camps[i].location;
        s += ".bmp";
        pic[i] = load_bitmap(s.c_str(), NULL);
        if (pic[i] == NULL)
        {
          l = text_length(font, camps[i].text.c_str()) + 12;
          opt[i].init(320 - l / 2, lasty + 10, l, 16, camps[i].text.c_str());
          lasty += 10;
        }
        else
        {
          opt[i].init(320 - pic[i]->w / 2, lasty + 10, pic[i]->w, pic[i]->h, "", pic[i]);
          lasty += 10 + pic[i]->h;
        }
        i++;
      }
    }
    first = false;
  }
  back.check(back_buffer);
  if (back.clicked())
  {
    i = 0;
    while (i < camps.size())
    {
      if (pic[i] != NULL)
      {
        destroy_bitmap(pic[i]);
      }
      i++;
    }
    first = true;
    cv.state = CAMPAIGN_QUIT;
  }
  if (!ok)
  {
    textout_centre(back_buffer, font, "Error opening campaign/campaigns.txt", 320, 200, RED);
  }
  else
  {
    rect(back_buffer, 150, 150, 490, 250, DBROWN);
    rectfill(back_buffer, 0, 0, 640, 49, BROWN);
    //rectfill(back_buffer, 0, 30, 
    text_mode(-1);
    
    i = 0;
    while (i < camps.size())
    {
      opt[i].check(back_buffer);
      i++;
    }
    text_mode(0);
    if (selected != -1)
    {
      next.check(back_buffer);
      if (next.clicked())
      {
        i = 0;
        while (i < camps.size())
        {
          if (pic[i] != NULL)
          {
            destroy_bitmap(pic[i]);
          }
          i++;
        }
        first = true;
        cv.state = CAMPAIGN_SELECTSTAGE;
      }
    }
  }
  draw_mouse();
}

void select_stage()
{
}

void in_campaign_game()
{
}
