#ifndef _empire
#define _empire

#include <time.h>
#include <string>
#include <allegro.h>
#include <winalleg.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <fstream.h>
#include "button.h"
#include "units.h"
#include "player.h"
using namespace std;

#define QUIT -1
#define MENU 0
#define LOGIC 1
#define MAPEDIT 2
#define GAMEOVER 3

#define LMOUSE 0
#define LTILE 1

#define BACK 0
#define SPRITE 1
#define MOUSE 2

#define DIRECT 0
#define RANGED 1

#define LAND 0
#define AIR 1
#define SEA 2

#define BLACK makecol(0, 0, 0)
#define GREY makecol(128, 128, 128)
#define LGREY makecol(192, 192, 192)
#define DGREY makecol(64, 64, 64)
#define VDGREY makecol(32, 32, 32)
#define RED makecol(255, 0, 0)
#define GREEN makecol(0, 255, 0)
#define DGREEN makecol(0, 150, 0)
#define BLUE makecol(0, 0, 255)
#define YELLOW makecol(255, 255, 0)
#define DYELLOW makecol(150, 150, 0)
#define WHITE makecol(255, 255, 255)
#define ORANGE makecol(255, 128, 0)
#define TRANS makecol(255, 0, 255)

#define RIGHT 1
#define DOWN  2
#define UP    3
#define LEFT  4

#define ANTI_AIR 0
#define APC 1
#define ARTILLERY 2
#define B_COPTER 3
#define B_SHIP 4
#define BOMBER 5
#define CRUISER 6
#define FIGHTER 7
#define INFANTRY 8
#define LANDER 9
#define MD_TANK 10
#define MECH 11
#define MISSILES 12
#define RECON 13
#define ROCKETS 14
#define SUB 15
#define T_COPTER 16
#define TANK 17

#define M_INFANTRY 0
#define M_TIRES    1
#define M_TREAD    2
#define M_AIR      3
#define M_MECH     4
#define M_SEA      5

#define AUTOGUN    0
#define BOMBS      1
#define CHOPPER    2
#define CLICK      3
#define ENGINE     4
#define BLAST      5
#define JET        6
#define MARCH      7
#define MDTANKFIRE 8
#define MISSILE    9
#define SEABOAT    10
#define TANKMOVE   11
#define TANKFIRE   12
#define TILEDOWN   13
#define TORPEDO    14
#define UNITDOWN   15
#define EXPLOSION  16
#define VICTORY    17

typedef struct _dirtyrect
{
  int x;
  int y;
  int w;
  int h;
  int buffer;
} _dirtyrect;

void create_dirty(int buffnum, int x, int y, int w, int h);
void draw_mouse();
void play_sound(int soundtype);
int mouse_moved();
int mouse_clicked();
int mouse_rclicked();

extern DATAFILE *graphics;
extern DATAFILE *units;
extern DATAFILE *mouse;
extern DATAFILE *explosions;
extern DATAFILE *p[4];
extern BITMAP *back_buffer;
extern BITMAP *sprite_buffer;
extern BITMAP *mouse_bitmap;
extern _player player[4];
extern _character character[8];

extern volatile int counter;

extern char mapname[15];
extern char msg[30];
extern int scroll_x;
extern int scroll_y;
extern int map[50][50];
extern int unitmap[50][50];
extern int l;
extern int h;
extern int pturn;
extern int loaded_game;

#endif
