#ifndef _unit_h
#define _unit_h

typedef struct unitprops
{
  int move;
  int movetype;
  int vision;
  int gas;
  int ammo;
  int attacktype;
  int price;
  int basetype;
} unitprops;

typedef struct _loadedunit
{
  int loaded;
  int type;
  int gas;
  int ammo;
  float health;
} _loadedunit;

class _unit
{
  float frame;
  int direction;
  int x;
  int y;
  int movelist[10];
  int moving;
  int destx;
  int desty;
  int maxload;
  int otherunit;
  void sort_movelist();
  void clear_movelist();
  void do_move();
  unitprops get_properties(int type);
  public:
    int type;
    int color;
    int number;
    int ready;
    int price;
    float health;
    int exists;
    int basetype;
    int tilex;
    int tiley;
    int move;
    int movetype;
    int vision;
    int gas;
    int ammo;
    int submerged;
    int attacktype;
    int capturing;
    void create(int utype, int tx, int ty, int tcolor, int tnum);
    void draw(int forced);
    void set_move(int d);
    void set_moves(int list[10]);
    void supply();
    void kill();
    void set_tiles(int tx, int ty);
    int load_unit(_unit u);
    int can_load_unit(_unit u);
    int can_unload_unit(int n);
    int movestatus(int origvalue);
    _loadedunit load[2];
};

#endif
