#include "empire.h"

int _player::create_unit(int type, int x, int y, int player)
{
  int i = 0;
  while (i < 50)
  {
    if (unit[i].exists == 0)
    {
      unit[i].create(type, x, y, player, i);
      return i;  //return the number of the newly created unit
      i = 50;
    }
    i++;
  }
  return -1;
}

void _player::clear_units()
{
  int i = 0;
  int x, y;
  while (i < 50)
  {
    unit[i].exists = 0;
    x = (unit[i].tilex - scroll_x) * 40;
    y = (unit[i].tiley - scroll_y) * 40;
    rectfill(sprite_buffer, x, y, x + 40, y + 40, TRANS);
    unitmap[unit[i].tilex][unit[i].tiley] = -1;
    i++;
  }
}

void _player::ready_units()
{
  int i = 0;
  while (i < 50)
  {
    unit[i].ready = 1;
    i++;
  }
}

int _player::units_in_play()
{
  int i = 0;
  int n = 0;
  while (i < 50)
  {
    if (unit[i].exists == 1)
    {
      n++;
    }
    i++;
  }
  return n;
}

void _character::create(string n, string d, int s, int w, int p, string pn, BITMAP *pic)
{
  name = n;
  description = d;
  strength = s;
  weakness = w;
  power = p;
  powername = pn;
  picture = create_bitmap(80, 80);
  clear_to_color(picture, BLACK);
  stretch_sprite(picture, pic, 0, 0, 80, 80);
}

void _character::destroy()
{
  name = "";
  description = "";
  strength = 5;
  weakness = 5;
  power = 0;
  powername = "";
  destroy_bitmap(picture);
}
