#include "empire.h"

const int INTRO = -10;
const int FIRST = -11;
const int LOAD = -12;
const int OPTIONS = -13;
const int GAME_OPTIONS = -14;
const int GAME_LOAD = -15;

int numplayers;

extern int dovsync;
extern int mspeed;
extern int volume;

_button start[5];
_button pselect[6];
_button back;
_button ok;
_button plyr[8];
_button opt[10];

_player player[4];

DATAFILE *glb;
extern void draw_minimap(int x, int y, string file);
extern void clear_unitmap();

int do_first();
int do_load();
int do_options();
int do_gameoptions();
int do_gameload();
void description(int c);
void list_players(int numplayers, int selected);

int menu()
{
  glb = (DATAFILE *)graphics[2].dat;
  static int menunum = INTRO;
  int t;
  switch (menunum)
  {
    case INTRO:
      clear(back_buffer);
      blit((BITMAP *)glb[0].dat, back_buffer, 0, 0, 95, 15, 450, 450);
      masked_blit((BITMAP *)glb[1].dat, back_buffer, 0, 0, 58, 5, 524, 128);
      create_dirty(BACK, 58, 5, 524, 128);
      create_dirty(BACK, 95, 15, 450, 450);
      menunum = FIRST;
      break;
    case FIRST:
      menunum = do_first();
      break;
    case LOAD:
      menunum = do_load();
      break;
    case OPTIONS:
      menunum = do_options();
      break;
    case MAPEDIT:
      menunum = INTRO;
      return MAPEDIT;
      break;
    case GAME_OPTIONS:
      menunum = do_gameoptions();
      break;
    case GAME_LOAD:
      menunum = do_gameload();
      break;
    case QUIT:
      return QUIT;
      break;
    default:        //default cases would lead out of the menu, so
      t = menunum;  //the menu has to open in INTRO next time
      menunum = INTRO;
      return t;
      break;
  }
  return MENU;
}





int do_first()
{
  static int drawbox = 1;
  int moved = mouse_moved();
  if (drawbox == 1)
  {
    clear_to_color(back_buffer, BLACK);
    blit((BITMAP *)glb[0].dat, back_buffer, 0, 0, 95, 15, 450, 450);
    masked_blit((BITMAP *)glb[1].dat, back_buffer, 0, 0, 58, 5, 524, 128);
    start[0].init(270, 150, 100, 20, "Start");
    start[0].draw(back_buffer);
    start[1].init(270, 180, 100, 20, "Load Game");
    start[1].draw(back_buffer);
    start[2].init(270, 240, 100, 20, "Quit");
    start[2].draw(back_buffer);
    start[3].init(270, 300, 100, 20, "Map Editor");
    start[3].draw(back_buffer);
    start[4].init(270, 350, 100, 20, "Options");
    start[4].draw(back_buffer);
    create_dirty(BACK, 0, 0, 640, 480);
    moved = 1;
    drawbox = 0;
  }
  start[0].check(back_buffer, moved);
  start[1].check(back_buffer, moved);
  start[2].check(back_buffer, moved);
  start[3].check(back_buffer, moved);
  start[4].check(back_buffer, moved);
  if (start[0].clicked() == 1)
  {
    clear(back_buffer);
    create_dirty(BACK, 0, 0, 640, 480);
    drawbox = 1;
    return LOAD;
  }
  if (start[1].clicked() == 1)
  {
    drawbox = 1;
    return GAME_LOAD;
  }
  if ((start[2].clicked() == 1) || (key[KEY_ESC]))
  {
    drawbox = 1;
    return QUIT;
  }
  if (start[3].clicked() == 1)
  {
    drawbox = 1;
    return MAPEDIT;
  }
  if (start[4].clicked() == 1)
  {
    drawbox = 1;
    return GAME_OPTIONS;
  }
  if (moved == 1)
  {
    draw_mouse();
  }
  return FIRST;
}





int do_load()
{
  static int drawfirst = 1;
  static int mapok = 1;
  static int highlighted = -1;
  static int delay = 0;
  static int lscroll = 0;
  static int mapnum;
  int moved = mouse_moved();
  int a, b, c, d;
  int i;
  int j;
  int ok;
  int mx;
  int my;
  int sel;
  char p[30] = "";
  static string n[50];
  if (drawfirst == 1)
  {
    clear_to_color(back_buffer, VDGREY);
    text_mode(-1);
    textout_centre(back_buffer, (FONT *)glb[2].dat, "SELECT THE BATTLEGROUND", 320, 380, GREEN);
    text_mode(0);
    textout_centre(back_buffer, font, "Left mouse: Select", 320, 460, WHITE);
    ifstream map("maps/maplist.txt");
    if (map.bad())
    {
      textout(back_buffer, font, "Unable to load 'maplist.txt'", 5, 5, RED);
      mapok = 0;
    }
    i = 0;
    while (i < 50)
    {
      n[i] = "";
      i++;
    }
    opt[0].init(10, 455, 100, 20, "Back");
    opt[0].draw(back_buffer);
    rect(back_buffer, 195, 15, 370, 350, LGREY);
    rectfill(back_buffer, 196, 16, 369, 349, BLACK);
    if (mapok == 1)
    {
      i = 0;
      while (!map.eof())
      {
        getline(map, n[i]);
        i++;
      }
      if (i > 22)  //if the list will go beyond the load box
      {
        opt[1].init(195, 355, 85, 20, "Up");
        opt[1].draw(back_buffer);
        opt[2].init(285, 355, 85, 20, "Down");
        opt[2].draw(back_buffer);
      }
      mapnum = i;
      i = lscroll;
      while (i < lscroll + 22)
      {
        textout(back_buffer, font, n[i].c_str(), 200, 20 + (15 * (i - lscroll)), WHITE);
        i++;
      }
    }
    create_dirty(BACK, 0, 0, 640, 480);
    moved = 1;
    drawfirst = 0;
  }
  opt[0].check(back_buffer, moved);
  if (mapnum > 22)
  {
    opt[1].check(back_buffer, moved);
    opt[2].check(back_buffer, moved);
    if (opt[1].clicked() == 1)
    {
      if (lscroll > 0)
      {
        lscroll--;
        drawfirst = 1;
      }
    }
    if (opt[2].clicked() == 1)
    {
      if (lscroll + 22 < mapnum)
      {
        lscroll++;
        drawfirst = 1;
      }
    }
  }
  if (opt[0].clicked() == 1)
  {
    clear(back_buffer);
    drawfirst = 1;
    highlighted = -1;
    lscroll = 0;
    return FIRST;
  }
  mx = mouse_x;
  my = mouse_y;
  if ((mx > 200) && (mx < 370))
  {
    if ((my > 15) && (my < 350))
    {
      sel = (my - 20) / 15 + lscroll;
      if ((sel != highlighted) && (n[sel].c_str() != ""))
      {
        strcat(p, "maps/");
        strcat(p, n[sel].c_str());
        ifstream m(p);
        ok = 1;
        if (m.bad())
        {
          ok = 0;
          m.close();
        }
        if (ok == 1)
        {
          m >> a >> b >> c;
          m.close();
          rectfill(back_buffer, 400, 85, 620, 300, VDGREY);
          textout(back_buffer, font, n[sel].c_str(), 400, 85, WHITE);
          textprintf(back_buffer, font, 400, 95, WHITE, "%-1d Players", c);
          create_dirty(BACK, 400, 85, 220, 215);
          draw_minimap(400, 110, p);
          highlighted = sel;
        }
      }
      if (mouse_b & 1)
      {
        strcat(p, "maps/");
        strcat(p, n[sel].c_str());
        ok = 1;
        ifstream m(p);
        if (m.bad())
        {
          ok = 0;
        }
        if (ok == 1)
        {
 /*         sprintf(p, n[sel].c_str());  //
          i = strlen(p) - 1;           //
          j = 0;                       //
          while (j < 4)                //
          {                            // this code removes the ".map"
            p[i] = '\0';               // from the end of the name
            i--;                       //
            j++;                       //
          }                            //
          strcpy(mapname, p);          //    */
          m >> l >> h >> numplayers;
          i = 0;
          while (i < numplayers)
          {  //initialize all players participating in this game
            player[i].playing = 1;
            player[i].cash = 0;
            player[i].power = 0;
            i++;
          }
          while (i < 4)
          {  //make sure the other players aren't in the game
            player[i].playing = 0;
            i++;
          }
          i = 0;
          while (i < h)
          {
            j = 0;
            while (j < l)
            {
              m >> map[j][i];
              j++;
            }
            i++;
          }
          player[0].clear_units();  //get rid of any previous unit settings
          player[1].clear_units();
          player[2].clear_units();
          player[3].clear_units();
          player[0].powered = 0;
          player[1].powered = 0;
          player[2].powered = 0;
          player[3].powered = 0;
          clear_unitmap();
          i = 0;
          while (i < 50)  //loading any placed units
          {
            m >> a;
            if (a != -1)  //if there is a saved unit for this i
            {
              m >> b >> c >> d;
              player[d].create_unit(c, a, b, d);
            }
            else  //if a reads -1, there are no more saved units
            {
              i = 50;
            }
            i++;
          }          
          lscroll = 0;
          drawfirst = 1;
          highlighted = -1;
          return OPTIONS;
        }
      }
    }
  }
  if (delay > 0)
  {
    delay--;
  }
  if (moved == 1)
  {
    draw_mouse();
  }
  return LOAD;
}

int do_options()
{
  static int pselect = 0;
  static int drawfirst = 1;
  int selected = 0;
  int over[10];
  int i = 0;
  int j = 0;
  char m[15];
  int moved = mouse_moved();
  if (drawfirst == 1)
  {
    clear(back_buffer);
    back.init(560, 460, 80, 20, "Back");
    back.draw(back_buffer);
    i = 0;
    while (i < 4)
    {
      player[i].number = -1;
      player[i].playing = 1;
      i++;
    }
    list_players(numplayers, pselect);
    while (j < 2)
    {
      i = 0;
      while (i < 4)
      {
        plyr[i + (4 * j)].init(110 + (85 * i), 315 + (85 * j), 80, 80, "", character[i + (4 * j)].picture);
        plyr[i + (4 * j)].draw(back_buffer);
        over[i + (4 * j)] = 0;
        i++;
      }
      j++;
    }
    drawfirst = 0;
    moved = 1;
    create_dirty(BACK, 0, 0, 640, 480);
  }
  back.check(back_buffer, moved);
  if (back.clicked() == 1)
  {
    clear(back_buffer);
    create_dirty(BACK, 0, 0, 640, 480);
    pselect = 0;
    drawfirst = 1;
    return LOAD;
  }
  if (pselect >= numplayers)
  {
    ok.check(back_buffer, moved);
    if (ok.clicked() == 1)
    {
      clear(back_buffer);
      create_dirty(BACK, 0, 0, 640, 480);
      pselect = 0;
      drawfirst = 1;
      i = 0;
      while (i < 4)  //set whether players 3 and four are actually in the game
      {
        if (i < numplayers)
        {
          player[i].playing = 1;
        }
        else
        {
          player[i].playing = 0;
        }
        i++;
      }
      pturn = 0;  //make player 1 start first
      loaded_game = 0;  //the game was not loaded from a saved file
      return LOGIC;
    }
    description(-2);
  }
  else
  {
    selected = 0;
    i = 0;
    while (i < 8)
    {
      if (plyr[i].mouseover() == 1)
      {
        description(i);
        selected = 1;
      }
      if (plyr[i].clicked() == 1)
      {
        player[pselect].number = i;
        pselect++;
        if (pselect >= numplayers)
        {
          ok.init(545, 400, 95, 30, "OK");
          ok.draw(back_buffer);
        }
        list_players(numplayers, pselect);
      }
      i++;
    }
    if (selected == 0)
    {
      description(-1);
    }
  }
  if (moved == 1)
  {
    draw_mouse();
  }
  return OPTIONS;
}

void description(int c)
{
  static int old = 100;
  string n, m, s, w, p;
  if (old != c)
  {
    if ((c > -1) && (c < 8))
    {
      n = character[c].name;
      m = character[c].description;
      s = "Strength: ";
      switch(character[c].strength)
      {
        case 0:
          s += "Direct Attacks";
          break;
        case 1:
          s += "Ranged Attacks";
          break;
        case 2:
          s += "Land Units";
          break;
        case 3:
          s += "Air Units";
          break;
        case 4:
          s += "Sea Units";
          break;
        case 5:
          s += "None";
          break;
      }
      w = "Weakness: ";
      switch(character[c].weakness)
      {
        case 0:
          w += "Direct Attacks";
          break;
        case 1:
          w += "Ranged Attacks";
          break;
        case 2:
          w += "Land Units";
          break;
        case 3:
          w += "Air Units";
          break;
        case 4:
          w += "Sea Units";
          break;
        case 5:
          w += "None";
          break;
      }
      p = "Power: ";
      p += character[c].powername;
      switch(character[c].power)
      {
        case 0:
          p += " (+2 unit health)";
          break;
        case 1:
          p += " (better direct attacks)";
          break;
        case 2:
          p += " (better ranged attacks)";
          break;
        case 3:
          p += " (-1 enemy health)";
          break;
        case 4:
          p += " (refresh non-infantry units)";
          break;
        case 5:
          p += " (kill 1/5 random enemy units)";
          break;
      }
    }
    else
    {
      n = "";
      m = "";
      p = "";
    }
    rectfill(back_buffer, 0, 260, 640, 314, BLACK);
    textout_centre(back_buffer, font, n.c_str(), 320, 262, WHITE);
    textout_centre(back_buffer, font, m.c_str(), 320, 272, WHITE);
    textout_centre(back_buffer, font, s.c_str(), 320, 282, GREEN);
    textout_centre(back_buffer, font, w.c_str(), 320, 292, RED);
    textout_centre(back_buffer, font, p.c_str(), 320, 302, WHITE);
    create_dirty(BACK, 0, 260, 640, 54);
    old = c;
  }
}

void list_players(int numplayers, int selected)
{
  int i = 0;
  char m[15];
  while (i < numplayers)
  {
    text_mode(-1);
    sprintf(m, "Player %-1d", i + 1);
    rectfill(back_buffer, 7, 42 + (40 * i), 103, 58 + (40 * i), BLACK);
    rect(back_buffer, 5, 40 + (40 * i), 105, 60 + (40 * i), DGREY);
    rectfill(back_buffer, 7, 42 + (40 * i), 103, 58 + (40 * i), GREY);
    if (i == selected)
    {
      textout_centre(back_buffer, font, m, 55, 46 + (40 * i), RED);
    }
    else
    {
      textout_centre(back_buffer, font, m, 55, 46 + (40 * i), BLACK);
    }
    create_dirty(BACK, 5, 40 + (40 * i), 100, 20);
    text_mode(0);
    if ((player[i].number > -1) && (player[i].number < 8))
    {
      textout(back_buffer, font, character[player[i].number].name.c_str(), 115, 47 + (40 * i), WHITE);
    }
    create_dirty(BACK, 115, 47 + (40 * i), 120, 20);
    i++;
  }
}

int do_gameoptions()
{
  static int first = 1;
  int moved = mouse_moved();
  static _button back;
  static _button sync;
  static _button speed[2];
  static _button vol[2];
  static _button testsound;
  if (first == 1)
  {
    clear(back_buffer);
    back.init(560, 460, 80, 20, "Back");
    if (dovsync == 0)
    {
      sync.init(270, 250, 100, 20, "Vsync: OFF");
    }
    else
    {
      sync.init(270, 250, 100, 20, "Vsync: ON");
    }
    textout_centre(back_buffer, font, "Sound Volume", 320, 210, WHITE);
    textprintf_centre(back_buffer, font, 320, 230, WHITE, "%-1d", volume);
    vol[0].init(260, 220, 30, 20, "<");
    vol[1].init(350, 220, 30, 20, ">");
    testsound.init(430, 220, 100, 20, "Test");
    textout_centre(back_buffer, font, "Mouse Speed (Higher value means slower mouse)", 320, 310, WHITE);
    textprintf_centre(back_buffer, font, 320, 330, WHITE, "%-1d", mspeed);    
    speed[0].init(270, 320, 30, 20, "<");
    speed[1].init(340, 320, 30, 20, ">");
    back.draw(back_buffer);
    sync.draw(back_buffer);
    vol[0].draw(back_buffer);
    vol[1].draw(back_buffer);
    testsound.draw(back_buffer);
    speed[0].draw(back_buffer);
    speed[1].draw(back_buffer);
    create_dirty(BACK, 0, 0, 640, 480);
    moved = 1;
    first = 0;
  }
  back.check(back_buffer, moved);
  sync.check(back_buffer, moved);
  vol[0].check(back_buffer, moved);
  vol[1].check(back_buffer, moved);
  testsound.check(back_buffer, moved);
  speed[0].check(back_buffer, moved);
  speed[1].check(back_buffer, moved);
  if (sync.clicked() == 1)
  {
    if (dovsync == 0)
    {
      dovsync = 1;
      sync.init(270, 250, 100, 20, "Vsync: ON");
      sync.draw(back_buffer);
    }
    else
    {
      dovsync = 0;
      sync.init(270, 250, 100, 20, "Vsync: OFF");
      sync.draw(back_buffer);
    }
  }
  if (testsound.clicked() == 1)
  {
    play_sound(rand()%11);
  }
  if (vol[0].mousedown() == 1)
  {
    if (volume > 0) volume--;
    set_volume(volume, volume);
    rectfill(back_buffer, 301, 220, 339, 240, BLACK);
    textprintf_centre(back_buffer, font, 320, 230, WHITE, "%-1d", volume);
    create_dirty(BACK, 300, 229, 40, 10);
  }
  if (vol[1].mousedown() == 1)
  {
    if (volume < 255) volume++;
    set_volume(volume, volume);
    rectfill(back_buffer, 301, 220, 339, 240, BLACK);
    textprintf_centre(back_buffer, font, 320, 230, WHITE, "%-1d", volume);
    create_dirty(BACK, 300, 229, 40, 10);
  }
  if (speed[0].clicked() == 1)
  {
    if (mspeed > 1) mspeed--;
    set_mouse_speed(mspeed, mspeed);
    rectfill(back_buffer, 301, 320, 339, 370, BLACK);
    textprintf_centre(back_buffer, font, 320, 330, WHITE, "%-1d", mspeed);
    create_dirty(BACK, 310, 329, 20, 10);
  }
  if (speed[1].clicked() == 1)
  {
    if (mspeed < 9) mspeed++;
    set_mouse_speed(mspeed, mspeed);
    rectfill(back_buffer, 301, 320, 339, 370, BLACK);
    textprintf_centre(back_buffer, font, 320, 330, WHITE, "%-1d", mspeed);
    create_dirty(BACK, 310, 329, 20, 10);
  }
  if (back.clicked() == 1)
  {
    first = 1;
    return FIRST;
  }
  if (moved == 1)
  {
    draw_mouse();
  }
  return GAME_OPTIONS;
}

int do_gameload()
{
  int i, o, p, num, safety;
  int type, tilex, tiley, ammo, gas, ready, capturing, unum;
  float health;
  int moved = mouse_moved();
  int thechoice = -1;
  char text[10];
  char d[20];
  static int first = 1;
  static _button choice[10];
  char path[10];
  if (first == 1)
  {
    clear(back_buffer);
    o = 0;
    while (o < 9)
    {
      sprintf(path, "game%-1d.sav", o);
      ifstream n(path);
      if (n.bad())
      {
        choice[o].init(250, 50 + (o * 35), 140, 20, "Empty");
      }
      else
      {
        sprintf(text, "%-1d", o);
        choice[o].init(250, 50 + (o * 35), 140, 20, text);
      }
      choice[o].draw(back_buffer);
      o++;
    }
    choice[9].init(250, 455, 140, 20, "Back");
    choice[9].draw(back_buffer);
    create_dirty(BACK, 0, 0, 640, 480);
    first = 0;
  }
  i = 0;
  while (i < 10)
  {
    choice[i].check(back_buffer, moved);
    if (choice[i].clicked() == 1)
    {
      thechoice = i;
    }
    i++;
  }
  if ((thechoice != -1) && (thechoice != 9))
  {
    sprintf(path, "game%-1d.sav", thechoice);
    ifstream savefile(path);
    if (!(savefile.bad()))
    {
      savefile >> l >> h;
      o = 0;
      while (o < h)
      {
        p = 0;
        while (p < l)
        {
          savefile >> map[p][o];
          p++;
        }
        o++;
      }
      clear_unitmap();
      safety = 0;
      o = 0;
      while (o < 4)
      {
        player[o].clear_units();
        savefile >> d >> player[o].playing;
        if (player[o].playing == 1)
        {
          savefile >> d >> player[o].number;
          savefile >> d >> player[o].cash;
          savefile >> d >> player[o].power;
          savefile >> d >> player[o].powered;
          savefile >> d >> unum;
          p = 0;
          while (p < unum)
          {
            savefile >> d >> type;
            savefile >> d >> tilex;
            savefile >> d >> tiley;
            savefile >> d >> health;
            savefile >> d >> ammo;
            savefile >> d >> gas;
            savefile >> d >> ready;
            savefile >> d >> capturing;
            num = player[o].create_unit(type, tilex, tiley, o);
            player[o].unit[num].health = health;
            player[o].unit[num].ammo = ammo;
            player[o].unit[num].gas = gas;
            player[o].unit[num].ready = ready;
            player[o].unit[num].capturing = capturing;
            savefile >> d >> player[o].unit[num].load[0].loaded;
            savefile >> d >> player[o].unit[num].load[0].type;
            savefile >> d >> player[o].unit[num].load[0].health;
            savefile >> d >> player[o].unit[num].load[0].ammo;
            savefile >> d >> player[o].unit[num].load[0].gas;
            savefile >> d >> player[o].unit[num].load[1].loaded;
            savefile >> d >> player[o].unit[num].load[1].type;
            savefile >> d >> player[o].unit[num].load[1].health;
            savefile >> d >> player[o].unit[num].load[1].ammo;
            savefile >> d >> player[o].unit[num].load[1].gas;
            p++;
          }
        }
        o++;
      }
      savefile >> d >> pturn;
      loaded_game = 1;  //the game has been loaded from a file
      first = 1;
      return LOGIC;
    }
  }
  else if (thechoice == 9)
  {
    first = 1;
    return FIRST;
  }
  if (moved == 1)
  {
    draw_mouse();
  }
  return GAME_LOAD;
}
