#include "empire.h"

volatile int counter;
volatile int fps_counter;
char msg[30];
int loaded_game;
int gamestatus;
int dirtyrects;
int scroll_x;
int scroll_y;
int dovsync;
int mspeed;
int volume;

extern _player player[4];

_character character[8];
_dirtyrect dirty[300];  //a maximum of 300 dirty rectangles per logic loop

BITMAP *back_buffer;
BITMAP *sprite_buffer;
BITMAP *mouse_buffer;
BITMAP *mouse_bitmap;
BITMAP *player_bitmap[8];
DATAFILE *graphics;
DATAFILE *units;
DATAFILE *sounds;
DATAFILE *explosions;
DATAFILE *p[4];
DATAFILE *tiles;
DATAFILE *mouse;
DATAFILE *title;
DATAFILE *land;
DATAFILE *river;
DATAFILE *sea;
DATAFILE *shoal;
DATAFILE *buildings;
DATAFILE *mapunits;
DATAFILE *darkunits;

extern void draw_tiles(int scrollx, int scrolly, int editing);
extern void draw_tile(int set, int pic, int x, int y);
void draw_dirty();

int logic();
int menu();
int mapedit();
int show_winner();
void clear_unitmap();
void clear_dirty_rects();

void timer_handler()
{
  counter++;
}
END_OF_FUNCTION(timer_handler);

void fps_handler()
{
  fps_counter++;
}
END_OF_FUNCTION(fps_handler);

int main()
{
  int defaultgfx = 0;
  int modestried = 0;
  int goodmode = 0;
  srand(time(NULL));
  set_color_depth(24);
  LOCK_VARIABLE(counter);
  LOCK_FUNCTION(timer_handler);
  LOCK_VARIABLE(fps_counter);
  LOCK_FUNCTION(fps_handler);
  allegro_init();
  install_keyboard();
  install_timer();
  install_mouse();
  install_int_ex(timer_handler, BPS_TO_TIMER(50));
  install_int_ex(fps_handler, BPS_TO_TIMER(1));
  ifstream opt("empire.ini");
  if (opt.bad())
  {
    dovsync = 0;
    mspeed = 2;
    volume = 192;
    defaultgfx = 0;
  }
  else
  {
    opt >> dovsync;
    opt >> mspeed;
    opt >> volume;
    opt >> defaultgfx;
  }
  while ((modestried < 4) && (goodmode == 0))
  {
    if (defaultgfx == 0)
    {
      if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) != 0)
      {
        defaultgfx = 1;
      }
      else
      {
        goodmode = 1;
      }
      modestried++;
    }
    if (defaultgfx == 1)
    {
      set_color_depth(15);
      if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) != 0)
      {
        defaultgfx = 2;
      }
      else
      {
        goodmode = 1;
      }
      modestried++;
    }
    if (defaultgfx == 2)
    {
      set_color_depth(16);
      if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) != 0)
      {
        defaultgfx = 3;
      }
      else
      {
        goodmode = 1;
      }
      modestried++;
    }
    if (defaultgfx == 3)
    {
      set_color_depth(32);
      if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) != 0)
      {
        defaultgfx = 0;
      }
      else
      {
        goodmode = 1;
      }
      modestried++;
    }
  }
  if (goodmode == 0)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
    return 1;
  }
  textout(screen, font, "LOADING...", 5, 5, WHITE);
  if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0)
  {
    allegro_message("Error initialising sound\n%s\n", allegro_error);
    install_sound(DIGI_NONE, MIDI_NONE, NULL);
  }
  graphics = load_datafile("empire.dat");
  if (!graphics)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to load empire.dat\n%s\n", allegro_error);
    return 1;
  }
  tiles = (DATAFILE *)graphics[0].dat;
  land = (DATAFILE *)tiles[0].dat;
  river = (DATAFILE *)tiles[1].dat;
  sea = (DATAFILE *)tiles[2].dat;
  shoal = (DATAFILE *)tiles[3].dat;
  buildings = (DATAFILE *)tiles[4].dat;
  mapunits = (DATAFILE *)tiles[5].dat;
  darkunits = (DATAFILE *)tiles[6].dat;
  mouse = (DATAFILE *)graphics[1].dat;
  title = (DATAFILE *)graphics[2].dat;
  explosions = (DATAFILE *)graphics[4].dat;
  units = load_datafile("units.dat");
  if (!units)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to load units.dat\n%s\n", allegro_error);
    return 1;
  }
  p[0] = (DATAFILE *)units[0].dat;
  p[1] = (DATAFILE *)units[1].dat;
  p[2] = (DATAFILE *)units[2].dat;
  p[3] = (DATAFILE *)units[3].dat;
  sounds = load_datafile("empfx.dat");
  if (!sounds)
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to load empfx.dat\n%s\n", allegro_error);
    return 1;
  }  
  ifstream playerdat("players.dat");
  if (playerdat.bad())
  {
    set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
    allegro_message("Unable to load players.dat\n%s\n", allegro_error);
    return 1;
  }
  string a[8], b[8], c[8], d[8], e[8], f[8];
  int i = 0;
  while (i < 8)
  {
    getline(playerdat, a[i]);
    getline(playerdat, b[i]);
    getline(playerdat, c[i]);
    getline(playerdat, d[i]);
    getline(playerdat, e[i]);
    getline(playerdat, f[i]);
    i++;
  }
  playerdat.close();
  char blah[3];
  string thepath;
  BITMAP *temp[8];
  PALETTE q;
  i = 0;
  while (i < 8)
  {
    thepath = "player";
    sprintf(blah, "%-1d", i + 1);
    thepath += blah;
    thepath += ".bmp";
    temp[i] = load_bitmap(thepath.c_str(), q);
    if (!temp[i])
    {
      temp[i] = create_bitmap(80, 80);
      clear_to_color(temp[i], LGREY);
    }
    character[i].create(a[i], b[i], int(strtol(c[i].c_str(), NULL, 10)), int(strtol(d[i].c_str(), NULL, 10)), int(strtol(e[i].c_str(), NULL, 10)), f[i], temp[i]);
    i++;
  }
  i = 0;
  while (i < 8)
  {
    destroy_bitmap(temp[i]);
    i++;
  }
  BITMAP *tempbmp = create_bitmap(640, 480);
  set_volume(volume, volume);
  set_mouse_speed(mspeed, mspeed);
  back_buffer = create_bitmap(640, 480);
  sprite_buffer = create_bitmap(640, 480);
  mouse_buffer = create_bitmap(640, 480);
  mouse_bitmap = (BITMAP *)mouse[0].dat;
  clear_to_color(back_buffer, BLACK);
  clear_to_color(sprite_buffer, TRANS);
  clear_to_color(mouse_buffer, TRANS);
  set_trans_blender(192, 192, 192, 192);
  gamestatus = MENU;
  counter = 0;
  dirtyrects = 0;
  scroll_x = 0;
  scroll_y = 0;
  while (gamestatus != QUIT)
  {
    while (counter > 0)
    {
      if (key[KEY_B])
      {
        gamestatus = QUIT;
      }
      switch(gamestatus)
      {
        case MENU:
          gamestatus = menu();
          break;
        case LOGIC:
          gamestatus = logic();
          break;
        case GAMEOVER:
          gamestatus = show_winner();
          break;
        case MAPEDIT:
          gamestatus = mapedit();
          break;
      }
      counter--;
    }
    if (dovsync == 1)
    {
      vsync();
    }
    draw_dirty();
    if (key[KEY_F12])
    {
      blit(back_buffer, tempbmp, 0, 0, 0, 0, 640, 480);
      masked_blit(sprite_buffer, tempbmp, 0, 0, 0, 0, 640, 480);
      masked_blit(mouse_buffer, tempbmp, 0, 0, 0, 0, 640, 480);
      save_bitmap("scrngrab.bmp", tempbmp, NULL);
    }
    yield_timeslice();
  }
  i = 0;
  while (i < 8)
  {
    character[i].destroy();
    i++;
  }
  ofstream settings("empire.ini");
  if (!(settings.bad()))
  {
    settings << dovsync << "\n" << mspeed << "\n" << volume << "\n" << defaultgfx;
    settings.close();
  }
  destroy_bitmap(back_buffer);
  destroy_bitmap(sprite_buffer);
  destroy_bitmap(mouse_buffer);
  destroy_bitmap(tempbmp);
  unload_datafile(graphics);
  unload_datafile(units);
  unload_datafile(sounds);
  allegro_exit();
  return 0;
}
END_OF_MAIN();





void create_dirty(int buffnum, int x, int y, int w, int h)
{
  dirty[dirtyrects].x = x;
  dirty[dirtyrects].y = y;
  dirty[dirtyrects].w = w;
  dirty[dirtyrects].h = h;
  dirty[dirtyrects].buffer = buffnum;
  dirtyrects++;
}





void draw_dirty()
{
  int i;
  int t = 0;
  while (t < 3)  //This is an inefficient way of getting the right draw order, but
  {              //it shouldn't slow things much.  The dirty rectangles are looped
    i = 0;       //through thrice: first the back buffer, then sprite, then mouse.
    while (i < dirtyrects)
    {
      if (dirty[i].buffer == t)
      {
        if ((dirty[i].w > 1) || (dirty[i].h > 1))
        {
          if (dirty[i].buffer == BACK)
          {
            blit(back_buffer, screen, dirty[i].x, dirty[i].y, dirty[i].x, dirty[i].y, dirty[i].w, dirty[i].h);
          }
          else if (dirty[i].buffer == SPRITE)
          {
            masked_blit(sprite_buffer, screen, dirty[i].x, dirty[i].y, dirty[i].x, dirty[i].y, dirty[i].w, dirty[i].h);
          }
          else if (dirty[i].buffer == MOUSE)
          {
            masked_blit(mouse_buffer, screen, dirty[i].x, dirty[i].y, dirty[i].x, dirty[i].y, dirty[i].w, dirty[i].h);
          }
        }
        else
        {
          if (dirty[i].buffer == BACK)
          {
            putpixel(screen, dirty[i].x, dirty[i].y, getpixel(back_buffer, dirty[i].x, dirty[i].y));
          }
          else if (dirty[i].buffer == SPRITE)
          {
            putpixel(screen, dirty[i].x, dirty[i].y, getpixel(sprite_buffer, dirty[i].x, dirty[i].y));
          }
          else if (dirty[i].buffer == MOUSE)
          {
            putpixel(screen, dirty[i].x, dirty[i].y, getpixel(mouse_buffer, dirty[i].x, dirty[i].y));
          }
        }
      }
      i++;
    }
    t++;
  }
  dirtyrects = 0;
}





int mouse_moved()
{
  static int mx = 0;
  static int my = 0;
  if ((mx != mouse_x) || (my != mouse_y))
  {
    mx = mouse_x;
    my = mouse_y;
    return 1;
  }
  return 0;
}





int mouse_clicked()
{
  static int mousedown = 0;
  if (mouse_b & 1)
  {
    mousedown = 1;
  }
  else
  {
    if (mousedown == 1)
    {
      mousedown = 0;
      return 1;
    }
  }
  return 0;
}





int mouse_rclicked()
{
  static int mousedown = 0;
  if (mouse_b & 2)
  {
    mousedown = 1;
  }
  else
  {
    if (mousedown == 1)
    {
      mousedown = 0;
      return 1;
    }
  }
  return 0;
}





void draw_mouse()
{
  static int old_mouse_x = 0;
  static int old_mouse_y = 0;
  rectfill(mouse_buffer, old_mouse_x, old_mouse_y, old_mouse_x + 15, old_mouse_y + 15, TRANS);
  create_dirty(BACK, old_mouse_x, old_mouse_y, 15, 15);   //restore the buffers the
  create_dirty(SPRITE, old_mouse_x, old_mouse_y, 15, 15); //mouse previously covered
  old_mouse_x = mouse_x;
  old_mouse_y = mouse_y;
  draw_sprite(mouse_buffer, mouse_bitmap, old_mouse_x, old_mouse_y);
  create_dirty(MOUSE, old_mouse_x, old_mouse_y, 15, 15);
}





void clear_unitmap()
{
  int i = 0;
  int j;
  while (i < h)
  {
    j = 0;
    while (j < l)
    {
      unitmap[j][i] = -1;
      j++;
    }
    i++;
  }
}





void clear_dirty_rects()
{
  dirtyrects = 0;
}





int show_winner()
{
  DATAFILE *glb = (DATAFILE *)graphics[2].dat;
  static int first = 1;
  static int color;
  int winner;
  int i;
  if (first == 1)
  {
    i = 0;
    while (i < 4)
    {
      if (player[i].playing == 1)
      {  //by this time, only one player will be left playing
        winner = i;
        i = 4;
      }
      i++;
    }
    switch(winner)
    {
      case 0:
        color = RED;
        break;
      case 1:
        color = BLUE;
        break;
      case 2:
        color = DGREEN;
        break;
      case 3:
        color = DYELLOW;
        break;
    }
    text_mode(-1);
    textprintf_centre(back_buffer, (FONT *)glb[2].dat, 319, 230, WHITE, "Player %-1d Wins!", winner + 1);
    textprintf_centre(back_buffer, (FONT *)glb[2].dat, 321, 230, WHITE, "Player %-1d Wins!", winner + 1);
    textprintf_centre(back_buffer, (FONT *)glb[2].dat, 320, 230, color, "Player %-1d Wins!", winner + 1);
    textout_centre(back_buffer, font, "Press Enter", 320, 400, BLACK);
    text_mode(0);
    rectfill(sprite_buffer, 0, 0, 640, 480, TRANS);
    create_dirty(BACK, 0, 0, 640, 480);
    play_sound(VICTORY);
    first = 0;
  }
  if (key[KEY_ENTER])
  {
    first = 1;
    return MENU;
  }
  return GAMEOVER;
}

void play_sound(int soundtype)
{
  play_sample((SAMPLE *)sounds[soundtype].dat, volume, 128, 1000, FALSE);
}
