#include "empire.h"

int _button::mouseover()
{
  int mx;
  int my;
  mx = mouse_x;
  my = mouse_y;
  if ((mx >= x) && (mx <= x + w))
  {
    if ((my >= y) && (my <= y + h))
    {
      return 1;
    }
  }
  return 0;
}

int _button::mousenear()
{
  int mx;
  int my;
  mx = mouse_x;
  my = mouse_y;
  if ((mx < x + w + 25) && (mx > x - 11))
  {
    if ((my < y + h + 25) && (my > y - 11))
    {
      return 1;
    }
  }
  return 0;
}

int _button::mousedown()
{
  if (mouseover() == 1)
  {
    if (mouse_b & 1)
    {
      click = 1;
      return 1;
    }
  }
  else
  {
    click = 0;
    return 0;
  }
}

int _button::clicked()
{
  if ((mousedown() == 0) && (click == 1))
  {
    if (mouseover() == 1)
    {
      click = 0;
      return 1;
    }
  }
  return 0;
}

void _button::draw(BITMAP *back_buffer)
{
  if (picture == NULL)
  {
    int l = text_length(font, text.c_str());
    rect(back_buffer, x, y, x + w, y + h, DGREY);
    rectfill(back_buffer, x + 2, y + 2, x + w - 2, y + h - 2, GREY);
    textout_centre(back_buffer, font, text.c_str(), x + (w / 2), y + (h / 2) - 4, GREEN);
    rect(back_buffer, x + (w / 2) - (l / 2) - 1, y + (h / 2) - 5, x + (w / 2) + (l / 2), y + (h / 2) + 4, DGREY);
    if (mousedown() == 0)
    {
      rect(back_buffer, x + 1, y + 1, x + w - 1, y + h - 1, LGREY);
      hline(back_buffer, x + 1, y + h - 1, x + w - 1, DGREY);
      vline(back_buffer, x + w - 1, y + 1, y + h - 1, DGREY);
      create_dirty(BACK, x, y, w + 1, h + 1);
    }
    else
    {
      rect(back_buffer, x + 1, y + 1, x + w - 1, y + h - 1, DGREY);
      hline(back_buffer, x + 1, y + h - 1, x + w - 1, LGREY);
      vline(back_buffer, x + w - 1, y + 1, y + h - 1, LGREY);
      create_dirty(BACK, x, y, w + 1, h + 1);
    }
  }
  else
  {
    draw_sprite(back_buffer, picture, x, y);
    create_dirty(BACK, x, y, w + 1, h + 1);
  }
}

void _button::redraw(BITMAP *back_buffer)
{
  if (picture == NULL)
  {
    int l = text_length(font, text.c_str());
    if (mousedown() == 0)
    {
      rect(back_buffer, x, y, x + w, y + h, DGREY);
      rect(back_buffer, x + 1, y + 1, x + w - 1, y + h - 1, LGREY);
      hline(back_buffer, x + 1, y + h - 1, x + w - 1, DGREY);
      vline(back_buffer, x + w - 1, y + 1, y + h - 1, DGREY);
      rect(back_buffer, x + (w / 2) - (l / 2), y + (h / 2) - 4, x + (w / 2) + (l / 2) + 1, y + (h / 2) + 5, GREY);
      rect(back_buffer, x + (w / 2) - (l / 2) - 1, y + (h / 2) - 5, x + (w / 2) + (l / 2), y + (h / 2) + 4, DGREY);
      textout_centre(back_buffer, font, text.c_str(), x + (w / 2), y + (h / 2) - 4, GREEN);
    }
    else
    {
      rect(back_buffer, x, y, x + w, y + h, DGREY);
      rect(back_buffer, x + 1, y + 1, x + w - 1, y + h - 1, DGREY);
      hline(back_buffer, x + 1, y + h - 1, x + w - 1, LGREY);
      vline(back_buffer, x + w - 1, y + 1, y + h - 1, LGREY);
      rect(back_buffer, x + (w / 2) - (l / 2) - 1, y + (h / 2) - 5, x + (w / 2) + (l / 2), y + (h / 2) + 4, GREY);
      rect(back_buffer, x + (w / 2) - (l / 2), y + (h / 2) - 4, x + (w / 2) + (l / 2) + 1, y + (h / 2) + 5, DGREY);
      textout_centre(back_buffer, font, text.c_str(), x + (w / 2) + 1, y + (h / 2) - 3, GREEN);
    }
    create_dirty(BACK, x, y, 2, h);
    create_dirty(BACK, x, y, w, 2);
    create_dirty(BACK, x + w - 2, y, 2, h);
    create_dirty(BACK, x, y + h - 2, w, 2);
    create_dirty(BACK, x + (w / 2) - (l / 2) - 1, y + (h / 2) - 5, l + 3, 13);
  }
  else
  {
    draw_sprite(back_buffer, picture, x, y);
    create_dirty(BACK, x, y, w + 1, h + 1);
  }
}

void _button::check(BITMAP *back_buffer, int moved)
{
  if (((moved == 1) && (mousenear() == 1)) || (mouseover() == 1))
  {
    redraw(back_buffer);
    draw_mouse();
  }
  if (mousedown() == 1)
  {
    if (sound == 0)
    {
      play_sound(CLICK);
      sound = 1;
    }
  }
  else
  {
    sound = 0;
  }
}

void _button::init(int ix, int iy, int iw, int ih)
{
  init(ix, iy, iw, ih, "", NULL);
}

void _button::init(int ix, int iy, int iw, int ih, string itext)
{
  init(ix, iy, iw, ih, itext, NULL);
}

void _button::init(int ix, int iy, int iw, int ih, string itext, BITMAP *ipicture)
{
  x = ix;
  y = iy;
  w = iw;
  h = ih;
  text = itext;
  picture = ipicture;
  click = 0;
  sound = 0;
}
