/*Elkulator 0.6 by Tom Walker*/
/*Main loop*/

#include <allegro.h>
#include <winalleg.h>
#include <stdio.h>
#include <stdlib.h>
#include "elk.h"

void updatewindowsize(int x, int y);

int fullscreen=0;
int fasttape=1;
int sdouble=0;
int quit=0;

/*  Declare Windows procedure  */
LRESULT CALLBACK WindowProcedure (HWND, UINT, WPARAM, LPARAM);

/*  Make the class name into a global variable  */
char szClassName[ ] = "WindowsApp";
HWND ghwnd;
int infocus;
int quited=0;
int drawit=0;
HMENU menu;
void dodrawit()
{
        drawit=1;
}

#define IDM_FILE_LSNAP    40000
#define IDM_FILE_SSNAP    40001
#define IDM_FILE_RESET    40002
#define IDM_FILE_EXIT     40003
#define IDM_DISC_PLUS3    40010
#define IDM_DISC_DFS      40011
#define IDM_DISC_ADFS     40012
#define IDM_DISC_LOAD     40013
#define IDM_DISC_LOAD2    40014
#define IDM_TAPE_LOAD     40030
#define IDM_TAPE_REWIND   40031
#define IDM_TAPE_FAST     40032
#define IDM_ROM_LOAD      40040
#define IDM_ROM_LOAD2     40041
#define IDM_ROM_UNLOAD    40042
#define IDM_RES_LOW       40050
#define IDM_RES_HIGH      40051
#define IDM_RES_HIGH2     40052
#define IDM_RES_2XSAI     40053
#define IDM_VIDEO_FULL    40060
#define IDM_VIDEO_BLUR    40061
#define IDM_VIDEO_MONO    40062
#define IDM_VIDEO_SCRSHOT 40063
#define IDM_SOUND_ENA     40070

void makemenu()
{
        HMENU hpop,hpop2;
        menu=CreateMenu();
        hpop=CreateMenu();
        AppendMenu(hpop,MF_STRING,IDM_FILE_LSNAP,"&Load Snapshot...");
        AppendMenu(hpop,MF_STRING,IDM_FILE_SSNAP,"&Save Snapshot...");
        AppendMenu(hpop,MF_SEPARATOR,0,NULL);
        AppendMenu(hpop,MF_STRING,IDM_FILE_RESET,"&Reset");
        AppendMenu(hpop,MF_SEPARATOR,0,NULL);
        AppendMenu(hpop,MF_STRING,IDM_FILE_EXIT,"E&xit");
        AppendMenu(menu,MF_POPUP,hpop,"&File");
        hpop=CreateMenu();
        AppendMenu(hpop,MF_STRING,IDM_DISC_PLUS3,"&Plus 3 Enable");
        AppendMenu(hpop,MF_STRING,IDM_DISC_ADFS,"&ADFS Enable");
        AppendMenu(hpop,MF_STRING,IDM_DISC_DFS,"&DFS Enable");
        AppendMenu(hpop,MF_SEPARATOR,0,NULL);
        AppendMenu(hpop,MF_STRING,IDM_DISC_LOAD,"Load Disc &0/2...");
        AppendMenu(hpop,MF_STRING,IDM_DISC_LOAD2,"Load Disc &1/3...");
        AppendMenu(menu,MF_POPUP,hpop,"&Disc");
        hpop=CreateMenu();
        AppendMenu(hpop,MF_STRING,IDM_TAPE_LOAD,"&Load Tape...");
        AppendMenu(hpop,MF_STRING,IDM_TAPE_REWIND,"&Rewind Tape");
        AppendMenu(hpop,MF_STRING,IDM_TAPE_FAST,"&Fast Loading");
        AppendMenu(menu,MF_POPUP,hpop,"&Tape");
        hpop=CreateMenu();
        AppendMenu(hpop,MF_STRING,IDM_ROM_LOAD,"Load ROM Cartridge &1...");
        AppendMenu(hpop,MF_STRING,IDM_ROM_LOAD2,"Load ROM Cartridge &2...");
        AppendMenu(hpop,MF_STRING,IDM_ROM_UNLOAD,"&Unload ROM Cartridges");
        AppendMenu(menu,MF_POPUP,hpop,"&ROM");
        hpop=CreateMenu();
        hpop2=CreateMenu();
        AppendMenu(hpop2,MF_STRING,IDM_RES_LOW,"&Low");
        AppendMenu(hpop2,MF_STRING,IDM_RES_HIGH2,"High With &Scanlines");
        AppendMenu(hpop2,MF_STRING,IDM_RES_HIGH,"&High");
        AppendMenu(hpop2,MF_STRING,IDM_RES_2XSAI,"&2xSaI");
        AppendMenu(hpop,MF_POPUP,hpop2,"&Resolution");
        AppendMenu(hpop,MF_STRING,IDM_VIDEO_FULL,"&Fullscreen");
        AppendMenu(hpop,MF_STRING,IDM_VIDEO_BLUR,"&Blur Filter");
        AppendMenu(hpop,MF_STRING,IDM_VIDEO_MONO,"&Monochrome");
        AppendMenu(hpop,MF_STRING,IDM_VIDEO_SCRSHOT,"&Screenshot...");
        AppendMenu(menu,MF_POPUP,hpop,"&Video");
        hpop=CreateMenu();
        AppendMenu(hpop,MF_STRING,IDM_SOUND_ENA,"&Enabled");
        AppendMenu(menu,MF_POPUP,hpop,"&Sound");
}

void updatemenu()
{
        CheckMenuItem(menu,IDM_RES_2XSAI,MF_UNCHECKED);
        CheckMenuItem(menu,IDM_RES_HIGH2, MF_UNCHECKED);
        CheckMenuItem(menu,IDM_RES_HIGH, MF_UNCHECKED);
        CheckMenuItem(menu,IDM_RES_LOW,  MF_UNCHECKED);
        if (hires==2)      CheckMenuItem(menu,IDM_RES_2XSAI,MF_CHECKED);
        else if (!hires)   CheckMenuItem(menu,IDM_RES_LOW,MF_CHECKED);
        else if (!sdouble) CheckMenuItem(menu,IDM_RES_HIGH2,MF_CHECKED);
        else               CheckMenuItem(menu,IDM_RES_HIGH,MF_CHECKED);
        if (plus3ena)    CheckMenuItem(menu,IDM_DISC_PLUS3,MF_CHECKED);
        else             CheckMenuItem(menu,IDM_DISC_PLUS3,MF_UNCHECKED);
        if (adfsena)     CheckMenuItem(menu,IDM_DISC_ADFS,MF_CHECKED);
        else             CheckMenuItem(menu,IDM_DISC_ADFS,MF_UNCHECKED);
        if (dfsena)      CheckMenuItem(menu,IDM_DISC_DFS,MF_CHECKED);
        else             CheckMenuItem(menu,IDM_DISC_DFS,MF_UNCHECKED);
        if (fasttape)    CheckMenuItem(menu,IDM_TAPE_FAST,MF_CHECKED);
        else             CheckMenuItem(menu,IDM_TAPE_FAST,MF_UNCHECKED);
        if (blur)        CheckMenuItem(menu,IDM_VIDEO_BLUR,MF_CHECKED);
        else             CheckMenuItem(menu,IDM_VIDEO_BLUR,MF_UNCHECKED);
        if (mono)        CheckMenuItem(menu,IDM_VIDEO_MONO,MF_CHECKED);
        else             CheckMenuItem(menu,IDM_VIDEO_MONO,MF_UNCHECKED);
        if (soundenable) CheckMenuItem(menu,IDM_SOUND_ENA,MF_CHECKED);
        else             CheckMenuItem(menu,IDM_SOUND_ENA,MF_UNCHECKED);
}

int quitting=0;

int WINAPI WinMain (HINSTANCE hThisInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR lpszArgument,
                    int nFunsterStil)
{
        int frame=0,c;
        /* This is the handle for our window */
        MSG messages;            /* Here messages to the application are saved */
        WNDCLASSEX wincl;        /* Data structure for the windowclass */

        /* The Window structure */
        wincl.hInstance = hThisInstance;
        wincl.lpszClassName = szClassName;
        wincl.lpfnWndProc = WindowProcedure;      /* This function is called by windows */
        wincl.style = CS_DBLCLKS;                 /* Catch double-clicks */
        wincl.cbSize = sizeof (WNDCLASSEX);

        /* Use default icon and mouse-pointer */
        wincl.hIcon = LoadIcon (NULL, IDI_APPLICATION);
        wincl.hIconSm = LoadIcon (NULL, IDI_APPLICATION);
        wincl.hCursor = LoadCursor (NULL, IDC_ARROW);
        wincl.lpszMenuName = NULL;                 /* No menu */
        wincl.cbClsExtra = 0;                      /* No extra bytes after the window class */
        wincl.cbWndExtra = 0;                      /* structure or the window instance */
        /* Use Windows's default color as the background of the window */
        wincl.hbrBackground = (HBRUSH) COLOR_BACKGROUND;

        /* Register the window class, and if it fails quit the program */
        if (!RegisterClassEx (&wincl))
           return 0;

        makemenu();
        /* The class is registered, let's create the program*/
        ghwnd = CreateWindowEx (
           0,                   /* Extended possibilites for variation */
           szClassName,         /* Classname */
           "Elkulator v0.6",    /* Title Text */
           WS_OVERLAPPEDWINDOW&~(WS_MAXIMIZEBOX|WS_SIZEBOX), /* default window */
           CW_USEDEFAULT,       /* Windows decides the position */
           CW_USEDEFAULT,       /* where the window ends up on the screen */
           320+(GetSystemMetrics(SM_CXFIXEDFRAME)*2),/* The programs width */
           256+(GetSystemMetrics(SM_CYFIXEDFRAME)*2)+GetSystemMetrics(SM_CYMENUSIZE)+GetSystemMetrics(SM_CYCAPTION)+1,/* and height in pixels */
           HWND_DESKTOP,        /* The window is a child-window to desktop */
           menu,                /* No menu */
           hThisInstance,       /* Program Instance handler */
           NULL                 /* No Window Creation data */
           );

        /* Make the window visible on the screen */
        ShowWindow (ghwnd, nFunsterStil);
        win_set_window(ghwnd);

        /*Initialise emulation stuff*/
        loadconfig();
        initmem();
        loadroms();
        reset6502();
        initula();
        install_mouse();
        openuef(tapename);
        loaddisc(discname,0);
        loaddisc(discname2,1);
        reset1770();
        updateadfs();
        initsound();
        install_int_ex(dodrawit,BPS_TO_TIMER(50));

        if (!fullscreen)
        {
                if (hires) updatewindowsize(640,512);
                else       updatewindowsize(320,256);
        }
        updatemenu();
        while (!quited)
        {
                if (infocus && !quitting)
                {
                        exec6502(312,128);
                        frame++;
                        if (frame==5 && soundenable)
                        {
                                frame=0;
                                mixsound();
                                drawit=0;
                        }
                        else
                        {
                                if (frame==5) frame=0;
                                while (!drawit && !(tapeon && fasttape))
                                {
                                        yield_timeslice();
                                        c++;
                                }
                                drawit=0;
                        }
                        if (key[KEY_F12])
                        {
                                while (key[KEY_F12]) yield_timeslice();
                                reset6502();
                                reset1770();
                                if (key[KEY_LCONTROL] || key[KEY_RCONTROL]) ula.ints|=2;
                        }
                        if ((key[KEY_F11]|(mouse_b&2)) && fullscreen)
                        {
                                while ((key[KEY_F11]|(mouse_b&2))) yield_timeslice();
//                                c=soundenable;
                                dogui();
                                if (quit) quited=1;
//                                if (soundenable && c) { as=play_audio_stream(625,8,0,31250,255,127); }
                        }
//                        sleep(1);
                }
                else
                {
                        if (soundenable)
                           mixsound();
//                        sleep(1);
                }
                sleep(1);
                if (PeekMessage(&messages,NULL,0,0,PM_REMOVE))
                {
                        if (messages.message==WM_QUIT)
                        {
                                quited=1;
                        }
                        /* Translate virtual-key messages into character messages */
                        TranslateMessage(&messages);
                        /* Send message to WindowProcedure */
                        DispatchMessage(&messages);
                }
        }
        allegro_exit();
        saveconfig();
        if (changed[0]) savedisc(discname,0);
        if (changed[1]) savedisc(discname2,0);
        return 0;
}

void updatewindowsize(int x, int y)
{
        RECT r;
        GetWindowRect(ghwnd,&r);
        MoveWindow(ghwnd,r.left,r.top,
                     x+(GetSystemMetrics(SM_CXFIXEDFRAME)*2),
                     y+(GetSystemMetrics(SM_CYFIXEDFRAME)*2)+GetSystemMetrics(SM_CYMENUSIZE)+GetSystemMetrics(SM_CYCAPTION)+1,
                     TRUE);
}

int getfn(HWND hwnd, char *f, char *s, int save, char *de)
{
        char fn[512];
        char start[512];
        OPENFILENAME ofn;
        fn[0]=0;
        start[0]=0;
        strcpy(fn,s);
        ZeroMemory(&ofn, sizeof(ofn));
        ofn.lStructSize = sizeof(ofn);
        ofn.hwndOwner = hwnd;
        ofn.lpstrFile = fn;
        ofn.nMaxFile = 260;
        ofn.lpstrFilter = f;//"All\0*.*\0Text\0*.TXT\0";
        ofn.nFilterIndex = 1;
        ofn.lpstrFileTitle = NULL;
        ofn.nMaxFileTitle = 0;
        ofn.lpstrInitialDir = NULL;
        ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST | OFN_OVERWRITEPROMPT | 0x10000000;//OFN_FORCESHOWHIDDEN;
        ofn.lpstrDefExt=de;
        if (save)
        {
                if (GetSaveFileName(&ofn))
                {
                        strcpy(s,fn);
                        return 0;
                }
        }
        else
        {
                if (GetOpenFileName(&ofn))
                {
                        strcpy(s,fn);
                        return 0;
                }
        }
        return -1;
}

/*  This function is called by the Windows function DispatchMessage()  */
LRESULT CALLBACK WindowProcedure (HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
        HMENU hmenu;
        HDC hdc;
        int ohires;
        char s[260];
        int c;
        PAINTSTRUCT ps;
        switch (message)                  /* handle the messages */
        {
                case WM_PAINT:
                hdc=BeginPaint(hwnd,&ps);
                EndPaint(hwnd,&ps);
                return 0;
                case WM_COMMAND:
                switch (LOWORD(wParam))
                {
                        case IDM_FILE_LSNAP:
                        if (!getfn(hwnd,"Elkulator Snapshot (*.SNP)\0*.SNP\0All\0*.*\0\0",s,0,"SNP"))
                           loadsnapshot(s);
                        return 0;
                        case IDM_FILE_SSNAP:
                        if (!getfn(hwnd,"Elkulator Snapshot (*.SNP)\0*.SNP\0All\0*.*\0\0",s,1,"SNP"))
                           savesnapshot(s);
                        return 0;
                        case IDM_FILE_RESET:
                        reset6502();
                        reset1770();
                        ula.ints|=2;
                        memset(ram,0,32768);
                        return 0;
                        case IDM_FILE_EXIT:
//                        dumpregs();
//                        saveconfig();
                        PostQuitMessage (0);
                        if (!quitting) quitting=1;
                        return 0;
                        case IDM_DISC_PLUS3:
                        plus3ena^=1;
                        updatemenu();
                        reset6502();
                        reset1770();
                        updateadfs();
                        ula.ints|=2;
                        return 0;
                        case IDM_DISC_ADFS:
                        adfsena^=1;
                        updatemenu();
                        if (plus3ena)
                        {
                                reset6502();
                                reset1770();
                                updateadfs();
                                ula.ints|=2;
                        }
                        return 0;
                        case IDM_DISC_DFS:
                        dfsena^=1;
                        updatemenu();
                        if (plus3ena)
                        {
                                reset6502();
                                reset1770();
                                updateadfs();
                                ula.ints|=2;
                        }
                        return 0;
                        case IDM_DISC_LOAD:
                        if (changed[0]) savedisc(discname,0);
                        if (dfsena)
                        {
                                if (!getfn(hwnd,"DFS Single Sided Disc Image (*.SSD)\0*.SSD\0DFS Double Sided Disc Image (*.DSD)\0*.DSD\0ADFS Disc Image (*.ADF)\0*.ADF\0All\0*.*\0\0",discname,0,"SSD"))
                                   loaddisc(discname,0);
                        }
                        else
                        {
                                if (!getfn(hwnd,"ADFS Disc Image (*.ADF)\0*.ADF\0All\0*.*\0\0",discname,0,"ADF"))
                                   loaddisc(discname,0);
                        }
                        return 0;
                        case IDM_DISC_LOAD2:
                        if (changed[1]) savedisc(discname,1);
                        if (dfsena)
                        {
                                if (!getfn(hwnd,"DFS Single Sided Disc Image (*.SSD)\0*.SSD\0DFS Double Sided Disc Image (*.DSD)\0*.DSD\0ADFS Disc Image (*.ADF)\0*.ADF\0All\0*.*\0\0",discname2,0,"SSD"))
                                   loaddisc(discname2,1);
                        }
                        else
                        {
                                if (!getfn(hwnd,"ADFS Disc Image (*.ADF)\0*.ADF\0All\0*.*\0\0",discname2,0,"ADF"))
                                   loaddisc(discname2,1);
                        }
                        return 0;
                        case IDM_TAPE_LOAD:
                        if (!getfn(hwnd,"UEF Tape Image (*.UEF)\0*.UEF\0All\0*.*\0\0",tapename,0,"UEF"))
                        {
                                openuef(tapename);
                                saveconfig();
                        }
                        return 0;
                        case IDM_TAPE_REWIND:
                        openuef(tapename);
                        return 0;
                        case IDM_TAPE_FAST:
                        fasttape^=1;
                        updatemenu();
                        return 0;
                        case IDM_ROM_LOAD:
                        s[0]=0;
                        if (!getfn(hwnd,"ROM Image (*.ROM)\0*.ROM\0All\0*.*\0\0",s,0,"ROM"))
                        {
                                loadcart(s);
                                reset6502();
                                reset1770();
                                ula.ints|=2;
                        }
                        return 0;
                        case IDM_ROM_LOAD2:
                        s[0]=0;
                        if (!getfn(hwnd,"ROM Image (*.ROM)\0*.ROM\0All\0*.*\0\0",s,0,"ROM"))
                        {
                                loadcart2(s);
                                reset6502();
                                reset1770();
                                ula.ints|=2;
                        }
                        return 0;
                        case IDM_ROM_UNLOAD:
                        unloadcart();
                        reset6502();
                        reset1770();
                        ula.ints|=2;
                        return 0;
                        case IDM_RES_LOW:
                        hires=0;
                        updatemenu();
                        updateres();
                        updatewindowsize(320,256);
                        return 0;
                        case IDM_RES_HIGH:
                        hires=8;
                        sdouble=1;
                        updatemenu();
                        updateres();
                        updatewindowsize(640,512);
                        return 0;
                        case IDM_RES_HIGH2:
                        hires=8;
                        sdouble=0;
                        updatemenu();
                        updateres();
                        updatewindowsize(640,512);
                        return 0;
                        case IDM_RES_2XSAI:
                        hires=2;
                        updatemenu();
                        updateres();
                        updatewindowsize(640,512);
                        return 0;
                        case IDM_VIDEO_FULL:
                        fullscreen^=1;
                        updatemenu();
                        updateres();
                        return 0;
                        case IDM_VIDEO_BLUR:
                        blur^=1;
                        updatemenu();
                        return 0;
                        case IDM_VIDEO_MONO:
                        mono^=1;
                        updatemenu();
                        updatepal();
                        return 0;
                        case IDM_VIDEO_SCRSHOT:
                        s[0]=0;
                        if (!getfn(hwnd,"Bitmap file (*.BMP)\0*.BMP\0All\0*.*\0\0",s,1,"BMP"))
                           takeshot(s);
                        return 0;
                        case IDM_SOUND_ENA:
                        soundenable^=1;
                        updatesnd();
                        updatemenu();
                        return 0;
                }
                return DefWindowProc (hwnd, message, wParam, lParam);
                case WM_SETFOCUS:
                infocus=1;
                break;
                case WM_KILLFOCUS:
                infocus=0;
                break;
                case WM_DESTROY:
                PostQuitMessage (0);       /* send a WM_QUIT to the message queue */
                break;
                default:                      /* for messages that we don't deal with */
                return DefWindowProc (hwnd, message, wParam, lParam);
        }
        return 0;
}
