/*Elkulator 0.6 by Tom Walker*/
/*DOS & Fullscreen GUI*/
#include <stdio.h>
#include <allegro.h>
#include <winalleg.h>
#include "elk.h"

int ingui=0;
int cngres;
int sdouble;
int fasttape;
MENU hwmenu[3];
MENU soundmenu[3];
MENU videomenu[6];
MENU resmenu[5];

void takeshot(char *fn)
{
        BITMAP *b;
        if (hires==2)
        {
                save_bmp(fn,buf162,elkpal);
        }
        else if (!hires)
        {
                b=create_bitmap(320,256);
                blit(buffer,b,0,0,0,0,320,256);
                save_bmp(fn,b,elkpal);
                destroy_bitmap(b);
        }
        else
        {
                b=create_bitmap(640,512);
                blit(buffer,b,0,0,0,0,640,512);
                save_bmp(fn,b,elkpal);
                destroy_bitmap(b);
        }
}

FILE *cfg;

void saveconfig()
{
        fwrite(tapename,260,1,cfg);
        fwrite(discname,260,1,cfg);
        fwrite(discname2,260,1,cfg);
        putc(soundenable,cfg);
        putc(pcsound,cfg);
        putc(mono,cfg);
        putc(plus3ena,cfg);
        putc(fasttape,cfg);
        putc(hires,cfg);
        putc(blur,cfg);
        putc(sdouble,cfg);
        putc(fullscreen,cfg);
        putc(adfsena,cfg);
        putc(dfsena,cfg);
        fclose(cfg);
}

void loadconfig()
{
        FILE *f=fopen("elk.cfg","rb");
        if (!f)
        {
                tapename[0]=discname[0]=discname2[0]=0;
                soundenable=1; pcsound=0;
                mono=plus3ena=dfsena=adfsena=0;
                fasttape=1;
                hires=blur=sdouble=fullscreen=0;
        }
        else
        {
                fread(tapename,260,1,f);
                fread(discname,260,1,f);
                fread(discname2,260,1,f);
                soundenable=getc(f);
                pcsound=getc(f);
                mono=getc(f);
                plus3ena=getc(f);
                fasttape=getc(f);
                hires=getc(f);
                blur=getc(f);
                sdouble=getc(f);
                fullscreen=getc(f);
                adfsena=getc(f);
                dfsena=getc(f);
                fclose(f);
        }
        cfg=fopen("elk.cfg","wb");
}

int fileret()
{
        quit=0;
        return D_CLOSE;
}

int filequit()
{
        quit=1;
        return D_CLOSE;
}

int mscrshot()
{
        int temp;
        char fn[260];
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        fn[0]=0;
        if (file_select_ex("Enter a file name",fn,"BMP",260,xsize,ysize))
        {
//                printf("Saving %s\n",fn);
                restorepal();
                if (hires==2)
                {
                        temp=save_bmp(fn,buf162,elkpal);
                }
                else if (!hires)
                {
                        blit(buffer,scrshotbuffer,0,0,0,0,320,256);
                        temp=save_bmp(fn,buffer,elkpal);
                }
                else
                {
                        temp=save_bmp(fn,buffer,elkpal);
                }
                fadepal();
        }
        return D_EXIT;
}

int freset()
{
        reset6502();
        reset1770();
        ula.ints|=2;
        memset(ram,0,32768);
        return D_CLOSE;
}

int lsnap()
{
        char tempname[260];
        int ret,c;
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        memset(tempname,0,260);
        ret=file_select_ex("Enter a file name",tempname,"SNP",260,xsize,ysize);
        if (ret)
        {
                c=loadsnapshot(tempname);
        }
        return D_CLOSE;
}

int ssnap()
{
        char tempname[260];
        int ret,c;
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        memset(tempname,0,260);
        ret=file_select_ex("Enter a file name",tempname,"SNP",260,xsize,ysize);
        if (ret)
        {
                savesnapshot(tempname);
        }
        return D_CLOSE;
}

MENU filemenu[]=
{
        {"&Return",fileret,NULL,NULL,NULL},
        {"R&eset",freset,NULL,NULL,NULL},
        {"&Load Snapshot...",lsnap,NULL,NULL,NULL},
        {"&Save Snapshot...",ssnap,NULL,NULL,NULL},
        {"&Quit",filequit,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}        
};

int plus3()
{
        if (plus3ena)
        {
                plus3ena=0;
                hwmenu[0].flags&=~D_SELECTED;
        }
        else
        {
                plus3ena=1;
                hwmenu[0].flags|=D_SELECTED;
        }
        reset6502();
        reset1770();
        updateadfs();
        ula.ints|=2;
        return D_CLOSE;
}

int adfsen()
{
        if (adfsena)
        {
                adfsena=0;
                hwmenu[0].flags&=~D_SELECTED;
        }
        else
        {
                adfsena=1;
                hwmenu[0].flags|=D_SELECTED;
        }
        if (plus3ena)
        {
                reset6502();
                reset1770();
                updateadfs();
                ula.ints|=2;
        }
        return D_CLOSE;
}

int dfsen()
{
        if (dfsena)
        {
                dfsena=0;
                hwmenu[0].flags&=~D_SELECTED;
        }
        else
        {
                dfsena=1;
                hwmenu[0].flags|=D_SELECTED;
        }
        if (plus3ena)
        {
                reset6502();
                reset1770();
                updateadfs();
                ula.ints|=2;
        }
        return D_CLOSE;
}

int changedisc()
{
        char tempname[260];
        int ret,c;
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        memcpy(tempname,discname,260);
        if (changed[0]) savedisc(discname,0);
        ret=file_select_ex("Please choose a disc image",tempname,"ADF;SSD;DSD",260,xsize,ysize);
        if (ret)
        {
                memcpy(discname,tempname,260);
                loaddisc(discname,0);
        }
        return D_CLOSE;
}

int changedisc2()
{
        char tempname[260];
        int ret,c;
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        memcpy(tempname,discname2,260);
        if (changed[1]) savedisc(discname,1);
        ret=file_select_ex("Please choose a disc image",tempname,"ADF;SSD;DSD",260,xsize,ysize);
        if (ret)
        {
                memcpy(discname2,tempname,260);
                loaddisc(discname2,1);
        }
        return D_CLOSE;
}

MENU discmenu[]=
{
        {"&Plus 3 Enable",plus3,NULL,NULL,NULL},
        {"&ADFS Enable",adfsen,NULL,NULL,NULL},
        {"&DFS Enable",dfsen,NULL,NULL,NULL},
        {"Load disc &0/2...",changedisc,NULL,NULL,NULL},
        {"Load disc &1/3...",changedisc2,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

int changetape()
{
        char tempname[260];
        int ret,c;
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        memcpy(tempname,tapename,260);
        ret=file_select_ex("Please choose a UEF file",tempname,"UEF",260,xsize,ysize);
        if (ret)
        {
                memcpy(tapename,tempname,260);
                openuef(tapename);
        }
        return D_CLOSE;
}

int rewindtape()
{
        openuef(tapename);
        return D_CLOSE;
}

int fastl()
{
        fasttape^=1;
        return D_CLOSE;
}

MENU tapemenu[]=
{
        {"&Load tape...",changetape,NULL,NULL,NULL},
        {"&Rewind tape",rewindtape,NULL,NULL,NULL},
        {"&Fast loading",fastl,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

int loadrom()
{
        int temp;
        char fn[260];
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        fn[0]=0;
        if (file_select_ex("Please choost a ROM image",fn,"ROM",260,xsize,ysize))
        {
                loadcart(fn);
                reset6502();
                reset1770();
                ula.ints|=2;
        }
        return D_CLOSE;
}

int loadrom2()
{
        int temp;
        char fn[260];
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        fn[0]=0;
        if (file_select_ex("Please choost a ROM image",fn,"ROM",260,xsize,ysize))
        {
                loadcart2(fn);
                reset6502();
                reset1770();
                ula.ints|=2;
        }
        return D_CLOSE;
}

int unloadrom()
{
        unloadcart();
        reset6502();
        reset1770();
        ula.ints|=2;
        return D_CLOSE;
}

MENU rommenu[]=
{
        {"Load ROM cartridge &1...",loadrom,NULL,NULL,NULL},
        {"Load ROM cartridge &2...",loadrom2,NULL,NULL,NULL},
        {"&Unload ROM cartridges",unloadrom,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

int blurena()
{
        blur^=1;
        videomenu[1].flags^=D_SELECTED;
        return D_CLOSE;
}

int monoena()
{
        mono^=1;
        videomenu[2].flags^=D_SELECTED;
        return D_CLOSE;
}

int fullscr()
{
        fullscreen=0;
        return D_CLOSE;
}

int reslo()
{
        hires=0;
        cngres=1;
        return D_CLOSE;
}

int reshis()
{
        hires=8;
        sdouble=0;
        cngres=1;
        return D_CLOSE;
}

int reshi()
{
        hires=8;
        sdouble=0;
        cngres=1;
        return D_CLOSE;
}

int res2xsai()
{
        hires=2;
        cngres=1;
        return D_CLOSE;
}

MENU resmenu[]=
{
        {"&400x300",reslo,NULL,NULL,NULL},
        {"800x600 with &scanlines",reshis,NULL,NULL,NULL},
        {"&800x600",reshi,NULL,NULL,NULL},
        {"800x600 with &2xSaI",res2xsai,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

MENU videomenu[]=
{
        {"&Resolution",NULL,resmenu,NULL,NULL},
        {"&Fullscreen",fullscr,NULL,NULL,NULL},
        {"&Blur filter",blurena,NULL,NULL,NULL},
        {"&Monochrome",monoena,NULL,NULL,NULL},
        {"&Screenshot...",mscrshot,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

int sndenable()
{
        soundenable^=1;
        soundmenu[0].flags^=D_SELECTED;
        updatesnd();
        return D_CLOSE;
}

int pcsndenable()
{
        pcsound^=1;
        soundmenu[1].flags^=D_SELECTED;
        return D_CLOSE;
}

MENU soundmenu[]=
{
        {"&Enabled",sndenable,NULL,NULL,NULL},
//        {"&PC Speaker Enabled",pcsndenable,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

MENU mainmenu[]=
{
        {"&File",NULL,filemenu,NULL,NULL},
        {"&Disc",NULL,discmenu,NULL,NULL},
        {"&Tape",NULL,tapemenu,NULL,NULL},
        {"&ROM",NULL,rommenu,NULL,NULL},
        {"&Video",NULL,videomenu,NULL,NULL},
        {"&Sound",NULL,soundmenu,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

DIALOG elkgui[]=
{
      {d_ctext_proc, 200, 292, 0,  0, 255,   0,0,0,0,0,"Elkulator v0.6"},
      {d_menu_proc,  0,   0,   0,  0, 0xFFFF,0,0,0,0,0,mainmenu},
      {0,0,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL}
};

void dogui()
{
        int oldres=hires,x=1,s=soundenable;
        DIALOG_PLAYER *dp;
        cngres=0;
        if (hires) { elkgui[0].x=400; elkgui[0].y=592; }
        else       { elkgui[0].x=200; elkgui[0].y=292; }
        fadepal();
        resmenu[0].flags&=~D_SELECTED; resmenu[1].flags&=~D_SELECTED; resmenu[2].flags&=~D_SELECTED; resmenu[3].flags&=~D_SELECTED;
        if (hires==1)     resmenu[3].flags|=D_SELECTED;
        else if (!hires)  resmenu[0].flags|=D_SELECTED;
        else if (sdouble) resmenu[2].flags|=D_SELECTED;
        else              resmenu[1].flags|=D_SELECTED;
        if (plus3ena) discmenu[0].flags|=D_SELECTED;
        else          discmenu[0].flags&=~D_SELECTED;
        if (adfsena) discmenu[1].flags|=D_SELECTED;
        else         discmenu[1].flags&=~D_SELECTED;
        if (dfsena) discmenu[2].flags|=D_SELECTED;
        else        discmenu[2].flags&=~D_SELECTED;
        if (blur) videomenu[2].flags|=D_SELECTED;
        else      videomenu[2].flags&=~D_SELECTED;
        if (mono) videomenu[3].flags|=D_SELECTED;
        else      videomenu[3].flags&=~D_SELECTED;
        videomenu[1].flags=D_SELECTED;
        if (soundenable) soundmenu[0].flags|=D_SELECTED;
        else             soundmenu[0].flags&=~D_SELECTED;
//        if (pcsound) soundmenu[1].flags|=D_SELECTED;
//        else         soundmenu[1].flags&=~D_SELECTED;
        gui_fg_color=makecol(255,255,255);
        gui_bg_color=makecol(0,0,0);
        elkgui[0].fg=makecol(255,255,255);
        set_mouse_sprite(NULL);
        dp=init_dialog(elkgui,0);
        show_mouse(screen);
        ingui=1;
        while (x && !key[KEY_F11] && !(mouse_b&2) && !key[KEY_ESC])
        {
                if (s) mixsound();
                x=update_dialog(dp);
        }
        ingui=0;
        if (key[KEY_ESC]) { while (key[KEY_ESC]) yield_timeslice(); }
        if (key[KEY_F11]) { while (key[KEY_F11]) yield_timeslice(); }
        rectfill(screen,0,0,400,22,0);
        rectfill(screen,0,292,400,300,0);
        rectfill(screen,0,592,800,600,0);
        if (cngres) updateres();
        restorepal();
        if (!fullscreen)
        {
                updateres();
                if (hires) updatewindowsize(640,512);
                else       updatewindowsize(320,256);
        }
}
