/*Elkulator 0.5 by Tom Walker*/
/*ULA/Video/Sound handling*/
#include <allegro.h>
#include <stdio.h>
#include "2xsai.h"
#include "elk.h"

int sdouble;
int fasttape;
int tapewcount=130,tapew=0;
int drawfirst;
int checksound;
FILE *soundf;
int fps,frames;
void secondtimer()
{
        fps=frames;
        frames=0;
}

BITMAP *buffer,*buff2,*scrshotbuffer,*buf16,*buf162;

int keys[2][14][4]=
{
        {
                {KEY_RIGHT,KEY_END,0,KEY_SPACE},
                {KEY_LEFT,KEY_DOWN,KEY_ENTER,KEY_DEL},
                {KEY_MINUS,KEY_UP,KEY_QUOTE,0},
                {KEY_0,KEY_P,KEY_COLON,KEY_SLASH},
                {KEY_9,KEY_O,KEY_L,KEY_STOP},
                {KEY_8,KEY_I,KEY_K,KEY_COMMA},
                {KEY_7,KEY_U,KEY_J,KEY_M},
                {KEY_6,KEY_Y,KEY_H,KEY_N},
                {KEY_5,KEY_T,KEY_G,KEY_B},
                {KEY_4,KEY_R,KEY_F,KEY_V},
                {KEY_3,KEY_E,KEY_D,KEY_C},
                {KEY_2,KEY_W,KEY_S,KEY_X},
                {KEY_1,KEY_Q,KEY_A,KEY_Z},
                {KEY_ESC,KEY_ALT,KEY_LCONTROL,KEY_LSHIFT}
        },
        {
                {KEY_RIGHT,KEY_END,0,KEY_SPACE},
                {KEY_LEFT,KEY_DOWN,KEY_ENTER,KEY_BACKSPACE},
                {KEY_MINUS,KEY_UP,KEY_QUOTE,0},
                {KEY_0,KEY_P,KEY_COLON,KEY_SLASH},
                {KEY_9,KEY_O,KEY_L,KEY_STOP},
                {KEY_8,KEY_I,KEY_K,KEY_COMMA},
                {KEY_7,KEY_U,KEY_J,KEY_M},
                {KEY_6,KEY_Y,KEY_H,KEY_N},
                {KEY_5,KEY_T,KEY_G,KEY_B},
                {KEY_4,KEY_R,KEY_F,KEY_V},
                {KEY_3,KEY_E,KEY_D,KEY_C},
                {KEY_2,KEY_W,KEY_S,KEY_X},
                {KEY_1,KEY_Q,KEY_A,KEY_Z},
                {KEY_ESC,KEY_TILDE,KEY_RCONTROL,KEY_RSHIFT}
        }
};

unsigned char pal[16];
int palwritenum=0,palwritenum2=0;
PALETTE elkpal =
{
      {0,0,0},
      {63,0,0},
      {0,63,0},
      {63,63,0},
      {0,0,63},
      {63,0,63},
      {0,63,63},
      {63,63,63},
};

PALETTE monopal =
{
      {0,0,0},
      {16,16,16},
      {24,24,24},
      {40,40,40},
      {8,8,8},
      {24,24,24},
      {32,32,32},
      {56,56,56},
};

fixed soundcount,soundlimit;
unsigned char soundstat=0;
int soundon[313];

void mixsound(int wait)
{
        unsigned char *p;
        int c;
        p=0;
        if (tapeon && fasttape)
        {
                p=(unsigned char *)get_audio_stream_buffer(as);
                if (p)
                {
                        memset(p,0,625);
                        free_audio_stream_buffer(as);
                }
                return;
        }
        while (!p) p=(unsigned char *)get_audio_stream_buffer(as);
        if (p)
        {
                for (c=0;c<625;c++)
                {
                        soundcount+=0x20000;
                        if (soundcount>=soundlimit)
                        {
                                soundcount=0;
                                soundstat^=0xFF;
                        }
                        if (soundlimit<0x20000) p[c]=(soundon[c>>1])?0x7F:0;
                        else if (soundon[c>>1]) p[c]=soundstat;
                        else                    p[c]=0;
                }
                free_audio_stream_buffer(as);
        }
}

void initsound()
{
        if (install_sound(DIGI_AUTODETECT,MIDI_NONE,0)) { soundenable=0; return; }
        if (soundenable) as=play_audio_stream(625,8,0,31250,255,127);
//        soundf=fopen("sound.pcm","wb");
}

void intula(unsigned char val)
{
        ula.ints|=val;
        if ((ula.ints&ula.intc)&0x7E) ula.ints|=1;
        else                          ula.ints&=~1;
        interrupt=ula.ints&1;
}

unsigned char readkeys(unsigned short addr)
{
        int c;
        unsigned char temp=0;
        for (c=0;c<14;c++)
        {
                if (!(addr&(1<<c)))
                {
                        if (key[keys[0][c][0]]) temp|=1;
                        if (key[keys[0][c][1]]) temp|=2;
                        if (key[keys[0][c][2]]) temp|=4;
                        if (key[keys[0][c][3]]) temp|=8;
                        if (key[keys[1][c][0]]) temp|=1;
                        if (key[keys[1][c][1]]) temp|=2;
                        if (key[keys[1][c][2]]) temp|=4;
                        if (key[keys[1][c][3]]) temp|=8;
                }
        }
        return temp;
}

unsigned long lookup[256][9],lookup2[256][9][2];

void makelookup4()
{
        int c,d,temp=0;
        for (c=0;c<256;c++)
        {
                lookup[c][0]=lookup[c][1]=0;
                if (c&0x80) lookup[c][0]|=pal[8];       else lookup[c][0]|=pal[0];
                if (c&0x40) lookup[c][0]|=(pal[8]<<8);  else lookup[c][0]|=(pal[0]<<8);
                if (c&0x20) lookup[c][0]|=(pal[8]<<16); else lookup[c][0]|=(pal[0]<<16);
                if (c&0x10) lookup[c][0]|=(pal[8]<<24); else lookup[c][0]|=(pal[0]<<24);
                if (c&0x8) lookup[c][1]|=pal[8];       else lookup[c][1]|=pal[0];
                if (c&0x4) lookup[c][1]|=(pal[8]<<8);  else lookup[c][1]|=(pal[0]<<8);
                if (c&0x2) lookup[c][1]|=(pal[8]<<16); else lookup[c][1]|=(pal[0]<<16);
                if (c&0x1) lookup[c][1]|=(pal[8]<<24); else lookup[c][1]|=(pal[0]<<24);
                lookup[c][2]=0;
                if (c&0x80) lookup[c][2]|=pal[8];       else lookup[c][2]|=pal[0];
                if (c&0x20) lookup[c][2]|=(pal[8]<<8);  else lookup[c][2]|=(pal[0]<<8);
                if (c&0x08) lookup[c][2]|=(pal[8]<<16); else lookup[c][2]|=(pal[0]<<16);
                if (c&0x02) lookup[c][2]|=(pal[8]<<24); else lookup[c][2]|=(pal[0]<<24);
                
                lookup[c][3]=lookup[c][4]=0;
                switch (c&0x88)
                {
                        case 0x00: lookup[c][3]|=pal[0]|(pal[0]<<8); break;
                        case 0x08: lookup[c][3]|=pal[2]|(pal[2]<<8); break;
                        case 0x80: lookup[c][3]|=pal[8]|(pal[8]<<8); break;
                        case 0x88: lookup[c][3]|=pal[10]|(pal[10]<<8); break;
                }
                switch (c&0x44)
                {
                        case 0x00: lookup[c][3]|=(pal[0]<<16)|(pal[0]<<24); break;
                        case 0x04: lookup[c][3]|=(pal[2]<<16)|(pal[2]<<24); break;
                        case 0x40: lookup[c][3]|=(pal[8]<<16)|(pal[8]<<24); break;
                        case 0x44: lookup[c][3]|=(pal[10]<<16)|(pal[10]<<24); break;
                }
                switch (c&0x22)
                {
                        case 0x00: lookup[c][4]|=pal[0]|(pal[0]<<8); break;
                        case 0x02: lookup[c][4]|=pal[2]|(pal[2]<<8); break;
                        case 0x20: lookup[c][4]|=pal[8]|(pal[8]<<8); break;
                        case 0x22: lookup[c][4]|=pal[10]|(pal[10]<<8); break;
                }
                switch (c&0x11)
                {
                        case 0x00: lookup[c][4]|=(pal[0]<<16)|(pal[0]<<24); break;
                        case 0x01: lookup[c][4]|=(pal[2]<<16)|(pal[2]<<24); break;
                        case 0x10: lookup[c][4]|=(pal[8]<<16)|(pal[8]<<24); break;
                        case 0x11: lookup[c][4]|=(pal[10]<<16)|(pal[10]<<24); break;
                }
                lookup[c][5]=0;
                switch (c&0x88)
                {
                        case 0x00: lookup[c][5]|=pal[0]; break;
                        case 0x08: lookup[c][5]|=pal[2]; break;
                        case 0x80: lookup[c][5]|=pal[8]; break;
                        case 0x88: lookup[c][5]|=pal[10]; break;
                }
                switch (c&0x44)
                {
                        case 0x00: lookup[c][5]|=(pal[0]<<8); break;
                        case 0x04: lookup[c][5]|=(pal[2]<<8); break;
                        case 0x40: lookup[c][5]|=(pal[8]<<8); break;
                        case 0x44: lookup[c][5]|=(pal[10]<<8); break;
                }
                switch (c&0x22)
                {
                        case 0x00: lookup[c][5]|=(pal[0]<<16); break;
                        case 0x02: lookup[c][5]|=(pal[2]<<16); break;
                        case 0x20: lookup[c][5]|=(pal[8]<<16); break;
                        case 0x22: lookup[c][5]|=(pal[10]<<16); break;
                }
                switch (c&0x11)
                {
                        case 0x00: lookup[c][5]|=(pal[0]<<24); break;
                        case 0x01: lookup[c][5]|=(pal[2]<<24); break;
                        case 0x10: lookup[c][5]|=(pal[8]<<24); break;
                        case 0x11: lookup[c][5]|=(pal[10]<<24); break;
                }

                lookup[c][6]=0;
                temp=0;
                if (c&2) temp|=1;
                if (c&8) temp|=2;
                if (c&0x20) temp|=4;
                if (c&0x80) temp|=8;
                lookup[c][6]|=pal[temp]|(pal[temp]<<8);
                temp=0;
                if (c&1) temp|=1;
                if (c&4) temp|=2;
                if (c&0x10) temp|=4;
                if (c&0x40) temp|=8;
                lookup[c][6]|=(pal[temp]<<16)|(pal[temp]<<24);
                for (d=0;d<9;d++)
                {
                        lookup2[c][d][0]=lookup[c][d]&0xFF;
                        lookup2[c][d][0]|=(lookup[c][d]&0xFF00)<<8;
                        lookup2[c][d][1]=(lookup[c][d]&0xFF0000)>>16;
                        lookup2[c][d][1]|=(lookup[c][d]&0xFF000000)>>8;
                        lookup2[c][d][0]|=(lookup2[c][d][0]<<8);
                        lookup2[c][d][1]|=(lookup2[c][d][1]<<8);
                }
        }
}

unsigned short pc;
int extline;
void writeula(unsigned short addr, unsigned char val)
{
        int c;
        switch (addr&0xF)
        {
                case 0:
                ula.intc=val;
//                printf("INTC %02X\n",val);
                break;
                case 2:
                ula.addrlo=val&0xE0;
                break;
                case 3:
                ula.addrhi=val&0x3F;
                break;
                case 4:
//                printf("FE04 write %02X %04X %i\n",val,pc,extline);
                ula.ints&=~0x30;
                intula(0);
                tapewcount=130;
                return;
                case 5:
                if (val&0x10) ula.ints&=~4;
                if (val&0x20) ula.ints&=~8;
                if (val&0x40)
                {
                        ula.ints&=~0x40;
//                        printf("High tone cleared\n");
                }
                intula(0);
                val&=0xF;
                if (currom<8 || currom>11 || val>7)
                {
                        currom=val;
                        for (c=0x80;c<0x0C0;c++) mem[c]=(unsigned char *)(rom+(currom<<14)+((c&0x3F)<<8));
                        if (val==8 || val==9)       for (c=0x80;c<0xC0;c++) memstat[c]=2;
                        else if (val==3 && dfsena)  for (c=0x80;c<0xC0;c++) memstat[c]=0;
                        else                        for (c=0x80;c<0xC0;c++) memstat[c]=1;
                }               
                break;
                case 6:
                pcsoundl=31250/(val+1);
                soundlimit=(val<<16);
                if (soundcount>soundlimit) soundcount=0;
                if (pcsound && soundena) sound(pcsoundl);
//                else                     nosound();
//                soundcount=0;
                break;
                case 7:
                if ((((val&6)==2)?1:0)!=soundena)
                {
                        soundena=((val&6)==2)?1:0;
                        if (pcsound && soundena) sound(pcsoundl);
                        else                     nosound();
                }
                if ((val&6)==4) tapew=1;
                else            tapew=0;
//                printf("%i %i\n",val&6,tapew);
                if (tapeon && !(val&64))
                   resetspeed=1;
                tapeon=val&64;
                if (((val>>3)&7)!=ula.mode)
                {
                        ula.mode=(val>>3)&7;
                        switch (ula.mode)
                        {
                                case 0: case 3: case 4: case 6: makelookup4(); break;
                                case 1: case 5: makelookup4(); break;
                                case 2: makelookup4(); break;
                        }
                }
                break;
                case 0x8: case 0xA: case 0xC: case 0xE:
//                printf("%04X write %02X %04X %i\n",addr,val,pc,extline);
                switch ((addr>>1)&3)
                {
                        case 0:
                        pal[0]&=~4;
                        pal[2]&=~4;
                        pal[8]&=~6;
                        pal[10]&=~6;
                        if (!(val&0x10)) pal[0]|=4;
                        if (!(val&0x20)) pal[2]|=4;
                        if (!(val&0x40)) pal[8]|=4;
                        if (!(val&0x80)) pal[10]|=4;
                        if (!(val&0x4)) pal[8]|=2;
                        if (!(val&0x8)) pal[10]|=2;
                        break;
                        case 1:
                        pal[4]&=~4;
                        pal[6]&=~4;
                        pal[12]&=~6;
                        pal[14]&=~6;
                        if (!(val&0x10)) pal[4]|=4;
                        if (!(val&0x20)) pal[6]|=4;
                        if (!(val&0x40)) pal[12]|=4;
                        if (!(val&0x80)) pal[14]|=4;
                        if (!(val&0x4)) pal[12]|=2;
                        if (!(val&0x8)) pal[14]|=2;
                        break;
                        case 2:
                        pal[5]&=~4;
                        pal[7]&=~4;
                        pal[13]&=~6;
                        pal[15]&=~6;
                        if (!(val&0x10)) pal[5]|=4;
                        if (!(val&0x20)) pal[7]|=4;
                        if (!(val&0x40)) pal[13]|=4;
                        if (!(val&0x80)) pal[15]|=4;
                        if (!(val&0x4)) pal[13]|=2;
                        if (!(val&0x8)) pal[15]|=2;
                        break;
                        case 3:
                        pal[1]&=~4;
                        pal[3]&=~4;
                        pal[9]&=~6;
                        pal[11]&=~6;
                        if (!(val&0x10)) pal[1]|=4;
                        if (!(val&0x20)) pal[3]|=4;
                        if (!(val&0x40)) pal[9]|=4;
                        if (!(val&0x80)) pal[11]|=4;
                        if (!(val&0x4)) pal[9]|=2;
                        if (!(val&0x8)) pal[11]|=2;
                        break;
                }
                makelookup4();
                break;
                case 0x9: case 0xB: case 0xD: case 0xF:
//                printf("%04X write %02X %04X %i\n",addr,val,pc,extline);
                switch ((addr>>1)&3)
                {
                        case 0:
                        pal[0]&=~3;
                        pal[2]&=~3;
                        pal[8]&=~1;
                        pal[10]&=~1;
                        if (!(val&1)) pal[0]|=1;
                        if (!(val&2)) pal[2]|=1;
                        if (!(val&4)) pal[8]|=1;
                        if (!(val&8)) pal[10]|=1;
                        if (!(val&16)) pal[0]|=2;
                        if (!(val&32)) pal[2]|=2;
                        break;
                        case 1:
                        pal[4]&=~3;
                        pal[6]&=~3;
                        pal[12]&=~1;
                        pal[14]&=~1;
                        if (!(val&1)) pal[4]|=1;
                        if (!(val&2)) pal[6]|=1;
                        if (!(val&4)) pal[12]|=1;
                        if (!(val&8)) pal[14]|=1;
                        if (!(val&16)) pal[4]|=2;
                        if (!(val&32)) pal[6]|=2;
                        break;
                        case 2:
                        pal[5]&=~3;
                        pal[7]&=~3;
                        pal[13]&=~1;
                        pal[15]&=~1;
                        if (!(val&1)) pal[5]|=1;
                        if (!(val&2)) pal[7]|=1;
                        if (!(val&4)) pal[13]|=1;
                        if (!(val&8)) pal[15]|=1;
                        if (!(val&16)) pal[5]|=2;
                        if (!(val&32)) pal[7]|=2;
                        break;
                        case 3:
                        pal[1]&=~3;
                        pal[3]&=~3;
                        pal[9]&=~1;
                        pal[11]&=~1;
                        if (!(val&1)) pal[1]|=1;
                        if (!(val&2)) pal[3]|=1;
                        if (!(val&4)) pal[9]|=1;
                        if (!(val&8)) pal[11]|=1;
                        if (!(val&16)) pal[1]|=2;
                        if (!(val&32)) pal[3]|=2;
                        break;
                }
                makelookup4();
                break;
        }
}

unsigned char readula(unsigned short addr)
{
        unsigned char temp;
        switch (addr&0xF)
        {
                case 0:
                temp=ula.ints;
                ula.ints&=~2;
                return temp;
                case 4:
                ula.ints&=~0x10;
                intula(0);
                return ula.receivebyte;
        }
}

void tapecountover()
{
        tapewcount=13;
        if (tapew) ula.ints|=0x30;
        else       ula.ints|=0x20;
        intula(0);
//        printf("Tape count over %02X %i\n",ula.ints,extline);
}

void receive(unsigned char val)
{
      ula.receivebyte=val;
//      printf("Received %02X\n",ula.receivebyte);
      intula(0x10);
}

void genpal()
{
        int c,d;
        for (c=0;c<8;c++)
        {
                for (d=0;d<8;d++)
                {
                        elkpal[c+(d<<3)+128].r=elkpal[c&7].r>>1;
                        elkpal[c+(d<<3)+128].r+=elkpal[d&7].r>>1;
                        elkpal[c+(d<<3)+128].g=elkpal[c&7].g>>1;
                        elkpal[c+(d<<3)+128].g+=elkpal[d&7].g>>1;
                        elkpal[c+(d<<3)+128].b=elkpal[c&7].b>>1;
                        elkpal[c+(d<<3)+128].b+=elkpal[d&7].b>>1;
                        monopal[c+(d<<3)+128].r=monopal[c&7].r>>1;
                        monopal[c+(d<<3)+128].r+=monopal[d&7].r>>1;
                        monopal[c+(d<<3)+128].g=monopal[c&7].g>>1;
                        monopal[c+(d<<3)+128].g+=monopal[d&7].g>>1;
                        monopal[c+(d<<3)+128].b=monopal[c&7].b>>1;
                        monopal[c+(d<<3)+128].b+=monopal[d&7].b>>1;
                }
        }
}

void updateres()
{
        if (hires==2) set_color_depth(16);
        else          set_color_depth(8);
        if (hires) set_gfx_mode(GFX_AUTODETECT,800,600,0,0);
        else       set_gfx_mode(GFX_MODEX,400,300,0,0);
        if (mono) set_palette(monopal);
        else      set_palette(elkpal);
        clear(buffer);
        clear(buff2);
        clear(buf16);
}

void initula()
{
        elkpal[255].r=elkpal[255].g=elkpal[255].b=63;
        monopal[255].r=monopal[255].g=monopal[255].b=63;
        allegro_init();
        set_color_depth(16);
        buf16=create_bitmap(320,256);
        buf162=create_bitmap(640,512);
        Init_2xSaI(16);
        set_color_depth(8);
        if (hires) set_gfx_mode(GFX_AUTODETECT,800,600,0,0);
        else       set_gfx_mode(GFX_MODEX,400,300,0,0);
        genpal();
        if (mono) set_palette(monopal);
        else      set_palette(elkpal);
        install_keyboard();
        buffer=create_bitmap(640,512);
        clear(buffer);
        buff2=create_bitmap(640,512);
        clear(buff2);
        scrshotbuffer=create_bitmap(320,256);
        install_timer();
        install_int_ex(secondtimer,MSEC_TO_TIMER(1000));
        ula.ints=2;
        ula.mode=6;
}

void fadepal()
{
        int c;
        for (c=0;c<128;c++) elkpal[c].r>>=1;
        for (c=0;c<128;c++) elkpal[c].g>>=1;
        for (c=0;c<128;c++) elkpal[c].b>>=1;
        for (c=0;c<128;c++) monopal[c].r>>=1;
        for (c=0;c<128;c++) monopal[c].g>>=1;
        for (c=0;c<128;c++) monopal[c].b>>=1;
        set_palette(elkpal);
        if (mono) set_palette(monopal);
        else      set_palette(elkpal);
}

void restorepal()
{
        int c;
        for (c=0;c<128;c++) elkpal[c].r<<=1;
        for (c=0;c<128;c++) elkpal[c].g<<=1;
        for (c=0;c<128;c++) elkpal[c].b<<=1;
        for (c=0;c<128;c++) monopal[c].r<<=1;
        for (c=0;c<128;c++) monopal[c].g<<=1;
        for (c=0;c<128;c++) monopal[c].b<<=1;
        if (mono) set_palette(monopal);
        else      set_palette(elkpal);
}

int sc;
int tapeframe=0;

void drawline(int line)
{
        int x,y;
        unsigned char val;
        unsigned short addr;
        soundon[line]=soundena;
        if (!line) 
        {
                if (tapeon && fasttape)
                {
                        tapeframe++;
                        if (tapeframe==50)
                        {
                                tapeframe=0;
                                drawfirst=1;
                        }
                }
                else
                   drawfirst=1;
                sc=0;
                ula.addr=(ula.addrlo<<1)|(ula.addrhi<<9);
        }
        if (drawfirst)
        {
        if (line<256)
        {
                switch (ula.mode|(hires&8))
                {
                        case 0:
                        if (sc&8)
                           hline(buffer,0,line,320,0);
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<80;x++)
                                {
                                        if (addr&0x8000) addr-=0x5000;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line])[x]=lookup[val][2];
                                }
                        }
                        break;
                        case 1:
                        if (sc&8)
                           hline(buffer,0,line,320,0);
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<80;x++)
                                {
                                        if (addr&0x8000) addr-=0x5000;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line])[x]=lookup[val][5];
                                }
                        }
                        break;
                        case 2:
                        if (sc&8)
                           hline(buffer,0,line,320,0);
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<80;x++)
                                {
                                        if (addr&0x8000) addr-=0x5000;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line])[x]=lookup[val][6];
                                }
                        }
                        break;
                        case 3:
                        if (sc&8 || line>249)
                           hline(buffer,0,line,320,0);
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<80;x++)
                                {
                                        if (addr&0x8000) addr-=0x4000;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line])[x]=lookup[val][2];
                                }
                        }
                        break;
                        case 4:
                        if (sc&8)
                           hline(buffer,0,line,320,0);
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<80;x+=2)
                                {
                                        if (addr&0x8000) addr-=0x2800;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line])[x]=lookup[val][0];
                                        ((unsigned long *)buffer->line[line])[x+1]=lookup[val][1];
                                }
                        }
                        break;
                        case 5:
                        if (sc&8)
                           hline(buffer,0,line,320,0);
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<80;x+=2)
                                {
                                        if (addr&0x8000) addr-=0x2800;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line])[x]=lookup[val][3];
                                        ((unsigned long *)buffer->line[line])[x+1]=lookup[val][4];
                                }
                        }
                        break;
                        case 6:
                        if (sc&8 || line>249)
                           hline(buffer,0,line,320,0);
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<80;x+=2)
                                {
                                        if (addr&0x8000) addr-=0x2000;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line])[x]=lookup[val][0];
                                        ((unsigned long *)buffer->line[line])[x+1]=lookup[val][1];
                                }
                        }
                        break;
                        case 7:
                        hline(buffer,0,line,320,0);
                        break;
                        case 8:
                        if (sc&8)
                        {
                                hline(buffer,0,line<<1,640,0);
                                if (sdouble) hline(buffer,0,(line<<1)+1,640,0);
                        }
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<160;x+=2)
                                {
                                        if (addr&0x8000) addr-=0x5000;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line<<1])[x]=lookup[val][0];
                                        ((unsigned long *)buffer->line[line<<1])[x+1]=lookup[val][1];
                                        if (sdouble)
                                        {
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x]=lookup[val][0];
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x+1]=lookup[val][1];
                                        }
                                }
                        }
                        break;
                        case 9:
                        if (sc&8)
                        {
                                hline(buffer,0,line<<1,640,0);
                                if (sdouble) hline(buffer,0,(line<<1)+1,640,0);
                        }
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<160;x+=2)
                                {
                                        if (addr&0x8000) addr-=0x5000;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line<<1])[x]=lookup2[val][5][0];
                                        ((unsigned long *)buffer->line[line<<1])[x+1]=lookup2[val][5][1];
                                        if (sdouble)
                                        {
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x]=lookup2[val][5][0];
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x+1]=lookup2[val][5][1];
                                        }
                                }
                        }
                        break;
                        case 10:
                        if (sc&8)
                        {
                                hline(buffer,0,line<<1,640,0);
                                if (sdouble) hline(buffer,0,(line<<1)+1,640,0);
                        }
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<160;x+=2)
                                {
                                        if (addr&0x8000) addr-=0x5000;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line<<1])[x]=lookup2[val][6][0];
                                        ((unsigned long *)buffer->line[line<<1])[x+1]=lookup2[val][6][1];
                                        if (sdouble)
                                        {
                                                ((unsigned long *)buffer->line[(line<<1)+1])[x]=lookup2[val][6][0];
                                                ((unsigned long *)buffer->line[(line<<1)+1])[x+1]=lookup2[val][6][1];
                                        }
                                }
                        }
                        break;
                        case 11:
                        if (sc&8  || line>249)
                        {
                                hline(buffer,0,line<<1,640,0);
                                if (sdouble) hline(buffer,0,(line<<1)+1,640,0);
                        }
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<160;x+=2)
                                {
                                        if (addr&0x8000) addr-=0x4000;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line<<1])[x]=lookup[val][0];
                                        ((unsigned long *)buffer->line[line<<1])[x+1]=lookup[val][1];
                                        if (sdouble)
                                        {
                                                ((unsigned long *)buffer->line[(line<<1)+1])[x]=lookup[val][0];
                                                ((unsigned long *)buffer->line[(line<<1)+1])[x+1]=lookup[val][1];
                                        }
                                }
                        }
                        break;
                        case 12:
                        if (sc&8)
                        {
                                hline(buffer,0,line<<1,640,0);
                                if (sdouble) hline(buffer,0,(line<<1)+1,640,0);
                        }
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<160;x+=4)
                                {
                                        if (addr&0x8000) addr-=0x2800;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line<<1])[x]=lookup2[val][0][0];
                                        ((unsigned long *)buffer->line[line<<1])[x+1]=lookup2[val][0][1];
                                        ((unsigned long *)buffer->line[line<<1])[x+2]=lookup2[val][1][0];
                                        ((unsigned long *)buffer->line[line<<1])[x+3]=lookup2[val][1][1];
                                        if (sdouble)
                                        {
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x]=lookup2[val][0][0];
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x+1]=lookup2[val][0][1];
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x+2]=lookup2[val][1][0];
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x+3]=lookup2[val][1][1];
                                        }
                                }
                        }
                        break;
                        case 13:
                        if (sc&8)
                        {
                                hline(buffer,0,line<<1,640,0);
                                if (sdouble) hline(buffer,0,(line<<1)+1,640,0);
                        }
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<160;x+=4)
                                {
                                        if (addr&0x8000) addr-=0x2800;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line<<1])[x]=lookup2[val][3][0];
                                        ((unsigned long *)buffer->line[line<<1])[x+1]=lookup2[val][3][1];
                                        ((unsigned long *)buffer->line[line<<1])[x+2]=lookup2[val][4][0];
                                        ((unsigned long *)buffer->line[line<<1])[x+3]=lookup2[val][4][1];
                                        if (sdouble)
                                        {
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x]=lookup2[val][3][0];
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x+1]=lookup2[val][3][1];
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x+2]=lookup2[val][4][0];
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x+3]=lookup2[val][4][1];
                                        }
                                }
                        }
                        break;
                        case 14:
                        if (sc&8 || line>249)
                        {
                                hline(buffer,0,line<<1,640,0);
                                if (sdouble) hline(buffer,0,(line<<1)+1,640,0);
                        }
                        else
                        {
                                addr=ula.addr+sc;
                                for (x=0;x<160;x+=4)
                                {
                                        if (addr&0x8000) addr-=0x2000;
                                        val=ram[addr];
                                        addr+=8;
                                        ((unsigned long *)buffer->line[line<<1])[x]=lookup2[val][0][0];
                                        ((unsigned long *)buffer->line[line<<1])[x+1]=lookup2[val][0][1];
                                        ((unsigned long *)buffer->line[line<<1])[x+2]=lookup2[val][1][0];
                                        ((unsigned long *)buffer->line[line<<1])[x+3]=lookup2[val][1][1];
                                        if (sdouble)
                                        {
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x]=lookup2[val][0][0];
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x+1]=lookup2[val][0][1];
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x+2]=lookup2[val][1][0];
                                                ((unsigned long *)buffer->line[(line<<1)+sdouble])[x+3]=lookup2[val][1][1];
                                        }
                                }
                        }
                        break;
                        case 15:
                        hline(buffer,0,line<<1,640,0);
                        if (sdouble) hline(buffer,0,(line<<1)+1,640,0);
                        break;
                }
                sc++;
                sc&=15;
                if (ula.mode==3 || ula.mode==6)
                {
                        if (sc>=10)
                        {
                                sc=0;
                                if (ula.mode&4) ula.addr+=320;
                                else            ula.addr+=640;
                        }
                }
                else
                {                        
                        if (sc>=8)
                        {
                                sc=0;
                                if (ula.mode&4) ula.addr+=320;
                                else            ula.addr+=640;
                        }
                }                        
        }
        }
        if (line==99)
           intula(8);
        if (line==256)
        {
                intula(4);
//                textprintf(buffer,font,0,0,7,"%i",fps);
                if (drawfirst)//!tapeon || !tapeframe)
                {
                        if (hires==2)
                        {
                                blit(buffer,buf16,0,0,0,0,320,256);
                                Super2xSaI(buf16,buf162,0,0,0,0,320,256);
                                blit(buf162,screen,0,0,80,44,640,512);
                        }
                        else
                        {
                        if (blur)
                        {
                                if (hires)
                                {
                                        for (y=0;y<512;y+=2)
                                        {
                                                buff2->line[y][0]=buff2->line[y][1]=buffer->line[y][0];
                                                for (x=2;x<640;x+=2)
                                                {
                                                        buff2->line[y][x]=buff2->line[y][x+1]=128+buffer->line[y][x]+(buffer->line[y][x-2]<<3);
                                                }
                                        }
                                        blit(buff2,screen,0,0,80,44,640,512);
                                }
                                else
                                {
                                        for (y=0;y<256;y++)
                                        {
                                                buff2->line[y][0]=buffer->line[y][0];
                                                for (x=1;x<320;x++)
                                                {
                                                        buff2->line[y][x]=128+buffer->line[y][x]+(buffer->line[y][x-1]<<3);
                                                }
                                        }
                                        blit(buff2,screen,0,0,40,22,320,256);
                                }
                        }
                        else
                        {
                                if (hires) blit(buffer,screen,0,0,80,44,640,512);
                                else       blit(buffer,screen,0,0,40,22,320,256);
                        }
                        }
                }
                drawfirst=0;
                frames++;
        }
}

void loadulastate(FILE *f)
{
        int c;
        fread(pal,16,1,f);
        ula.ints=getc(f);
        ula.intc=getc(f);
        ula.addrlo=getc(f);
        ula.addrhi=getc(f);
        ula.mode=getc(f);
        ula.receivebyte=getc(f);
        tapeon=getc(f);
        soundena=getc(f);
        soundlimit=getc(f);
        soundlimit|=getc(f)<<8;
        soundlimit|=getc(f)<<16;
        soundlimit|=getc(f)<<24;
        intula(0);
        for (c=0x80;c<0x0C0;c++) mem[c]=(unsigned char *)(rom+(currom<<14)+((c&0x3F)<<8));
        if (currom==8 || currom==9) for (c=0x80;c<0xC0;c++) memstat[c]=2;
        else                        for (c=0x80;c<0xC0;c++) memstat[c]=1;
        makelookup4();
}

void saveulastate(FILE *f)
{
        fwrite(pal,16,1,f);
        putc(ula.ints,f);
        putc(ula.intc,f);
        putc(ula.addrlo,f);
        putc(ula.addrhi,f);
        putc(ula.mode,f);
        putc(ula.receivebyte,f);
        putc(tapeon,f);
        putc(soundena,f);
        putc(soundlimit&0xFF,f);
        putc((soundlimit>>8)&0xFF,f);
        putc((soundlimit>>16)&0xFF,f);
        putc((soundlimit>>24)&0xFF,f);
}

