/*Elkulator 0.5 by Tom Walker*/
/*DOS GUI*/
#include <stdio.h>
#include <allegro.h>
#include "elk.h"

int changed[2];
int cngres=0;
int sdouble=0;
int fasttape;
MENU soundmenu[3];
MENU videomenu[5];
MENU resmenu[5];
MENU discmenu[6];

void saveconfig()
{
        char s[80];
        set_config_file("elk.cfg");
        set_config_string(NULL,"tape_name",tapename);
        set_config_string(NULL,"disc_name",discname);
        set_config_string(NULL,"disc_name_2",discname2);
        sprintf(s,"%i",soundenable);
        set_config_string(NULL,"sound_enable",s);
        sprintf(s,"%i",pcsound);
        set_config_string(NULL,"pc_sound",s);
        sprintf(s,"%i",mono);
        set_config_string(NULL,"mono",s);
        sprintf(s,"%i",plus3ena);
        set_config_string(NULL,"plus_3_enable",s);
        sprintf(s,"%i",adfsena);
        set_config_string(NULL,"adfs_enable",s);
        sprintf(s,"%i",dfsena);
        set_config_string(NULL,"dfs_enable",s);
        sprintf(s,"%i",hires);
        set_config_string(NULL,"resolution",s);
        sprintf(s,"%i",blur);
        set_config_string(NULL,"blur",s);
        sprintf(s,"%i",sdouble);
        set_config_string(NULL,"scanline_double",s);
        sprintf(s,"%i",fasttape);
        set_config_string(NULL,"fast_tape",s);
}

void loadconfig()
{
        char *s;
        set_config_file("elk.cfg");
        s=get_config_string(NULL,"tape_name",NULL);
        strcpy(tapename,s);
        s=get_config_string(NULL,"disc_name",NULL);
        strcpy(discname,s);
        s=get_config_string(NULL,"disc_name_2",NULL);
        strcpy(discname2,s);
        s=get_config_string(NULL,"sound_enable",NULL);
        if (!s || strcmp(s,"1")) soundenable=0;
        else                     soundenable=1;
        s=get_config_string(NULL,"pc_sound",NULL);
        if (!s || strcmp(s,"1")) pcsound=0;
        else                     pcsound=1;
        s=get_config_string(NULL,"mono",NULL);
        if (!s || strcmp(s,"1")) mono=0;
        else                     mono=1;
        s=get_config_string(NULL,"plus_3_enable",NULL);
        if (!s || strcmp(s,"1")) plus3ena=0;
        else                     plus3ena=1;
        s=get_config_string(NULL,"adfs_enable",NULL);
        if (!s || strcmp(s,"1")) adfsena=0;
        else                     adfsena=1;
        s=get_config_string(NULL,"dfs_enable",NULL);
        if (!s || strcmp(s,"1")) dfsena=0;
        else                     dfsena=1;
        s=get_config_string(NULL,"resolution",NULL);
        if (!s) hires=0;
        else    sscanf(s,"%i",&hires);
        s=get_config_string(NULL,"blur",NULL);
        if (!s || strcmp(s,"1")) blur=0;
        else                     blur=1;
        s=get_config_string(NULL,"scanline_double",NULL);
        if (!s || strcmp(s,"1")) sdouble=0;
        else                     sdouble=1;
        s=get_config_string(NULL,"fast_tape",NULL);
        if (!s || strcmp(s,"1")) fasttape=0;
        else                     fasttape=1;
}

int fileret()
{
        quit=0;
        return D_CLOSE;
}

int filequit()
{
        quit=1;
        return D_CLOSE;
}

int mscrshot()
{
        int temp;
        char fn[260];
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        if (file_select_ex("Enter a file name",fn,"BMP",260,xsize,ysize))
        {
//                printf("Saving %s\n",fn);
                restorepal();
                if (hires==2)
                {
                        temp=save_bmp(fn,buf162,elkpal);
                }
                else if (!hires)
                {
                        blit(buffer,scrshotbuffer,0,0,0,0,320,256);
                        temp=save_bmp(fn,buffer,elkpal);
                }
                else
                {
                        temp=save_bmp(fn,buffer,elkpal);
                }
                fadepal();
        }
        return D_EXIT;
}

int lsnap()
{
        char tempname[260];
        int ret,c;
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        memset(tempname,0,260);
        ret=file_select_ex("Enter a file name",tempname,"SNP",260,xsize,ysize);
        if (ret)
        {
                c=loadsnapshot(tempname);
        }
        return D_CLOSE;
}

int ssnap()
{
        char tempname[260];
        int ret,c;
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        memset(tempname,0,260);
        ret=file_select_ex("Enter a file name",tempname,"SNP",260,xsize,ysize);
        if (ret)
        {
                savesnapshot(tempname);
        }
        return D_CLOSE;
}

int freset()
{
        reset6502();
        reset1770();
        ula.ints|=2;
        memset(ram,0,32768);
        return D_CLOSE;
}


MENU filemenu[]=
{
        {"&Return",fileret,NULL,NULL,NULL},
        {"R&eset",freset,NULL,NULL,NULL},
        {"&Load Snapshot...",lsnap,NULL,NULL,NULL},
        {"&Save Snapshot...",ssnap,NULL,NULL,NULL},
        {"&Quit",filequit,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}        
};

int plus3()
{
        if (plus3ena)
        {
                plus3ena=0;
                discmenu[0].flags&=~D_SELECTED;
        }
        else
        {
                plus3ena=1;
                discmenu[0].flags|=D_SELECTED;
        }
        reset6502();
        reset1770();
        updateadfs();
        ula.ints|=2;
        return D_CLOSE;
}

int adfsen()
{
        if (adfsena)
        {
                adfsena=0;
                discmenu[1].flags&=~D_SELECTED;
        }
        else
        {
                adfsena=1;
                discmenu[1].flags|=D_SELECTED;
        }
        if (plus3ena)
        {
                reset6502();
                reset1770();
                updateadfs();
                ula.ints|=2;
        }
        return D_CLOSE;
}

int dfsen()
{
        if (dfsena)
        {
                dfsena=0;
                discmenu[2].flags&=~D_SELECTED;
        }
        else
        {
                dfsena=1;
                discmenu[2].flags|=D_SELECTED;
        }
        if (plus3ena)
        {
                reset6502();
                reset1770();
                updateadfs();
                ula.ints|=2;
        }
        return D_CLOSE;
}

int changedisc()
{
        char tempname[260];
        int ret,c;
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        memcpy(tempname,discname,260);
        if (changed[0]) savedisc(discname,0);
        ret=file_select_ex("Please choose a disc image",tempname,"ADF;SSD;DSD",260,xsize,ysize);
        if (ret)
        {
                memcpy(discname,tempname,260);
                loaddisc(discname,0);
        }
        return D_CLOSE;
}

int changedisc2()
{
        char tempname[260];
        int ret,c;
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        memcpy(tempname,discname2,260);
        if (changed[1]) savedisc(discname,1);
        ret=file_select_ex("Please choose a disc image",tempname,"ADF;SSD;DSD",260,xsize,ysize);
        if (ret)
        {
                memcpy(discname2,tempname,260);
                loaddisc(discname2,1);
        }
        return D_CLOSE;
}

MENU discmenu[]=
{
        {"&Plus 3 Enable",plus3,NULL,NULL,NULL},
        {"&ADFS Enable",adfsen,NULL,NULL,NULL},
        {"&DFS Enable",dfsen,NULL,NULL,NULL},
        {"Load disc &0/2...",changedisc,NULL,NULL,NULL},
        {"Load disc &1/3...",changedisc2,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

int changetape()
{
        char tempname[260];
        int ret,c;
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        memcpy(tempname,tapename,260);
        ret=file_select_ex("Please choose a UEF file",tempname,"UEF",260,xsize,ysize);
        if (ret)
        {
                memcpy(tapename,tempname,260);
                openuef(tapename);
        }
        return D_CLOSE;
}

int rewindtape()
{
        openuef(tapename);
        return D_CLOSE;
}

int fastl()
{
        fasttape^=1;
        return D_CLOSE;
}

MENU tapemenu[]=
{
        {"&Load tape...",changetape,NULL,NULL,NULL},
        {"&Rewind tape",rewindtape,NULL,NULL,NULL},
        {"&Fast loading",fastl,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

int loadrom()
{
        int temp;
        char fn[260];
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        fn[0]=0;
        if (file_select_ex("Please choost a ROM image",fn,"ROM",260,xsize,ysize))
        {
                loadcart(fn);
                reset6502();
                reset1770();
                ula.ints|=2;
        }
        return D_CLOSE;
}

int loadrom2()
{
        int temp;
        char fn[260];
        int xsize=(hires)?768:384;
        int ysize=(hires)?384:192;
        fn[0]=0;
        if (file_select_ex("Please choost a ROM image",fn,"ROM",260,xsize,ysize))
        {
                loadcart2(fn);
                reset6502();
                reset1770();
                ula.ints|=2;
        }
        return D_CLOSE;
}

int unloadrom()
{
        unloadcart();
        reset6502();
        reset1770();
        ula.ints|=2;
        return D_CLOSE;
}

MENU rommenu[]=
{
        {"Load ROM cartridge &1...",loadrom,NULL,NULL,NULL},
        {"Load ROM cartridge &2...",loadrom2,NULL,NULL,NULL},
        {"&Unload ROM cartridges",unloadrom,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

int blurena()
{
        blur^=1;
        videomenu[1].flags^=D_SELECTED;
        return D_CLOSE;
}

int monoena()
{
        mono^=1;
        videomenu[2].flags^=D_SELECTED;
        return D_CLOSE;
}

int fullscr()
{
        fullscreen=0;
        return D_CLOSE;
}

int reslo()
{
        hires=0;
        cngres=1;
        return D_CLOSE;
}

int reshis()
{
        hires=8;
        sdouble=0;
        cngres=1;
        return D_CLOSE;
}

int reshi()
{
        hires=8;
        sdouble=0;
        cngres=1;
        return D_CLOSE;
}

int res2xsai()
{
        hires=2;
        cngres=1;
        return D_CLOSE;
}

MENU resmenu[]=
{
        {"&400x300",reslo,NULL,NULL,NULL},
        {"800x600 with &scanlines",reshis,NULL,NULL,NULL},
        {"&800x600",reshi,NULL,NULL,NULL},
        {"800x600 with &2xSaI",res2xsai,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

MENU videomenu[]=
{
        {"&Resolution",NULL,resmenu,NULL,NULL},
//        {"&Fullscreen",fullscr,NULL,NULL,NULL},
        {"&Blur filter",blurena,NULL,NULL,NULL},
        {"&Monochrome",monoena,NULL,NULL,NULL},
        {"&Screenshot...",mscrshot,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

int sndenable()
{
        soundenable^=1;
        soundmenu[0].flags^=D_SELECTED;
//        updatesnd();
        return D_CLOSE;
}

int pcsndenable()
{
        pcsound^=1;
        soundmenu[1].flags^=D_SELECTED;
        return D_CLOSE;
}

MENU soundmenu[]=
{
        {"&Enabled",sndenable,NULL,NULL,NULL},
        {"&PC Speaker Enabled",pcsndenable,NULL,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

MENU mainmenu[]=
{
        {"&File",NULL,filemenu,NULL,NULL},
        {"&Disc",NULL,discmenu,NULL,NULL},
        {"&Tape",NULL,tapemenu,NULL,NULL},
        {"&ROM",NULL,rommenu,NULL,NULL},
        {"&Video",NULL,videomenu,NULL,NULL},
        {"&Sound",NULL,soundmenu,NULL,NULL},
        {NULL,NULL,NULL,NULL,NULL}
};

DIALOG elkgui[]=
{
      {d_ctext_proc, 200, 292, 0,  0, 255,   0,0,0,0,0,"Elkulator v0.6"},
      {d_menu_proc,  0,   0,   0,  0, 0xFFFF,0,0,0,0,0,mainmenu},
      {0,0,0,0,0,0,0,0,0,0,0,NULL,NULL,NULL}
};

void dogui()
{
        DIALOG_PLAYER *dp;
        int oldres=hires;
        int olds=soundenable;
        int x=1;
        if (pcsound) nosound();
        if (hires) { elkgui[0].x=400; elkgui[0].y=592; }
        else       { elkgui[0].x=200; elkgui[0].y=292; }
        fadepal();
        resmenu[0].flags&=~D_SELECTED; resmenu[1].flags&=~D_SELECTED; resmenu[2].flags&=~D_SELECTED; resmenu[3].flags&=~D_SELECTED;
        if (hires==1)     resmenu[3].flags|=D_SELECTED;
        else if (!hires)  resmenu[0].flags|=D_SELECTED;
        else if (sdouble) resmenu[2].flags|=D_SELECTED;
        else              resmenu[1].flags|=D_SELECTED;
        if (plus3ena) discmenu[0].flags|=D_SELECTED;
        else          discmenu[0].flags&=~D_SELECTED;
        if (adfsena) discmenu[1].flags|=D_SELECTED;
        else         discmenu[1].flags&=~D_SELECTED;
        if (dfsena) discmenu[2].flags|=D_SELECTED;
        else        discmenu[2].flags&=~D_SELECTED;
        if (fasttape) tapemenu[2].flags|=D_SELECTED;
        else          tapemenu[2].flags&=~D_SELECTED;
        if (blur) videomenu[1].flags|=D_SELECTED;
        else      videomenu[1].flags&=~D_SELECTED;
        if (mono) videomenu[2].flags|=D_SELECTED;
        else      videomenu[2].flags&=~D_SELECTED;
        if (soundenable) soundmenu[0].flags|=D_SELECTED;
        else             soundmenu[0].flags&=~D_SELECTED;
        if (pcsound) soundmenu[1].flags|=D_SELECTED;
        else         soundmenu[1].flags&=~D_SELECTED;
        gui_fg_color=makecol(255,255,255);
        gui_bg_color=makecol(0,0,0);
        elkgui[0].fg=makecol(255,255,255);
        set_mouse_sprite(NULL);
        cngres=0;
        dp=init_dialog(elkgui,0);
        show_mouse(screen);
        while (x && !key[KEY_F11] && !(mouse_b&2) && !key[KEY_ESC])
        {
                x=update_dialog(dp);
        }
        show_mouse(NULL);
        shutdown_dialog(dp);
        if (key[KEY_ESC]) { while (key[KEY_ESC]) yield_timeslice(); }
        rectfill(screen,0,0,400,22,0);
        rectfill(screen,0,292,400,300,0);
        rectfill(screen,0,592,800,600,0);
        if (cngres) updateres();
        restorepal();
        if (pcsound && soundena) sound(pcsoundl);
        if (soundenable && !olds) install_sound(DIGI_AUTODETECT,MIDI_NONE,0);
        if (!soundenable && olds) remove_sound();
}
