/*Elkulator 0.6 by Tom Walker*/
/*1770 emulator*/

#include <stdio.h>
#include <allegro.h>
#include "elk.h"

#define SIDES 2
#define TRACKS 80
#define SECTORS 16
#define SECTORSIZE 256

int changed[2];

char serr[256];
int discin[4];

int output;
unsigned char discs[2][SIDES][SECTORS*TRACKS][SECTORSIZE];

int endcommand=0;
int curside,curdisc;
int nmi;
int discint;

int sectorpos;
struct
{
        unsigned char track,sector,data,command,control,status;
        int curtrack,cursector;
} wd1770;

void loaddisc(char *fn, int drv)
{
        char s[80];
        FILE *f=fopen(fn,"rb");
        int c=0,d,e,ff;
        if (!f) return;
        changed[drv]=0;
        while (fn[c]) c++; /*Find end of filename*/
        while (fn[c]!='.') c--; /*Find file extension*/
        if (fn[c+1]=='a' || fn[c+1]=='A') /*Test file extension*/
        {                                 /*.ADF - ADFS file*/
                for (c=0;c<80*16*256;c++)
                    discs[drv][0][c>>8][c&255]=getc(f);
        }
        else if (fn[c+1]=='s' || fn[c+1]=='S') /*.SSD - Single sided DFS file*/
        {
                for (c=0;c<80;c++)
                {
                        for (d=0;d<10;d++)
                        {
                                for (e=0;e<256;e++)
                                {
                                        discs[drv][0][(c<<4)+d][e]=getc(f);
                                }
                        }
                }
        }
        else if (fn[c+1]=='d' || fn[c+1]=='D') /*.DSD - Double sided DFS file*/
        {
                for (c=0;c<80;c++)
                {
                        for (ff=0;ff<2;ff++)
                        {
                                for (d=0;d<10;d++)
                                {
                                        for (e=0;e<256;e++)
                                        {
                                                discs[drv][ff][(c<<4)+d][e]=getc(f);
                                        }
                                }
                        }
                }
        }
        fclose(f);
}

void savedisc(char *fn, int drv)
{
        char s[80];
        FILE *f=fopen(fn,"wb");
        int c=0,d,e,ff;
        if (!f) return;
        while (fn[c]) c++; /*Find end of filename*/
        while (fn[c]!='.') c--; /*Find file extension*/
        if (fn[c+1]=='a' || fn[c+1]=='A') /*Test file extension*/
        {                                 /*.ADF - ADFS file*/
                for (c=0;c<80*16*256;c++)
                    putc(discs[drv][0][c>>8][c&255],f);
        }
        else if (fn[c+1]=='s' || fn[c+1]=='S') /*.SSD - Single sided DFS file*/
        {
                for (c=0;c<80;c++)
                {
                        for (d=0;d<10;d++)
                        {
                                for (e=0;e<256;e++)
                                {
                                        putc(discs[drv][0][(c<<4)+d][e],f);
                                }
                        }
                }
        }
        else if (fn[c+1]=='d' || fn[c+1]=='D') /*.DSD - Double sided DFS file*/
        {
                for (c=0;c<80;c++)
                {
                        for (ff=0;ff<2;ff++)
                        {
                                for (d=0;d<10;d++)
                                {
                                        for (e=0;e<256;e++)
                                        {
                                                putc(discs[drv][ff][(c<<4)+d][e],f);
                                        }
                                }
                        }
                }
        }
        fclose(f);
}

void reset1770()
{
        wd1770.control=0xFF;
        wd1770.status=0x80;
        discint=0;
        nmi=0;
}

void set1770poll(int c)
{
        discint=c;
}

void start1770command()
{
        wd1770.status|=1;
        endcommand=0;
        switch (wd1770.command>>4)
        {
                case 0: wd1770.track=wd1770.curtrack=0; wd1770.status&=~1; wd1770.status|=4; break; /*Restore*/
                case 1: wd1770.track=wd1770.curtrack=wd1770.data; wd1770.status&=~5; if (!wd1770.curtrack) wd1770.status|=4; break; /*Seek*/
                case 5: wd1770.curtrack++; wd1770.track=wd1770.curtrack; wd1770.status&=~5; break; /*Step in*/
                case 8: wd1770.status=0x83; sectorpos=0; wd1770.curtrack=wd1770.track; wd1770.cursector=wd1770.sector; break; /*Read sector*/
                case 0xA: wd1770.status=0x83; sectorpos=0; wd1770.curtrack=wd1770.track; wd1770.cursector=wd1770.sector; changed[curdisc]=1; break; /*Write sector*/
                default:
                printf("Bad 1770 command %01X\n",wd1770.command>>4);
                dumpregs();
                exit(-1);
        }
}

void write1770(unsigned short addr, unsigned char val)
{
        switch (addr)
        {
                case 0xFCC0: /*Control register*/
                wd1770.control=val;
                if (val&0x20) reset1770();
                if (val&1) curdisc=0;
                if (val&2) curdisc=1;
                if (val&4) curside=1; else curside=0;
                return;
                case 0xFCC4: /*Command*/
                if (wd1770.status&1 && (val>>4)!=0xD) return;
                wd1770.command=val;
                start1770command();
                return;
                case 0xFCC5: /*Track register*/
                wd1770.track=val;
                return;
                case 0xFCC6: /*Sector register*/
                wd1770.sector=val;
                return;
                case 0xFCC7: /*Data register*/
                wd1770.status&=~2;
                nmi&=~2;
                wd1770.data=val;
                if ((wd1770.command>>4)==0xA)
                {
                        discs[curdisc][curside][(wd1770.curtrack*16)+wd1770.cursector][sectorpos++]=val;
                        if (sectorpos==256)
                        {
                                wd1770.status=0x80;
                                wd1770.command=0;
                        }
                        else
                           wd1770.status|=2;
                }
                return;
        }
}

unsigned char read1770(unsigned short addr)
{
        switch (addr)
        {
                case 0xFCC0: /*Control*/
                return wd1770.control;
                case 0xFCC4: /*Status register*/
                return wd1770.status;
                case 0xFCC5: /*Track register*/
                return wd1770.track;
                case 0xFCC6: /*Sector register*/
                return wd1770.sector;
                case 0xFCC7: /*Data register*/
                if ((wd1770.command>>4)==8)
                {
                        wd1770.data=discs[curdisc][curside][(wd1770.curtrack*16)+wd1770.cursector][sectorpos++];
                        if (sectorpos==256)
                        {
                                wd1770.status=0x80;
                                wd1770.command=0;
                        }
                }
                return wd1770.data; 
        }
}
