#include "main.h"

#define DEFINE_PATTERN_CONSTRUCTORS
#include "pattern.h"
#include "sqwave.h"
#include "triwave.h"
#include "noise.h"

#include "sfx.h"



#define H1 3072
#define H2 4869
#define H3 6144
#define H4 7133



#define SQ 1

static PATTERN pattern_menu_select[] = {
	S(60,60),
	N(0,SQ,32,48,0,0),N(1,SQ,64,60,0,0),N(2,SQ,128,72,0,0),R(),
	P(0,   16,48,0  ),P(1,   32,60,0  ),P(2,    64,72,0  ),E()
};

static PATTERN pattern_menu_enter[] = {
	S(20,60),
	N(0,SQ,255,48,0,0),R(),
	R(),
	N(0,SQ,255,60,0,0),R(),
	N(0,SQ,255,48,0,0),E()
};

static PATTERN pattern_menu_error[] = {
	S(5,60),
	N(0,SQ, 64,0, 0,0),N(1,SQ, 64,0, 0,0),
	N(2,SQ, 24,0,H1,0),N(3,SQ, 24,0,H1,0),
	N(4,SQ, 24,0,H2,0),N(5,SQ, 24,0,H2,0),
	N(6,SQ,  8,0,H3,0),N(7,SQ,  8,0,H3,0),
	N(8,SQ,  8,0,H4,0),N(9,SQ,  8,0,H4,0),
	E()
};

#undef SQ

#define GW 1
#define GB 2
#define TR 3
#define NS 4

static PATTERN pattern_gunshot_whistle[] = {
	S(30,60),
	N(0,TR,21,60,   80-180,0),R(),
	P(0,   43,60,   40-150  ),R(),
	P(0,   64,60,    0      ),R(),
	P(0,   59,60,  -40+150  ),R(),
	P(0,   53,60,  -80+180  ),R(),
	P(0,   36,60, -120+150  ),R(),
	P(0,   29,60, -160      ),R(),
	P(0,   25,60, -200-150  ),R(),
	P(0,   22,60, -240-180  ),R(),
	P(0,   20,60, -280-150  ),R(),
	P(0,   18,60, -320      ),R(),
	P(0,   16,60, -360+150  ),R(),
	P(0,   15,60, -400+180  ),R(),
	P(0,   13,60, -440+150  ),R(),
	P(0,   12,60, -480      ),R(),
	P(0,   11,60, -520-150  ),R(),
	P(0,   10,60, -560-180  ),R(),
	P(0,    9,60, -600-150  ),R(),
	P(0,    8,60, -640      ),R(),
	P(0,    7,60, -680+150  ),R(),
	P(0,    6,60, -720+180  ),R(),
	P(0,    6,60, -760+150  ),R(),
	P(0,    5,60, -800      ),R(),
	P(0,    4,60, -840-150  ),R(),
	P(0,    4,60, -880-180  ),R(),
	P(0,    3,60, -920-150  ),R(),
	P(0,    3,60, -960      ),R(),
	P(0,    2,60,-1000+150  ),R(),
	P(0,    2,60,-1040+180  ),R(),
	P(0,    1,60,-1080+150  ),R(),
	P(0,    1,60,-1120      ),R(),
	P(0,    1,60,-1160-150  ),E()
};

static PATTERN pattern_gunshot_bang[] = {
	S(30,60),
	N(0,NS,192,36,0,0),R(),
	P(0,   148,36,0  ),R(),
	P(0,   143,36,0  ),R(),
	P(0,   130,36,0  ),R(),
	P(0,   120,36,0  ),R(),
	P(0,   111,36,0  ),R(),
	P(0,   103,36,0  ),R(),
	P(0,    96,36,0  ),R(),
	P(0,    90,36,0  ),R(),
	P(0,    85,36,0  ),R(),
	P(0,    80,36,0  ),R(),
	P(0,    75,36,0  ),R(),
	P(0,    70,36,0  ),R(),
	P(0,    65,36,0  ),R(),
	P(0,    60,36,0  ),R(),
	P(0,    55,36,0  ),R(),
	P(0,    50,36,0  ),R(),
	P(0,    45,36,0  ),R(),
	P(0,    41,36,0  ),R(),
	P(0,    36,36,0  ),R(),
	P(0,    32,36,0  ),R(),
	P(0,    28,36,0  ),R(),
	P(0,    24,36,0  ),R(),
	P(0,    20,36,0  ),R(),
	P(0,    16,36,0  ),R(),
	P(0,    13,36,0  ),R(),
	P(0,    11,36,0  ),R(),
	P(0,     9,36,0  ),R(),
	P(0,     7,36,0  ),R(),
	P(0,     5,36,0  ),R(),
	P(0,     3,36,0  ),R(),
	P(0,     1,36,0  ),E()
};

static PATTERN pattern_gunshot[] = {
	S(15,15),
	N(0,GB,255, 0,0,0),
	N(1,GB,255, 6,0,0),
	N(2,GB,255,12,0,0),
	N(3,GB,255,24,0,0),
	N(4,GB,128,36,0,0),
	N(5,GW,255, 0,0,0),
	N(6,GW,255, 4,0,0),
	R(),R(),R(),E()
};

#undef GW
#undef GB
#undef TR
#undef NS



static DUH_SIGTYPE_DESC *menu_select_desc[] = {
	&pattern_desc,
	&sqwave_desc
};

static void *menu_select_sigdata[] = {
	pattern_menu_select,
	NULL
};



static DUH_SIGTYPE_DESC *menu_enter_desc[] = {
	&pattern_desc,
	&sqwave_desc
};

static void *menu_enter_sigdata[] = {
	pattern_menu_enter,
	NULL
};



static DUH_SIGTYPE_DESC *menu_error_desc[] = {
	&pattern_desc,
	&sqwave_desc
};

static void *menu_error_sigdata[] = {
	pattern_menu_error,
	NULL
};



static DUH_SIGTYPE_DESC *gunshot_desc[] = {
	&pattern_desc,
	&pattern_desc,
	&pattern_desc,
	&triwave_desc,
	&noise_desc
};

static void *gunshot_sigdata[] = {
	pattern_gunshot,
	pattern_gunshot_whistle,
	pattern_gunshot_bang,
	NULL,
	NULL
};



DUH *sfx_menu_select = NULL;
DUH *sfx_menu_enter = NULL;
DUH *sfx_menu_error = NULL;
DUH *sfx_gunshot = NULL;



void make_sfx(void)
{
	init_noise();

	sfx_menu_select = make_duh(0, 2, menu_select_desc, menu_select_sigdata);
	sfx_menu_enter = make_duh(0, 2, menu_enter_desc, menu_enter_sigdata);
	sfx_menu_error = make_duh(0, 2, menu_error_desc, menu_error_sigdata);
	sfx_gunshot = make_duh(0, 5, gunshot_desc, gunshot_sigdata);
}

void destroy_sfx(void)
{
	unload_duh(sfx_menu_select);
	unload_duh(sfx_menu_enter);
	unload_duh(sfx_menu_error);
	unload_duh(sfx_gunshot);
}
