#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <aldumb.h>
#include "main.h"
#include "texture.h"
#include "timeloop.h"
#include "screen.h"
#include "menu.h"
#include "m_warn.h"
#include "m_missn.h"
#include "m_main.h"
#include "m_error.h"
#include "tconfig.h"
#include "sfx.h"
#include "sfxplay.h"
#include "music.h"



static RGB_MAP the_rgb_map;

BITMAP *sand_texture;
BITMAP *quicksand_texture;
BITMAP *player_texture;
BITMAP *teletubby_texture;
BITMAP *bmp_mission_complete;
BITMAP *bmp_mission_failed;

DUH *sfx_menu_select;
DUH *sfx_menu_enter;

PALETTE pal = {
	{  0  ,   0  ,   0  , 0},
	{204/4, 204/4, 255/4, 0},
	{192/4, 192/4,  64/4, 0},
	{255/4, 255/4, 255/4, 0},
	{255/4,   0/4,   0/4, 0},
	{  0/4,   0/4,   0/4, 0},
	{  0/4,  64/4, 192/4, 0},
	{192/4,  64/4,   0/4, 0},
	{  0/4, 102/4,   0/4, 0},
	{ 51/4, 102/4, 204/4, 0},
	{255/4, 204/4, 153/4, 0},
	{102/4,  51/4,   0/4, 0},
	{128/4,   0/4, 176/4, 0},
	{160/4, 160/4, 160/4, 0},
	{210/4, 185/4, 160/4, 0},
	{170/4, 255/4,  85/4, 0},
	{ 64/4, 128/4,   0/4, 0}
};

int palptr = 17;



int main(void);
int main(void)
{
	int gfx_reverted = 0;
	int sound;

	srand(time(NULL));
	set_uformat(U_ASCII);
	allegro_init();
	set_config_file("telehack.ini");
	install_timer();
	init_timeloop();
	init_menu_module();
	install_keyboard();
	set_volume_per_voice(0);
	reserve_voices(64, -1);
	sound = install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);

	load_options();

	text_mode(-1);

	palette_texture(160, 224, 64, 32);
	palette_texture(128, 192, 32, 48);

	create_rgb_table(&the_rgb_map, pal, NULL);
	rgb_map = &the_rgb_map;

	if (set_screen(8, GFX_W, GFX_H)) {
		char first_error[256];
		if (opt_gfx_mode_id == 0) {
			allegro_message("Error setting graphics mode 320x200x8\n%s\n", allegro_error);
			exit(1);
		}
		strcpy(first_error, allegro_error);
		if (set_screen(8, 320, 200)) {
			allegro_message(
				"Error setting graphics mode %dx%dx8\n%s\n\n"
				"Error setting graphics mode 320x200x8\n%s\n",
				GFX_W, GFX_H, first_error, allegro_error
			);
			exit(1);
		}
		opt_gfx_mode_id = 0;
		gfx_reverted = 1;
	}

	sand_texture = create_texture(128, 128, 160, 224, 64, 32);
	quicksand_texture = create_texture(128, 128, 128, 192, 32, 48);
	player_texture = create_player_texture();
	teletubby_texture = create_teletubby_texture();
	bmp_mission_complete = create_text_bmp("MISSION COMPLETE", makecol(0, 64, 192));
	bmp_mission_failed = create_text_bmp("MISSION FAILED", makecol(192, 64, 0));

	if (sound == 0) make_sfx();
	init_sfx();

	/* Give modern monitors time to come on (grr). */
	rest(get_config_int("misc", "monitor_delay", 2000));

	{
		MENU_SYSTEM *ms = init_menu_system();
		if (gfx_reverted)
			run_error_menu(ms, "Graphics mode reverted to 320x200");
		run_warning_menu(ms);
		init_music();
		run_mission_menu(ms);
		run_main_menu(ms);
		shut_down_menu_system(ms);
		shut_down_music();
		clear(screen);
		rest_callback(300, &sfx_poll); /* Allow sound effects to finish playing. */
	}

	shut_down_sfx();
	destroy_sfx();

	destroy_bitmap(bmp_mission_failed);
	destroy_bitmap(bmp_mission_complete);
	destroy_bitmap(teletubby_texture);
	destroy_bitmap(player_texture);
	destroy_bitmap(quicksand_texture);
	destroy_bitmap(sand_texture);

	save_options();

	return 0;
}
END_OF_MAIN();

