#include "main.h"
#include "tconfig.h"
#include "menu.h"
#include "menuproc.h"
#include "m_option.h"
#include "timeloop.h"
#include "sfx.h"
#include "sfxplay.h"



int run_options_menu(MENU_SYSTEM *ms)
{
	int new_gfx_mode_id = opt_gfx_mode_id;

	MENU_ENTRY me[] = {
		/* draw            , x                      , y                          , dp1                      , key       , k1                   , kp1 */
		{&md_textout_right , (GFX_W >> 1) + FONT_W*7, (GFX_H >> 1) - (FONT_H/2)*6, "Number of Teletubbies: ", &mk_option, OPT_N_TELETUBBIES_MAX, &opt_n_teletubbies_id},
		{&md_option        , (GFX_W >> 1) + FONT_W*7, (GFX_H >> 1) - (FONT_H/2)*6, opt_n_teletubbies_str    , NULL      , 0                    , &opt_n_teletubbies_id},
		{&md_textout_right , (GFX_W >> 1) + FONT_W*7, (GFX_H >> 1) - (FONT_H/2)*4, "Difficulty: "           , &mk_option, OPT_DIFFICULTY_MAX   , &opt_difficulty_id   },
		{&md_option        , (GFX_W >> 1) + FONT_W*7, (GFX_H >> 1) - (FONT_H/2)*4, opt_difficulty_str       , NULL      , 0                    , &opt_difficulty_id   },
		{&md_textout_right , (GFX_W >> 1) + FONT_W*7, (GFX_H >> 1) - (FONT_H/2)*0, "Graphics Mode: "        , &mk_option, OPT_GFX_MODE_MAX     , &new_gfx_mode_id     },
		{&md_option        , (GFX_W >> 1) + FONT_W*7, (GFX_H >> 1) - (FONT_H/2)*0, opt_gfx_mode_str         , NULL      , 0                    , &new_gfx_mode_id     },
		{&md_textout_centre, (GFX_W >> 1)           , (GFX_H >> 1) + (FONT_H/2)*4, "Main Menu"              , &mk_exit  , MK_END               , NULL                 },
		{NULL              , 0                      , 0                          , NULL                     , NULL      , 0                    , NULL                 }
	};

	MENU_DATA *md = wrap_menu_data(ms, me, 0);
	timeloop(BPS_TO_TIMER(MENU_FPS), 10, &t_draw_menu, &t_update_menu, md);
	unwrap_menu_data(md);

	sfx_play(sfx_menu_enter, 1, 0, 1.0);

	return new_gfx_mode_id;
}

