#ifndef INC_GAME_H
#define INC_GAME_H


/* This header is shared by a lot of files. Sometimes it's just not worth the
 * effort to make lower levels work on individual components of the GAME
 * struct instead of the whole thing...
 */


#include "bsp.h"
#include "world.h"


#define GAME_FPS 100

#define GAME_ABORTED   1
#define GAME_ALL_DEAD  2
#define GAME_COMPLETED 3

#define MAX_PLAYERS 4

#define PLAYER_NAME_MAX 19

/* Transcendental information about the player - keys, score, etc. Stuff that
 * transcends the world, unlike coordinates which exist only in the world.
 */
typedef struct PLAYER_TRANS PLAYER_TRANS;

typedef struct SPRITE SPRITE;
typedef struct GAME GAME;

#define K_TURN_LEFT      0
#define K_TURN_RIGHT     1
#define K_LOOK_DOWN      2
#define K_LOOK_UP        3
#define K_WALK_FORWARDS  4
#define K_STEP_BACKWARDS 5
#define K_SIDESTEP_LEFT  6
#define K_SIDESTEP_RIGHT 7
#define K_FIRE           8
#define N_KEYS           9

struct PLAYER_TRANS
{
	unsigned char name[PLAYER_NAME_MAX+1];
	unsigned char k[N_KEYS];
	SPRITE *sprite;
	int score;
};


typedef void (*SPRITE_UPDATE_PROC)(GAME *game, SPRITE *sprite);
typedef void (*SPRITE_SHOOT_PROC)(PLAYER_TRANS *ptrans, SPRITE *sprite, float r, float zr);
typedef void (*SPRITE_DESTROY_PROC)(void *data);

#define SPRITE_DEAD 1

struct SPRITE
{
	SPRITE *next;
	int flags;
	SPRITE_UPDATE_PROC update;
	float x, y, z;
	float r, zr;
	SPRITE_SHOOT_PROC shoot;
	SPRITE_DESTROY_PROC destroy;
	void *data;
	VERTEX vtx[4];
	POLYGON poly;
	POLYGON_VERTEX polyvtx[4];
};

struct GAME
{
	int n_players;
	PLAYER_TRANS *ptrans[4];
	WORLD *world;
	SPRITE *sprite;
	int n_teletubbies;
	int end_time;
};

SPRITE *add_sprite(
	GAME *game,
	int flags,
	SPRITE_UPDATE_PROC update,
	float x, float y, float z,
	float r, float zr,
	SPRITE_SHOOT_PROC shoot,
	SPRITE_DESTROY_PROC destroy,
	void *data,
	BITMAP *texture
);

GAME *init_game(int n_players, PLAYER_TRANS *ptrans, int n_teletubbies);
void shut_down_game(GAME *game);

void draw_game(void *data);
int update_game(void *data);


#endif /* INC_GAME_H */

