#include "mathpi.h"
#include "main.h"
#include "game.h"
#include "fire.h"
#include "sfx.h"
#include "sfxplay.h"



/* Number of squares a bullet can go offside before it need not be considered
 * further.
 */
#define BULLET_BORDER 1



static float v_intercept(float ui, float ud, float vd, float u, float v)
{
/* u + l*ud = ui
 * v + l*vd = vi
 *
 * l = (ui - u) / ud
 * vi = v + (ui-u)/ud * vd
 *
 * return vi;
 */
 return v + (ui - u) * vd / ud;
}



void fire_bullet(GAME *game, PLAYER_TRANS *ptrans, float x, float y, float z, float phi, float theta)
{
	SPRITE *sprite;
	float dmax;

	float sp = sin(phi);
	float cp = cos(phi);

	float st = sin(theta);
	float ct = cos(theta);

	/* Extrapolate the potential course of the bullet. */

	float xend = x, yend = y, zend = z;
	float xd = sp*ct, yd = -cp*ct, zd = st;

	int xi = floor(xend);
	int yi = floor(yend);

	sfx_play(sfx_gunshot, 1, 0, 1.0);

	do {
		float xf = xend - xi;
		float yf = yend - yi;

		// To do: consider hitting the diagonal between triangles

		if (xd > yd && xd > -yd) {
			float yh = v_intercept(1, xd, yd, xf, yf);
			if (yh >= 0 && yh <= 1) {
				xend = ++xi;
				yend = yh + yi;
				goto hit_done;
			}
		} else if (xd < yd && xd < -yd) {
			float yl = v_intercept(0, xd, yd, xf, yf);
			if (yl >= 0 && yl <= 1) {
				xend = xi--;
				yend = yl + yi;
				goto hit_done;
			}
		}

		if (yd > 0) {
			float xh = v_intercept(1, yd, xd, yf, xf);
			if (xh >= 0 && xh <= 1) {
				xend = xh + xi;
				yend = ++yi;
				goto hit_done;
			}
		} else {
			float xl = v_intercept(0, yd, xd, yf, xf);
			if (xl >= 0 && xl <= 1) {
				xend = xl + xi;
				yend = yi--;
				goto hit_done;
			}
		}

		if (xd > 0) {
			float yh = v_intercept(1, xd, yd, xf, yf);
			xend = ++xi;
			yend = yh + yi;
		} else {
			float yl = v_intercept(0, xd, yd, xf, yf);
			xend = xi--;
			yend = yl + yi;
		}

		hit_done:

		if ((xd > yd) == (xd > -yd))
			zend = z + (xend - x) * zd / xd;
		else
			zend = z + (yend - y) * zd / yd;
	} while (
		xi >= -BULLET_BORDER && xi < game->world->w + BULLET_BORDER &&
		yi >= -BULLET_BORDER && yi < game->world->h + BULLET_BORDER &&
		zend > get_ground_height(game->world, xend, yend, NULL)
	);

	/* Scan for sprites that lie in the bullet's path. */

	xend -= x;
	yend -= y;
	zend -= z;

	/* Calculate the length. (xd,yd,zd) is parallel to (xend,yend,zend). */
	dmax = xd*xend + yd*yend + zd*zend;

	for (sprite = game->sprite; sprite; sprite = sprite->next)
	{
		float xs, ys, zs;
		float d, r, zr;

		if (!sprite->shoot) continue;

		xs = sprite->x - x;
		ys = sprite->y - y;
		zs = sprite->z - z;

		/* Is the sprite behind the player, too close to the player, or
		 * beyond the end point?
		 */
		d = xs*xd + ys*yd + zs*zd;
		if (d < 0.06 || d > dmax) continue;

		/* In perp. plane containing sprite, how high is the bullet? */
		zr = zd * d - zs;
		if (zr < -sprite->zr || zr > sprite->zr) continue;

		/* What is the bullet's horizontal displacement in said plane?
		 * (-yd,xd) points right in the plane.
		 */
		r = ys*xd - xs*yd;
		if (r < -sprite->r || r > sprite->r) continue;

		/* Target acquired! */
		(*sprite->shoot)(ptrans, sprite, r, zr);
	}
}
