#include <math.h>
#include "main.h"
#include "bsp.h"



/* This need be called only once per polygon when the polygon is created, and
 * again each time the polygon moves. It precalculates the polygon normal,
 * used for constructing the BSP tree and for lighting.
 */
void prepare_polygon(POLYGON *poly)
{
	float xa = poly->p[1].vtx->x - poly->p[0].vtx->x;
	float ya = poly->p[1].vtx->y - poly->p[0].vtx->y;
	float za = poly->p[1].vtx->z - poly->p[0].vtx->z;
	float xb = poly->p[2].vtx->x - poly->p[0].vtx->x;
	float yb = poly->p[2].vtx->y - poly->p[0].vtx->y;
	float zb = poly->p[2].vtx->z - poly->p[0].vtx->z;

	float f;

	/* We're in a left-handed coordinate system. */
	poly->xn = yb * za - ya * zb;
	poly->yn = zb * xa - za * xb;
	poly->zn = xb * ya - xa * yb;

	f = 1.0 / sqrt(
		poly->xn * poly->xn +
		poly->yn * poly->yn +
		poly->zn * poly->zn
	);

	poly->xn *= f;
	poly->yn *= f;
	poly->zn *= f;
}

