#ifndef INC_WORLD_H
#define INC_WORLD_H


#include "bsp.h"


typedef struct WORLD WORLD;

struct WORLD
{
	int w, h;
	float **z; /* (w+1)*(h+1) points, w*h tiles. */

	/* These hold data for the ground alone. */
	int n_vtx;
	VERTEX *vtx;

	int n_poly;
	POLYGON *poly;

	BSP_TREE *tree;
};


WORLD *create_world(void);
void destroy_world(WORLD *world);

void draw_world(BITMAP *bmp, MATRIX_f *camera, float xc, float yc, float zc, WORLD *world);

float get_ground_height(WORLD *world, float x, float y, int *outside);


#endif /* INC_WORLD_H */

