#include "mathpi.h"
#include "main.h"
#include "game.h"
#include "tubby.h"
#include "player.h"
#include "tconfig.h"



#define MAX_TELETUBBY_DISTANCE 1e+08



static void update_teletubby(GAME *game, SPRITE *sprite)
{
	float xd = 0, yd = 0;
	float d = MAX_TELETUBBY_DISTANCE;
	int found = 0;
	int i;

	for (i = 0; i < MAX_PLAYERS; i++) {
		if (game->ptrans[i]) {
			SPRITE *pspr = game->ptrans[i]->sprite;
			if (pspr) {
				float xdt = pspr->x - sprite->x;
				float ydt = pspr->y - sprite->y;
				float dt = xdt*xdt + ydt*ydt;
				if (dt < d) {
					found = 1;
					xd = xdt;
					yd = ydt;
					d = dt;
				}
			}
		}
	}

	if (!found) {
		/* No players left? Walk away from the (middle of the) level. */
		xd = sprite->x - game->world->w * 0.5;
		yd = sprite->y - game->world->h * 0.5;
		d = xd*xd + yd*yd;
	}

	if (d < sprite->r*sprite->r) {
		float phi = RND(2*M_PI);
		xd = sin(phi);
		yd = cos(phi);
		d = 1;
	}

	d = opt_difficulty_speed[opt_difficulty_id] / sqrt(d);
	xd *= d;
	yd *= d;
	sprite->x += xd;
	sprite->y += yd;
	sprite->z = get_ground_height(game->world, sprite->x, sprite->y, NULL) + sprite->zr;

	for (i = 0; i < MAX_PLAYERS; i++) {
		PLAYER_TRANS *ptrans = game->ptrans[i];
		if (ptrans) {
			SPRITE *pspr = ptrans->sprite;
			/* Only one test necessary; Teletubbies never leave the ground. */
			if (pspr && pspr->z - sprite->z < pspr->zr + sprite->zr) {
				float r = pspr->r + sprite->r;
				xd = pspr->x - sprite->x;
				yd = pspr->y - sprite->y;
				d = xd*xd + yd*yd;
				if (d < r*r)
					player_deduct_health(pspr, opt_difficulty_hurt[opt_difficulty_id]);
			}
		}
	}
}



static void shoot_teletubby(PLAYER_TRANS *ptrans, SPRITE *sprite, float r, float zr)
{
	(void)r;
	(void)zr;

	sprite->flags |= SPRITE_DEAD;
	ptrans->score += 100;
}



static void destroy_teletubby(void *data)
{
	GAME *game = data;
	game->n_teletubbies--;
}



void create_teletubby(GAME *game, float x, float y)
{
	float zr = 0.08;
	float z = get_ground_height(game->world, x, y, NULL) + zr;
	game->n_teletubbies++;
	add_sprite(game, 0, &update_teletubby, x, y, z, 0.035, zr, &shoot_teletubby, &destroy_teletubby, game, teletubby_texture);
}

