#ifndef INC_TIMELOOP_H
#define INC_TIMELOOP_H



#include "game.h"

extern volatile int true_time;
extern int logic_time;

extern unsigned char timeloop_scancode[MAX_PLAYERS][N_KEYS];
extern volatile unsigned char (*ckey)[N_KEYS];

void init_timeloop(void);



/* Notes for timeloop():
 *
 * On call to (*update)(), logic_time corresponds to the frame that has just
 * been drawn (if there was time to draw it). The first frame is 0, and will
 * always be drawn before any updates occur.
 *
 * Recursive structures such as menus can be set up using recursive calls to
 * timeloop(). Proper protocol is to call timeloop() from the end of the
 * (*update)() function. logic_time will be incremented before the inner
 * (*update)() function is called, and the inner (*draw)() function will be
 * used immediately (with the new logic_time) if time permits. When the inner
 * (*update)() function returns 1, logic_time will again be incremented
 * before the outer (*update)() function is called, and the outer (*draw)()
 * function will be used immediately (with the new logic_time) if time
 * permits.
 */
int timeloop(
	int speed,
	int max_skip,
	void (*draw)(void *data),
	int (*update)(void *data),
	void *data
);



/* new_timeloop() can be used as an alternative to timeloop() when recursing.
 * For the inner functions, logic_time will count from 0. logic_time will
 * again be reset to 0 when the outer function resumes. There will be
 * discontinuities; before and after calling this function you can execute
 * time-consuming algorithms, and the computer will not try to catch up.
 */
int new_timeloop(
	int speed,
	int max_skip,
	void (*draw)(void *data),
	int (*update)(void *data),
	void *data
);



#endif /* INC_TIMELOOP_H */
