#include <stdlib.h>
#include "main.h"
#include "screen.h"
#include "texture.h"



void palette_texture(int r, int g, int b, int noise)
{
	int n;

	r -= noise >> 1;
	g -= noise >> 1;
	b -= noise >> 1;

	for (n = 0; n < noise; n += 4) {
		int rn, gn, bn;
		ASSERT(palptr < 256);
		rn = MID(0, r + n, 255);
		gn = MID(0, g + n, 255);
		bn = MID(0, b + n, 255);
		pal[palptr].r = rn >> 2;
		pal[palptr].g = gn >> 2;
		pal[palptr].b = bn >> 2;
		palptr++;
	}
}



BITMAP *create_texture(int w, int h, int r, int g, int b, int noise)
{
	BITMAP *bmp = create_bitmap(w, h);
	int x, y;

	if (!bmp) {
		set_screen(0, 0, 0);
		allegro_message("Out of memory!");
		exit(1);
	}

	r -= noise >> 1;
	g -= noise >> 1;
	b -= noise >> 1;

	for (y = 0; y < h; y++) {
		for (x = 0; x < w; x++) {
			int n = rand() % noise;
			int rn = MID(0, r + n, 255);
			int gn = MID(0, g + n, 255);
			int bn = MID(0, b + n, 255);
			putpixel(bmp, x, y, makecol(rn, gn, bn));
		}
	}

	return bmp;
}



BITMAP *create_player_texture(void)
{
	static int torso[] = {
		16,14,
		25,16,
		28,33,
		24,34,
		21,21,
		21,36,
		10,36,
		10,21,
		 7,34,
		 3,33,
		 6,16,
		15,14
	};

	static int jeans[] = {
		21,36,
		22,58,
		18,58,
		16,40,
		15,40,
		13,58,
		 9,58,
		10,36
	};

	static int leftboot[] = {
		13,59,
		13,64,
		 5,64,
		 5,60
	};

	static int rightboot[] = {
		26,60,
		26,64,
		18,64,
		18,59
	};

	static int gun[] = {
		25,35,
		28,36,
		28,44,
		28,39,
		25,36
	};

	static int hair[] = {
		16, 0,
		22, 3,
		22,14,
		20, 6,
		16, 4,
		15, 4,
		11, 6,
		 9,14,
		 9, 3,
		15, 0
	};

	BITMAP *bmp = create_bitmap(32, 64);

	if (!bmp) {
		set_screen(0, 0, 0);
		allegro_message("Out of memory!");
		exit(1);
	}

	clear_to_color(bmp, bitmap_mask_color(bmp));
	polygon(bmp, 12, torso, makecol(0,102,0));
	polygon(bmp, 8, jeans, makecol(51,102,204));
	polygon(bmp, 4, leftboot, makecol(0,0,0));
	polygon(bmp, 4, rightboot, makecol(0,0,0));
	polygon(bmp, 5, gun, makecol(0,0,0));
	circlefill(bmp, 16, 8, 6, makecol(255,204,153));
	hline(bmp, 11, 7, 20, makecol(0,0,0));
	hline(bmp, 13, 8, 14, makecol(0,0,0));
	hline(bmp, 17, 8, 18, makecol(0,0,0));
	polygon(bmp, 10, hair, makecol(102,51,0));

	return bmp;
}



BITMAP *create_teletubby_texture(void)
{
	static int aerial[] = {
		20, 0,
		20, 2,
		16, 6,
		16, 7,
		16, 5,
		19, 2,
		19, 1,
		12, 1,
		12, 2,
		15, 5,
		15, 7,
		15, 6,
		11, 2,
		11, 0
	};

	static int body[] = {
		16,20,
		31,27,
		31,32,
		24,30,
		28,41,
		28,43,
		27,46,
		23,47,
		23,62,
		25,62,
		25,64,
		18,64,
		16,43,
		15,43,
		13,64,
		 6,64,
		 6,62,
		 8,62,
		 8,47,
		 4,46,
		 3,43,
		 3,41,
		 7,30,
		 0,32,
		 0,27,
		15,20
	};

	static int left_hand[] = {
		 0,28,
		 1,29,
		 1,31,
		 0,32
	};

	static int right_hand[] = {
		31,28,
		30,29,
		30,31,
		31,32
	};

	static int telly[] = {
		16,37,
		22,36,
		23,44,
		22,45,
		17,46,
		14,46,
		 9,45,
		 8,44,
		 9,36,
		15,37
	};

	BITMAP *bmp = create_bitmap(32, 64);

	if (!bmp) {
		set_screen(0, 0, 0);
		allegro_message("Out of memory!");
		exit(1);
	}

	clear_to_color(bmp, bitmap_mask_color(bmp));
	polygon(bmp, 26, body, makecol(128,0,176));
	polygon(bmp, 10, telly, makecol(160,160,160));
	polygon(bmp, 4, left_hand, makecol(210,185,160));
	polygon(bmp, 4, right_hand, makecol(210,185,160));
	polygon(bmp, 14, aerial, makecol(128,0,176));
	ellipsefill(bmp, 16, 14, 8, 7, makecol(128,0,176));
	circlefill(bmp, 16, 14, 5, makecol(210,185,160));

	return bmp;
}



BITMAP *create_text_bmp(char *str, int c)
{
	BITMAP *bmp = create_bitmap(text_length(font, str), text_height(font));

	if (!bmp) {
		set_screen(0, 0, 0);
		allegro_message("Out of memory!");
		exit(1);
	}

	clear_to_color(bmp, bitmap_mask_color(bmp));
	textout(bmp, font, str, 0, 0, c);

	return bmp;
}

