#include <string.h>
#include "main.h"
#include "menu.h"
#include "m_single.h"
#include "m_multi.h"
#include "tconfig.h"
#include "game.h"



int opt_n_teletubbies_id;
int opt_n_teletubbies[10] = {1, 2, 3, 5, 10, 20, 30, 50, 75, 100};
char *opt_n_teletubbies_str[10] = {
	"   1",
	"   2",
	"   3",
	"   5",
	"  10",
	"  20",
	"  30",
	"  50",
	"  75",
	" 100"
};



int opt_difficulty_id;
int opt_difficulty_hurt[6] = {2, 3, 5, 7, 10, 20};
float opt_difficulty_speed[6] = {0.001, 0.002, 0.003, 0.004, 0.0045, 0.005};
char *opt_difficulty_str[6] = {
	"Very Easy",
	"Easy",
	"Moderate",
	"Hard",
	"Very Hard",
	"Insane"
};



int opt_gfx_mode_id;
int opt_gfx_mode_w[8] = {320, 400, 640, 800, 1024, 1152, 1280, 1600};
int opt_gfx_mode_h[8] = {200, 300, 480, 600,  768,  864, 1024, 1200};
char *opt_gfx_mode_str[8] = {
	" 320x200",
	" 400x300",
	" 640x480",
	" 800x600",
	"1024x768",
	"1152x864",
	"1280x1024",
	"1600x1200"
};



static char *hconfig_key_name[N_KEYS] = {
	"turn_left",
	"turn_right",
	"look_down",
	"look_up",
	"move_forwards",
	"step_backwards",
	"sidestep_left",
	"sidestep_right",
	"fire"
};



static void load_player(PLAYER_TRANS *ptrans, const char *section)
{
	int i;
	const char *str = get_config_string(section, "name", "");
	strncpy(ptrans->name, str, PLAYER_NAME_MAX);
	ptrans->name[PLAYER_NAME_MAX] = 0;
	for (i = 0; i < N_KEYS; i++) {
		ptrans->k[i] = get_config_int(section, hconfig_key_name[i], 0);
		if (ptrans->k[i] == KEY_ESC || ptrans->k[i] == KEY_PAUSE || ptrans->k[i] >= KEY_MAX)
			ptrans->k[i] = 0;
	}
}



void load_options(void)
{
	opt_n_teletubbies_id = get_config_int("options", "n_teletubbies_id", 3);
	opt_n_teletubbies_id = MID(0, opt_n_teletubbies_id, OPT_N_TELETUBBIES_MAX - 1);

	opt_difficulty_id = get_config_int("options", "difficulty_id", 1);
	opt_difficulty_id = MID(0, opt_difficulty_id, OPT_DIFFICULTY_MAX - 1);

	opt_gfx_mode_id = get_config_int("options", "gfx_mode_id", 0);
	opt_gfx_mode_id = MID(0, opt_gfx_mode_id, OPT_GFX_MODE_MAX - 1);

	load_player(&single_player, "single");
	load_player(&multiplayer[0], "player1");
	load_player(&multiplayer[1], "player2");
	load_player(&multiplayer[2], "player3");
	load_player(&multiplayer[3], "player4");
}



static void save_player(PLAYER_TRANS *ptrans, const char *section)
{
	int i;
	set_config_string(section, "name", ptrans->name);
	for (i = 0; i < N_KEYS; i++)
		set_config_int(section, hconfig_key_name[i], ptrans->k[i]);
}



void save_options(void)
{
	set_config_int("options", "n_teletubbies_id", opt_n_teletubbies_id);
	set_config_int("options", "difficulty_id", opt_difficulty_id);
	set_config_int("options", "gfx_mode_id", opt_gfx_mode_id);
	save_player(&single_player, "single");
	save_player(&multiplayer[0], "player1");
	save_player(&multiplayer[1], "player2");
	save_player(&multiplayer[2], "player3");
	save_player(&multiplayer[3], "player4");
}

