#include <stdlib.h>
#include <string.h>
#include "main.h"
#include "screen.h"



static BITMAP *buffer = NULL;
static int buffer_depth;



int set_screen(int depth, int w, int h)
{
	static char first_error[ALLEGRO_ERROR_SIZE];

	BITMAP *newbuffer;

	if (w == 0) {
		destroy_bitmap(buffer);
		buffer = NULL;
		if (set_gfx_mode(GFX_TEXT, 0, 0, 0, 0)) exit(1);
		return 0;
	}

	if (buffer && w == buffer->w && h == buffer->h && depth == buffer_depth) {
		clear(screen);
		return 0;
	}

	set_color_depth(depth);
	newbuffer = create_bitmap(w, h);

	if (!newbuffer) {
		strcpy(allegro_error, "Insufficient memory");
		return 1;
	}

	if (set_gfx_mode(GFX_AUTODETECT, w, h, 0, 0) == 0) {
		destroy_bitmap(buffer);
		buffer = newbuffer;
		buffer_depth = depth;
		set_palette(pal);
		return 0;
	}

	strcpy(first_error, allegro_error);

	destroy_bitmap(newbuffer);

	set_color_depth(buffer_depth);

	if (!buffer) {
		if (set_gfx_mode(GFX_TEXT, 0, 0, 0, 0)) exit(1);
		return 1;
	}

	if (set_gfx_mode(GFX_AUTODETECT, buffer->w, buffer->h, 0, 0) == 0) {
		set_palette(pal);
		return 1;
	}

	if (set_gfx_mode(GFX_TEXT, 0, 0, 0, 0))
		exit(1);

	allegro_message(
		"Unable to set graphics mode %dx%dx%d\n%s\n\n"
		"Unable to revert to %dx%dx%d\n%s\n\n"
		"Please take your computer to the vet.\n",
		w, h, depth, first_error,
		buffer->w, buffer->h, buffer_depth, allegro_error
	);

	destroy_bitmap(buffer);

	exit(1);
}



BITMAP *get_screen(void)
{
	return buffer;
}



void commit_screen(void)
{
	vsync();
	blit(buffer, screen, 0, 0, 0, 0, buffer->w, buffer->h);
}

