#ifndef INC_PATTERN_H
#define INC_PATTERN_H


#include "tdumb.h"

typedef struct PATTERN PATTERN;

#define P_END   0
#define P_LOOP  1
#define P_ROW   2
#define P_SPEED 3
#define P_NOTE  4
#define P_PARAM 5

struct PATTERN
{
	unsigned char command;
	unsigned char p1; /* channel */
	unsigned char p2; /* sig (0=off) */
	unsigned char p3; /* volume; speedhi */
	short p4; /* pitch; speedlo */
	unsigned short p5; /* pos, 256 per tick */
};

#ifdef DEFINE_PATTERN_CONSTRUCTORS
#define E() {P_END, 0, 0, 0, 0, 0}
#define L() {P_LOOP, 0, 0, 0, 0, 0}
#define R() {P_ROW, 0, 0, 0, 0, 0}
#define S(bpm, div) {P_SPEED, 0, 0, (65536*60 / ((bpm)*(div))) >> 16, (short)(65536*60 / ((bpm)*(div))), 0}
#define N(chan, sig, vol, note, ft, pos) {P_NOTE, chan, sig, vol, ((note) << 8) + (ft), pos}
#define P(chan, vol, note, ft) {P_PARAM, chan, 0, vol, ((note) << 8) + (ft), 0}
#endif

extern DUH_SIGTYPE_DESC pattern_desc;


#endif /* INC_PATTERN_H */

